<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$sales_ref_preview = new sales_ref_preview();

// Run the page
$sales_ref_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sales_ref_preview->Page_Render();
?>
<?php $sales_ref_preview->showPageHeader(); ?>
<div class="card ew-grid sales_ref"><!-- .card -->
<?php if ($sales_ref_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$sales_ref_preview->renderListOptions();

// Render list options (header, left)
$sales_ref_preview->ListOptions->render("header", "left");
?>
<?php if ($sales_ref->grp->Visible) { // grp ?>
	<?php if ($sales_ref->SortUrl($sales_ref->grp) == "") { ?>
		<th class="<?php echo $sales_ref->grp->headerCellClass() ?>"><?php echo $sales_ref->grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sales_ref->grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sales_ref->grp->Name) ?>" data-sort-order="<?php echo $sales_ref_preview->SortField == $sales_ref->grp->Name && $sales_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref_preview->SortField == $sales_ref->grp->Name) { ?><?php if ($sales_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->s_grp->Visible) { // s_grp ?>
	<?php if ($sales_ref->SortUrl($sales_ref->s_grp) == "") { ?>
		<th class="<?php echo $sales_ref->s_grp->headerCellClass() ?>"><?php echo $sales_ref->s_grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sales_ref->s_grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sales_ref->s_grp->Name) ?>" data-sort-order="<?php echo $sales_ref_preview->SortField == $sales_ref->s_grp->Name && $sales_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref_preview->SortField == $sales_ref->s_grp->Name) { ?><?php if ($sales_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->product->Visible) { // product ?>
	<?php if ($sales_ref->SortUrl($sales_ref->product) == "") { ?>
		<th class="<?php echo $sales_ref->product->headerCellClass() ?>"><?php echo $sales_ref->product->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sales_ref->product->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sales_ref->product->Name) ?>" data-sort-order="<?php echo $sales_ref_preview->SortField == $sales_ref->product->Name && $sales_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref_preview->SortField == $sales_ref->product->Name) { ?><?php if ($sales_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->rid->Visible) { // rid ?>
	<?php if ($sales_ref->SortUrl($sales_ref->rid) == "") { ?>
		<th class="<?php echo $sales_ref->rid->headerCellClass() ?>"><?php echo $sales_ref->rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sales_ref->rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sales_ref->rid->Name) ?>" data-sort-order="<?php echo $sales_ref_preview->SortField == $sales_ref->rid->Name && $sales_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref_preview->SortField == $sales_ref->rid->Name) { ?><?php if ($sales_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->packets->Visible) { // packets ?>
	<?php if ($sales_ref->SortUrl($sales_ref->packets) == "") { ?>
		<th class="<?php echo $sales_ref->packets->headerCellClass() ?>"><?php echo $sales_ref->packets->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sales_ref->packets->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sales_ref->packets->Name) ?>" data-sort-order="<?php echo $sales_ref_preview->SortField == $sales_ref->packets->Name && $sales_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref_preview->SortField == $sales_ref->packets->Name) { ?><?php if ($sales_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->quantity->Visible) { // quantity ?>
	<?php if ($sales_ref->SortUrl($sales_ref->quantity) == "") { ?>
		<th class="<?php echo $sales_ref->quantity->headerCellClass() ?>"><?php echo $sales_ref->quantity->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sales_ref->quantity->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sales_ref->quantity->Name) ?>" data-sort-order="<?php echo $sales_ref_preview->SortField == $sales_ref->quantity->Name && $sales_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref_preview->SortField == $sales_ref->quantity->Name) { ?><?php if ($sales_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->_40->Visible) { // @ ?>
	<?php if ($sales_ref->SortUrl($sales_ref->_40) == "") { ?>
		<th class="<?php echo $sales_ref->_40->headerCellClass() ?>"><?php echo $sales_ref->_40->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sales_ref->_40->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sales_ref->_40->Name) ?>" data-sort-order="<?php echo $sales_ref_preview->SortField == $sales_ref->_40->Name && $sales_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref_preview->SortField == $sales_ref->_40->Name) { ?><?php if ($sales_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->amount->Visible) { // amount ?>
	<?php if ($sales_ref->SortUrl($sales_ref->amount) == "") { ?>
		<th class="<?php echo $sales_ref->amount->headerCellClass() ?>"><?php echo $sales_ref->amount->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sales_ref->amount->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sales_ref->amount->Name) ?>" data-sort-order="<?php echo $sales_ref_preview->SortField == $sales_ref->amount->Name && $sales_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref_preview->SortField == $sales_ref->amount->Name) { ?><?php if ($sales_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->godown->Visible) { // godown ?>
	<?php if ($sales_ref->SortUrl($sales_ref->godown) == "") { ?>
		<th class="<?php echo $sales_ref->godown->headerCellClass() ?>"><?php echo $sales_ref->godown->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $sales_ref->godown->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($sales_ref->godown->Name) ?>" data-sort-order="<?php echo $sales_ref_preview->SortField == $sales_ref->godown->Name && $sales_ref_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref_preview->SortField == $sales_ref->godown->Name) { ?><?php if ($sales_ref_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sales_ref_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$sales_ref_preview->RecCount = 0;
$sales_ref_preview->RowCnt = 0;
while ($sales_ref_preview->Recordset && !$sales_ref_preview->Recordset->EOF) {

	// Init row class and style
	$sales_ref_preview->RecCount++;
	$sales_ref_preview->RowCnt++;
	$sales_ref_preview->CssStyle = "";
	$sales_ref_preview->loadListRowValues($sales_ref_preview->Recordset);

	// Render row
	$sales_ref_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$sales_ref_preview->resetAttributes();
	$sales_ref_preview->renderListRow();

	// Render list options
	$sales_ref_preview->renderListOptions();
?>
	<tr<?php echo $sales_ref_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sales_ref_preview->ListOptions->render("body", "left", $sales_ref_preview->RowCnt);
?>
<?php if ($sales_ref->grp->Visible) { // grp ?>
		<!-- grp -->
		<td<?php echo $sales_ref->grp->cellAttributes() ?>>
<span<?php echo $sales_ref->grp->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->grp->getViewValue())) && $sales_ref->grp->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->grp->linkAttributes() ?>><?php echo $sales_ref->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sales_ref->grp->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($sales_ref->s_grp->Visible) { // s_grp ?>
		<!-- s_grp -->
		<td<?php echo $sales_ref->s_grp->cellAttributes() ?>>
<span<?php echo $sales_ref->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->s_grp->getViewValue())) && $sales_ref->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->s_grp->linkAttributes() ?>><?php echo $sales_ref->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sales_ref->s_grp->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($sales_ref->product->Visible) { // product ?>
		<!-- product -->
		<td<?php echo $sales_ref->product->cellAttributes() ?>>
<span<?php echo $sales_ref->product->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->product->getViewValue())) && $sales_ref->product->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->product->linkAttributes() ?>><?php echo $sales_ref->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sales_ref->product->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($sales_ref->rid->Visible) { // rid ?>
		<!-- rid -->
		<td<?php echo $sales_ref->rid->cellAttributes() ?>>
<span<?php echo $sales_ref->rid->viewAttributes() ?>>
<?php echo $sales_ref->rid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($sales_ref->packets->Visible) { // packets ?>
		<!-- packets -->
		<td<?php echo $sales_ref->packets->cellAttributes() ?>>
<span<?php echo $sales_ref->packets->viewAttributes() ?>>
<?php echo $sales_ref->packets->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($sales_ref->quantity->Visible) { // quantity ?>
		<!-- quantity -->
		<td<?php echo $sales_ref->quantity->cellAttributes() ?>>
<span<?php echo $sales_ref->quantity->viewAttributes() ?>>
<?php echo $sales_ref->quantity->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($sales_ref->_40->Visible) { // @ ?>
		<!-- @ -->
		<td<?php echo $sales_ref->_40->cellAttributes() ?>>
<span<?php echo $sales_ref->_40->viewAttributes() ?>>
<?php echo $sales_ref->_40->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($sales_ref->amount->Visible) { // amount ?>
		<!-- amount -->
		<td<?php echo $sales_ref->amount->cellAttributes() ?>>
<span<?php echo $sales_ref->amount->viewAttributes() ?>>
<?php echo $sales_ref->amount->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($sales_ref->godown->Visible) { // godown ?>
		<!-- godown -->
		<td<?php echo $sales_ref->godown->cellAttributes() ?>>
<span<?php echo $sales_ref->godown->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->godown->getViewValue())) && $sales_ref->godown->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->godown->linkAttributes() ?>><?php echo $sales_ref->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sales_ref->godown->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$sales_ref_preview->ListOptions->render("body", "right", $sales_ref_preview->RowCnt);
?>
	</tr>
<?php
	$sales_ref_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($sales_ref_preview->TotalRecs > 0) { ?>
<?php if (!isset($sales_ref_preview->Pager)) $sales_ref_preview->Pager = new PrevNextPager($sales_ref_preview->StartRec, $sales_ref_preview->DisplayRecs, $sales_ref_preview->TotalRecs) ?>
<?php if ($sales_ref_preview->Pager->RecordCount > 0 && $sales_ref_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($sales_ref_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $sales_ref_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($sales_ref_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $sales_ref_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($sales_ref_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $sales_ref_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($sales_ref_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $sales_ref_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $sales_ref_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $sales_ref_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $sales_ref_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($sales_ref_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$sales_ref_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($sales_ref_preview->Recordset)
	$sales_ref_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$sales_ref_preview->terminate();
?>