<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sales_ref_search = new sales_ref_search();

// Run the page
$sales_ref_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sales_ref_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($sales_ref_search->IsModal) { ?>
var fsales_refsearch = currentAdvancedSearchForm = new ew.Form("fsales_refsearch", "search");
<?php } else { ?>
var fsales_refsearch = currentForm = new ew.Form("fsales_refsearch", "search");
<?php } ?>

// Form_CustomValidate event
fsales_refsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsales_refsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsales_refsearch.lists["x_grp"] = <?php echo $sales_ref_search->grp->Lookup->toClientList() ?>;
fsales_refsearch.lists["x_grp"].options = <?php echo JsonEncode($sales_ref_search->grp->lookupOptions()) ?>;
fsales_refsearch.lists["x_s_grp"] = <?php echo $sales_ref_search->s_grp->Lookup->toClientList() ?>;
fsales_refsearch.lists["x_s_grp"].options = <?php echo JsonEncode($sales_ref_search->s_grp->lookupOptions()) ?>;
fsales_refsearch.lists["x_product"] = <?php echo $sales_ref_search->product->Lookup->toClientList() ?>;
fsales_refsearch.lists["x_product"].options = <?php echo JsonEncode($sales_ref_search->product->lookupOptions()) ?>;
fsales_refsearch.lists["x_rid"] = <?php echo $sales_ref_search->rid->Lookup->toClientList() ?>;
fsales_refsearch.lists["x_rid"].options = <?php echo JsonEncode($sales_ref_search->rid->lookupOptions()) ?>;
fsales_refsearch.lists["x_godown"] = <?php echo $sales_ref_search->godown->Lookup->toClientList() ?>;
fsales_refsearch.lists["x_godown"].options = <?php echo JsonEncode($sales_ref_search->godown->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fsales_refsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sales_ref->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sales_ref->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sales_ref->_40->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sales_ref->amount->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sales_ref_search->showPageHeader(); ?>
<?php
$sales_ref_search->showMessage();
?>
<form name="fsales_refsearch" id="fsales_refsearch" class="<?php echo $sales_ref_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sales_ref_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sales_ref_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sales_ref">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$sales_ref_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($sales_ref->ids->Visible) { // ids ?>
	<div id="r_ids" class="form-group row">
		<label for="x_ids" class="<?php echo $sales_ref_search->LeftColumnClass ?>"><span id="elh_sales_ref_ids"><?php echo $sales_ref->ids->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ids" id="z_ids" value="LIKE"></span>
		</label>
		<div class="<?php echo $sales_ref_search->RightColumnClass ?>"><div<?php echo $sales_ref->ids->cellAttributes() ?>>
			<span id="el_sales_ref_ids">
<input type="text" data-table="sales_ref" data-field="x_ids" name="x_ids" id="x_ids" size="35" placeholder="<?php echo HtmlEncode($sales_ref->ids->getPlaceHolder()) ?>" value="<?php echo $sales_ref->ids->EditValue ?>"<?php echo $sales_ref->ids->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sales_ref->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $sales_ref_search->LeftColumnClass ?>"><span id="elh_sales_ref_grp"><?php echo $sales_ref->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $sales_ref_search->RightColumnClass ?>"><div<?php echo $sales_ref->grp->cellAttributes() ?>>
			<span id="el_sales_ref_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_grp" data-value-separator="<?php echo $sales_ref->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $sales_ref->grp->editAttributes() ?>>
		<?php echo $sales_ref->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $sales_ref->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sales_ref->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $sales_ref_search->LeftColumnClass ?>"><span id="elh_sales_ref_s_grp"><?php echo $sales_ref->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $sales_ref_search->RightColumnClass ?>"><div<?php echo $sales_ref->s_grp->cellAttributes() ?>>
			<span id="el_sales_ref_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_s_grp" data-value-separator="<?php echo $sales_ref->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $sales_ref->s_grp->editAttributes() ?>>
		<?php echo $sales_ref->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $sales_ref->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sales_ref->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $sales_ref_search->LeftColumnClass ?>"><span id="elh_sales_ref_product"><?php echo $sales_ref->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $sales_ref_search->RightColumnClass ?>"><div<?php echo $sales_ref->product->cellAttributes() ?>>
			<span id="el_sales_ref_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_product" data-value-separator="<?php echo $sales_ref->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $sales_ref->product->editAttributes() ?>>
		<?php echo $sales_ref->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $sales_ref->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sales_ref->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $sales_ref_search->LeftColumnClass ?>"><span id="elh_sales_ref_rid"><?php echo $sales_ref->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $sales_ref_search->RightColumnClass ?>"><div<?php echo $sales_ref->rid->cellAttributes() ?>>
			<span id="el_sales_ref_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_rid" data-value-separator="<?php echo $sales_ref->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $sales_ref->rid->editAttributes() ?>>
		<?php echo $sales_ref->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $sales_ref->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sales_ref->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $sales_ref_search->LeftColumnClass ?>"><span id="elh_sales_ref_packets"><?php echo $sales_ref->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $sales_ref_search->RightColumnClass ?>"><div<?php echo $sales_ref->packets->cellAttributes() ?>>
			<span id="el_sales_ref_packets">
<input type="text" data-table="sales_ref" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($sales_ref->packets->getPlaceHolder()) ?>" value="<?php echo $sales_ref->packets->EditValue ?>"<?php echo $sales_ref->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sales_ref->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $sales_ref_search->LeftColumnClass ?>"><span id="elh_sales_ref_quantity"><?php echo $sales_ref->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $sales_ref_search->RightColumnClass ?>"><div<?php echo $sales_ref->quantity->cellAttributes() ?>>
			<span id="el_sales_ref_quantity">
<input type="text" data-table="sales_ref" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($sales_ref->quantity->getPlaceHolder()) ?>" value="<?php echo $sales_ref->quantity->EditValue ?>"<?php echo $sales_ref->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sales_ref->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label for="x__40" class="<?php echo $sales_ref_search->LeftColumnClass ?>"><span id="elh_sales_ref__40"><?php echo $sales_ref->_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__40" id="z__40" value="="></span>
		</label>
		<div class="<?php echo $sales_ref_search->RightColumnClass ?>"><div<?php echo $sales_ref->_40->cellAttributes() ?>>
			<span id="el_sales_ref__40">
<input type="text" data-table="sales_ref" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($sales_ref->_40->getPlaceHolder()) ?>" value="<?php echo $sales_ref->_40->EditValue ?>"<?php echo $sales_ref->_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sales_ref->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $sales_ref_search->LeftColumnClass ?>"><span id="elh_sales_ref_amount"><?php echo $sales_ref->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $sales_ref_search->RightColumnClass ?>"><div<?php echo $sales_ref->amount->cellAttributes() ?>>
			<span id="el_sales_ref_amount">
<input type="text" data-table="sales_ref" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($sales_ref->amount->getPlaceHolder()) ?>" value="<?php echo $sales_ref->amount->EditValue ?>"<?php echo $sales_ref->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sales_ref->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $sales_ref_search->LeftColumnClass ?>"><span id="elh_sales_ref_godown"><?php echo $sales_ref->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $sales_ref_search->RightColumnClass ?>"><div<?php echo $sales_ref->godown->cellAttributes() ?>>
			<span id="el_sales_ref_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_godown" data-value-separator="<?php echo $sales_ref->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $sales_ref->godown->editAttributes() ?>>
		<?php echo $sales_ref->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $sales_ref->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$sales_ref_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $sales_ref_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$sales_ref_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sales_ref_search->terminate();
?>