<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_cart_app_list = new sample_req_cart_app_list();

// Run the page
$sample_req_cart_app_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_cart_app_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sample_req_cart_app->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsample_req_cart_applist = currentForm = new ew.Form("fsample_req_cart_applist", "list");
fsample_req_cart_applist.formKeyCountName = '<?php echo $sample_req_cart_app_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsample_req_cart_applist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_cart_applist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_cart_applist.lists["x_company_id"] = <?php echo $sample_req_cart_app_list->company_id->Lookup->toClientList() ?>;
fsample_req_cart_applist.lists["x_company_id"].options = <?php echo JsonEncode($sample_req_cart_app_list->company_id->lookupOptions()) ?>;
fsample_req_cart_applist.lists["x_partner_id"] = <?php echo $sample_req_cart_app_list->partner_id->Lookup->toClientList() ?>;
fsample_req_cart_applist.lists["x_partner_id"].options = <?php echo JsonEncode($sample_req_cart_app_list->partner_id->lookupOptions()) ?>;
fsample_req_cart_applist.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsample_req_cart_applist.lists["x_delivery_week"] = <?php echo $sample_req_cart_app_list->delivery_week->Lookup->toClientList() ?>;
fsample_req_cart_applist.lists["x_delivery_week"].options = <?php echo JsonEncode($sample_req_cart_app_list->delivery_week->lookupOptions()) ?>;
fsample_req_cart_applist.lists["x_status"] = <?php echo $sample_req_cart_app_list->status->Lookup->toClientList() ?>;
fsample_req_cart_applist.lists["x_status"].options = <?php echo JsonEncode($sample_req_cart_app_list->status->lookupOptions()) ?>;
fsample_req_cart_applist.lists["x_app_status"] = <?php echo $sample_req_cart_app_list->app_status->Lookup->toClientList() ?>;
fsample_req_cart_applist.lists["x_app_status"].options = <?php echo JsonEncode($sample_req_cart_app_list->app_status->lookupOptions()) ?>;

// Form object for search
var fsample_req_cart_applistsrch = currentSearchForm = new ew.Form("fsample_req_cart_applistsrch");

// Validate function for search
fsample_req_cart_applistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fsample_req_cart_applistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_cart_applistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_cart_applistsrch.lists["x_partner_id"] = <?php echo $sample_req_cart_app_list->partner_id->Lookup->toClientList() ?>;
fsample_req_cart_applistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($sample_req_cart_app_list->partner_id->lookupOptions()) ?>;
fsample_req_cart_applistsrch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsample_req_cart_applistsrch.lists["x_status"] = <?php echo $sample_req_cart_app_list->status->Lookup->toClientList() ?>;
fsample_req_cart_applistsrch.lists["x_status"].options = <?php echo JsonEncode($sample_req_cart_app_list->status->lookupOptions()) ?>;
fsample_req_cart_applistsrch.lists["x_app_status"] = <?php echo $sample_req_cart_app_list->app_status->Lookup->toClientList() ?>;
fsample_req_cart_applistsrch.lists["x_app_status"].options = <?php echo JsonEncode($sample_req_cart_app_list->app_status->lookupOptions()) ?>;

// Filters
fsample_req_cart_applistsrch.filterList = <?php echo $sample_req_cart_app_list->getFilterList() ?>;

// Init search panel as collapsed
fsample_req_cart_applistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sample_req_cart_app->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($sample_req_cart_app_list->TotalRecs > 0 && $sample_req_cart_app_list->ExportOptions->visible()) { ?>
<?php $sample_req_cart_app_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_cart_app_list->ImportOptions->visible()) { ?>
<?php $sample_req_cart_app_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_cart_app_list->SearchOptions->visible()) { ?>
<?php $sample_req_cart_app_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_cart_app_list->FilterOptions->visible()) { ?>
<?php $sample_req_cart_app_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$sample_req_cart_app_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$sample_req_cart_app->isExport() && !$sample_req_cart_app->CurrentAction) { ?>
<form name="fsample_req_cart_applistsrch" id="fsample_req_cart_applistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($sample_req_cart_app_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fsample_req_cart_applistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="sample_req_cart_app">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$sample_req_cart_app_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$sample_req_cart_app->RowType = ROWTYPE_SEARCH;

// Render row
$sample_req_cart_app->resetAttributes();
$sample_req_cart_app_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($sample_req_cart_app->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $sample_req_cart_app->partner_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$sample_req_cart_app->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$sample_req_cart_app->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($sample_req_cart_app->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($sample_req_cart_app->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($sample_req_cart_app->partner_id->getPlaceHolder()) ?>"<?php echo $sample_req_cart_app->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="sample_req_cart_app" data-field="x_partner_id" data-value-separator="<?php echo $sample_req_cart_app->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($sample_req_cart_app->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fsample_req_cart_applistsrch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $sample_req_cart_app->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($sample_req_cart_app->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $sample_req_cart_app->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_cart_app" data-field="x_status" data-value-separator="<?php echo $sample_req_cart_app->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $sample_req_cart_app->status->editAttributes() ?>>
		<?php echo $sample_req_cart_app->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $sample_req_cart_app->status->Lookup->getParamTag("p_x_status") ?>
</span>
	</div>
<?php } ?>
<?php if ($sample_req_cart_app->app_status->Visible) { // app_status ?>
	<div id="xsc_app_status" class="ew-cell form-group">
		<label for="x_app_status" class="ew-search-caption ew-label"><?php echo $sample_req_cart_app->app_status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_app_status" id="z_app_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_cart_app" data-field="x_app_status" data-value-separator="<?php echo $sample_req_cart_app->app_status->displayValueSeparatorAttribute() ?>" id="x_app_status" name="x_app_status"<?php echo $sample_req_cart_app->app_status->editAttributes() ?>>
		<?php echo $sample_req_cart_app->app_status->selectOptionListHtml("x_app_status") ?>
	</select>
</div>
<?php echo $sample_req_cart_app->app_status->Lookup->getParamTag("p_x_app_status") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($sample_req_cart_app_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($sample_req_cart_app_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $sample_req_cart_app_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($sample_req_cart_app_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($sample_req_cart_app_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($sample_req_cart_app_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($sample_req_cart_app_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $sample_req_cart_app_list->showPageHeader(); ?>
<?php
$sample_req_cart_app_list->showMessage();
?>
<?php if ($sample_req_cart_app_list->TotalRecs > 0 || $sample_req_cart_app->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($sample_req_cart_app_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> sample_req_cart_app">
<?php if (!$sample_req_cart_app->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$sample_req_cart_app->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sample_req_cart_app_list->Pager)) $sample_req_cart_app_list->Pager = new PrevNextPager($sample_req_cart_app_list->StartRec, $sample_req_cart_app_list->DisplayRecs, $sample_req_cart_app_list->TotalRecs, $sample_req_cart_app_list->AutoHidePager) ?>
<?php if ($sample_req_cart_app_list->Pager->RecordCount > 0 && $sample_req_cart_app_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sample_req_cart_app_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sample_req_cart_app_list->pageUrl() ?>start=<?php echo $sample_req_cart_app_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sample_req_cart_app_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sample_req_cart_app_list->pageUrl() ?>start=<?php echo $sample_req_cart_app_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sample_req_cart_app_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sample_req_cart_app_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sample_req_cart_app_list->pageUrl() ?>start=<?php echo $sample_req_cart_app_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sample_req_cart_app_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sample_req_cart_app_list->pageUrl() ?>start=<?php echo $sample_req_cart_app_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sample_req_cart_app_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sample_req_cart_app_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sample_req_cart_app_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sample_req_cart_app_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sample_req_cart_app_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sample_req_cart_app_list->TotalRecs > 0 && (!$sample_req_cart_app_list->AutoHidePageSizeSelector || $sample_req_cart_app_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sample_req_cart_app">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sample_req_cart_app_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sample_req_cart_app_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sample_req_cart_app_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sample_req_cart_app_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sample_req_cart_app_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sample_req_cart_app->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sample_req_cart_app_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsample_req_cart_applist" id="fsample_req_cart_applist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_cart_app_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_cart_app_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart_app">
<div id="gmp_sample_req_cart_app" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($sample_req_cart_app_list->TotalRecs > 0 || $sample_req_cart_app->isGridEdit()) { ?>
<table id="tbl_sample_req_cart_applist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$sample_req_cart_app_list->RowType = ROWTYPE_HEADER;

// Render list options
$sample_req_cart_app_list->renderListOptions();

// Render list options (header, left)
$sample_req_cart_app_list->ListOptions->render("header", "left");
?>
<?php if ($sample_req_cart_app->id->Visible) { // id ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->id) == "") { ?>
		<th data-name="id" class="<?php echo $sample_req_cart_app->id->headerCellClass() ?>"><div id="elh_sample_req_cart_app_id" class="sample_req_cart_app_id"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $sample_req_cart_app->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->id) ?>',2);"><div id="elh_sample_req_cart_app_id" class="sample_req_cart_app_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->company_id->Visible) { // company_id ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $sample_req_cart_app->company_id->headerCellClass() ?>"><div id="elh_sample_req_cart_app_company_id" class="sample_req_cart_app_company_id"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $sample_req_cart_app->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->company_id) ?>',2);"><div id="elh_sample_req_cart_app_company_id" class="sample_req_cart_app_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->partner_id->Visible) { // partner_id ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $sample_req_cart_app->partner_id->headerCellClass() ?>"><div id="elh_sample_req_cart_app_partner_id" class="sample_req_cart_app_partner_id"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $sample_req_cart_app->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->partner_id) ?>',2);"><div id="elh_sample_req_cart_app_partner_id" class="sample_req_cart_app_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->partner_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->old_ref->Visible) { // old_ref ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->old_ref) == "") { ?>
		<th data-name="old_ref" class="<?php echo $sample_req_cart_app->old_ref->headerCellClass() ?>"><div id="elh_sample_req_cart_app_old_ref" class="sample_req_cart_app_old_ref"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->old_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="old_ref" class="<?php echo $sample_req_cart_app->old_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->old_ref) ?>',2);"><div id="elh_sample_req_cart_app_old_ref" class="sample_req_cart_app_old_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->old_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->old_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->old_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->upload->Visible) { // upload ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->upload) == "") { ?>
		<th data-name="upload" class="<?php echo $sample_req_cart_app->upload->headerCellClass() ?>"><div id="elh_sample_req_cart_app_upload" class="sample_req_cart_app_upload"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->upload->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="upload" class="<?php echo $sample_req_cart_app->upload->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->upload) ?>',2);"><div id="elh_sample_req_cart_app_upload" class="sample_req_cart_app_upload">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->upload->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->upload->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->upload->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->design->Visible) { // design ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->design) == "") { ?>
		<th data-name="design" class="<?php echo $sample_req_cart_app->design->headerCellClass() ?>"><div id="elh_sample_req_cart_app_design" class="sample_req_cart_app_design"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $sample_req_cart_app->design->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->design) ?>',2);"><div id="elh_sample_req_cart_app_design" class="sample_req_cart_app_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->color->Visible) { // color ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->color) == "") { ?>
		<th data-name="color" class="<?php echo $sample_req_cart_app->color->headerCellClass() ?>"><div id="elh_sample_req_cart_app_color" class="sample_req_cart_app_color"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->color->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="color" class="<?php echo $sample_req_cart_app->color->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->color) ?>',2);"><div id="elh_sample_req_cart_app_color" class="sample_req_cart_app_color">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->color->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->color->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->color->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->size->Visible) { // size ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->size) == "") { ?>
		<th data-name="size" class="<?php echo $sample_req_cart_app->size->headerCellClass() ?>"><div id="elh_sample_req_cart_app_size" class="sample_req_cart_app_size"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size" class="<?php echo $sample_req_cart_app->size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->size) ?>',2);"><div id="elh_sample_req_cart_app_size" class="sample_req_cart_app_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->quantity->Visible) { // quantity ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $sample_req_cart_app->quantity->headerCellClass() ?>"><div id="elh_sample_req_cart_app_quantity" class="sample_req_cart_app_quantity"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $sample_req_cart_app->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->quantity) ?>',2);"><div id="elh_sample_req_cart_app_quantity" class="sample_req_cart_app_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->delivery_week->Visible) { // delivery_week ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->delivery_week) == "") { ?>
		<th data-name="delivery_week" class="<?php echo $sample_req_cart_app->delivery_week->headerCellClass() ?>"><div id="elh_sample_req_cart_app_delivery_week" class="sample_req_cart_app_delivery_week"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->delivery_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_week" class="<?php echo $sample_req_cart_app->delivery_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->delivery_week) ?>',2);"><div id="elh_sample_req_cart_app_delivery_week" class="sample_req_cart_app_delivery_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->delivery_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->delivery_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->delivery_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->status->Visible) { // status ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->status) == "") { ?>
		<th data-name="status" class="<?php echo $sample_req_cart_app->status->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_sample_req_cart_app_status" class="sample_req_cart_app_status"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $sample_req_cart_app->status->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->status) ?>',2);"><div id="elh_sample_req_cart_app_status" class="sample_req_cart_app_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->remarks->Visible) { // remarks ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $sample_req_cart_app->remarks->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_sample_req_cart_app_remarks" class="sample_req_cart_app_remarks"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $sample_req_cart_app->remarks->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->remarks) ?>',2);"><div id="elh_sample_req_cart_app_remarks" class="sample_req_cart_app_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->pp_remarks->Visible) { // pp_remarks ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->pp_remarks) == "") { ?>
		<th data-name="pp_remarks" class="<?php echo $sample_req_cart_app->pp_remarks->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_sample_req_cart_app_pp_remarks" class="sample_req_cart_app_pp_remarks"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->pp_remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pp_remarks" class="<?php echo $sample_req_cart_app->pp_remarks->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->pp_remarks) ?>',2);"><div id="elh_sample_req_cart_app_pp_remarks" class="sample_req_cart_app_pp_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->pp_remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->pp_remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->pp_remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->price->Visible) { // price ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->price) == "") { ?>
		<th data-name="price" class="<?php echo $sample_req_cart_app->price->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_sample_req_cart_app_price" class="sample_req_cart_app_price"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $sample_req_cart_app->price->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->price) ?>',2);"><div id="elh_sample_req_cart_app_price" class="sample_req_cart_app_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_app->app_status->Visible) { // app_status ?>
	<?php if ($sample_req_cart_app->sortUrl($sample_req_cart_app->app_status) == "") { ?>
		<th data-name="app_status" class="<?php echo $sample_req_cart_app->app_status->headerCellClass() ?>"><div id="elh_sample_req_cart_app_app_status" class="sample_req_cart_app_app_status"><div class="ew-table-header-caption"><?php echo $sample_req_cart_app->app_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="app_status" class="<?php echo $sample_req_cart_app->app_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_app->SortUrl($sample_req_cart_app->app_status) ?>',2);"><div id="elh_sample_req_cart_app_app_status" class="sample_req_cart_app_app_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_app->app_status->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_app->app_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_app->app_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sample_req_cart_app_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($sample_req_cart_app->ExportAll && $sample_req_cart_app->isExport()) {
	$sample_req_cart_app_list->StopRec = $sample_req_cart_app_list->TotalRecs;
} else {

	// Set the last record to display
	if ($sample_req_cart_app_list->TotalRecs > $sample_req_cart_app_list->StartRec + $sample_req_cart_app_list->DisplayRecs - 1)
		$sample_req_cart_app_list->StopRec = $sample_req_cart_app_list->StartRec + $sample_req_cart_app_list->DisplayRecs - 1;
	else
		$sample_req_cart_app_list->StopRec = $sample_req_cart_app_list->TotalRecs;
}
$sample_req_cart_app_list->RecCnt = $sample_req_cart_app_list->StartRec - 1;
if ($sample_req_cart_app_list->Recordset && !$sample_req_cart_app_list->Recordset->EOF) {
	$sample_req_cart_app_list->Recordset->moveFirst();
	$selectLimit = $sample_req_cart_app_list->UseSelectLimit;
	if (!$selectLimit && $sample_req_cart_app_list->StartRec > 1)
		$sample_req_cart_app_list->Recordset->move($sample_req_cart_app_list->StartRec - 1);
} elseif (!$sample_req_cart_app->AllowAddDeleteRow && $sample_req_cart_app_list->StopRec == 0) {
	$sample_req_cart_app_list->StopRec = $sample_req_cart_app->GridAddRowCount;
}

// Initialize aggregate
$sample_req_cart_app->RowType = ROWTYPE_AGGREGATEINIT;
$sample_req_cart_app->resetAttributes();
$sample_req_cart_app_list->renderRow();
while ($sample_req_cart_app_list->RecCnt < $sample_req_cart_app_list->StopRec) {
	$sample_req_cart_app_list->RecCnt++;
	if ($sample_req_cart_app_list->RecCnt >= $sample_req_cart_app_list->StartRec) {
		$sample_req_cart_app_list->RowCnt++;

		// Set up key count
		$sample_req_cart_app_list->KeyCount = $sample_req_cart_app_list->RowIndex;

		// Init row class and style
		$sample_req_cart_app->resetAttributes();
		$sample_req_cart_app->CssClass = "";
		if ($sample_req_cart_app->isGridAdd()) {
		} else {
			$sample_req_cart_app_list->loadRowValues($sample_req_cart_app_list->Recordset); // Load row values
		}
		$sample_req_cart_app->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$sample_req_cart_app->RowAttrs = array_merge($sample_req_cart_app->RowAttrs, array('data-rowindex'=>$sample_req_cart_app_list->RowCnt, 'id'=>'r' . $sample_req_cart_app_list->RowCnt . '_sample_req_cart_app', 'data-rowtype'=>$sample_req_cart_app->RowType));

		// Render row
		$sample_req_cart_app_list->renderRow();

		// Render list options
		$sample_req_cart_app_list->renderListOptions();
?>
	<tr<?php echo $sample_req_cart_app->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sample_req_cart_app_list->ListOptions->render("body", "left", $sample_req_cart_app_list->RowCnt);
?>
	<?php if ($sample_req_cart_app->id->Visible) { // id ?>
		<td data-name="id"<?php echo $sample_req_cart_app->id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_id" class="sample_req_cart_app_id">
<span<?php echo $sample_req_cart_app->id->viewAttributes() ?>>
<?php echo $sample_req_cart_app->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $sample_req_cart_app->company_id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_company_id" class="sample_req_cart_app_company_id">
<span<?php echo $sample_req_cart_app->company_id->viewAttributes() ?>>
<?php echo $sample_req_cart_app->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $sample_req_cart_app->partner_id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_partner_id" class="sample_req_cart_app_partner_id">
<span<?php echo $sample_req_cart_app->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($sample_req_cart_app->partner_id->getViewValue())) && $sample_req_cart_app->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $sample_req_cart_app->partner_id->linkAttributes() ?>><?php echo $sample_req_cart_app->partner_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sample_req_cart_app->partner_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->old_ref->Visible) { // old_ref ?>
		<td data-name="old_ref"<?php echo $sample_req_cart_app->old_ref->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_old_ref" class="sample_req_cart_app_old_ref">
<span<?php echo $sample_req_cart_app->old_ref->viewAttributes() ?>>
<?php if ((!EmptyString($sample_req_cart_app->old_ref->getViewValue())) && $sample_req_cart_app->old_ref->linkAttributes() <> "") { ?>
<a<?php echo $sample_req_cart_app->old_ref->linkAttributes() ?>><?php echo $sample_req_cart_app->old_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sample_req_cart_app->old_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->upload->Visible) { // upload ?>
		<td data-name="upload"<?php echo $sample_req_cart_app->upload->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_upload" class="sample_req_cart_app_upload">
<span>
<?php echo GetFileViewTag($sample_req_cart_app->upload, $sample_req_cart_app->upload->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->design->Visible) { // design ?>
		<td data-name="design"<?php echo $sample_req_cart_app->design->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_design" class="sample_req_cart_app_design">
<span<?php echo $sample_req_cart_app->design->viewAttributes() ?>>
<?php echo $sample_req_cart_app->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->color->Visible) { // color ?>
		<td data-name="color"<?php echo $sample_req_cart_app->color->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_color" class="sample_req_cart_app_color">
<span<?php echo $sample_req_cart_app->color->viewAttributes() ?>>
<?php echo $sample_req_cart_app->color->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->size->Visible) { // size ?>
		<td data-name="size"<?php echo $sample_req_cart_app->size->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_size" class="sample_req_cart_app_size">
<span<?php echo $sample_req_cart_app->size->viewAttributes() ?>>
<?php echo $sample_req_cart_app->size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $sample_req_cart_app->quantity->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_quantity" class="sample_req_cart_app_quantity">
<span<?php echo $sample_req_cart_app->quantity->viewAttributes() ?>>
<?php echo $sample_req_cart_app->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->delivery_week->Visible) { // delivery_week ?>
		<td data-name="delivery_week"<?php echo $sample_req_cart_app->delivery_week->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_delivery_week" class="sample_req_cart_app_delivery_week">
<span<?php echo $sample_req_cart_app->delivery_week->viewAttributes() ?>>
<?php echo $sample_req_cart_app->delivery_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->status->Visible) { // status ?>
		<td data-name="status"<?php echo $sample_req_cart_app->status->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_status" class="sample_req_cart_app_status">
<span<?php echo $sample_req_cart_app->status->viewAttributes() ?>>
<?php echo $sample_req_cart_app->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $sample_req_cart_app->remarks->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_remarks" class="sample_req_cart_app_remarks">
<span<?php echo $sample_req_cart_app->remarks->viewAttributes() ?>>
<?php echo $sample_req_cart_app->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->pp_remarks->Visible) { // pp_remarks ?>
		<td data-name="pp_remarks"<?php echo $sample_req_cart_app->pp_remarks->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_pp_remarks" class="sample_req_cart_app_pp_remarks">
<span<?php echo $sample_req_cart_app->pp_remarks->viewAttributes() ?>>
<?php echo $sample_req_cart_app->pp_remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->price->Visible) { // price ?>
		<td data-name="price"<?php echo $sample_req_cart_app->price->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_price" class="sample_req_cart_app_price">
<span<?php echo $sample_req_cart_app->price->viewAttributes() ?>>
<?php echo $sample_req_cart_app->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_app->app_status->Visible) { // app_status ?>
		<td data-name="app_status"<?php echo $sample_req_cart_app->app_status->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_app_list->RowCnt ?>_sample_req_cart_app_app_status" class="sample_req_cart_app_app_status">
<span<?php echo $sample_req_cart_app->app_status->viewAttributes() ?>>
<?php echo $sample_req_cart_app->app_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sample_req_cart_app_list->ListOptions->render("body", "right", $sample_req_cart_app_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$sample_req_cart_app->isGridAdd())
		$sample_req_cart_app_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$sample_req_cart_app->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($sample_req_cart_app_list->Recordset)
	$sample_req_cart_app_list->Recordset->Close();
?>
<?php if (!$sample_req_cart_app->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$sample_req_cart_app->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sample_req_cart_app_list->Pager)) $sample_req_cart_app_list->Pager = new PrevNextPager($sample_req_cart_app_list->StartRec, $sample_req_cart_app_list->DisplayRecs, $sample_req_cart_app_list->TotalRecs, $sample_req_cart_app_list->AutoHidePager) ?>
<?php if ($sample_req_cart_app_list->Pager->RecordCount > 0 && $sample_req_cart_app_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sample_req_cart_app_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sample_req_cart_app_list->pageUrl() ?>start=<?php echo $sample_req_cart_app_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sample_req_cart_app_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sample_req_cart_app_list->pageUrl() ?>start=<?php echo $sample_req_cart_app_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sample_req_cart_app_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sample_req_cart_app_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sample_req_cart_app_list->pageUrl() ?>start=<?php echo $sample_req_cart_app_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sample_req_cart_app_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sample_req_cart_app_list->pageUrl() ?>start=<?php echo $sample_req_cart_app_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sample_req_cart_app_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sample_req_cart_app_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sample_req_cart_app_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sample_req_cart_app_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sample_req_cart_app_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sample_req_cart_app_list->TotalRecs > 0 && (!$sample_req_cart_app_list->AutoHidePageSizeSelector || $sample_req_cart_app_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sample_req_cart_app">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sample_req_cart_app_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sample_req_cart_app_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sample_req_cart_app_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sample_req_cart_app_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sample_req_cart_app_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sample_req_cart_app->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sample_req_cart_app_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($sample_req_cart_app_list->TotalRecs == 0 && !$sample_req_cart_app->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $sample_req_cart_app_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$sample_req_cart_app_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sample_req_cart_app->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$sample_req_cart_app->isExport()) { ?>
<script>
ew.scrollableTable("gmp_sample_req_cart_app", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sample_req_cart_app_list->terminate();
?>