<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_cart_app_search = new sample_req_cart_app_search();

// Run the page
$sample_req_cart_app_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_cart_app_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($sample_req_cart_app_search->IsModal) { ?>
var fsample_req_cart_appsearch = currentAdvancedSearchForm = new ew.Form("fsample_req_cart_appsearch", "search");
<?php } else { ?>
var fsample_req_cart_appsearch = currentForm = new ew.Form("fsample_req_cart_appsearch", "search");
<?php } ?>

// Form_CustomValidate event
fsample_req_cart_appsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_cart_appsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_cart_appsearch.lists["x_delivery_week"] = <?php echo $sample_req_cart_app_search->delivery_week->Lookup->toClientList() ?>;
fsample_req_cart_appsearch.lists["x_delivery_week"].options = <?php echo JsonEncode($sample_req_cart_app_search->delivery_week->lookupOptions()) ?>;
fsample_req_cart_appsearch.lists["x_status"] = <?php echo $sample_req_cart_app_search->status->Lookup->toClientList() ?>;
fsample_req_cart_appsearch.lists["x_status"].options = <?php echo JsonEncode($sample_req_cart_app_search->status->lookupOptions()) ?>;
fsample_req_cart_appsearch.lists["x_app_status"] = <?php echo $sample_req_cart_app_search->app_status->Lookup->toClientList() ?>;
fsample_req_cart_appsearch.lists["x_app_status"].options = <?php echo JsonEncode($sample_req_cart_app_search->app_status->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fsample_req_cart_appsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sample_req_cart_app->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sample_req_cart_app->quantity->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sample_req_cart_app_search->showPageHeader(); ?>
<?php
$sample_req_cart_app_search->showMessage();
?>
<form name="fsample_req_cart_appsearch" id="fsample_req_cart_appsearch" class="<?php echo $sample_req_cart_app_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_cart_app_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_cart_app_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart_app">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$sample_req_cart_app_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($sample_req_cart_app->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $sample_req_cart_app_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_app_id"><?php echo $sample_req_cart_app->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $sample_req_cart_app_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_app->id->cellAttributes() ?>>
			<span id="el_sample_req_cart_app_id">
<input type="text" data-table="sample_req_cart_app" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($sample_req_cart_app->id->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_app->id->EditValue ?>"<?php echo $sample_req_cart_app->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_app->old_ref->Visible) { // old_ref ?>
	<div id="r_old_ref" class="form-group row">
		<label for="x_old_ref" class="<?php echo $sample_req_cart_app_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_app_old_ref"><?php echo $sample_req_cart_app->old_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_old_ref" id="z_old_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $sample_req_cart_app_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_app->old_ref->cellAttributes() ?>>
			<span id="el_sample_req_cart_app_old_ref">
<input type="text" data-table="sample_req_cart_app" data-field="x_old_ref" name="x_old_ref" id="x_old_ref" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($sample_req_cart_app->old_ref->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_app->old_ref->EditValue ?>"<?php echo $sample_req_cart_app->old_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_app->upload->Visible) { // upload ?>
	<div id="r_upload" class="form-group row">
		<label class="<?php echo $sample_req_cart_app_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_app_upload"><?php echo $sample_req_cart_app->upload->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_upload" id="z_upload" value="LIKE"></span>
		</label>
		<div class="<?php echo $sample_req_cart_app_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_app->upload->cellAttributes() ?>>
			<span id="el_sample_req_cart_app_upload">
<input type="text" data-table="sample_req_cart_app" data-field="x_upload" name="x_upload" id="x_upload" placeholder="<?php echo HtmlEncode($sample_req_cart_app->upload->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_app->upload->EditValue ?>"<?php echo $sample_req_cart_app->upload->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_app->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label for="x_design" class="<?php echo $sample_req_cart_app_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_app_design"><?php echo $sample_req_cart_app->design->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		</label>
		<div class="<?php echo $sample_req_cart_app_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_app->design->cellAttributes() ?>>
			<span id="el_sample_req_cart_app_design">
<input type="text" data-table="sample_req_cart_app" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($sample_req_cart_app->design->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_app->design->EditValue ?>"<?php echo $sample_req_cart_app->design->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_app->color->Visible) { // color ?>
	<div id="r_color" class="form-group row">
		<label for="x_color" class="<?php echo $sample_req_cart_app_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_app_color"><?php echo $sample_req_cart_app->color->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_color" id="z_color" value="LIKE"></span>
		</label>
		<div class="<?php echo $sample_req_cart_app_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_app->color->cellAttributes() ?>>
			<span id="el_sample_req_cart_app_color">
<input type="text" data-table="sample_req_cart_app" data-field="x_color" name="x_color" id="x_color" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($sample_req_cart_app->color->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_app->color->EditValue ?>"<?php echo $sample_req_cart_app->color->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_app->size->Visible) { // size ?>
	<div id="r_size" class="form-group row">
		<label for="x_size" class="<?php echo $sample_req_cart_app_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_app_size"><?php echo $sample_req_cart_app->size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size" id="z_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $sample_req_cart_app_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_app->size->cellAttributes() ?>>
			<span id="el_sample_req_cart_app_size">
<input type="text" data-table="sample_req_cart_app" data-field="x_size" name="x_size" id="x_size" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($sample_req_cart_app->size->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_app->size->EditValue ?>"<?php echo $sample_req_cart_app->size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_app->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $sample_req_cart_app_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_app_quantity"><?php echo $sample_req_cart_app->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $sample_req_cart_app_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_app->quantity->cellAttributes() ?>>
			<span id="el_sample_req_cart_app_quantity">
<input type="text" data-table="sample_req_cart_app" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($sample_req_cart_app->quantity->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_app->quantity->EditValue ?>"<?php echo $sample_req_cart_app->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_app->delivery_week->Visible) { // delivery_week ?>
	<div id="r_delivery_week" class="form-group row">
		<label for="x_delivery_week" class="<?php echo $sample_req_cart_app_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_app_delivery_week"><?php echo $sample_req_cart_app->delivery_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_delivery_week" id="z_delivery_week" value="="></span>
		</label>
		<div class="<?php echo $sample_req_cart_app_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_app->delivery_week->cellAttributes() ?>>
			<span id="el_sample_req_cart_app_delivery_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_cart_app" data-field="x_delivery_week" data-value-separator="<?php echo $sample_req_cart_app->delivery_week->displayValueSeparatorAttribute() ?>" id="x_delivery_week" name="x_delivery_week"<?php echo $sample_req_cart_app->delivery_week->editAttributes() ?>>
		<?php echo $sample_req_cart_app->delivery_week->selectOptionListHtml("x_delivery_week") ?>
	</select>
</div>
<?php echo $sample_req_cart_app->delivery_week->Lookup->getParamTag("p_x_delivery_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_app->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $sample_req_cart_app_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_app_status"><?php echo $sample_req_cart_app->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $sample_req_cart_app_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_app->status->cellAttributes() ?>>
			<span id="el_sample_req_cart_app_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_cart_app" data-field="x_status" data-value-separator="<?php echo $sample_req_cart_app->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $sample_req_cart_app->status->editAttributes() ?>>
		<?php echo $sample_req_cart_app->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $sample_req_cart_app->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_app->sp_remarks->Visible) { // sp_remarks ?>
	<div id="r_sp_remarks" class="form-group row">
		<label for="x_sp_remarks" class="<?php echo $sample_req_cart_app_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_app_sp_remarks"><?php echo $sample_req_cart_app->sp_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sp_remarks" id="z_sp_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $sample_req_cart_app_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_app->sp_remarks->cellAttributes() ?>>
			<span id="el_sample_req_cart_app_sp_remarks">
<input type="text" data-table="sample_req_cart_app" data-field="x_sp_remarks" name="x_sp_remarks" id="x_sp_remarks" size="35" placeholder="<?php echo HtmlEncode($sample_req_cart_app->sp_remarks->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_app->sp_remarks->EditValue ?>"<?php echo $sample_req_cart_app->sp_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_app->app_status->Visible) { // app_status ?>
	<div id="r_app_status" class="form-group row">
		<label for="x_app_status" class="<?php echo $sample_req_cart_app_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_app_app_status"><?php echo $sample_req_cart_app->app_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_app_status" id="z_app_status" value="="></span>
		</label>
		<div class="<?php echo $sample_req_cart_app_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_app->app_status->cellAttributes() ?>>
			<span id="el_sample_req_cart_app_app_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_cart_app" data-field="x_app_status" data-value-separator="<?php echo $sample_req_cart_app->app_status->displayValueSeparatorAttribute() ?>" id="x_app_status" name="x_app_status"<?php echo $sample_req_cart_app->app_status->editAttributes() ?>>
		<?php echo $sample_req_cart_app->app_status->selectOptionListHtml("x_app_status") ?>
	</select>
</div>
<?php echo $sample_req_cart_app->app_status->Lookup->getParamTag("p_x_app_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$sample_req_cart_app_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $sample_req_cart_app_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$sample_req_cart_app_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sample_req_cart_app_search->terminate();
?>