<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_cart_app_view = new sample_req_cart_app_view();

// Run the page
$sample_req_cart_app_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_cart_app_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sample_req_cart_app->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fsample_req_cart_appview = currentForm = new ew.Form("fsample_req_cart_appview", "view");

// Form_CustomValidate event
fsample_req_cart_appview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_cart_appview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_cart_appview.lists["x_delivery_week"] = <?php echo $sample_req_cart_app_view->delivery_week->Lookup->toClientList() ?>;
fsample_req_cart_appview.lists["x_delivery_week"].options = <?php echo JsonEncode($sample_req_cart_app_view->delivery_week->lookupOptions()) ?>;
fsample_req_cart_appview.lists["x_app_status"] = <?php echo $sample_req_cart_app_view->app_status->Lookup->toClientList() ?>;
fsample_req_cart_appview.lists["x_app_status"].options = <?php echo JsonEncode($sample_req_cart_app_view->app_status->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sample_req_cart_app->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $sample_req_cart_app_view->ExportOptions->render("body") ?>
<?php $sample_req_cart_app_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $sample_req_cart_app_view->showPageHeader(); ?>
<?php
$sample_req_cart_app_view->showMessage();
?>
<form name="fsample_req_cart_appview" id="fsample_req_cart_appview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_cart_app_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_cart_app_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart_app">
<input type="hidden" name="modal" value="<?php echo (int)$sample_req_cart_app_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($sample_req_cart_app->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $sample_req_cart_app_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_app_id"><?php echo $sample_req_cart_app->id->caption() ?></span></td>
		<td data-name="id"<?php echo $sample_req_cart_app->id->cellAttributes() ?>>
<span id="el_sample_req_cart_app_id">
<span<?php echo $sample_req_cart_app->id->viewAttributes() ?>>
<?php echo $sample_req_cart_app->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart_app->old_ref->Visible) { // old_ref ?>
	<tr id="r_old_ref">
		<td class="<?php echo $sample_req_cart_app_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_app_old_ref"><?php echo $sample_req_cart_app->old_ref->caption() ?></span></td>
		<td data-name="old_ref"<?php echo $sample_req_cart_app->old_ref->cellAttributes() ?>>
<span id="el_sample_req_cart_app_old_ref">
<span<?php echo $sample_req_cart_app->old_ref->viewAttributes() ?>>
<?php if ((!EmptyString($sample_req_cart_app->old_ref->getViewValue())) && $sample_req_cart_app->old_ref->linkAttributes() <> "") { ?>
<a<?php echo $sample_req_cart_app->old_ref->linkAttributes() ?>><?php echo $sample_req_cart_app->old_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sample_req_cart_app->old_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart_app->upload->Visible) { // upload ?>
	<tr id="r_upload">
		<td class="<?php echo $sample_req_cart_app_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_app_upload"><?php echo $sample_req_cart_app->upload->caption() ?></span></td>
		<td data-name="upload"<?php echo $sample_req_cart_app->upload->cellAttributes() ?>>
<span id="el_sample_req_cart_app_upload">
<span>
<?php echo GetFileViewTag($sample_req_cart_app->upload, $sample_req_cart_app->upload->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart_app->design->Visible) { // design ?>
	<tr id="r_design">
		<td class="<?php echo $sample_req_cart_app_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_app_design"><?php echo $sample_req_cart_app->design->caption() ?></span></td>
		<td data-name="design"<?php echo $sample_req_cart_app->design->cellAttributes() ?>>
<span id="el_sample_req_cart_app_design">
<span<?php echo $sample_req_cart_app->design->viewAttributes() ?>>
<?php echo $sample_req_cart_app->design->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart_app->color->Visible) { // color ?>
	<tr id="r_color">
		<td class="<?php echo $sample_req_cart_app_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_app_color"><?php echo $sample_req_cart_app->color->caption() ?></span></td>
		<td data-name="color"<?php echo $sample_req_cart_app->color->cellAttributes() ?>>
<span id="el_sample_req_cart_app_color">
<span<?php echo $sample_req_cart_app->color->viewAttributes() ?>>
<?php echo $sample_req_cart_app->color->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart_app->size->Visible) { // size ?>
	<tr id="r_size">
		<td class="<?php echo $sample_req_cart_app_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_app_size"><?php echo $sample_req_cart_app->size->caption() ?></span></td>
		<td data-name="size"<?php echo $sample_req_cart_app->size->cellAttributes() ?>>
<span id="el_sample_req_cart_app_size">
<span<?php echo $sample_req_cart_app->size->viewAttributes() ?>>
<?php echo $sample_req_cart_app->size->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart_app->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $sample_req_cart_app_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_app_quantity"><?php echo $sample_req_cart_app->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $sample_req_cart_app->quantity->cellAttributes() ?>>
<span id="el_sample_req_cart_app_quantity">
<span<?php echo $sample_req_cart_app->quantity->viewAttributes() ?>>
<?php echo $sample_req_cart_app->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart_app->delivery_week->Visible) { // delivery_week ?>
	<tr id="r_delivery_week">
		<td class="<?php echo $sample_req_cart_app_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_app_delivery_week"><?php echo $sample_req_cart_app->delivery_week->caption() ?></span></td>
		<td data-name="delivery_week"<?php echo $sample_req_cart_app->delivery_week->cellAttributes() ?>>
<span id="el_sample_req_cart_app_delivery_week">
<span<?php echo $sample_req_cart_app->delivery_week->viewAttributes() ?>>
<?php echo $sample_req_cart_app->delivery_week->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart_app->sp_remarks->Visible) { // sp_remarks ?>
	<tr id="r_sp_remarks">
		<td class="<?php echo $sample_req_cart_app_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_app_sp_remarks"><?php echo $sample_req_cart_app->sp_remarks->caption() ?></span></td>
		<td data-name="sp_remarks"<?php echo $sample_req_cart_app->sp_remarks->cellAttributes() ?>>
<span id="el_sample_req_cart_app_sp_remarks">
<span<?php echo $sample_req_cart_app->sp_remarks->viewAttributes() ?>>
<?php echo $sample_req_cart_app->sp_remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart_app->app_status->Visible) { // app_status ?>
	<tr id="r_app_status">
		<td class="<?php echo $sample_req_cart_app_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_app_app_status"><?php echo $sample_req_cart_app->app_status->caption() ?></span></td>
		<td data-name="app_status"<?php echo $sample_req_cart_app->app_status->cellAttributes() ?>>
<span id="el_sample_req_cart_app_app_status">
<span<?php echo $sample_req_cart_app->app_status->viewAttributes() ?>>
<?php echo $sample_req_cart_app->app_status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$sample_req_cart_app_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sample_req_cart_app->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sample_req_cart_app_view->terminate();
?>