<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_cart_feedback_list = new sample_req_cart_feedback_list();

// Run the page
$sample_req_cart_feedback_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_cart_feedback_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sample_req_cart_feedback->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsample_req_cart_feedbacklist = currentForm = new ew.Form("fsample_req_cart_feedbacklist", "list");
fsample_req_cart_feedbacklist.formKeyCountName = '<?php echo $sample_req_cart_feedback_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsample_req_cart_feedbacklist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_cart_feedbacklist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_cart_feedbacklist.lists["x_request_by"] = <?php echo $sample_req_cart_feedback_list->request_by->Lookup->toClientList() ?>;
fsample_req_cart_feedbacklist.lists["x_request_by"].options = <?php echo JsonEncode($sample_req_cart_feedback_list->request_by->lookupOptions()) ?>;
fsample_req_cart_feedbacklist.autoSuggests["x_request_by"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsample_req_cart_feedbacklist.lists["x_company_id"] = <?php echo $sample_req_cart_feedback_list->company_id->Lookup->toClientList() ?>;
fsample_req_cart_feedbacklist.lists["x_company_id"].options = <?php echo JsonEncode($sample_req_cart_feedback_list->company_id->lookupOptions()) ?>;
fsample_req_cart_feedbacklist.lists["x_partner_id"] = <?php echo $sample_req_cart_feedback_list->partner_id->Lookup->toClientList() ?>;
fsample_req_cart_feedbacklist.lists["x_partner_id"].options = <?php echo JsonEncode($sample_req_cart_feedback_list->partner_id->lookupOptions()) ?>;
fsample_req_cart_feedbacklist.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsample_req_cart_feedbacklist.lists["x_f_yn"] = <?php echo $sample_req_cart_feedback_list->f_yn->Lookup->toClientList() ?>;
fsample_req_cart_feedbacklist.lists["x_f_yn"].options = <?php echo JsonEncode($sample_req_cart_feedback_list->f_yn->lookupOptions()) ?>;
fsample_req_cart_feedbacklist.lists["x_delivery_week"] = <?php echo $sample_req_cart_feedback_list->delivery_week->Lookup->toClientList() ?>;
fsample_req_cart_feedbacklist.lists["x_delivery_week"].options = <?php echo JsonEncode($sample_req_cart_feedback_list->delivery_week->lookupOptions()) ?>;
fsample_req_cart_feedbacklist.lists["x_status"] = <?php echo $sample_req_cart_feedback_list->status->Lookup->toClientList() ?>;
fsample_req_cart_feedbacklist.lists["x_status"].options = <?php echo JsonEncode($sample_req_cart_feedback_list->status->lookupOptions()) ?>;

// Form object for search
var fsample_req_cart_feedbacklistsrch = currentSearchForm = new ew.Form("fsample_req_cart_feedbacklistsrch");

// Validate function for search
fsample_req_cart_feedbacklistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sample_req_cart_feedback->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fsample_req_cart_feedbacklistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_cart_feedbacklistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_cart_feedbacklistsrch.lists["x_partner_id"] = <?php echo $sample_req_cart_feedback_list->partner_id->Lookup->toClientList() ?>;
fsample_req_cart_feedbacklistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($sample_req_cart_feedback_list->partner_id->lookupOptions()) ?>;
fsample_req_cart_feedbacklistsrch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsample_req_cart_feedbacklistsrch.lists["x_status"] = <?php echo $sample_req_cart_feedback_list->status->Lookup->toClientList() ?>;
fsample_req_cart_feedbacklistsrch.lists["x_status"].options = <?php echo JsonEncode($sample_req_cart_feedback_list->status->lookupOptions()) ?>;

// Filters
fsample_req_cart_feedbacklistsrch.filterList = <?php echo $sample_req_cart_feedback_list->getFilterList() ?>;

// Init search panel as collapsed
fsample_req_cart_feedbacklistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sample_req_cart_feedback->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($sample_req_cart_feedback_list->TotalRecs > 0 && $sample_req_cart_feedback_list->ExportOptions->visible()) { ?>
<?php $sample_req_cart_feedback_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_cart_feedback_list->ImportOptions->visible()) { ?>
<?php $sample_req_cart_feedback_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_cart_feedback_list->SearchOptions->visible()) { ?>
<?php $sample_req_cart_feedback_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_cart_feedback_list->FilterOptions->visible()) { ?>
<?php $sample_req_cart_feedback_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$sample_req_cart_feedback_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$sample_req_cart_feedback->isExport() && !$sample_req_cart_feedback->CurrentAction) { ?>
<form name="fsample_req_cart_feedbacklistsrch" id="fsample_req_cart_feedbacklistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($sample_req_cart_feedback_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fsample_req_cart_feedbacklistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="sample_req_cart_feedback">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$sample_req_cart_feedback_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$sample_req_cart_feedback->RowType = ROWTYPE_SEARCH;

// Render row
$sample_req_cart_feedback->resetAttributes();
$sample_req_cart_feedback_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($sample_req_cart_feedback->id->Visible) { // id ?>
	<div id="xsc_id" class="ew-cell form-group">
		<label for="x_id" class="ew-search-caption ew-label"><?php echo $sample_req_cart_feedback->id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="sample_req_cart_feedback" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($sample_req_cart_feedback->id->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_feedback->id->EditValue ?>"<?php echo $sample_req_cart_feedback->id->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($sample_req_cart_feedback->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $sample_req_cart_feedback->partner_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$sample_req_cart_feedback->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$sample_req_cart_feedback->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($sample_req_cart_feedback->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($sample_req_cart_feedback->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($sample_req_cart_feedback->partner_id->getPlaceHolder()) ?>"<?php echo $sample_req_cart_feedback->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="sample_req_cart_feedback" data-field="x_partner_id" data-value-separator="<?php echo $sample_req_cart_feedback->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($sample_req_cart_feedback->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fsample_req_cart_feedbacklistsrch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $sample_req_cart_feedback->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($sample_req_cart_feedback->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $sample_req_cart_feedback->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_cart_feedback" data-field="x_status" data-value-separator="<?php echo $sample_req_cart_feedback->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $sample_req_cart_feedback->status->editAttributes() ?>>
		<?php echo $sample_req_cart_feedback->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $sample_req_cart_feedback->status->Lookup->getParamTag("p_x_status") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($sample_req_cart_feedback_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($sample_req_cart_feedback_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $sample_req_cart_feedback_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($sample_req_cart_feedback_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($sample_req_cart_feedback_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($sample_req_cart_feedback_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($sample_req_cart_feedback_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $sample_req_cart_feedback_list->showPageHeader(); ?>
<?php
$sample_req_cart_feedback_list->showMessage();
?>
<?php if ($sample_req_cart_feedback_list->TotalRecs > 0 || $sample_req_cart_feedback->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($sample_req_cart_feedback_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> sample_req_cart_feedback">
<?php if (!$sample_req_cart_feedback->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$sample_req_cart_feedback->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sample_req_cart_feedback_list->Pager)) $sample_req_cart_feedback_list->Pager = new PrevNextPager($sample_req_cart_feedback_list->StartRec, $sample_req_cart_feedback_list->DisplayRecs, $sample_req_cart_feedback_list->TotalRecs, $sample_req_cart_feedback_list->AutoHidePager) ?>
<?php if ($sample_req_cart_feedback_list->Pager->RecordCount > 0 && $sample_req_cart_feedback_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sample_req_cart_feedback_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sample_req_cart_feedback_list->pageUrl() ?>start=<?php echo $sample_req_cart_feedback_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sample_req_cart_feedback_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sample_req_cart_feedback_list->pageUrl() ?>start=<?php echo $sample_req_cart_feedback_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sample_req_cart_feedback_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sample_req_cart_feedback_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sample_req_cart_feedback_list->pageUrl() ?>start=<?php echo $sample_req_cart_feedback_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sample_req_cart_feedback_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sample_req_cart_feedback_list->pageUrl() ?>start=<?php echo $sample_req_cart_feedback_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sample_req_cart_feedback_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sample_req_cart_feedback_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sample_req_cart_feedback_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sample_req_cart_feedback_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sample_req_cart_feedback_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sample_req_cart_feedback_list->TotalRecs > 0 && (!$sample_req_cart_feedback_list->AutoHidePageSizeSelector || $sample_req_cart_feedback_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sample_req_cart_feedback">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sample_req_cart_feedback_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sample_req_cart_feedback_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sample_req_cart_feedback_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sample_req_cart_feedback_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sample_req_cart_feedback_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sample_req_cart_feedback->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sample_req_cart_feedback_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsample_req_cart_feedbacklist" id="fsample_req_cart_feedbacklist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_cart_feedback_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_cart_feedback_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart_feedback">
<div id="gmp_sample_req_cart_feedback" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($sample_req_cart_feedback_list->TotalRecs > 0 || $sample_req_cart_feedback->isGridEdit()) { ?>
<table id="tbl_sample_req_cart_feedbacklist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$sample_req_cart_feedback_list->RowType = ROWTYPE_HEADER;

// Render list options
$sample_req_cart_feedback_list->renderListOptions();

// Render list options (header, left)
$sample_req_cart_feedback_list->ListOptions->render("header", "left");
?>
<?php if ($sample_req_cart_feedback->id->Visible) { // id ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->id) == "") { ?>
		<th data-name="id" class="<?php echo $sample_req_cart_feedback->id->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_id" class="sample_req_cart_feedback_id"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $sample_req_cart_feedback->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->id) ?>',2);"><div id="elh_sample_req_cart_feedback_id" class="sample_req_cart_feedback_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->request_by->Visible) { // request_by ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->request_by) == "") { ?>
		<th data-name="request_by" class="<?php echo $sample_req_cart_feedback->request_by->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_request_by" class="sample_req_cart_feedback_request_by"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->request_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="request_by" class="<?php echo $sample_req_cart_feedback->request_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->request_by) ?>',2);"><div id="elh_sample_req_cart_feedback_request_by" class="sample_req_cart_feedback_request_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->request_by->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->request_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->request_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->company_id->Visible) { // company_id ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $sample_req_cart_feedback->company_id->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_company_id" class="sample_req_cart_feedback_company_id"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $sample_req_cart_feedback->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->company_id) ?>',2);"><div id="elh_sample_req_cart_feedback_company_id" class="sample_req_cart_feedback_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->partner_id->Visible) { // partner_id ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $sample_req_cart_feedback->partner_id->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_partner_id" class="sample_req_cart_feedback_partner_id"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $sample_req_cart_feedback->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->partner_id) ?>',2);"><div id="elh_sample_req_cart_feedback_partner_id" class="sample_req_cart_feedback_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->partner_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->old_ref->Visible) { // old_ref ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->old_ref) == "") { ?>
		<th data-name="old_ref" class="<?php echo $sample_req_cart_feedback->old_ref->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_old_ref" class="sample_req_cart_feedback_old_ref"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->old_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="old_ref" class="<?php echo $sample_req_cart_feedback->old_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->old_ref) ?>',2);"><div id="elh_sample_req_cart_feedback_old_ref" class="sample_req_cart_feedback_old_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->old_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->old_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->old_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->design->Visible) { // design ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->design) == "") { ?>
		<th data-name="design" class="<?php echo $sample_req_cart_feedback->design->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_design" class="sample_req_cart_feedback_design"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $sample_req_cart_feedback->design->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->design) ?>',2);"><div id="elh_sample_req_cart_feedback_design" class="sample_req_cart_feedback_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->color->Visible) { // color ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->color) == "") { ?>
		<th data-name="color" class="<?php echo $sample_req_cart_feedback->color->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_color" class="sample_req_cart_feedback_color"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->color->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="color" class="<?php echo $sample_req_cart_feedback->color->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->color) ?>',2);"><div id="elh_sample_req_cart_feedback_color" class="sample_req_cart_feedback_color">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->color->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->color->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->color->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->size->Visible) { // size ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->size) == "") { ?>
		<th data-name="size" class="<?php echo $sample_req_cart_feedback->size->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_size" class="sample_req_cart_feedback_size"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size" class="<?php echo $sample_req_cart_feedback->size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->size) ?>',2);"><div id="elh_sample_req_cart_feedback_size" class="sample_req_cart_feedback_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->f_yn->Visible) { // f_yn ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->f_yn) == "") { ?>
		<th data-name="f_yn" class="<?php echo $sample_req_cart_feedback->f_yn->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_f_yn" class="sample_req_cart_feedback_f_yn"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->f_yn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="f_yn" class="<?php echo $sample_req_cart_feedback->f_yn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->f_yn) ?>',2);"><div id="elh_sample_req_cart_feedback_f_yn" class="sample_req_cart_feedback_f_yn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->f_yn->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->f_yn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->f_yn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->f_upload->Visible) { // f_upload ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->f_upload) == "") { ?>
		<th data-name="f_upload" class="<?php echo $sample_req_cart_feedback->f_upload->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_f_upload" class="sample_req_cart_feedback_f_upload"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->f_upload->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="f_upload" class="<?php echo $sample_req_cart_feedback->f_upload->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->f_upload) ?>',2);"><div id="elh_sample_req_cart_feedback_f_upload" class="sample_req_cart_feedback_f_upload">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->f_upload->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->f_upload->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->f_upload->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->quantity->Visible) { // quantity ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $sample_req_cart_feedback->quantity->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_quantity" class="sample_req_cart_feedback_quantity"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $sample_req_cart_feedback->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->quantity) ?>',2);"><div id="elh_sample_req_cart_feedback_quantity" class="sample_req_cart_feedback_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->delivery_week->Visible) { // delivery_week ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->delivery_week) == "") { ?>
		<th data-name="delivery_week" class="<?php echo $sample_req_cart_feedback->delivery_week->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_delivery_week" class="sample_req_cart_feedback_delivery_week"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->delivery_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_week" class="<?php echo $sample_req_cart_feedback->delivery_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->delivery_week) ?>',2);"><div id="elh_sample_req_cart_feedback_delivery_week" class="sample_req_cart_feedback_delivery_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->delivery_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->delivery_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->delivery_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->status->Visible) { // status ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->status) == "") { ?>
		<th data-name="status" class="<?php echo $sample_req_cart_feedback->status->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_sample_req_cart_feedback_status" class="sample_req_cart_feedback_status"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $sample_req_cart_feedback->status->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->status) ?>',2);"><div id="elh_sample_req_cart_feedback_status" class="sample_req_cart_feedback_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->upload->Visible) { // upload ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->upload) == "") { ?>
		<th data-name="upload" class="<?php echo $sample_req_cart_feedback->upload->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_upload" class="sample_req_cart_feedback_upload"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->upload->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="upload" class="<?php echo $sample_req_cart_feedback->upload->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->upload) ?>',2);"><div id="elh_sample_req_cart_feedback_upload" class="sample_req_cart_feedback_upload">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->upload->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->upload->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->upload->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->remarks->Visible) { // remarks ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $sample_req_cart_feedback->remarks->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_sample_req_cart_feedback_remarks" class="sample_req_cart_feedback_remarks"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $sample_req_cart_feedback->remarks->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->remarks) ?>',2);"><div id="elh_sample_req_cart_feedback_remarks" class="sample_req_cart_feedback_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->pp_remarks->Visible) { // pp_remarks ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->pp_remarks) == "") { ?>
		<th data-name="pp_remarks" class="<?php echo $sample_req_cart_feedback->pp_remarks->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_sample_req_cart_feedback_pp_remarks" class="sample_req_cart_feedback_pp_remarks"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->pp_remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pp_remarks" class="<?php echo $sample_req_cart_feedback->pp_remarks->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->pp_remarks) ?>',2);"><div id="elh_sample_req_cart_feedback_pp_remarks" class="sample_req_cart_feedback_pp_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->pp_remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->pp_remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->pp_remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->po_remarks->Visible) { // po_remarks ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->po_remarks) == "") { ?>
		<th data-name="po_remarks" class="<?php echo $sample_req_cart_feedback->po_remarks->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_po_remarks" class="sample_req_cart_feedback_po_remarks"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->po_remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_remarks" class="<?php echo $sample_req_cart_feedback->po_remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->po_remarks) ?>',2);"><div id="elh_sample_req_cart_feedback_po_remarks" class="sample_req_cart_feedback_po_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->po_remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->po_remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->po_remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->price->Visible) { // price ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->price) == "") { ?>
		<th data-name="price" class="<?php echo $sample_req_cart_feedback->price->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_sample_req_cart_feedback_price" class="sample_req_cart_feedback_price"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $sample_req_cart_feedback->price->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->price) ?>',2);"><div id="elh_sample_req_cart_feedback_price" class="sample_req_cart_feedback_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->dispatch->Visible) { // dispatch ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->dispatch) == "") { ?>
		<th data-name="dispatch" class="<?php echo $sample_req_cart_feedback->dispatch->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_dispatch" class="sample_req_cart_feedback_dispatch"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->dispatch->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dispatch" class="<?php echo $sample_req_cart_feedback->dispatch->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->dispatch) ?>',2);"><div id="elh_sample_req_cart_feedback_dispatch" class="sample_req_cart_feedback_dispatch">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->dispatch->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->dispatch->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->dispatch->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->d_upload->Visible) { // d_upload ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->d_upload) == "") { ?>
		<th data-name="d_upload" class="<?php echo $sample_req_cart_feedback->d_upload->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_d_upload" class="sample_req_cart_feedback_d_upload"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->d_upload->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_upload" class="<?php echo $sample_req_cart_feedback->d_upload->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->d_upload) ?>',2);"><div id="elh_sample_req_cart_feedback_d_upload" class="sample_req_cart_feedback_d_upload">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->d_upload->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->d_upload->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->d_upload->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->f_operator->Visible) { // f_operator ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->f_operator) == "") { ?>
		<th data-name="f_operator" class="<?php echo $sample_req_cart_feedback->f_operator->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_f_operator" class="sample_req_cart_feedback_f_operator"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->f_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="f_operator" class="<?php echo $sample_req_cart_feedback->f_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->f_operator) ?>',2);"><div id="elh_sample_req_cart_feedback_f_operator" class="sample_req_cart_feedback_f_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->f_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->f_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->f_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->f_datetime->Visible) { // f_datetime ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->f_datetime) == "") { ?>
		<th data-name="f_datetime" class="<?php echo $sample_req_cart_feedback->f_datetime->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_f_datetime" class="sample_req_cart_feedback_f_datetime"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->f_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="f_datetime" class="<?php echo $sample_req_cart_feedback->f_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->f_datetime) ?>',2);"><div id="elh_sample_req_cart_feedback_f_datetime" class="sample_req_cart_feedback_f_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->f_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->f_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->f_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->req_chat_id->Visible) { // req_chat_id ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->req_chat_id) == "") { ?>
		<th data-name="req_chat_id" class="<?php echo $sample_req_cart_feedback->req_chat_id->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_req_chat_id" class="sample_req_cart_feedback_req_chat_id"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->req_chat_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_chat_id" class="<?php echo $sample_req_cart_feedback->req_chat_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->req_chat_id) ?>',2);"><div id="elh_sample_req_cart_feedback_req_chat_id" class="sample_req_cart_feedback_req_chat_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->req_chat_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->req_chat_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->req_chat_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_feedback->url->Visible) { // url ?>
	<?php if ($sample_req_cart_feedback->sortUrl($sample_req_cart_feedback->url) == "") { ?>
		<th data-name="url" class="<?php echo $sample_req_cart_feedback->url->headerCellClass() ?>"><div id="elh_sample_req_cart_feedback_url" class="sample_req_cart_feedback_url"><div class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $sample_req_cart_feedback->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_feedback->SortUrl($sample_req_cart_feedback->url) ?>',2);"><div id="elh_sample_req_cart_feedback_url" class="sample_req_cart_feedback_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_feedback->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_feedback->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_feedback->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sample_req_cart_feedback_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($sample_req_cart_feedback->ExportAll && $sample_req_cart_feedback->isExport()) {
	$sample_req_cart_feedback_list->StopRec = $sample_req_cart_feedback_list->TotalRecs;
} else {

	// Set the last record to display
	if ($sample_req_cart_feedback_list->TotalRecs > $sample_req_cart_feedback_list->StartRec + $sample_req_cart_feedback_list->DisplayRecs - 1)
		$sample_req_cart_feedback_list->StopRec = $sample_req_cart_feedback_list->StartRec + $sample_req_cart_feedback_list->DisplayRecs - 1;
	else
		$sample_req_cart_feedback_list->StopRec = $sample_req_cart_feedback_list->TotalRecs;
}
$sample_req_cart_feedback_list->RecCnt = $sample_req_cart_feedback_list->StartRec - 1;
if ($sample_req_cart_feedback_list->Recordset && !$sample_req_cart_feedback_list->Recordset->EOF) {
	$sample_req_cart_feedback_list->Recordset->moveFirst();
	$selectLimit = $sample_req_cart_feedback_list->UseSelectLimit;
	if (!$selectLimit && $sample_req_cart_feedback_list->StartRec > 1)
		$sample_req_cart_feedback_list->Recordset->move($sample_req_cart_feedback_list->StartRec - 1);
} elseif (!$sample_req_cart_feedback->AllowAddDeleteRow && $sample_req_cart_feedback_list->StopRec == 0) {
	$sample_req_cart_feedback_list->StopRec = $sample_req_cart_feedback->GridAddRowCount;
}

// Initialize aggregate
$sample_req_cart_feedback->RowType = ROWTYPE_AGGREGATEINIT;
$sample_req_cart_feedback->resetAttributes();
$sample_req_cart_feedback_list->renderRow();
while ($sample_req_cart_feedback_list->RecCnt < $sample_req_cart_feedback_list->StopRec) {
	$sample_req_cart_feedback_list->RecCnt++;
	if ($sample_req_cart_feedback_list->RecCnt >= $sample_req_cart_feedback_list->StartRec) {
		$sample_req_cart_feedback_list->RowCnt++;

		// Set up key count
		$sample_req_cart_feedback_list->KeyCount = $sample_req_cart_feedback_list->RowIndex;

		// Init row class and style
		$sample_req_cart_feedback->resetAttributes();
		$sample_req_cart_feedback->CssClass = "";
		if ($sample_req_cart_feedback->isGridAdd()) {
		} else {
			$sample_req_cart_feedback_list->loadRowValues($sample_req_cart_feedback_list->Recordset); // Load row values
		}
		$sample_req_cart_feedback->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$sample_req_cart_feedback->RowAttrs = array_merge($sample_req_cart_feedback->RowAttrs, array('data-rowindex'=>$sample_req_cart_feedback_list->RowCnt, 'id'=>'r' . $sample_req_cart_feedback_list->RowCnt . '_sample_req_cart_feedback', 'data-rowtype'=>$sample_req_cart_feedback->RowType));

		// Render row
		$sample_req_cart_feedback_list->renderRow();

		// Render list options
		$sample_req_cart_feedback_list->renderListOptions();
?>
	<tr<?php echo $sample_req_cart_feedback->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sample_req_cart_feedback_list->ListOptions->render("body", "left", $sample_req_cart_feedback_list->RowCnt);
?>
	<?php if ($sample_req_cart_feedback->id->Visible) { // id ?>
		<td data-name="id"<?php echo $sample_req_cart_feedback->id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_id" class="sample_req_cart_feedback_id">
<span<?php echo $sample_req_cart_feedback->id->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->request_by->Visible) { // request_by ?>
		<td data-name="request_by"<?php echo $sample_req_cart_feedback->request_by->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_request_by" class="sample_req_cart_feedback_request_by">
<span<?php echo $sample_req_cart_feedback->request_by->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->request_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $sample_req_cart_feedback->company_id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_company_id" class="sample_req_cart_feedback_company_id">
<span<?php echo $sample_req_cart_feedback->company_id->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $sample_req_cart_feedback->partner_id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_partner_id" class="sample_req_cart_feedback_partner_id">
<span<?php echo $sample_req_cart_feedback->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($sample_req_cart_feedback->partner_id->getViewValue())) && $sample_req_cart_feedback->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $sample_req_cart_feedback->partner_id->linkAttributes() ?>><?php echo $sample_req_cart_feedback->partner_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sample_req_cart_feedback->partner_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->old_ref->Visible) { // old_ref ?>
		<td data-name="old_ref"<?php echo $sample_req_cart_feedback->old_ref->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_old_ref" class="sample_req_cart_feedback_old_ref">
<span<?php echo $sample_req_cart_feedback->old_ref->viewAttributes() ?>>
<?php if ((!EmptyString($sample_req_cart_feedback->old_ref->getViewValue())) && $sample_req_cart_feedback->old_ref->linkAttributes() <> "") { ?>
<a<?php echo $sample_req_cart_feedback->old_ref->linkAttributes() ?>><?php echo $sample_req_cart_feedback->old_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sample_req_cart_feedback->old_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->design->Visible) { // design ?>
		<td data-name="design"<?php echo $sample_req_cart_feedback->design->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_design" class="sample_req_cart_feedback_design">
<span<?php echo $sample_req_cart_feedback->design->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->color->Visible) { // color ?>
		<td data-name="color"<?php echo $sample_req_cart_feedback->color->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_color" class="sample_req_cart_feedback_color">
<span<?php echo $sample_req_cart_feedback->color->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->color->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->size->Visible) { // size ?>
		<td data-name="size"<?php echo $sample_req_cart_feedback->size->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_size" class="sample_req_cart_feedback_size">
<span<?php echo $sample_req_cart_feedback->size->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->f_yn->Visible) { // f_yn ?>
		<td data-name="f_yn"<?php echo $sample_req_cart_feedback->f_yn->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_f_yn" class="sample_req_cart_feedback_f_yn">
<span<?php echo $sample_req_cart_feedback->f_yn->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->f_yn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->f_upload->Visible) { // f_upload ?>
		<td data-name="f_upload"<?php echo $sample_req_cart_feedback->f_upload->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_f_upload" class="sample_req_cart_feedback_f_upload">
<span>
<?php echo GetFileViewTag($sample_req_cart_feedback->f_upload, $sample_req_cart_feedback->f_upload->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $sample_req_cart_feedback->quantity->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_quantity" class="sample_req_cart_feedback_quantity">
<span<?php echo $sample_req_cart_feedback->quantity->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->delivery_week->Visible) { // delivery_week ?>
		<td data-name="delivery_week"<?php echo $sample_req_cart_feedback->delivery_week->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_delivery_week" class="sample_req_cart_feedback_delivery_week">
<span<?php echo $sample_req_cart_feedback->delivery_week->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->delivery_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->status->Visible) { // status ?>
		<td data-name="status"<?php echo $sample_req_cart_feedback->status->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_status" class="sample_req_cart_feedback_status">
<span<?php echo $sample_req_cart_feedback->status->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->upload->Visible) { // upload ?>
		<td data-name="upload"<?php echo $sample_req_cart_feedback->upload->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_upload" class="sample_req_cart_feedback_upload">
<span>
<?php echo GetFileViewTag($sample_req_cart_feedback->upload, $sample_req_cart_feedback->upload->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $sample_req_cart_feedback->remarks->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_remarks" class="sample_req_cart_feedback_remarks">
<span<?php echo $sample_req_cart_feedback->remarks->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->pp_remarks->Visible) { // pp_remarks ?>
		<td data-name="pp_remarks"<?php echo $sample_req_cart_feedback->pp_remarks->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_pp_remarks" class="sample_req_cart_feedback_pp_remarks">
<span<?php echo $sample_req_cart_feedback->pp_remarks->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->pp_remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->po_remarks->Visible) { // po_remarks ?>
		<td data-name="po_remarks"<?php echo $sample_req_cart_feedback->po_remarks->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_po_remarks" class="sample_req_cart_feedback_po_remarks">
<span<?php echo $sample_req_cart_feedback->po_remarks->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->po_remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->price->Visible) { // price ?>
		<td data-name="price"<?php echo $sample_req_cart_feedback->price->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_price" class="sample_req_cart_feedback_price">
<span<?php echo $sample_req_cart_feedback->price->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->dispatch->Visible) { // dispatch ?>
		<td data-name="dispatch"<?php echo $sample_req_cart_feedback->dispatch->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_dispatch" class="sample_req_cart_feedback_dispatch">
<span<?php echo $sample_req_cart_feedback->dispatch->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->dispatch->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->d_upload->Visible) { // d_upload ?>
		<td data-name="d_upload"<?php echo $sample_req_cart_feedback->d_upload->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_d_upload" class="sample_req_cart_feedback_d_upload">
<span<?php echo $sample_req_cart_feedback->d_upload->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->d_upload->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->f_operator->Visible) { // f_operator ?>
		<td data-name="f_operator"<?php echo $sample_req_cart_feedback->f_operator->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_f_operator" class="sample_req_cart_feedback_f_operator">
<span<?php echo $sample_req_cart_feedback->f_operator->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->f_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->f_datetime->Visible) { // f_datetime ?>
		<td data-name="f_datetime"<?php echo $sample_req_cart_feedback->f_datetime->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_f_datetime" class="sample_req_cart_feedback_f_datetime">
<span<?php echo $sample_req_cart_feedback->f_datetime->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->f_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->req_chat_id->Visible) { // req_chat_id ?>
		<td data-name="req_chat_id"<?php echo $sample_req_cart_feedback->req_chat_id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_req_chat_id" class="sample_req_cart_feedback_req_chat_id">
<span<?php echo $sample_req_cart_feedback->req_chat_id->viewAttributes() ?>>
<?php if ((!EmptyString($sample_req_cart_feedback->req_chat_id->getViewValue())) && $sample_req_cart_feedback->req_chat_id->linkAttributes() <> "") { ?>
<a<?php echo $sample_req_cart_feedback->req_chat_id->linkAttributes() ?>><?php echo $sample_req_cart_feedback->req_chat_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sample_req_cart_feedback->req_chat_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_feedback->url->Visible) { // url ?>
		<td data-name="url"<?php echo $sample_req_cart_feedback->url->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_feedback_list->RowCnt ?>_sample_req_cart_feedback_url" class="sample_req_cart_feedback_url">
<span<?php echo $sample_req_cart_feedback->url->viewAttributes() ?>>
<?php echo $sample_req_cart_feedback->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sample_req_cart_feedback_list->ListOptions->render("body", "right", $sample_req_cart_feedback_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$sample_req_cart_feedback->isGridAdd())
		$sample_req_cart_feedback_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$sample_req_cart_feedback->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($sample_req_cart_feedback_list->Recordset)
	$sample_req_cart_feedback_list->Recordset->Close();
?>
<?php if (!$sample_req_cart_feedback->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$sample_req_cart_feedback->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sample_req_cart_feedback_list->Pager)) $sample_req_cart_feedback_list->Pager = new PrevNextPager($sample_req_cart_feedback_list->StartRec, $sample_req_cart_feedback_list->DisplayRecs, $sample_req_cart_feedback_list->TotalRecs, $sample_req_cart_feedback_list->AutoHidePager) ?>
<?php if ($sample_req_cart_feedback_list->Pager->RecordCount > 0 && $sample_req_cart_feedback_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sample_req_cart_feedback_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sample_req_cart_feedback_list->pageUrl() ?>start=<?php echo $sample_req_cart_feedback_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sample_req_cart_feedback_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sample_req_cart_feedback_list->pageUrl() ?>start=<?php echo $sample_req_cart_feedback_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sample_req_cart_feedback_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sample_req_cart_feedback_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sample_req_cart_feedback_list->pageUrl() ?>start=<?php echo $sample_req_cart_feedback_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sample_req_cart_feedback_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sample_req_cart_feedback_list->pageUrl() ?>start=<?php echo $sample_req_cart_feedback_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sample_req_cart_feedback_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sample_req_cart_feedback_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sample_req_cart_feedback_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sample_req_cart_feedback_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sample_req_cart_feedback_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sample_req_cart_feedback_list->TotalRecs > 0 && (!$sample_req_cart_feedback_list->AutoHidePageSizeSelector || $sample_req_cart_feedback_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sample_req_cart_feedback">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sample_req_cart_feedback_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sample_req_cart_feedback_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sample_req_cart_feedback_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sample_req_cart_feedback_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sample_req_cart_feedback_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sample_req_cart_feedback->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sample_req_cart_feedback_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($sample_req_cart_feedback_list->TotalRecs == 0 && !$sample_req_cart_feedback->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $sample_req_cart_feedback_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$sample_req_cart_feedback_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sample_req_cart_feedback->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$sample_req_cart_feedback->isExport()) { ?>
<script>
ew.scrollableTable("gmp_sample_req_cart_feedback", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sample_req_cart_feedback_list->terminate();
?>