<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_cart_po_search = new sample_req_cart_po_search();

// Run the page
$sample_req_cart_po_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_cart_po_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($sample_req_cart_po_search->IsModal) { ?>
var fsample_req_cart_posearch = currentAdvancedSearchForm = new ew.Form("fsample_req_cart_posearch", "search");
<?php } else { ?>
var fsample_req_cart_posearch = currentForm = new ew.Form("fsample_req_cart_posearch", "search");
<?php } ?>

// Form_CustomValidate event
fsample_req_cart_posearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_cart_posearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_cart_posearch.lists["x_delivery_week"] = <?php echo $sample_req_cart_po_search->delivery_week->Lookup->toClientList() ?>;
fsample_req_cart_posearch.lists["x_delivery_week"].options = <?php echo JsonEncode($sample_req_cart_po_search->delivery_week->lookupOptions()) ?>;
fsample_req_cart_posearch.lists["x_status"] = <?php echo $sample_req_cart_po_search->status->Lookup->toClientList() ?>;
fsample_req_cart_posearch.lists["x_status"].options = <?php echo JsonEncode($sample_req_cart_po_search->status->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fsample_req_cart_posearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sample_req_cart_po->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sample_req_cart_po->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sample_req_cart_po->po_operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sample_req_cart_po->po_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sample_req_cart_po_search->showPageHeader(); ?>
<?php
$sample_req_cart_po_search->showMessage();
?>
<form name="fsample_req_cart_posearch" id="fsample_req_cart_posearch" class="<?php echo $sample_req_cart_po_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_cart_po_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_cart_po_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart_po">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$sample_req_cart_po_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($sample_req_cart_po->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $sample_req_cart_po_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_id"><?php echo $sample_req_cart_po->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $sample_req_cart_po_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_po->id->cellAttributes() ?>>
			<span id="el_sample_req_cart_po_id">
<input type="text" data-table="sample_req_cart_po" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($sample_req_cart_po->id->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_po->id->EditValue ?>"<?php echo $sample_req_cart_po->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_po->upload->Visible) { // upload ?>
	<div id="r_upload" class="form-group row">
		<label class="<?php echo $sample_req_cart_po_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_upload"><?php echo $sample_req_cart_po->upload->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_upload" id="z_upload" value="LIKE"></span>
		</label>
		<div class="<?php echo $sample_req_cart_po_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_po->upload->cellAttributes() ?>>
			<span id="el_sample_req_cart_po_upload">
<input type="text" data-table="sample_req_cart_po" data-field="x_upload" name="x_upload" id="x_upload" placeholder="<?php echo HtmlEncode($sample_req_cart_po->upload->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_po->upload->EditValue ?>"<?php echo $sample_req_cart_po->upload->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_po->old_ref->Visible) { // old_ref ?>
	<div id="r_old_ref" class="form-group row">
		<label for="x_old_ref" class="<?php echo $sample_req_cart_po_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_old_ref"><?php echo $sample_req_cart_po->old_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_old_ref" id="z_old_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $sample_req_cart_po_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_po->old_ref->cellAttributes() ?>>
			<span id="el_sample_req_cart_po_old_ref">
<input type="text" data-table="sample_req_cart_po" data-field="x_old_ref" name="x_old_ref" id="x_old_ref" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($sample_req_cart_po->old_ref->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_po->old_ref->EditValue ?>"<?php echo $sample_req_cart_po->old_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_po->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label for="x_design" class="<?php echo $sample_req_cart_po_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_design"><?php echo $sample_req_cart_po->design->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		</label>
		<div class="<?php echo $sample_req_cart_po_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_po->design->cellAttributes() ?>>
			<span id="el_sample_req_cart_po_design">
<input type="text" data-table="sample_req_cart_po" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($sample_req_cart_po->design->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_po->design->EditValue ?>"<?php echo $sample_req_cart_po->design->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_po->color->Visible) { // color ?>
	<div id="r_color" class="form-group row">
		<label for="x_color" class="<?php echo $sample_req_cart_po_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_color"><?php echo $sample_req_cart_po->color->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_color" id="z_color" value="LIKE"></span>
		</label>
		<div class="<?php echo $sample_req_cart_po_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_po->color->cellAttributes() ?>>
			<span id="el_sample_req_cart_po_color">
<input type="text" data-table="sample_req_cart_po" data-field="x_color" name="x_color" id="x_color" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($sample_req_cart_po->color->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_po->color->EditValue ?>"<?php echo $sample_req_cart_po->color->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_po->size->Visible) { // size ?>
	<div id="r_size" class="form-group row">
		<label for="x_size" class="<?php echo $sample_req_cart_po_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_size"><?php echo $sample_req_cart_po->size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size" id="z_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $sample_req_cart_po_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_po->size->cellAttributes() ?>>
			<span id="el_sample_req_cart_po_size">
<input type="text" data-table="sample_req_cart_po" data-field="x_size" name="x_size" id="x_size" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($sample_req_cart_po->size->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_po->size->EditValue ?>"<?php echo $sample_req_cart_po->size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_po->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $sample_req_cart_po_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_quantity"><?php echo $sample_req_cart_po->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $sample_req_cart_po_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_po->quantity->cellAttributes() ?>>
			<span id="el_sample_req_cart_po_quantity">
<input type="text" data-table="sample_req_cart_po" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($sample_req_cart_po->quantity->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_po->quantity->EditValue ?>"<?php echo $sample_req_cart_po->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_po->delivery_week->Visible) { // delivery_week ?>
	<div id="r_delivery_week" class="form-group row">
		<label for="x_delivery_week" class="<?php echo $sample_req_cart_po_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_delivery_week"><?php echo $sample_req_cart_po->delivery_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_delivery_week" id="z_delivery_week" value="="></span>
		</label>
		<div class="<?php echo $sample_req_cart_po_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_po->delivery_week->cellAttributes() ?>>
			<span id="el_sample_req_cart_po_delivery_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_cart_po" data-field="x_delivery_week" data-value-separator="<?php echo $sample_req_cart_po->delivery_week->displayValueSeparatorAttribute() ?>" id="x_delivery_week" name="x_delivery_week"<?php echo $sample_req_cart_po->delivery_week->editAttributes() ?>>
		<?php echo $sample_req_cart_po->delivery_week->selectOptionListHtml("x_delivery_week") ?>
	</select>
</div>
<?php echo $sample_req_cart_po->delivery_week->Lookup->getParamTag("p_x_delivery_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_po->sp_remarks->Visible) { // sp_remarks ?>
	<div id="r_sp_remarks" class="form-group row">
		<label for="x_sp_remarks" class="<?php echo $sample_req_cart_po_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_sp_remarks"><?php echo $sample_req_cart_po->sp_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sp_remarks" id="z_sp_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $sample_req_cart_po_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_po->sp_remarks->cellAttributes() ?>>
			<span id="el_sample_req_cart_po_sp_remarks">
<input type="text" data-table="sample_req_cart_po" data-field="x_sp_remarks" name="x_sp_remarks" id="x_sp_remarks" size="35" placeholder="<?php echo HtmlEncode($sample_req_cart_po->sp_remarks->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_po->sp_remarks->EditValue ?>"<?php echo $sample_req_cart_po->sp_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_po->po_remarks->Visible) { // po_remarks ?>
	<div id="r_po_remarks" class="form-group row">
		<label for="x_po_remarks" class="<?php echo $sample_req_cart_po_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_po_remarks"><?php echo $sample_req_cart_po->po_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po_remarks" id="z_po_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $sample_req_cart_po_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_po->po_remarks->cellAttributes() ?>>
			<span id="el_sample_req_cart_po_po_remarks">
<input type="text" data-table="sample_req_cart_po" data-field="x_po_remarks" name="x_po_remarks" id="x_po_remarks" size="35" maxlength="200" placeholder="<?php echo HtmlEncode($sample_req_cart_po->po_remarks->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_po->po_remarks->EditValue ?>"<?php echo $sample_req_cart_po->po_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_po->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $sample_req_cart_po_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_status"><?php echo $sample_req_cart_po->status->caption() ?></span>
		</label>
		<div class="<?php echo $sample_req_cart_po_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_po->status->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_status" id="z_status" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($sample_req_cart_po->status->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($sample_req_cart_po->status->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($sample_req_cart_po->status->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($sample_req_cart_po->status->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($sample_req_cart_po->status->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($sample_req_cart_po->status->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($sample_req_cart_po->status->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_sample_req_cart_po_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_cart_po" data-field="x_status" data-value-separator="<?php echo $sample_req_cart_po->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $sample_req_cart_po->status->editAttributes() ?>>
		<?php echo $sample_req_cart_po->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $sample_req_cart_po->status->Lookup->getParamTag("p_x_status") ?>
</span>
			<span class="ew-search-cond btw1_status d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_sample_req_cart_po_status" class="btw1_status d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_cart_po" data-field="x_status" data-value-separator="<?php echo $sample_req_cart_po->status->displayValueSeparatorAttribute() ?>" id="y_status" name="y_status"<?php echo $sample_req_cart_po->status->editAttributes() ?>>
		<?php echo $sample_req_cart_po->status->selectOptionListHtml("y_status") ?>
	</select>
</div>
<?php echo $sample_req_cart_po->status->Lookup->getParamTag("p_y_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_po->po_operator->Visible) { // po_operator ?>
	<div id="r_po_operator" class="form-group row">
		<label for="x_po_operator" class="<?php echo $sample_req_cart_po_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_po_operator"><?php echo $sample_req_cart_po->po_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_operator" id="z_po_operator" value="="></span>
		</label>
		<div class="<?php echo $sample_req_cart_po_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_po->po_operator->cellAttributes() ?>>
			<span id="el_sample_req_cart_po_po_operator">
<input type="text" data-table="sample_req_cart_po" data-field="x_po_operator" name="x_po_operator" id="x_po_operator" size="30" placeholder="<?php echo HtmlEncode($sample_req_cart_po->po_operator->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_po->po_operator->EditValue ?>"<?php echo $sample_req_cart_po->po_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart_po->po_datetime->Visible) { // po_datetime ?>
	<div id="r_po_datetime" class="form-group row">
		<label for="x_po_datetime" class="<?php echo $sample_req_cart_po_search->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_po_datetime"><?php echo $sample_req_cart_po->po_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_datetime" id="z_po_datetime" value="="></span>
		</label>
		<div class="<?php echo $sample_req_cart_po_search->RightColumnClass ?>"><div<?php echo $sample_req_cart_po->po_datetime->cellAttributes() ?>>
			<span id="el_sample_req_cart_po_po_datetime">
<input type="text" data-table="sample_req_cart_po" data-field="x_po_datetime" name="x_po_datetime" id="x_po_datetime" placeholder="<?php echo HtmlEncode($sample_req_cart_po->po_datetime->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_po->po_datetime->EditValue ?>"<?php echo $sample_req_cart_po->po_datetime->editAttributes() ?>>
<?php if (!$sample_req_cart_po->po_datetime->ReadOnly && !$sample_req_cart_po->po_datetime->Disabled && !isset($sample_req_cart_po->po_datetime->EditAttrs["readonly"]) && !isset($sample_req_cart_po->po_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsample_req_cart_posearch", "x_po_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$sample_req_cart_po_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $sample_req_cart_po_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$sample_req_cart_po_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sample_req_cart_po_search->terminate();
?>