<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_cart_status_list = new sample_req_cart_status_list();

// Run the page
$sample_req_cart_status_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_cart_status_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sample_req_cart_status->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsample_req_cart_statuslist = currentForm = new ew.Form("fsample_req_cart_statuslist", "list");
fsample_req_cart_statuslist.formKeyCountName = '<?php echo $sample_req_cart_status_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsample_req_cart_statuslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_cart_statuslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_cart_statuslist.lists["x_status"] = <?php echo $sample_req_cart_status_list->status->Lookup->toClientList() ?>;
fsample_req_cart_statuslist.lists["x_status"].options = <?php echo JsonEncode($sample_req_cart_status_list->status->lookupOptions()) ?>;
fsample_req_cart_statuslist.lists["x_request_by"] = <?php echo $sample_req_cart_status_list->request_by->Lookup->toClientList() ?>;
fsample_req_cart_statuslist.lists["x_request_by"].options = <?php echo JsonEncode($sample_req_cart_status_list->request_by->lookupOptions()) ?>;
fsample_req_cart_statuslist.autoSuggests["x_request_by"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsample_req_cart_statuslist.lists["x_partner_id"] = <?php echo $sample_req_cart_status_list->partner_id->Lookup->toClientList() ?>;
fsample_req_cart_statuslist.lists["x_partner_id"].options = <?php echo JsonEncode($sample_req_cart_status_list->partner_id->lookupOptions()) ?>;
fsample_req_cart_statuslist.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fsample_req_cart_statuslistsrch = currentSearchForm = new ew.Form("fsample_req_cart_statuslistsrch");

// Validate function for search
fsample_req_cart_statuslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($sample_req_cart_status->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fsample_req_cart_statuslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_cart_statuslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_cart_statuslistsrch.lists["x_status"] = <?php echo $sample_req_cart_status_list->status->Lookup->toClientList() ?>;
fsample_req_cart_statuslistsrch.lists["x_status"].options = <?php echo JsonEncode($sample_req_cart_status_list->status->lookupOptions()) ?>;
fsample_req_cart_statuslistsrch.lists["x_request_by"] = <?php echo $sample_req_cart_status_list->request_by->Lookup->toClientList() ?>;
fsample_req_cart_statuslistsrch.lists["x_request_by"].options = <?php echo JsonEncode($sample_req_cart_status_list->request_by->lookupOptions()) ?>;
fsample_req_cart_statuslistsrch.autoSuggests["x_request_by"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsample_req_cart_statuslistsrch.lists["x_partner_id"] = <?php echo $sample_req_cart_status_list->partner_id->Lookup->toClientList() ?>;
fsample_req_cart_statuslistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($sample_req_cart_status_list->partner_id->lookupOptions()) ?>;
fsample_req_cart_statuslistsrch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fsample_req_cart_statuslistsrch.filterList = <?php echo $sample_req_cart_status_list->getFilterList() ?>;

// Init search panel as collapsed
fsample_req_cart_statuslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sample_req_cart_status->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($sample_req_cart_status_list->TotalRecs > 0 && $sample_req_cart_status_list->ExportOptions->visible()) { ?>
<?php $sample_req_cart_status_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_cart_status_list->ImportOptions->visible()) { ?>
<?php $sample_req_cart_status_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_cart_status_list->SearchOptions->visible()) { ?>
<?php $sample_req_cart_status_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_cart_status_list->FilterOptions->visible()) { ?>
<?php $sample_req_cart_status_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$sample_req_cart_status_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$sample_req_cart_status->isExport() && !$sample_req_cart_status->CurrentAction) { ?>
<form name="fsample_req_cart_statuslistsrch" id="fsample_req_cart_statuslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($sample_req_cart_status_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fsample_req_cart_statuslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="sample_req_cart_status">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$sample_req_cart_status_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$sample_req_cart_status->RowType = ROWTYPE_SEARCH;

// Render row
$sample_req_cart_status->resetAttributes();
$sample_req_cart_status_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($sample_req_cart_status->id->Visible) { // id ?>
	<div id="xsc_id" class="ew-cell form-group">
		<label for="x_id" class="ew-search-caption ew-label"><?php echo $sample_req_cart_status->id->caption() ?></label>
		<span class="ew-search-operator"><select name="z_id" id="z_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($sample_req_cart_status->id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($sample_req_cart_status->id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($sample_req_cart_status->id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($sample_req_cart_status->id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($sample_req_cart_status->id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($sample_req_cart_status->id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($sample_req_cart_status->id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($sample_req_cart_status->id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($sample_req_cart_status->id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="sample_req_cart_status" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($sample_req_cart_status->id->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_status->id->EditValue ?>"<?php echo $sample_req_cart_status->id->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_id style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_id style="d-none"">
<input type="text" data-table="sample_req_cart_status" data-field="x_id" name="y_id" id="y_id" placeholder="<?php echo HtmlEncode($sample_req_cart_status->id->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart_status->id->EditValue2 ?>"<?php echo $sample_req_cart_status->id->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($sample_req_cart_status->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $sample_req_cart_status->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_cart_status" data-field="x_status" data-value-separator="<?php echo $sample_req_cart_status->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $sample_req_cart_status->status->editAttributes() ?>>
		<?php echo $sample_req_cart_status->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $sample_req_cart_status->status->Lookup->getParamTag("p_x_status") ?>
</span>
	</div>
<?php } ?>
<?php if ($sample_req_cart_status->request_by->Visible) { // request_by ?>
	<div id="xsc_request_by" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $sample_req_cart_status->request_by->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_request_by" id="z_request_by" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$sample_req_cart_status->request_by->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$sample_req_cart_status->request_by->EditAttrs["onchange"] = "";
?>
<span id="as_x_request_by" class="text-nowrap" style="z-index: 8930">
	<input type="text" class="form-control" name="sv_x_request_by" id="sv_x_request_by" value="<?php echo RemoveHtml($sample_req_cart_status->request_by->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($sample_req_cart_status->request_by->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($sample_req_cart_status->request_by->getPlaceHolder()) ?>"<?php echo $sample_req_cart_status->request_by->editAttributes() ?>>
</span>
<input type="hidden" data-table="sample_req_cart_status" data-field="x_request_by" data-value-separator="<?php echo $sample_req_cart_status->request_by->displayValueSeparatorAttribute() ?>" name="x_request_by" id="x_request_by" value="<?php echo HtmlEncode($sample_req_cart_status->request_by->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fsample_req_cart_statuslistsrch.createAutoSuggest({"id":"x_request_by","forceSelect":false});
</script>
<?php echo $sample_req_cart_status->request_by->Lookup->getParamTag("p_x_request_by") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($sample_req_cart_status->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $sample_req_cart_status->partner_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$sample_req_cart_status->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$sample_req_cart_status->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8910">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($sample_req_cart_status->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($sample_req_cart_status->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($sample_req_cart_status->partner_id->getPlaceHolder()) ?>"<?php echo $sample_req_cart_status->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="sample_req_cart_status" data-field="x_partner_id" data-value-separator="<?php echo $sample_req_cart_status->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($sample_req_cart_status->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fsample_req_cart_statuslistsrch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $sample_req_cart_status->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($sample_req_cart_status_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($sample_req_cart_status_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $sample_req_cart_status_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($sample_req_cart_status_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($sample_req_cart_status_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($sample_req_cart_status_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($sample_req_cart_status_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $sample_req_cart_status_list->showPageHeader(); ?>
<?php
$sample_req_cart_status_list->showMessage();
?>
<?php if ($sample_req_cart_status_list->TotalRecs > 0 || $sample_req_cart_status->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($sample_req_cart_status_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> sample_req_cart_status">
<?php if (!$sample_req_cart_status->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$sample_req_cart_status->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sample_req_cart_status_list->Pager)) $sample_req_cart_status_list->Pager = new PrevNextPager($sample_req_cart_status_list->StartRec, $sample_req_cart_status_list->DisplayRecs, $sample_req_cart_status_list->TotalRecs, $sample_req_cart_status_list->AutoHidePager) ?>
<?php if ($sample_req_cart_status_list->Pager->RecordCount > 0 && $sample_req_cart_status_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sample_req_cart_status_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sample_req_cart_status_list->pageUrl() ?>start=<?php echo $sample_req_cart_status_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sample_req_cart_status_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sample_req_cart_status_list->pageUrl() ?>start=<?php echo $sample_req_cart_status_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sample_req_cart_status_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sample_req_cart_status_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sample_req_cart_status_list->pageUrl() ?>start=<?php echo $sample_req_cart_status_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sample_req_cart_status_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sample_req_cart_status_list->pageUrl() ?>start=<?php echo $sample_req_cart_status_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sample_req_cart_status_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sample_req_cart_status_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sample_req_cart_status_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sample_req_cart_status_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sample_req_cart_status_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sample_req_cart_status_list->TotalRecs > 0 && (!$sample_req_cart_status_list->AutoHidePageSizeSelector || $sample_req_cart_status_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sample_req_cart_status">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sample_req_cart_status_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sample_req_cart_status_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sample_req_cart_status_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sample_req_cart_status_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sample_req_cart_status_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sample_req_cart_status->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sample_req_cart_status_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsample_req_cart_statuslist" id="fsample_req_cart_statuslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_cart_status_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_cart_status_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart_status">
<div id="gmp_sample_req_cart_status" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($sample_req_cart_status_list->TotalRecs > 0 || $sample_req_cart_status->isGridEdit()) { ?>
<table id="tbl_sample_req_cart_statuslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$sample_req_cart_status_list->RowType = ROWTYPE_HEADER;

// Render list options
$sample_req_cart_status_list->renderListOptions();

// Render list options (header, left)
$sample_req_cart_status_list->ListOptions->render("header", "left");
?>
<?php if ($sample_req_cart_status->id->Visible) { // id ?>
	<?php if ($sample_req_cart_status->sortUrl($sample_req_cart_status->id) == "") { ?>
		<th data-name="id" class="<?php echo $sample_req_cart_status->id->headerCellClass() ?>"><div id="elh_sample_req_cart_status_id" class="sample_req_cart_status_id"><div class="ew-table-header-caption"><?php echo $sample_req_cart_status->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $sample_req_cart_status->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_status->SortUrl($sample_req_cart_status->id) ?>',2);"><div id="elh_sample_req_cart_status_id" class="sample_req_cart_status_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_status->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_status->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_status->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_status->datetime->Visible) { // datetime ?>
	<?php if ($sample_req_cart_status->sortUrl($sample_req_cart_status->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $sample_req_cart_status->datetime->headerCellClass() ?>"><div id="elh_sample_req_cart_status_datetime" class="sample_req_cart_status_datetime"><div class="ew-table-header-caption"><?php echo $sample_req_cart_status->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $sample_req_cart_status->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_status->SortUrl($sample_req_cart_status->datetime) ?>',2);"><div id="elh_sample_req_cart_status_datetime" class="sample_req_cart_status_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_status->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_status->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_status->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_status->r_text->Visible) { // r_text ?>
	<?php if ($sample_req_cart_status->sortUrl($sample_req_cart_status->r_text) == "") { ?>
		<th data-name="r_text" class="<?php echo $sample_req_cart_status->r_text->headerCellClass() ?>"><div id="elh_sample_req_cart_status_r_text" class="sample_req_cart_status_r_text"><div class="ew-table-header-caption"><?php echo $sample_req_cart_status->r_text->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_text" class="<?php echo $sample_req_cart_status->r_text->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_status->SortUrl($sample_req_cart_status->r_text) ?>',2);"><div id="elh_sample_req_cart_status_r_text" class="sample_req_cart_status_r_text">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_status->r_text->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_status->r_text->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_status->r_text->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_status->status->Visible) { // status ?>
	<?php if ($sample_req_cart_status->sortUrl($sample_req_cart_status->status) == "") { ?>
		<th data-name="status" class="<?php echo $sample_req_cart_status->status->headerCellClass() ?>"><div id="elh_sample_req_cart_status_status" class="sample_req_cart_status_status"><div class="ew-table-header-caption"><?php echo $sample_req_cart_status->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $sample_req_cart_status->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_status->SortUrl($sample_req_cart_status->status) ?>',2);"><div id="elh_sample_req_cart_status_status" class="sample_req_cart_status_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_status->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_status->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_status->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_status->request_by->Visible) { // request_by ?>
	<?php if ($sample_req_cart_status->sortUrl($sample_req_cart_status->request_by) == "") { ?>
		<th data-name="request_by" class="<?php echo $sample_req_cart_status->request_by->headerCellClass() ?>"><div id="elh_sample_req_cart_status_request_by" class="sample_req_cart_status_request_by"><div class="ew-table-header-caption"><?php echo $sample_req_cart_status->request_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="request_by" class="<?php echo $sample_req_cart_status->request_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_status->SortUrl($sample_req_cart_status->request_by) ?>',2);"><div id="elh_sample_req_cart_status_request_by" class="sample_req_cart_status_request_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_status->request_by->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_status->request_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_status->request_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart_status->partner_id->Visible) { // partner_id ?>
	<?php if ($sample_req_cart_status->sortUrl($sample_req_cart_status->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $sample_req_cart_status->partner_id->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_sample_req_cart_status_partner_id" class="sample_req_cart_status_partner_id"><div class="ew-table-header-caption"><?php echo $sample_req_cart_status->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $sample_req_cart_status->partner_id->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart_status->SortUrl($sample_req_cart_status->partner_id) ?>',2);"><div id="elh_sample_req_cart_status_partner_id" class="sample_req_cart_status_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart_status->partner_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart_status->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart_status->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sample_req_cart_status_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($sample_req_cart_status->ExportAll && $sample_req_cart_status->isExport()) {
	$sample_req_cart_status_list->StopRec = $sample_req_cart_status_list->TotalRecs;
} else {

	// Set the last record to display
	if ($sample_req_cart_status_list->TotalRecs > $sample_req_cart_status_list->StartRec + $sample_req_cart_status_list->DisplayRecs - 1)
		$sample_req_cart_status_list->StopRec = $sample_req_cart_status_list->StartRec + $sample_req_cart_status_list->DisplayRecs - 1;
	else
		$sample_req_cart_status_list->StopRec = $sample_req_cart_status_list->TotalRecs;
}
$sample_req_cart_status_list->RecCnt = $sample_req_cart_status_list->StartRec - 1;
if ($sample_req_cart_status_list->Recordset && !$sample_req_cart_status_list->Recordset->EOF) {
	$sample_req_cart_status_list->Recordset->moveFirst();
	$selectLimit = $sample_req_cart_status_list->UseSelectLimit;
	if (!$selectLimit && $sample_req_cart_status_list->StartRec > 1)
		$sample_req_cart_status_list->Recordset->move($sample_req_cart_status_list->StartRec - 1);
} elseif (!$sample_req_cart_status->AllowAddDeleteRow && $sample_req_cart_status_list->StopRec == 0) {
	$sample_req_cart_status_list->StopRec = $sample_req_cart_status->GridAddRowCount;
}

// Initialize aggregate
$sample_req_cart_status->RowType = ROWTYPE_AGGREGATEINIT;
$sample_req_cart_status->resetAttributes();
$sample_req_cart_status_list->renderRow();
while ($sample_req_cart_status_list->RecCnt < $sample_req_cart_status_list->StopRec) {
	$sample_req_cart_status_list->RecCnt++;
	if ($sample_req_cart_status_list->RecCnt >= $sample_req_cart_status_list->StartRec) {
		$sample_req_cart_status_list->RowCnt++;

		// Set up key count
		$sample_req_cart_status_list->KeyCount = $sample_req_cart_status_list->RowIndex;

		// Init row class and style
		$sample_req_cart_status->resetAttributes();
		$sample_req_cart_status->CssClass = "";
		if ($sample_req_cart_status->isGridAdd()) {
		} else {
			$sample_req_cart_status_list->loadRowValues($sample_req_cart_status_list->Recordset); // Load row values
		}
		$sample_req_cart_status->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$sample_req_cart_status->RowAttrs = array_merge($sample_req_cart_status->RowAttrs, array('data-rowindex'=>$sample_req_cart_status_list->RowCnt, 'id'=>'r' . $sample_req_cart_status_list->RowCnt . '_sample_req_cart_status', 'data-rowtype'=>$sample_req_cart_status->RowType));

		// Render row
		$sample_req_cart_status_list->renderRow();

		// Render list options
		$sample_req_cart_status_list->renderListOptions();
?>
	<tr<?php echo $sample_req_cart_status->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sample_req_cart_status_list->ListOptions->render("body", "left", $sample_req_cart_status_list->RowCnt);
?>
	<?php if ($sample_req_cart_status->id->Visible) { // id ?>
		<td data-name="id"<?php echo $sample_req_cart_status->id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_status_list->RowCnt ?>_sample_req_cart_status_id" class="sample_req_cart_status_id">
<span<?php echo $sample_req_cart_status->id->viewAttributes() ?>>
<?php echo $sample_req_cart_status->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_status->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $sample_req_cart_status->datetime->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_status_list->RowCnt ?>_sample_req_cart_status_datetime" class="sample_req_cart_status_datetime">
<span<?php echo $sample_req_cart_status->datetime->viewAttributes() ?>>
<?php echo $sample_req_cart_status->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_status->r_text->Visible) { // r_text ?>
		<td data-name="r_text"<?php echo $sample_req_cart_status->r_text->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_status_list->RowCnt ?>_sample_req_cart_status_r_text" class="sample_req_cart_status_r_text">
<span<?php echo $sample_req_cart_status->r_text->viewAttributes() ?>>
<?php echo $sample_req_cart_status->r_text->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_status->status->Visible) { // status ?>
		<td data-name="status"<?php echo $sample_req_cart_status->status->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_status_list->RowCnt ?>_sample_req_cart_status_status" class="sample_req_cart_status_status">
<span<?php echo $sample_req_cart_status->status->viewAttributes() ?>>
<?php echo $sample_req_cart_status->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_status->request_by->Visible) { // request_by ?>
		<td data-name="request_by"<?php echo $sample_req_cart_status->request_by->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_status_list->RowCnt ?>_sample_req_cart_status_request_by" class="sample_req_cart_status_request_by">
<span<?php echo $sample_req_cart_status->request_by->viewAttributes() ?>>
<?php echo $sample_req_cart_status->request_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart_status->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $sample_req_cart_status->partner_id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_status_list->RowCnt ?>_sample_req_cart_status_partner_id" class="sample_req_cart_status_partner_id">
<span<?php echo $sample_req_cart_status->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($sample_req_cart_status->partner_id->getViewValue())) && $sample_req_cart_status->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $sample_req_cart_status->partner_id->linkAttributes() ?>><?php echo $sample_req_cart_status->partner_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sample_req_cart_status->partner_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sample_req_cart_status_list->ListOptions->render("body", "right", $sample_req_cart_status_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$sample_req_cart_status->isGridAdd())
		$sample_req_cart_status_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$sample_req_cart_status->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($sample_req_cart_status_list->Recordset)
	$sample_req_cart_status_list->Recordset->Close();
?>
<?php if (!$sample_req_cart_status->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$sample_req_cart_status->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sample_req_cart_status_list->Pager)) $sample_req_cart_status_list->Pager = new PrevNextPager($sample_req_cart_status_list->StartRec, $sample_req_cart_status_list->DisplayRecs, $sample_req_cart_status_list->TotalRecs, $sample_req_cart_status_list->AutoHidePager) ?>
<?php if ($sample_req_cart_status_list->Pager->RecordCount > 0 && $sample_req_cart_status_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sample_req_cart_status_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sample_req_cart_status_list->pageUrl() ?>start=<?php echo $sample_req_cart_status_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sample_req_cart_status_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sample_req_cart_status_list->pageUrl() ?>start=<?php echo $sample_req_cart_status_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sample_req_cart_status_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sample_req_cart_status_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sample_req_cart_status_list->pageUrl() ?>start=<?php echo $sample_req_cart_status_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sample_req_cart_status_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sample_req_cart_status_list->pageUrl() ?>start=<?php echo $sample_req_cart_status_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sample_req_cart_status_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sample_req_cart_status_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sample_req_cart_status_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sample_req_cart_status_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sample_req_cart_status_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sample_req_cart_status_list->TotalRecs > 0 && (!$sample_req_cart_status_list->AutoHidePageSizeSelector || $sample_req_cart_status_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sample_req_cart_status">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sample_req_cart_status_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sample_req_cart_status_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sample_req_cart_status_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sample_req_cart_status_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sample_req_cart_status_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sample_req_cart_status->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sample_req_cart_status_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($sample_req_cart_status_list->TotalRecs == 0 && !$sample_req_cart_status->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $sample_req_cart_status_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$sample_req_cart_status_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sample_req_cart_status->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$sample_req_cart_status->isExport()) { ?>
<script>
ew.scrollableTable("gmp_sample_req_cart_status", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sample_req_cart_status_list->terminate();
?>