<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_cart_edit = new sample_req_cart_edit();

// Run the page
$sample_req_cart_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_cart_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fsample_req_cartedit = currentForm = new ew.Form("fsample_req_cartedit", "edit");

// Validate form
fsample_req_cartedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($sample_req_cart_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_cart->id->caption(), $sample_req_cart->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_cart_edit->request_by->Required) { ?>
			elm = this.getElements("x" + infix + "_request_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_cart->request_by->caption(), $sample_req_cart->request_by->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_cart_edit->old_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_old_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_cart->old_ref->caption(), $sample_req_cart->old_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_cart_edit->upload->Required) { ?>
			felm = this.getElements("x" + infix + "_upload");
			elm = this.getElements("fn_x" + infix + "_upload");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $sample_req_cart->upload->caption(), $sample_req_cart->upload->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_cart_edit->design->Required) { ?>
			elm = this.getElements("x" + infix + "_design");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_cart->design->caption(), $sample_req_cart->design->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_design");
			if (elm && !ew.checkByRegEx(elm.value, /^[^,]+$/))
				return this.onError(elm, "<?php echo JsEncode($sample_req_cart->design->errorMessage()) ?>");
		<?php if ($sample_req_cart_edit->color->Required) { ?>
			elm = this.getElements("x" + infix + "_color");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_cart->color->caption(), $sample_req_cart->color->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_color");
			if (elm && !ew.checkByRegEx(elm.value, /^[^,]+$/))
				return this.onError(elm, "<?php echo JsEncode($sample_req_cart->color->errorMessage()) ?>");
		<?php if ($sample_req_cart_edit->size->Required) { ?>
			elm = this.getElements("x" + infix + "_size");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_cart->size->caption(), $sample_req_cart->size->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_size");
			if (elm && !ew.checkByRegEx(elm.value, /^[^,]+$/))
				return this.onError(elm, "<?php echo JsEncode($sample_req_cart->size->errorMessage()) ?>");
		<?php if ($sample_req_cart_edit->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_cart->quantity->caption(), $sample_req_cart->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sample_req_cart->quantity->errorMessage()) ?>");
		<?php if ($sample_req_cart_edit->comments->Required) { ?>
			elm = this.getElements("x" + infix + "_comments");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_cart->comments->caption(), $sample_req_cart->comments->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_cart_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_cart->operator->caption(), $sample_req_cart->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_cart_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_cart->datetime->caption(), $sample_req_cart->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_cart_edit->app_status->Required) { ?>
			elm = this.getElements("x" + infix + "_app_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_cart->app_status->caption(), $sample_req_cart->app_status->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsample_req_cartedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_cartedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_cartedit.lists["x_request_by"] = <?php echo $sample_req_cart_edit->request_by->Lookup->toClientList() ?>;
fsample_req_cartedit.lists["x_request_by"].options = <?php echo JsonEncode($sample_req_cart_edit->request_by->lookupOptions()) ?>;
fsample_req_cartedit.lists["x_operator"] = <?php echo $sample_req_cart_edit->operator->Lookup->toClientList() ?>;
fsample_req_cartedit.lists["x_operator"].options = <?php echo JsonEncode($sample_req_cart_edit->operator->lookupOptions()) ?>;
fsample_req_cartedit.lists["x_app_status"] = <?php echo $sample_req_cart_edit->app_status->Lookup->toClientList() ?>;
fsample_req_cartedit.lists["x_app_status"].options = <?php echo JsonEncode($sample_req_cart_edit->app_status->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sample_req_cart_edit->showPageHeader(); ?>
<?php
$sample_req_cart_edit->showMessage();
?>
<form name="fsample_req_cartedit" id="fsample_req_cartedit" class="<?php echo $sample_req_cart_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_cart_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_cart_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$sample_req_cart_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($sample_req_cart->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_sample_req_cart_id" class="<?php echo $sample_req_cart_edit->LeftColumnClass ?>"><?php echo $sample_req_cart->id->caption() ?><?php echo ($sample_req_cart->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_cart_edit->RightColumnClass ?>"><div<?php echo $sample_req_cart->id->cellAttributes() ?>>
<span id="el_sample_req_cart_id">
<span<?php echo $sample_req_cart->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sample_req_cart->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="sample_req_cart" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($sample_req_cart->id->CurrentValue) ?>">
<?php echo $sample_req_cart->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart->request_by->Visible) { // request_by ?>
	<div id="r_request_by" class="form-group row">
		<label id="elh_sample_req_cart_request_by" for="x_request_by" class="<?php echo $sample_req_cart_edit->LeftColumnClass ?>"><?php echo $sample_req_cart->request_by->caption() ?><?php echo ($sample_req_cart->request_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_cart_edit->RightColumnClass ?>"><div<?php echo $sample_req_cart->request_by->cellAttributes() ?>>
<span id="el_sample_req_cart_request_by">
<span<?php echo $sample_req_cart->request_by->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sample_req_cart->request_by->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="sample_req_cart" data-field="x_request_by" name="x_request_by" id="x_request_by" value="<?php echo HtmlEncode($sample_req_cart->request_by->CurrentValue) ?>">
<?php echo $sample_req_cart->request_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart->old_ref->Visible) { // old_ref ?>
	<div id="r_old_ref" class="form-group row">
		<label id="elh_sample_req_cart_old_ref" for="x_old_ref" class="<?php echo $sample_req_cart_edit->LeftColumnClass ?>"><?php echo $sample_req_cart->old_ref->caption() ?><?php echo ($sample_req_cart->old_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_cart_edit->RightColumnClass ?>"><div<?php echo $sample_req_cart->old_ref->cellAttributes() ?>>
<span id="el_sample_req_cart_old_ref">
<input type="text" data-table="sample_req_cart" data-field="x_old_ref" name="x_old_ref" id="x_old_ref" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($sample_req_cart->old_ref->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart->old_ref->EditValue ?>"<?php echo $sample_req_cart->old_ref->editAttributes() ?>>
</span>
<?php echo $sample_req_cart->old_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart->upload->Visible) { // upload ?>
	<div id="r_upload" class="form-group row">
		<label id="elh_sample_req_cart_upload" class="<?php echo $sample_req_cart_edit->LeftColumnClass ?>"><?php echo $sample_req_cart->upload->caption() ?><?php echo ($sample_req_cart->upload->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_cart_edit->RightColumnClass ?>"><div<?php echo $sample_req_cart->upload->cellAttributes() ?>>
<span id="el_sample_req_cart_upload">
<div id="fd_x_upload">
<span title="<?php echo $sample_req_cart->upload->title() ? $sample_req_cart->upload->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($sample_req_cart->upload->ReadOnly || $sample_req_cart->upload->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="sample_req_cart" data-field="x_upload" name="x_upload" id="x_upload" multiple="multiple"<?php echo $sample_req_cart->upload->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_upload" id= "fn_x_upload" value="<?php echo $sample_req_cart->upload->Upload->FileName ?>">
<?php if (Post("fa_x_upload") == "0") { ?>
<input type="hidden" name="fa_x_upload" id= "fa_x_upload" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_upload" id= "fa_x_upload" value="1">
<?php } ?>
<input type="hidden" name="fs_x_upload" id= "fs_x_upload" value="500">
<input type="hidden" name="fx_x_upload" id= "fx_x_upload" value="<?php echo $sample_req_cart->upload->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_upload" id= "fm_x_upload" value="<?php echo $sample_req_cart->upload->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_upload" id= "fc_x_upload" value="<?php echo $sample_req_cart->upload->UploadMaxFileCount ?>">
</div>
<table id="ft_x_upload" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $sample_req_cart->upload->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label id="elh_sample_req_cart_design" for="x_design" class="<?php echo $sample_req_cart_edit->LeftColumnClass ?>"><?php echo $sample_req_cart->design->caption() ?><?php echo ($sample_req_cart->design->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_cart_edit->RightColumnClass ?>"><div<?php echo $sample_req_cart->design->cellAttributes() ?>>
<span id="el_sample_req_cart_design">
<input type="text" data-table="sample_req_cart" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($sample_req_cart->design->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart->design->EditValue ?>"<?php echo $sample_req_cart->design->editAttributes() ?>>
</span>
<?php echo $sample_req_cart->design->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart->color->Visible) { // color ?>
	<div id="r_color" class="form-group row">
		<label id="elh_sample_req_cart_color" for="x_color" class="<?php echo $sample_req_cart_edit->LeftColumnClass ?>"><?php echo $sample_req_cart->color->caption() ?><?php echo ($sample_req_cart->color->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_cart_edit->RightColumnClass ?>"><div<?php echo $sample_req_cart->color->cellAttributes() ?>>
<span id="el_sample_req_cart_color">
<input type="text" data-table="sample_req_cart" data-field="x_color" name="x_color" id="x_color" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($sample_req_cart->color->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart->color->EditValue ?>"<?php echo $sample_req_cart->color->editAttributes() ?>>
</span>
<?php echo $sample_req_cart->color->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart->size->Visible) { // size ?>
	<div id="r_size" class="form-group row">
		<label id="elh_sample_req_cart_size" for="x_size" class="<?php echo $sample_req_cart_edit->LeftColumnClass ?>"><?php echo $sample_req_cart->size->caption() ?><?php echo ($sample_req_cart->size->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_cart_edit->RightColumnClass ?>"><div<?php echo $sample_req_cart->size->cellAttributes() ?>>
<span id="el_sample_req_cart_size">
<input type="text" data-table="sample_req_cart" data-field="x_size" name="x_size" id="x_size" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($sample_req_cart->size->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart->size->EditValue ?>"<?php echo $sample_req_cart->size->editAttributes() ?>>
</span>
<?php echo $sample_req_cart->size->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_sample_req_cart_quantity" for="x_quantity" class="<?php echo $sample_req_cart_edit->LeftColumnClass ?>"><?php echo $sample_req_cart->quantity->caption() ?><?php echo ($sample_req_cart->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_cart_edit->RightColumnClass ?>"><div<?php echo $sample_req_cart->quantity->cellAttributes() ?>>
<span id="el_sample_req_cart_quantity">
<input type="text" data-table="sample_req_cart" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($sample_req_cart->quantity->getPlaceHolder()) ?>" value="<?php echo $sample_req_cart->quantity->EditValue ?>"<?php echo $sample_req_cart->quantity->editAttributes() ?>>
</span>
<?php echo $sample_req_cart->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart->comments->Visible) { // comments ?>
	<div id="r_comments" class="form-group row">
		<label id="elh_sample_req_cart_comments" for="x_comments" class="<?php echo $sample_req_cart_edit->LeftColumnClass ?>"><?php echo $sample_req_cart->comments->caption() ?><?php echo ($sample_req_cart->comments->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_cart_edit->RightColumnClass ?>"><div<?php echo $sample_req_cart->comments->cellAttributes() ?>>
<span id="el_sample_req_cart_comments">
<textarea data-table="sample_req_cart" data-field="x_comments" name="x_comments" id="x_comments" cols="35" rows="4" placeholder="<?php echo HtmlEncode($sample_req_cart->comments->getPlaceHolder()) ?>"<?php echo $sample_req_cart->comments->editAttributes() ?>><?php echo $sample_req_cart->comments->EditValue ?></textarea>
</span>
<?php echo $sample_req_cart->comments->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req_cart->app_status->Visible) { // app_status ?>
	<div id="r_app_status" class="form-group row">
		<label id="elh_sample_req_cart_app_status" for="x_app_status" class="<?php echo $sample_req_cart_edit->LeftColumnClass ?>"><?php echo $sample_req_cart->app_status->caption() ?><?php echo ($sample_req_cart->app_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_cart_edit->RightColumnClass ?>"><div<?php echo $sample_req_cart->app_status->cellAttributes() ?>>
<span id="el_sample_req_cart_app_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_cart" data-field="x_app_status" data-value-separator="<?php echo $sample_req_cart->app_status->displayValueSeparatorAttribute() ?>" id="x_app_status" name="x_app_status"<?php echo $sample_req_cart->app_status->editAttributes() ?>>
		<?php echo $sample_req_cart->app_status->selectOptionListHtml("x_app_status") ?>
	</select>
</div>
<?php echo $sample_req_cart->app_status->Lookup->getParamTag("p_x_app_status") ?>
</span>
<?php echo $sample_req_cart->app_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$sample_req_cart_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $sample_req_cart_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $sample_req_cart_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$sample_req_cart_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sample_req_cart_edit->terminate();
?>