<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_cart_list = new sample_req_cart_list();

// Run the page
$sample_req_cart_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_cart_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sample_req_cart->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsample_req_cartlist = currentForm = new ew.Form("fsample_req_cartlist", "list");
fsample_req_cartlist.formKeyCountName = '<?php echo $sample_req_cart_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsample_req_cartlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_cartlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_cartlist.lists["x_request_by"] = <?php echo $sample_req_cart_list->request_by->Lookup->toClientList() ?>;
fsample_req_cartlist.lists["x_request_by"].options = <?php echo JsonEncode($sample_req_cart_list->request_by->lookupOptions()) ?>;
fsample_req_cartlist.lists["x_operator"] = <?php echo $sample_req_cart_list->operator->Lookup->toClientList() ?>;
fsample_req_cartlist.lists["x_operator"].options = <?php echo JsonEncode($sample_req_cart_list->operator->lookupOptions()) ?>;
fsample_req_cartlist.lists["x_status"] = <?php echo $sample_req_cart_list->status->Lookup->toClientList() ?>;
fsample_req_cartlist.lists["x_status"].options = <?php echo JsonEncode($sample_req_cart_list->status->lookupOptions()) ?>;

// Form object for search
var fsample_req_cartlistsrch = currentSearchForm = new ew.Form("fsample_req_cartlistsrch");

// Validate function for search
fsample_req_cartlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fsample_req_cartlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_cartlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_cartlistsrch.lists["x_status"] = <?php echo $sample_req_cart_list->status->Lookup->toClientList() ?>;
fsample_req_cartlistsrch.lists["x_status"].options = <?php echo JsonEncode($sample_req_cart_list->status->lookupOptions()) ?>;

// Filters
fsample_req_cartlistsrch.filterList = <?php echo $sample_req_cart_list->getFilterList() ?>;

// Init search panel as collapsed
fsample_req_cartlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sample_req_cart->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($sample_req_cart_list->TotalRecs > 0 && $sample_req_cart_list->ExportOptions->visible()) { ?>
<?php $sample_req_cart_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_cart_list->ImportOptions->visible()) { ?>
<?php $sample_req_cart_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_cart_list->SearchOptions->visible()) { ?>
<?php $sample_req_cart_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_cart_list->FilterOptions->visible()) { ?>
<?php $sample_req_cart_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$sample_req_cart_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$sample_req_cart->isExport() && !$sample_req_cart->CurrentAction) { ?>
<form name="fsample_req_cartlistsrch" id="fsample_req_cartlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($sample_req_cart_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fsample_req_cartlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="sample_req_cart">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$sample_req_cart_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$sample_req_cart->RowType = ROWTYPE_SEARCH;

// Render row
$sample_req_cart->resetAttributes();
$sample_req_cart_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($sample_req_cart->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $sample_req_cart->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase(">=") ?><input type="hidden" name="z_status" id="z_status" value=">="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_cart" data-field="x_status" data-value-separator="<?php echo $sample_req_cart->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $sample_req_cart->status->editAttributes() ?>>
		<?php echo $sample_req_cart->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $sample_req_cart->status->Lookup->getParamTag("p_x_status") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($sample_req_cart_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($sample_req_cart_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $sample_req_cart_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($sample_req_cart_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($sample_req_cart_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($sample_req_cart_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($sample_req_cart_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $sample_req_cart_list->showPageHeader(); ?>
<?php
$sample_req_cart_list->showMessage();
?>
<?php if ($sample_req_cart_list->TotalRecs > 0 || $sample_req_cart->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($sample_req_cart_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> sample_req_cart">
<?php if (!$sample_req_cart->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$sample_req_cart->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sample_req_cart_list->Pager)) $sample_req_cart_list->Pager = new PrevNextPager($sample_req_cart_list->StartRec, $sample_req_cart_list->DisplayRecs, $sample_req_cart_list->TotalRecs, $sample_req_cart_list->AutoHidePager) ?>
<?php if ($sample_req_cart_list->Pager->RecordCount > 0 && $sample_req_cart_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sample_req_cart_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sample_req_cart_list->pageUrl() ?>start=<?php echo $sample_req_cart_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sample_req_cart_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sample_req_cart_list->pageUrl() ?>start=<?php echo $sample_req_cart_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sample_req_cart_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sample_req_cart_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sample_req_cart_list->pageUrl() ?>start=<?php echo $sample_req_cart_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sample_req_cart_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sample_req_cart_list->pageUrl() ?>start=<?php echo $sample_req_cart_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sample_req_cart_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sample_req_cart_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sample_req_cart_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sample_req_cart_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sample_req_cart_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sample_req_cart_list->TotalRecs > 0 && (!$sample_req_cart_list->AutoHidePageSizeSelector || $sample_req_cart_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sample_req_cart">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sample_req_cart_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sample_req_cart_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sample_req_cart_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sample_req_cart_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sample_req_cart_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sample_req_cart->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sample_req_cart_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsample_req_cartlist" id="fsample_req_cartlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_cart_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_cart_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart">
<div id="gmp_sample_req_cart" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($sample_req_cart_list->TotalRecs > 0 || $sample_req_cart->isGridEdit()) { ?>
<table id="tbl_sample_req_cartlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$sample_req_cart_list->RowType = ROWTYPE_HEADER;

// Render list options
$sample_req_cart_list->renderListOptions();

// Render list options (header, left)
$sample_req_cart_list->ListOptions->render("header", "left");
?>
<?php if ($sample_req_cart->id->Visible) { // id ?>
	<?php if ($sample_req_cart->sortUrl($sample_req_cart->id) == "") { ?>
		<th data-name="id" class="<?php echo $sample_req_cart->id->headerCellClass() ?>"><div id="elh_sample_req_cart_id" class="sample_req_cart_id"><div class="ew-table-header-caption"><?php echo $sample_req_cart->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $sample_req_cart->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart->SortUrl($sample_req_cart->id) ?>',2);"><div id="elh_sample_req_cart_id" class="sample_req_cart_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart->request_by->Visible) { // request_by ?>
	<?php if ($sample_req_cart->sortUrl($sample_req_cart->request_by) == "") { ?>
		<th data-name="request_by" class="<?php echo $sample_req_cart->request_by->headerCellClass() ?>"><div id="elh_sample_req_cart_request_by" class="sample_req_cart_request_by"><div class="ew-table-header-caption"><?php echo $sample_req_cart->request_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="request_by" class="<?php echo $sample_req_cart->request_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart->SortUrl($sample_req_cart->request_by) ?>',2);"><div id="elh_sample_req_cart_request_by" class="sample_req_cart_request_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart->request_by->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart->request_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart->request_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart->old_ref->Visible) { // old_ref ?>
	<?php if ($sample_req_cart->sortUrl($sample_req_cart->old_ref) == "") { ?>
		<th data-name="old_ref" class="<?php echo $sample_req_cart->old_ref->headerCellClass() ?>"><div id="elh_sample_req_cart_old_ref" class="sample_req_cart_old_ref"><div class="ew-table-header-caption"><?php echo $sample_req_cart->old_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="old_ref" class="<?php echo $sample_req_cart->old_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart->SortUrl($sample_req_cart->old_ref) ?>',2);"><div id="elh_sample_req_cart_old_ref" class="sample_req_cart_old_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart->old_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart->old_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart->old_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart->upload->Visible) { // upload ?>
	<?php if ($sample_req_cart->sortUrl($sample_req_cart->upload) == "") { ?>
		<th data-name="upload" class="<?php echo $sample_req_cart->upload->headerCellClass() ?>"><div id="elh_sample_req_cart_upload" class="sample_req_cart_upload"><div class="ew-table-header-caption"><?php echo $sample_req_cart->upload->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="upload" class="<?php echo $sample_req_cart->upload->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart->SortUrl($sample_req_cart->upload) ?>',2);"><div id="elh_sample_req_cart_upload" class="sample_req_cart_upload">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart->upload->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart->upload->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart->upload->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart->design->Visible) { // design ?>
	<?php if ($sample_req_cart->sortUrl($sample_req_cart->design) == "") { ?>
		<th data-name="design" class="<?php echo $sample_req_cart->design->headerCellClass() ?>"><div id="elh_sample_req_cart_design" class="sample_req_cart_design"><div class="ew-table-header-caption"><?php echo $sample_req_cart->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $sample_req_cart->design->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart->SortUrl($sample_req_cart->design) ?>',2);"><div id="elh_sample_req_cart_design" class="sample_req_cart_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart->color->Visible) { // color ?>
	<?php if ($sample_req_cart->sortUrl($sample_req_cart->color) == "") { ?>
		<th data-name="color" class="<?php echo $sample_req_cart->color->headerCellClass() ?>"><div id="elh_sample_req_cart_color" class="sample_req_cart_color"><div class="ew-table-header-caption"><?php echo $sample_req_cart->color->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="color" class="<?php echo $sample_req_cart->color->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart->SortUrl($sample_req_cart->color) ?>',2);"><div id="elh_sample_req_cart_color" class="sample_req_cart_color">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart->color->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart->color->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart->color->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart->size->Visible) { // size ?>
	<?php if ($sample_req_cart->sortUrl($sample_req_cart->size) == "") { ?>
		<th data-name="size" class="<?php echo $sample_req_cart->size->headerCellClass() ?>"><div id="elh_sample_req_cart_size" class="sample_req_cart_size"><div class="ew-table-header-caption"><?php echo $sample_req_cart->size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size" class="<?php echo $sample_req_cart->size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart->SortUrl($sample_req_cart->size) ?>',2);"><div id="elh_sample_req_cart_size" class="sample_req_cart_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart->size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart->size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart->size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart->quantity->Visible) { // quantity ?>
	<?php if ($sample_req_cart->sortUrl($sample_req_cart->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $sample_req_cart->quantity->headerCellClass() ?>"><div id="elh_sample_req_cart_quantity" class="sample_req_cart_quantity"><div class="ew-table-header-caption"><?php echo $sample_req_cart->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $sample_req_cart->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart->SortUrl($sample_req_cart->quantity) ?>',2);"><div id="elh_sample_req_cart_quantity" class="sample_req_cart_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart->comments->Visible) { // comments ?>
	<?php if ($sample_req_cart->sortUrl($sample_req_cart->comments) == "") { ?>
		<th data-name="comments" class="<?php echo $sample_req_cart->comments->headerCellClass() ?>"><div id="elh_sample_req_cart_comments" class="sample_req_cart_comments"><div class="ew-table-header-caption"><?php echo $sample_req_cart->comments->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="comments" class="<?php echo $sample_req_cart->comments->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart->SortUrl($sample_req_cart->comments) ?>',2);"><div id="elh_sample_req_cart_comments" class="sample_req_cart_comments">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart->comments->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart->comments->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart->comments->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart->operator->Visible) { // operator ?>
	<?php if ($sample_req_cart->sortUrl($sample_req_cart->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $sample_req_cart->operator->headerCellClass() ?>"><div id="elh_sample_req_cart_operator" class="sample_req_cart_operator"><div class="ew-table-header-caption"><?php echo $sample_req_cart->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $sample_req_cart->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart->SortUrl($sample_req_cart->operator) ?>',2);"><div id="elh_sample_req_cart_operator" class="sample_req_cart_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart->datetime->Visible) { // datetime ?>
	<?php if ($sample_req_cart->sortUrl($sample_req_cart->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $sample_req_cart->datetime->headerCellClass() ?>"><div id="elh_sample_req_cart_datetime" class="sample_req_cart_datetime"><div class="ew-table-header-caption"><?php echo $sample_req_cart->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $sample_req_cart->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart->SortUrl($sample_req_cart->datetime) ?>',2);"><div id="elh_sample_req_cart_datetime" class="sample_req_cart_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req_cart->status->Visible) { // status ?>
	<?php if ($sample_req_cart->sortUrl($sample_req_cart->status) == "") { ?>
		<th data-name="status" class="<?php echo $sample_req_cart->status->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_sample_req_cart_status" class="sample_req_cart_status"><div class="ew-table-header-caption"><?php echo $sample_req_cart->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $sample_req_cart->status->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req_cart->SortUrl($sample_req_cart->status) ?>',2);"><div id="elh_sample_req_cart_status" class="sample_req_cart_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req_cart->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req_cart->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req_cart->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sample_req_cart_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($sample_req_cart->ExportAll && $sample_req_cart->isExport()) {
	$sample_req_cart_list->StopRec = $sample_req_cart_list->TotalRecs;
} else {

	// Set the last record to display
	if ($sample_req_cart_list->TotalRecs > $sample_req_cart_list->StartRec + $sample_req_cart_list->DisplayRecs - 1)
		$sample_req_cart_list->StopRec = $sample_req_cart_list->StartRec + $sample_req_cart_list->DisplayRecs - 1;
	else
		$sample_req_cart_list->StopRec = $sample_req_cart_list->TotalRecs;
}
$sample_req_cart_list->RecCnt = $sample_req_cart_list->StartRec - 1;
if ($sample_req_cart_list->Recordset && !$sample_req_cart_list->Recordset->EOF) {
	$sample_req_cart_list->Recordset->moveFirst();
	$selectLimit = $sample_req_cart_list->UseSelectLimit;
	if (!$selectLimit && $sample_req_cart_list->StartRec > 1)
		$sample_req_cart_list->Recordset->move($sample_req_cart_list->StartRec - 1);
} elseif (!$sample_req_cart->AllowAddDeleteRow && $sample_req_cart_list->StopRec == 0) {
	$sample_req_cart_list->StopRec = $sample_req_cart->GridAddRowCount;
}

// Initialize aggregate
$sample_req_cart->RowType = ROWTYPE_AGGREGATEINIT;
$sample_req_cart->resetAttributes();
$sample_req_cart_list->renderRow();
while ($sample_req_cart_list->RecCnt < $sample_req_cart_list->StopRec) {
	$sample_req_cart_list->RecCnt++;
	if ($sample_req_cart_list->RecCnt >= $sample_req_cart_list->StartRec) {
		$sample_req_cart_list->RowCnt++;

		// Set up key count
		$sample_req_cart_list->KeyCount = $sample_req_cart_list->RowIndex;

		// Init row class and style
		$sample_req_cart->resetAttributes();
		$sample_req_cart->CssClass = "";
		if ($sample_req_cart->isGridAdd()) {
		} else {
			$sample_req_cart_list->loadRowValues($sample_req_cart_list->Recordset); // Load row values
		}
		$sample_req_cart->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$sample_req_cart->RowAttrs = array_merge($sample_req_cart->RowAttrs, array('data-rowindex'=>$sample_req_cart_list->RowCnt, 'id'=>'r' . $sample_req_cart_list->RowCnt . '_sample_req_cart', 'data-rowtype'=>$sample_req_cart->RowType));

		// Render row
		$sample_req_cart_list->renderRow();

		// Render list options
		$sample_req_cart_list->renderListOptions();
?>
	<tr<?php echo $sample_req_cart->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sample_req_cart_list->ListOptions->render("body", "left", $sample_req_cart_list->RowCnt);
?>
	<?php if ($sample_req_cart->id->Visible) { // id ?>
		<td data-name="id"<?php echo $sample_req_cart->id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_list->RowCnt ?>_sample_req_cart_id" class="sample_req_cart_id">
<span<?php echo $sample_req_cart->id->viewAttributes() ?>>
<?php echo $sample_req_cart->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart->request_by->Visible) { // request_by ?>
		<td data-name="request_by"<?php echo $sample_req_cart->request_by->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_list->RowCnt ?>_sample_req_cart_request_by" class="sample_req_cart_request_by">
<span<?php echo $sample_req_cart->request_by->viewAttributes() ?>>
<?php echo $sample_req_cart->request_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart->old_ref->Visible) { // old_ref ?>
		<td data-name="old_ref"<?php echo $sample_req_cart->old_ref->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_list->RowCnt ?>_sample_req_cart_old_ref" class="sample_req_cart_old_ref">
<span<?php echo $sample_req_cart->old_ref->viewAttributes() ?>>
<?php if ((!EmptyString($sample_req_cart->old_ref->getViewValue())) && $sample_req_cart->old_ref->linkAttributes() <> "") { ?>
<a<?php echo $sample_req_cart->old_ref->linkAttributes() ?>><?php echo $sample_req_cart->old_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sample_req_cart->old_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart->upload->Visible) { // upload ?>
		<td data-name="upload"<?php echo $sample_req_cart->upload->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_list->RowCnt ?>_sample_req_cart_upload" class="sample_req_cart_upload">
<span>
<?php echo GetFileViewTag($sample_req_cart->upload, $sample_req_cart->upload->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart->design->Visible) { // design ?>
		<td data-name="design"<?php echo $sample_req_cart->design->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_list->RowCnt ?>_sample_req_cart_design" class="sample_req_cart_design">
<span<?php echo $sample_req_cart->design->viewAttributes() ?>>
<?php echo $sample_req_cart->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart->color->Visible) { // color ?>
		<td data-name="color"<?php echo $sample_req_cart->color->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_list->RowCnt ?>_sample_req_cart_color" class="sample_req_cart_color">
<span<?php echo $sample_req_cart->color->viewAttributes() ?>>
<?php echo $sample_req_cart->color->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart->size->Visible) { // size ?>
		<td data-name="size"<?php echo $sample_req_cart->size->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_list->RowCnt ?>_sample_req_cart_size" class="sample_req_cart_size">
<span<?php echo $sample_req_cart->size->viewAttributes() ?>>
<?php echo $sample_req_cart->size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $sample_req_cart->quantity->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_list->RowCnt ?>_sample_req_cart_quantity" class="sample_req_cart_quantity">
<span<?php echo $sample_req_cart->quantity->viewAttributes() ?>>
<?php echo $sample_req_cart->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart->comments->Visible) { // comments ?>
		<td data-name="comments"<?php echo $sample_req_cart->comments->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_list->RowCnt ?>_sample_req_cart_comments" class="sample_req_cart_comments">
<span<?php echo $sample_req_cart->comments->viewAttributes() ?>>
<?php echo $sample_req_cart->comments->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $sample_req_cart->operator->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_list->RowCnt ?>_sample_req_cart_operator" class="sample_req_cart_operator">
<span<?php echo $sample_req_cart->operator->viewAttributes() ?>>
<?php echo $sample_req_cart->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $sample_req_cart->datetime->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_list->RowCnt ?>_sample_req_cart_datetime" class="sample_req_cart_datetime">
<span<?php echo $sample_req_cart->datetime->viewAttributes() ?>>
<?php echo $sample_req_cart->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req_cart->status->Visible) { // status ?>
		<td data-name="status"<?php echo $sample_req_cart->status->cellAttributes() ?>>
<span id="el<?php echo $sample_req_cart_list->RowCnt ?>_sample_req_cart_status" class="sample_req_cart_status">
<span<?php echo $sample_req_cart->status->viewAttributes() ?>>
<?php echo $sample_req_cart->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sample_req_cart_list->ListOptions->render("body", "right", $sample_req_cart_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$sample_req_cart->isGridAdd())
		$sample_req_cart_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$sample_req_cart->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($sample_req_cart_list->Recordset)
	$sample_req_cart_list->Recordset->Close();
?>
<?php if (!$sample_req_cart->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$sample_req_cart->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sample_req_cart_list->Pager)) $sample_req_cart_list->Pager = new PrevNextPager($sample_req_cart_list->StartRec, $sample_req_cart_list->DisplayRecs, $sample_req_cart_list->TotalRecs, $sample_req_cart_list->AutoHidePager) ?>
<?php if ($sample_req_cart_list->Pager->RecordCount > 0 && $sample_req_cart_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sample_req_cart_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sample_req_cart_list->pageUrl() ?>start=<?php echo $sample_req_cart_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sample_req_cart_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sample_req_cart_list->pageUrl() ?>start=<?php echo $sample_req_cart_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sample_req_cart_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sample_req_cart_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sample_req_cart_list->pageUrl() ?>start=<?php echo $sample_req_cart_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sample_req_cart_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sample_req_cart_list->pageUrl() ?>start=<?php echo $sample_req_cart_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sample_req_cart_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sample_req_cart_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sample_req_cart_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sample_req_cart_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sample_req_cart_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sample_req_cart_list->TotalRecs > 0 && (!$sample_req_cart_list->AutoHidePageSizeSelector || $sample_req_cart_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sample_req_cart">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sample_req_cart_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sample_req_cart_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sample_req_cart_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sample_req_cart_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sample_req_cart_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sample_req_cart->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sample_req_cart_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($sample_req_cart_list->TotalRecs == 0 && !$sample_req_cart->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $sample_req_cart_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$sample_req_cart_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sample_req_cart->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$sample_req_cart->isExport()) { ?>
<script>
ew.scrollableTable("gmp_sample_req_cart", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sample_req_cart_list->terminate();
?>