<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_cart_view = new sample_req_cart_view();

// Run the page
$sample_req_cart_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_cart_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sample_req_cart->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fsample_req_cartview = currentForm = new ew.Form("fsample_req_cartview", "view");

// Form_CustomValidate event
fsample_req_cartview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_cartview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_cartview.lists["x_request_by"] = <?php echo $sample_req_cart_view->request_by->Lookup->toClientList() ?>;
fsample_req_cartview.lists["x_request_by"].options = <?php echo JsonEncode($sample_req_cart_view->request_by->lookupOptions()) ?>;
fsample_req_cartview.lists["x_operator"] = <?php echo $sample_req_cart_view->operator->Lookup->toClientList() ?>;
fsample_req_cartview.lists["x_operator"].options = <?php echo JsonEncode($sample_req_cart_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sample_req_cart->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $sample_req_cart_view->ExportOptions->render("body") ?>
<?php $sample_req_cart_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $sample_req_cart_view->showPageHeader(); ?>
<?php
$sample_req_cart_view->showMessage();
?>
<form name="fsample_req_cartview" id="fsample_req_cartview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_cart_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_cart_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart">
<input type="hidden" name="modal" value="<?php echo (int)$sample_req_cart_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($sample_req_cart->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $sample_req_cart_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_id"><?php echo $sample_req_cart->id->caption() ?></span></td>
		<td data-name="id"<?php echo $sample_req_cart->id->cellAttributes() ?>>
<span id="el_sample_req_cart_id">
<span<?php echo $sample_req_cart->id->viewAttributes() ?>>
<?php echo $sample_req_cart->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart->request_by->Visible) { // request_by ?>
	<tr id="r_request_by">
		<td class="<?php echo $sample_req_cart_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_request_by"><?php echo $sample_req_cart->request_by->caption() ?></span></td>
		<td data-name="request_by"<?php echo $sample_req_cart->request_by->cellAttributes() ?>>
<span id="el_sample_req_cart_request_by">
<span<?php echo $sample_req_cart->request_by->viewAttributes() ?>>
<?php echo $sample_req_cart->request_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart->old_ref->Visible) { // old_ref ?>
	<tr id="r_old_ref">
		<td class="<?php echo $sample_req_cart_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_old_ref"><?php echo $sample_req_cart->old_ref->caption() ?></span></td>
		<td data-name="old_ref"<?php echo $sample_req_cart->old_ref->cellAttributes() ?>>
<span id="el_sample_req_cart_old_ref">
<span<?php echo $sample_req_cart->old_ref->viewAttributes() ?>>
<?php if ((!EmptyString($sample_req_cart->old_ref->getViewValue())) && $sample_req_cart->old_ref->linkAttributes() <> "") { ?>
<a<?php echo $sample_req_cart->old_ref->linkAttributes() ?>><?php echo $sample_req_cart->old_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sample_req_cart->old_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart->upload->Visible) { // upload ?>
	<tr id="r_upload">
		<td class="<?php echo $sample_req_cart_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_upload"><?php echo $sample_req_cart->upload->caption() ?></span></td>
		<td data-name="upload"<?php echo $sample_req_cart->upload->cellAttributes() ?>>
<span id="el_sample_req_cart_upload">
<span>
<?php echo GetFileViewTag($sample_req_cart->upload, $sample_req_cart->upload->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart->design->Visible) { // design ?>
	<tr id="r_design">
		<td class="<?php echo $sample_req_cart_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_design"><?php echo $sample_req_cart->design->caption() ?></span></td>
		<td data-name="design"<?php echo $sample_req_cart->design->cellAttributes() ?>>
<span id="el_sample_req_cart_design">
<span<?php echo $sample_req_cart->design->viewAttributes() ?>>
<?php echo $sample_req_cart->design->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart->color->Visible) { // color ?>
	<tr id="r_color">
		<td class="<?php echo $sample_req_cart_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_color"><?php echo $sample_req_cart->color->caption() ?></span></td>
		<td data-name="color"<?php echo $sample_req_cart->color->cellAttributes() ?>>
<span id="el_sample_req_cart_color">
<span<?php echo $sample_req_cart->color->viewAttributes() ?>>
<?php echo $sample_req_cart->color->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart->size->Visible) { // size ?>
	<tr id="r_size">
		<td class="<?php echo $sample_req_cart_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_size"><?php echo $sample_req_cart->size->caption() ?></span></td>
		<td data-name="size"<?php echo $sample_req_cart->size->cellAttributes() ?>>
<span id="el_sample_req_cart_size">
<span<?php echo $sample_req_cart->size->viewAttributes() ?>>
<?php echo $sample_req_cart->size->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $sample_req_cart_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_quantity"><?php echo $sample_req_cart->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $sample_req_cart->quantity->cellAttributes() ?>>
<span id="el_sample_req_cart_quantity">
<span<?php echo $sample_req_cart->quantity->viewAttributes() ?>>
<?php echo $sample_req_cart->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart->comments->Visible) { // comments ?>
	<tr id="r_comments">
		<td class="<?php echo $sample_req_cart_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_comments"><?php echo $sample_req_cart->comments->caption() ?></span></td>
		<td data-name="comments"<?php echo $sample_req_cart->comments->cellAttributes() ?>>
<span id="el_sample_req_cart_comments">
<span<?php echo $sample_req_cart->comments->viewAttributes() ?>>
<?php echo $sample_req_cart->comments->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $sample_req_cart_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_operator"><?php echo $sample_req_cart->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $sample_req_cart->operator->cellAttributes() ?>>
<span id="el_sample_req_cart_operator">
<span<?php echo $sample_req_cart->operator->viewAttributes() ?>>
<?php echo $sample_req_cart->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $sample_req_cart_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_datetime"><?php echo $sample_req_cart->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $sample_req_cart->datetime->cellAttributes() ?>>
<span id="el_sample_req_cart_datetime">
<span<?php echo $sample_req_cart->datetime->viewAttributes() ?>>
<?php echo $sample_req_cart->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_cart->po_id->Visible) { // po_id ?>
	<tr id="r_po_id">
		<td class="<?php echo $sample_req_cart_view->TableLeftColumnClass ?>"><span id="elh_sample_req_cart_po_id"><?php echo $sample_req_cart->po_id->caption() ?></span></td>
		<td data-name="po_id"<?php echo $sample_req_cart->po_id->cellAttributes() ?>>
<span id="el_sample_req_cart_po_id">
<span<?php echo $sample_req_cart->po_id->viewAttributes() ?>>
<?php echo $sample_req_cart->po_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$sample_req_cart_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sample_req_cart->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sample_req_cart_view->terminate();
?>