<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_misc_addopt = new sample_req_misc_addopt();

// Run the page
$sample_req_misc_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_misc_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fsample_req_miscaddopt = currentForm = new ew.Form("fsample_req_miscaddopt", "addopt");

// Validate form
fsample_req_miscaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($sample_req_misc_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_misc->grp->caption(), $sample_req_misc->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_misc_addopt->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_misc->item->caption(), $sample_req_misc->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_misc_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_misc->status->caption(), $sample_req_misc->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_misc_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_misc->operator->caption(), $sample_req_misc->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_misc_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req_misc->datetime->caption(), $sample_req_misc->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsample_req_miscaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_miscaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_miscaddopt.lists["x_grp"] = <?php echo $sample_req_misc_addopt->grp->Lookup->toClientList() ?>;
fsample_req_miscaddopt.lists["x_grp"].options = <?php echo JsonEncode($sample_req_misc_addopt->grp->lookupOptions()) ?>;
fsample_req_miscaddopt.lists["x_status"] = <?php echo $sample_req_misc_addopt->status->Lookup->toClientList() ?>;
fsample_req_miscaddopt.lists["x_status"].options = <?php echo JsonEncode($sample_req_misc_addopt->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sample_req_misc_addopt->showPageHeader(); ?>
<?php
$sample_req_misc_addopt->showMessage();
?>
<form name="fsample_req_miscaddopt" id="fsample_req_miscaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($sample_req_misc_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_misc_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $sample_req_misc_addopt->TableVar ?>">
<?php if ($sample_req_misc->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $sample_req_misc->grp->caption() ?><?php echo ($sample_req_misc->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_misc" data-field="x_grp" data-value-separator="<?php echo $sample_req_misc->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $sample_req_misc->grp->editAttributes() ?>>
		<?php echo $sample_req_misc->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $sample_req_misc->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $sample_req_misc->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($sample_req_misc->item->Visible) { // item ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_item"><?php echo $sample_req_misc->item->caption() ?><?php echo ($sample_req_misc->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="sample_req_misc" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($sample_req_misc->item->getPlaceHolder()) ?>" value="<?php echo $sample_req_misc->item->EditValue ?>"<?php echo $sample_req_misc->item->editAttributes() ?>>
<?php echo $sample_req_misc->item->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($sample_req_misc->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $sample_req_misc->status->caption() ?><?php echo ($sample_req_misc->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req_misc" data-field="x_status" data-value-separator="<?php echo $sample_req_misc->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $sample_req_misc->status->editAttributes() ?>>
		<?php echo $sample_req_misc->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $sample_req_misc->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($sample_req_misc->operator->Visible) { // operator ?>
	<input type="hidden" data-table="sample_req_misc" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($sample_req_misc->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($sample_req_misc->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="sample_req_misc" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($sample_req_misc->datetime->CurrentValue) ?>">
	<?php if (!$sample_req_misc->datetime->ReadOnly && !$sample_req_misc->datetime->Disabled && !isset($sample_req_misc->datetime->EditAttrs["readonly"]) && !isset($sample_req_misc->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fsample_req_miscaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
</form>
<?php
$sample_req_misc_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$sample_req_misc_addopt->terminate();
?>