<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_misc_view = new sample_req_misc_view();

// Run the page
$sample_req_misc_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_misc_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sample_req_misc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fsample_req_miscview = currentForm = new ew.Form("fsample_req_miscview", "view");

// Form_CustomValidate event
fsample_req_miscview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_req_miscview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_req_miscview.lists["x_grp"] = <?php echo $sample_req_misc_view->grp->Lookup->toClientList() ?>;
fsample_req_miscview.lists["x_grp"].options = <?php echo JsonEncode($sample_req_misc_view->grp->lookupOptions()) ?>;
fsample_req_miscview.lists["x_status"] = <?php echo $sample_req_misc_view->status->Lookup->toClientList() ?>;
fsample_req_miscview.lists["x_status"].options = <?php echo JsonEncode($sample_req_misc_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sample_req_misc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $sample_req_misc_view->ExportOptions->render("body") ?>
<?php $sample_req_misc_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $sample_req_misc_view->showPageHeader(); ?>
<?php
$sample_req_misc_view->showMessage();
?>
<form name="fsample_req_miscview" id="fsample_req_miscview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_misc_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_misc_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req_misc">
<input type="hidden" name="modal" value="<?php echo (int)$sample_req_misc_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($sample_req_misc->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $sample_req_misc_view->TableLeftColumnClass ?>"><span id="elh_sample_req_misc_id"><?php echo $sample_req_misc->id->caption() ?></span></td>
		<td data-name="id"<?php echo $sample_req_misc->id->cellAttributes() ?>>
<span id="el_sample_req_misc_id">
<span<?php echo $sample_req_misc->id->viewAttributes() ?>>
<?php echo $sample_req_misc->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_misc->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $sample_req_misc_view->TableLeftColumnClass ?>"><span id="elh_sample_req_misc_grp"><?php echo $sample_req_misc->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $sample_req_misc->grp->cellAttributes() ?>>
<span id="el_sample_req_misc_grp">
<span<?php echo $sample_req_misc->grp->viewAttributes() ?>>
<?php echo $sample_req_misc->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_misc->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $sample_req_misc_view->TableLeftColumnClass ?>"><span id="elh_sample_req_misc_item"><?php echo $sample_req_misc->item->caption() ?></span></td>
		<td data-name="item"<?php echo $sample_req_misc->item->cellAttributes() ?>>
<span id="el_sample_req_misc_item">
<span<?php echo $sample_req_misc->item->viewAttributes() ?>>
<?php echo $sample_req_misc->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_misc->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $sample_req_misc_view->TableLeftColumnClass ?>"><span id="elh_sample_req_misc_status"><?php echo $sample_req_misc->status->caption() ?></span></td>
		<td data-name="status"<?php echo $sample_req_misc->status->cellAttributes() ?>>
<span id="el_sample_req_misc_status">
<span<?php echo $sample_req_misc->status->viewAttributes() ?>>
<?php echo $sample_req_misc->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_misc->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $sample_req_misc_view->TableLeftColumnClass ?>"><span id="elh_sample_req_misc_operator"><?php echo $sample_req_misc->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $sample_req_misc->operator->cellAttributes() ?>>
<span id="el_sample_req_misc_operator">
<span<?php echo $sample_req_misc->operator->viewAttributes() ?>>
<?php echo $sample_req_misc->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req_misc->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $sample_req_misc_view->TableLeftColumnClass ?>"><span id="elh_sample_req_misc_datetime"><?php echo $sample_req_misc->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $sample_req_misc->datetime->cellAttributes() ?>>
<span id="el_sample_req_misc_datetime">
<span<?php echo $sample_req_misc->datetime->viewAttributes() ?>>
<?php echo $sample_req_misc->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$sample_req_misc_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sample_req_misc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sample_req_misc_view->terminate();
?>