<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_delete = new sample_req_delete();

// Run the page
$sample_req_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fsample_reqdelete = currentForm = new ew.Form("fsample_reqdelete", "delete");

// Form_CustomValidate event
fsample_reqdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_reqdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_reqdelete.lists["x_buyer_id"] = <?php echo $sample_req_delete->buyer_id->Lookup->toClientList() ?>;
fsample_reqdelete.lists["x_buyer_id"].options = <?php echo JsonEncode($sample_req_delete->buyer_id->lookupOptions()) ?>;
fsample_reqdelete.lists["x_sample_cart_id[]"] = <?php echo $sample_req_delete->sample_cart_id->Lookup->toClientList() ?>;
fsample_reqdelete.lists["x_sample_cart_id[]"].options = <?php echo JsonEncode($sample_req_delete->sample_cart_id->lookupOptions()) ?>;
fsample_reqdelete.lists["x_purpose"] = <?php echo $sample_req_delete->purpose->Lookup->toClientList() ?>;
fsample_reqdelete.lists["x_purpose"].options = <?php echo JsonEncode($sample_req_delete->purpose->lookupOptions()) ?>;
fsample_reqdelete.lists["x_label"] = <?php echo $sample_req_delete->label->Lookup->toClientList() ?>;
fsample_reqdelete.lists["x_label"].options = <?php echo JsonEncode($sample_req_delete->label->lookupOptions()) ?>;
fsample_reqdelete.lists["x_shipping_mode"] = <?php echo $sample_req_delete->shipping_mode->Lookup->toClientList() ?>;
fsample_reqdelete.lists["x_shipping_mode"].options = <?php echo JsonEncode($sample_req_delete->shipping_mode->options(FALSE, TRUE)) ?>;
fsample_reqdelete.lists["x_delivery_week"] = <?php echo $sample_req_delete->delivery_week->Lookup->toClientList() ?>;
fsample_reqdelete.lists["x_delivery_week"].options = <?php echo JsonEncode($sample_req_delete->delivery_week->lookupOptions()) ?>;
fsample_reqdelete.lists["x_shipping_address"] = <?php echo $sample_req_delete->shipping_address->Lookup->toClientList() ?>;
fsample_reqdelete.lists["x_shipping_address"].options = <?php echo JsonEncode($sample_req_delete->shipping_address->lookupOptions()) ?>;
fsample_reqdelete.lists["x_operator"] = <?php echo $sample_req_delete->operator->Lookup->toClientList() ?>;
fsample_reqdelete.lists["x_operator"].options = <?php echo JsonEncode($sample_req_delete->operator->lookupOptions()) ?>;
fsample_reqdelete.lists["x_status"] = <?php echo $sample_req_delete->status->Lookup->toClientList() ?>;
fsample_reqdelete.lists["x_status"].options = <?php echo JsonEncode($sample_req_delete->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sample_req_delete->showPageHeader(); ?>
<?php
$sample_req_delete->showMessage();
?>
<form name="fsample_reqdelete" id="fsample_reqdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($sample_req_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($sample_req->id->Visible) { // id ?>
		<th class="<?php echo $sample_req->id->headerCellClass() ?>"><span id="elh_sample_req_id" class="sample_req_id"><?php echo $sample_req->id->caption() ?></span></th>
<?php } ?>
<?php if ($sample_req->buyer_id->Visible) { // buyer_id ?>
		<th class="<?php echo $sample_req->buyer_id->headerCellClass() ?>"><span id="elh_sample_req_buyer_id" class="sample_req_buyer_id"><?php echo $sample_req->buyer_id->caption() ?></span></th>
<?php } ?>
<?php if ($sample_req->sample_cart_id->Visible) { // sample_cart_id ?>
		<th class="<?php echo $sample_req->sample_cart_id->headerCellClass() ?>"><span id="elh_sample_req_sample_cart_id" class="sample_req_sample_cart_id"><?php echo $sample_req->sample_cart_id->caption() ?></span></th>
<?php } ?>
<?php if ($sample_req->purpose->Visible) { // purpose ?>
		<th class="<?php echo $sample_req->purpose->headerCellClass() ?>"><span id="elh_sample_req_purpose" class="sample_req_purpose"><?php echo $sample_req->purpose->caption() ?></span></th>
<?php } ?>
<?php if ($sample_req->label->Visible) { // label ?>
		<th class="<?php echo $sample_req->label->headerCellClass() ?>"><span id="elh_sample_req_label" class="sample_req_label"><?php echo $sample_req->label->caption() ?></span></th>
<?php } ?>
<?php if ($sample_req->ssd->Visible) { // ssd ?>
		<th class="<?php echo $sample_req->ssd->headerCellClass() ?>"><span id="elh_sample_req_ssd" class="sample_req_ssd"><?php echo $sample_req->ssd->caption() ?></span></th>
<?php } ?>
<?php if ($sample_req->shipping_mode->Visible) { // shipping_mode ?>
		<th class="<?php echo $sample_req->shipping_mode->headerCellClass() ?>"><span id="elh_sample_req_shipping_mode" class="sample_req_shipping_mode"><?php echo $sample_req->shipping_mode->caption() ?></span></th>
<?php } ?>
<?php if ($sample_req->delivery_week->Visible) { // delivery_week ?>
		<th class="<?php echo $sample_req->delivery_week->headerCellClass() ?>"><span id="elh_sample_req_delivery_week" class="sample_req_delivery_week"><?php echo $sample_req->delivery_week->caption() ?></span></th>
<?php } ?>
<?php if ($sample_req->shipping_address->Visible) { // shipping_address ?>
		<th class="<?php echo $sample_req->shipping_address->headerCellClass() ?>"><span id="elh_sample_req_shipping_address" class="sample_req_shipping_address"><?php echo $sample_req->shipping_address->caption() ?></span></th>
<?php } ?>
<?php if ($sample_req->operator->Visible) { // operator ?>
		<th class="<?php echo $sample_req->operator->headerCellClass() ?>"><span id="elh_sample_req_operator" class="sample_req_operator"><?php echo $sample_req->operator->caption() ?></span></th>
<?php } ?>
<?php if ($sample_req->datetime->Visible) { // datetime ?>
		<th class="<?php echo $sample_req->datetime->headerCellClass() ?>"><span id="elh_sample_req_datetime" class="sample_req_datetime"><?php echo $sample_req->datetime->caption() ?></span></th>
<?php } ?>
<?php if ($sample_req->status->Visible) { // status ?>
		<th class="<?php echo $sample_req->status->headerCellClass() ?>"><span id="elh_sample_req_status" class="sample_req_status"><?php echo $sample_req->status->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$sample_req_delete->RecCnt = 0;
$i = 0;
while (!$sample_req_delete->Recordset->EOF) {
	$sample_req_delete->RecCnt++;
	$sample_req_delete->RowCnt++;

	// Set row properties
	$sample_req->resetAttributes();
	$sample_req->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$sample_req_delete->loadRowValues($sample_req_delete->Recordset);

	// Render row
	$sample_req_delete->renderRow();
?>
	<tr<?php echo $sample_req->rowAttributes() ?>>
<?php if ($sample_req->id->Visible) { // id ?>
		<td<?php echo $sample_req->id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_delete->RowCnt ?>_sample_req_id" class="sample_req_id">
<span<?php echo $sample_req->id->viewAttributes() ?>>
<?php echo $sample_req->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($sample_req->buyer_id->Visible) { // buyer_id ?>
		<td<?php echo $sample_req->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_delete->RowCnt ?>_sample_req_buyer_id" class="sample_req_buyer_id">
<span<?php echo $sample_req->buyer_id->viewAttributes() ?>>
<?php echo $sample_req->buyer_id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($sample_req->sample_cart_id->Visible) { // sample_cart_id ?>
		<td<?php echo $sample_req->sample_cart_id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_delete->RowCnt ?>_sample_req_sample_cart_id" class="sample_req_sample_cart_id">
<span<?php echo $sample_req->sample_cart_id->viewAttributes() ?>>
<?php echo $sample_req->sample_cart_id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($sample_req->purpose->Visible) { // purpose ?>
		<td<?php echo $sample_req->purpose->cellAttributes() ?>>
<span id="el<?php echo $sample_req_delete->RowCnt ?>_sample_req_purpose" class="sample_req_purpose">
<span<?php echo $sample_req->purpose->viewAttributes() ?>>
<?php echo $sample_req->purpose->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($sample_req->label->Visible) { // label ?>
		<td<?php echo $sample_req->label->cellAttributes() ?>>
<span id="el<?php echo $sample_req_delete->RowCnt ?>_sample_req_label" class="sample_req_label">
<span<?php echo $sample_req->label->viewAttributes() ?>>
<?php echo $sample_req->label->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($sample_req->ssd->Visible) { // ssd ?>
		<td<?php echo $sample_req->ssd->cellAttributes() ?>>
<span id="el<?php echo $sample_req_delete->RowCnt ?>_sample_req_ssd" class="sample_req_ssd">
<span<?php echo $sample_req->ssd->viewAttributes() ?>>
<?php echo $sample_req->ssd->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($sample_req->shipping_mode->Visible) { // shipping_mode ?>
		<td<?php echo $sample_req->shipping_mode->cellAttributes() ?>>
<span id="el<?php echo $sample_req_delete->RowCnt ?>_sample_req_shipping_mode" class="sample_req_shipping_mode">
<span<?php echo $sample_req->shipping_mode->viewAttributes() ?>>
<?php echo $sample_req->shipping_mode->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($sample_req->delivery_week->Visible) { // delivery_week ?>
		<td<?php echo $sample_req->delivery_week->cellAttributes() ?>>
<span id="el<?php echo $sample_req_delete->RowCnt ?>_sample_req_delivery_week" class="sample_req_delivery_week">
<span<?php echo $sample_req->delivery_week->viewAttributes() ?>>
<?php echo $sample_req->delivery_week->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($sample_req->shipping_address->Visible) { // shipping_address ?>
		<td<?php echo $sample_req->shipping_address->cellAttributes() ?>>
<span id="el<?php echo $sample_req_delete->RowCnt ?>_sample_req_shipping_address" class="sample_req_shipping_address">
<span<?php echo $sample_req->shipping_address->viewAttributes() ?>>
<?php echo $sample_req->shipping_address->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($sample_req->operator->Visible) { // operator ?>
		<td<?php echo $sample_req->operator->cellAttributes() ?>>
<span id="el<?php echo $sample_req_delete->RowCnt ?>_sample_req_operator" class="sample_req_operator">
<span<?php echo $sample_req->operator->viewAttributes() ?>>
<?php echo $sample_req->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($sample_req->datetime->Visible) { // datetime ?>
		<td<?php echo $sample_req->datetime->cellAttributes() ?>>
<span id="el<?php echo $sample_req_delete->RowCnt ?>_sample_req_datetime" class="sample_req_datetime">
<span<?php echo $sample_req->datetime->viewAttributes() ?>>
<?php echo $sample_req->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($sample_req->status->Visible) { // status ?>
		<td<?php echo $sample_req->status->cellAttributes() ?>>
<span id="el<?php echo $sample_req_delete->RowCnt ?>_sample_req_status" class="sample_req_status">
<span<?php echo $sample_req->status->viewAttributes() ?>>
<?php echo $sample_req->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$sample_req_delete->Recordset->moveNext();
}
$sample_req_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $sample_req_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$sample_req_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sample_req_delete->terminate();
?>