<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_edit = new sample_req_edit();

// Run the page
$sample_req_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fsample_reqedit = currentForm = new ew.Form("fsample_reqedit", "edit");

// Validate form
fsample_reqedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($sample_req_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req->id->caption(), $sample_req->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_edit->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req->buyer_id->caption(), $sample_req->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_edit->sample_cart_id->Required) { ?>
			elm = this.getElements("x" + infix + "_sample_cart_id[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req->sample_cart_id->caption(), $sample_req->sample_cart_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_edit->purpose->Required) { ?>
			elm = this.getElements("x" + infix + "_purpose");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req->purpose->caption(), $sample_req->purpose->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_edit->label->Required) { ?>
			elm = this.getElements("x" + infix + "_label");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req->label->caption(), $sample_req->label->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_edit->ssd->Required) { ?>
			elm = this.getElements("x" + infix + "_ssd");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req->ssd->caption(), $sample_req->ssd->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ssd");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sample_req->ssd->errorMessage()) ?>");
		<?php if ($sample_req_edit->shipping_mode->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_mode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req->shipping_mode->caption(), $sample_req->shipping_mode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_edit->delivery_week->Required) { ?>
			elm = this.getElements("x" + infix + "_delivery_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req->delivery_week->caption(), $sample_req->delivery_week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_edit->shipping_address->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req->shipping_address->caption(), $sample_req->shipping_address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req->remarks->caption(), $sample_req->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req->operator->caption(), $sample_req->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req->datetime->caption(), $sample_req->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_req_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_req->status->caption(), $sample_req->status->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsample_reqedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_reqedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_reqedit.lists["x_buyer_id"] = <?php echo $sample_req_edit->buyer_id->Lookup->toClientList() ?>;
fsample_reqedit.lists["x_buyer_id"].options = <?php echo JsonEncode($sample_req_edit->buyer_id->lookupOptions()) ?>;
fsample_reqedit.lists["x_sample_cart_id[]"] = <?php echo $sample_req_edit->sample_cart_id->Lookup->toClientList() ?>;
fsample_reqedit.lists["x_sample_cart_id[]"].options = <?php echo JsonEncode($sample_req_edit->sample_cart_id->lookupOptions()) ?>;
fsample_reqedit.lists["x_purpose"] = <?php echo $sample_req_edit->purpose->Lookup->toClientList() ?>;
fsample_reqedit.lists["x_purpose"].options = <?php echo JsonEncode($sample_req_edit->purpose->lookupOptions()) ?>;
fsample_reqedit.lists["x_label"] = <?php echo $sample_req_edit->label->Lookup->toClientList() ?>;
fsample_reqedit.lists["x_label"].options = <?php echo JsonEncode($sample_req_edit->label->lookupOptions()) ?>;
fsample_reqedit.lists["x_shipping_mode"] = <?php echo $sample_req_edit->shipping_mode->Lookup->toClientList() ?>;
fsample_reqedit.lists["x_shipping_mode"].options = <?php echo JsonEncode($sample_req_edit->shipping_mode->options(FALSE, TRUE)) ?>;
fsample_reqedit.lists["x_delivery_week"] = <?php echo $sample_req_edit->delivery_week->Lookup->toClientList() ?>;
fsample_reqedit.lists["x_delivery_week"].options = <?php echo JsonEncode($sample_req_edit->delivery_week->lookupOptions()) ?>;
fsample_reqedit.lists["x_shipping_address"] = <?php echo $sample_req_edit->shipping_address->Lookup->toClientList() ?>;
fsample_reqedit.lists["x_shipping_address"].options = <?php echo JsonEncode($sample_req_edit->shipping_address->lookupOptions()) ?>;
fsample_reqedit.lists["x_operator"] = <?php echo $sample_req_edit->operator->Lookup->toClientList() ?>;
fsample_reqedit.lists["x_operator"].options = <?php echo JsonEncode($sample_req_edit->operator->lookupOptions()) ?>;
fsample_reqedit.lists["x_status"] = <?php echo $sample_req_edit->status->Lookup->toClientList() ?>;
fsample_reqedit.lists["x_status"].options = <?php echo JsonEncode($sample_req_edit->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sample_req_edit->showPageHeader(); ?>
<?php
$sample_req_edit->showMessage();
?>
<form name="fsample_reqedit" id="fsample_reqedit" class="<?php echo $sample_req_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$sample_req_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($sample_req->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_sample_req_id" class="<?php echo $sample_req_edit->LeftColumnClass ?>"><?php echo $sample_req->id->caption() ?><?php echo ($sample_req->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_edit->RightColumnClass ?>"><div<?php echo $sample_req->id->cellAttributes() ?>>
<span id="el_sample_req_id">
<span<?php echo $sample_req->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sample_req->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="sample_req" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($sample_req->id->CurrentValue) ?>">
<?php echo $sample_req->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label id="elh_sample_req_buyer_id" for="x_buyer_id" class="<?php echo $sample_req_edit->LeftColumnClass ?>"><?php echo $sample_req->buyer_id->caption() ?><?php echo ($sample_req->buyer_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_edit->RightColumnClass ?>"><div<?php echo $sample_req->buyer_id->cellAttributes() ?>>
<span id="el_sample_req_buyer_id">
<span<?php echo $sample_req->buyer_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sample_req->buyer_id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="sample_req" data-field="x_buyer_id" name="x_buyer_id" id="x_buyer_id" value="<?php echo HtmlEncode($sample_req->buyer_id->CurrentValue) ?>">
<?php echo $sample_req->buyer_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req->sample_cart_id->Visible) { // sample_cart_id ?>
	<div id="r_sample_cart_id" class="form-group row">
		<label id="elh_sample_req_sample_cart_id" class="<?php echo $sample_req_edit->LeftColumnClass ?>"><?php echo $sample_req->sample_cart_id->caption() ?><?php echo ($sample_req->sample_cart_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_edit->RightColumnClass ?>"><div<?php echo $sample_req->sample_cart_id->cellAttributes() ?>>
<span id="el_sample_req_sample_cart_id">
<div id="tp_x_sample_cart_id" class="ew-template"><input type="checkbox" class="form-check-input" data-table="sample_req" data-field="x_sample_cart_id" data-value-separator="<?php echo $sample_req->sample_cart_id->displayValueSeparatorAttribute() ?>" name="x_sample_cart_id[]" id="x_sample_cart_id[]" value="{value}"<?php echo $sample_req->sample_cart_id->editAttributes() ?>></div>
<div id="dsl_x_sample_cart_id" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $sample_req->sample_cart_id->checkBoxListHtml(FALSE, "x_sample_cart_id[]") ?>
</div></div>
<?php echo $sample_req->sample_cart_id->Lookup->getParamTag("p_x_sample_cart_id") ?>
</span>
<?php echo $sample_req->sample_cart_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req->purpose->Visible) { // purpose ?>
	<div id="r_purpose" class="form-group row">
		<label id="elh_sample_req_purpose" for="x_purpose" class="<?php echo $sample_req_edit->LeftColumnClass ?>"><?php echo $sample_req->purpose->caption() ?><?php echo ($sample_req->purpose->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_edit->RightColumnClass ?>"><div<?php echo $sample_req->purpose->cellAttributes() ?>>
<span id="el_sample_req_purpose">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req" data-field="x_purpose" data-value-separator="<?php echo $sample_req->purpose->displayValueSeparatorAttribute() ?>" id="x_purpose" name="x_purpose"<?php echo $sample_req->purpose->editAttributes() ?>>
		<?php echo $sample_req->purpose->selectOptionListHtml("x_purpose") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "sample_req_misc") && !$sample_req->purpose->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_purpose" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $sample_req->purpose->caption() ?>" data-title="<?php echo $sample_req->purpose->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_purpose',url:'sample_req_miscaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $sample_req->purpose->Lookup->getParamTag("p_x_purpose") ?>
</span>
<?php echo $sample_req->purpose->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req->label->Visible) { // label ?>
	<div id="r_label" class="form-group row">
		<label id="elh_sample_req_label" for="x_label" class="<?php echo $sample_req_edit->LeftColumnClass ?>"><?php echo $sample_req->label->caption() ?><?php echo ($sample_req->label->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_edit->RightColumnClass ?>"><div<?php echo $sample_req->label->cellAttributes() ?>>
<span id="el_sample_req_label">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req" data-field="x_label" data-value-separator="<?php echo $sample_req->label->displayValueSeparatorAttribute() ?>" id="x_label" name="x_label"<?php echo $sample_req->label->editAttributes() ?>>
		<?php echo $sample_req->label->selectOptionListHtml("x_label") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "sample_req_misc") && !$sample_req->label->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_label" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $sample_req->label->caption() ?>" data-title="<?php echo $sample_req->label->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_label',url:'sample_req_miscaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $sample_req->label->Lookup->getParamTag("p_x_label") ?>
</span>
<?php echo $sample_req->label->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req->ssd->Visible) { // ssd ?>
	<div id="r_ssd" class="form-group row">
		<label id="elh_sample_req_ssd" for="x_ssd" class="<?php echo $sample_req_edit->LeftColumnClass ?>"><?php echo $sample_req->ssd->caption() ?><?php echo ($sample_req->ssd->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_edit->RightColumnClass ?>"><div<?php echo $sample_req->ssd->cellAttributes() ?>>
<span id="el_sample_req_ssd">
<input type="text" data-table="sample_req" data-field="x_ssd" name="x_ssd" id="x_ssd" placeholder="<?php echo HtmlEncode($sample_req->ssd->getPlaceHolder()) ?>" value="<?php echo $sample_req->ssd->EditValue ?>"<?php echo $sample_req->ssd->editAttributes() ?>>
<?php if (!$sample_req->ssd->ReadOnly && !$sample_req->ssd->Disabled && !isset($sample_req->ssd->EditAttrs["readonly"]) && !isset($sample_req->ssd->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsample_reqedit", "x_ssd", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $sample_req->ssd->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req->shipping_mode->Visible) { // shipping_mode ?>
	<div id="r_shipping_mode" class="form-group row">
		<label id="elh_sample_req_shipping_mode" for="x_shipping_mode" class="<?php echo $sample_req_edit->LeftColumnClass ?>"><?php echo $sample_req->shipping_mode->caption() ?><?php echo ($sample_req->shipping_mode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_edit->RightColumnClass ?>"><div<?php echo $sample_req->shipping_mode->cellAttributes() ?>>
<span id="el_sample_req_shipping_mode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req" data-field="x_shipping_mode" data-value-separator="<?php echo $sample_req->shipping_mode->displayValueSeparatorAttribute() ?>" id="x_shipping_mode" name="x_shipping_mode"<?php echo $sample_req->shipping_mode->editAttributes() ?>>
		<?php echo $sample_req->shipping_mode->selectOptionListHtml("x_shipping_mode") ?>
	</select>
</div>
</span>
<?php echo $sample_req->shipping_mode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req->delivery_week->Visible) { // delivery_week ?>
	<div id="r_delivery_week" class="form-group row">
		<label id="elh_sample_req_delivery_week" for="x_delivery_week" class="<?php echo $sample_req_edit->LeftColumnClass ?>"><?php echo $sample_req->delivery_week->caption() ?><?php echo ($sample_req->delivery_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_edit->RightColumnClass ?>"><div<?php echo $sample_req->delivery_week->cellAttributes() ?>>
<span id="el_sample_req_delivery_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req" data-field="x_delivery_week" data-value-separator="<?php echo $sample_req->delivery_week->displayValueSeparatorAttribute() ?>" id="x_delivery_week" name="x_delivery_week"<?php echo $sample_req->delivery_week->editAttributes() ?>>
		<?php echo $sample_req->delivery_week->selectOptionListHtml("x_delivery_week") ?>
	</select>
</div>
<?php echo $sample_req->delivery_week->Lookup->getParamTag("p_x_delivery_week") ?>
</span>
<?php echo $sample_req->delivery_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req->shipping_address->Visible) { // shipping_address ?>
	<div id="r_shipping_address" class="form-group row">
		<label id="elh_sample_req_shipping_address" for="x_shipping_address" class="<?php echo $sample_req_edit->LeftColumnClass ?>"><?php echo $sample_req->shipping_address->caption() ?><?php echo ($sample_req->shipping_address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_edit->RightColumnClass ?>"><div<?php echo $sample_req->shipping_address->cellAttributes() ?>>
<span id="el_sample_req_shipping_address">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req" data-field="x_shipping_address" data-value-separator="<?php echo $sample_req->shipping_address->displayValueSeparatorAttribute() ?>" id="x_shipping_address" name="x_shipping_address"<?php echo $sample_req->shipping_address->editAttributes() ?>>
		<?php echo $sample_req->shipping_address->selectOptionListHtml("x_shipping_address") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "shipping_address") && !$sample_req->shipping_address->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_shipping_address" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $sample_req->shipping_address->caption() ?>" data-title="<?php echo $sample_req->shipping_address->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_shipping_address',url:'shipping_addressaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $sample_req->shipping_address->Lookup->getParamTag("p_x_shipping_address") ?>
</span>
<?php echo $sample_req->shipping_address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_sample_req_remarks" for="x_remarks" class="<?php echo $sample_req_edit->LeftColumnClass ?>"><?php echo $sample_req->remarks->caption() ?><?php echo ($sample_req->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_edit->RightColumnClass ?>"><div<?php echo $sample_req->remarks->cellAttributes() ?>>
<span id="el_sample_req_remarks">
<textarea data-table="sample_req" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($sample_req->remarks->getPlaceHolder()) ?>"<?php echo $sample_req->remarks->editAttributes() ?>><?php echo $sample_req->remarks->EditValue ?></textarea>
</span>
<?php echo $sample_req->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_req->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_sample_req_status" for="x_status" class="<?php echo $sample_req_edit->LeftColumnClass ?>"><?php echo $sample_req->status->caption() ?><?php echo ($sample_req->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_req_edit->RightColumnClass ?>"><div<?php echo $sample_req->status->cellAttributes() ?>>
<span id="el_sample_req_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req" data-field="x_status" data-value-separator="<?php echo $sample_req->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $sample_req->status->editAttributes() ?>>
		<?php echo $sample_req->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $sample_req->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$sample_req_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $sample_req_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $sample_req_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$sample_req_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var label = $("x_label").val();
		if (label == 201)
		{
		$("#r_ssd").show();
		} else {
		$("#r_ssd").hide();
		}
		var ship = $("x_shipping_address").val();
		if (ship == 3)
		{
		$("#r_shipping_address_2").show();
		} else {
		$("#r_shipping_address_2").hide();
		}
</script>
<?php include_once "footer.php" ?>
<?php
$sample_req_edit->terminate();
?>