<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_list = new sample_req_list();

// Run the page
$sample_req_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sample_req->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsample_reqlist = currentForm = new ew.Form("fsample_reqlist", "list");
fsample_reqlist.formKeyCountName = '<?php echo $sample_req_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsample_reqlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_reqlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_reqlist.lists["x_buyer_id"] = <?php echo $sample_req_list->buyer_id->Lookup->toClientList() ?>;
fsample_reqlist.lists["x_buyer_id"].options = <?php echo JsonEncode($sample_req_list->buyer_id->lookupOptions()) ?>;
fsample_reqlist.lists["x_sample_cart_id[]"] = <?php echo $sample_req_list->sample_cart_id->Lookup->toClientList() ?>;
fsample_reqlist.lists["x_sample_cart_id[]"].options = <?php echo JsonEncode($sample_req_list->sample_cart_id->lookupOptions()) ?>;
fsample_reqlist.lists["x_purpose"] = <?php echo $sample_req_list->purpose->Lookup->toClientList() ?>;
fsample_reqlist.lists["x_purpose"].options = <?php echo JsonEncode($sample_req_list->purpose->lookupOptions()) ?>;
fsample_reqlist.lists["x_label"] = <?php echo $sample_req_list->label->Lookup->toClientList() ?>;
fsample_reqlist.lists["x_label"].options = <?php echo JsonEncode($sample_req_list->label->lookupOptions()) ?>;
fsample_reqlist.lists["x_shipping_mode"] = <?php echo $sample_req_list->shipping_mode->Lookup->toClientList() ?>;
fsample_reqlist.lists["x_shipping_mode"].options = <?php echo JsonEncode($sample_req_list->shipping_mode->options(FALSE, TRUE)) ?>;
fsample_reqlist.lists["x_delivery_week"] = <?php echo $sample_req_list->delivery_week->Lookup->toClientList() ?>;
fsample_reqlist.lists["x_delivery_week"].options = <?php echo JsonEncode($sample_req_list->delivery_week->lookupOptions()) ?>;
fsample_reqlist.lists["x_shipping_address"] = <?php echo $sample_req_list->shipping_address->Lookup->toClientList() ?>;
fsample_reqlist.lists["x_shipping_address"].options = <?php echo JsonEncode($sample_req_list->shipping_address->lookupOptions()) ?>;
fsample_reqlist.lists["x_operator"] = <?php echo $sample_req_list->operator->Lookup->toClientList() ?>;
fsample_reqlist.lists["x_operator"].options = <?php echo JsonEncode($sample_req_list->operator->lookupOptions()) ?>;
fsample_reqlist.lists["x_status"] = <?php echo $sample_req_list->status->Lookup->toClientList() ?>;
fsample_reqlist.lists["x_status"].options = <?php echo JsonEncode($sample_req_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fsample_reqlistsrch = currentSearchForm = new ew.Form("fsample_reqlistsrch");

// Validate function for search
fsample_reqlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fsample_reqlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_reqlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_reqlistsrch.lists["x_buyer_id"] = <?php echo $sample_req_list->buyer_id->Lookup->toClientList() ?>;
fsample_reqlistsrch.lists["x_buyer_id"].options = <?php echo JsonEncode($sample_req_list->buyer_id->lookupOptions()) ?>;
fsample_reqlistsrch.lists["x_status"] = <?php echo $sample_req_list->status->Lookup->toClientList() ?>;
fsample_reqlistsrch.lists["x_status"].options = <?php echo JsonEncode($sample_req_list->status->options(FALSE, TRUE)) ?>;

// Filters
fsample_reqlistsrch.filterList = <?php echo $sample_req_list->getFilterList() ?>;

// Init search panel as collapsed
fsample_reqlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sample_req->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($sample_req_list->TotalRecs > 0 && $sample_req_list->ExportOptions->visible()) { ?>
<?php $sample_req_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_list->ImportOptions->visible()) { ?>
<?php $sample_req_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_list->SearchOptions->visible()) { ?>
<?php $sample_req_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($sample_req_list->FilterOptions->visible()) { ?>
<?php $sample_req_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$sample_req_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$sample_req->isExport() && !$sample_req->CurrentAction) { ?>
<form name="fsample_reqlistsrch" id="fsample_reqlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($sample_req_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fsample_reqlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="sample_req">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$sample_req_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$sample_req->RowType = ROWTYPE_SEARCH;

// Render row
$sample_req->resetAttributes();
$sample_req_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($sample_req->buyer_id->Visible) { // buyer_id ?>
	<div id="xsc_buyer_id" class="ew-cell form-group">
		<label for="x_buyer_id" class="ew-search-caption ew-label"><?php echo $sample_req->buyer_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req" data-field="x_buyer_id" data-value-separator="<?php echo $sample_req->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $sample_req->buyer_id->editAttributes() ?>>
		<?php echo $sample_req->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $sample_req->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($sample_req->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $sample_req->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sample_req" data-field="x_status" data-value-separator="<?php echo $sample_req->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $sample_req->status->editAttributes() ?>>
		<?php echo $sample_req->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($sample_req_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($sample_req_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $sample_req_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($sample_req_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($sample_req_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($sample_req_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($sample_req_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $sample_req_list->showPageHeader(); ?>
<?php
$sample_req_list->showMessage();
?>
<?php if ($sample_req_list->TotalRecs > 0 || $sample_req->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($sample_req_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> sample_req">
<?php if (!$sample_req->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$sample_req->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sample_req_list->Pager)) $sample_req_list->Pager = new PrevNextPager($sample_req_list->StartRec, $sample_req_list->DisplayRecs, $sample_req_list->TotalRecs, $sample_req_list->AutoHidePager) ?>
<?php if ($sample_req_list->Pager->RecordCount > 0 && $sample_req_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sample_req_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sample_req_list->pageUrl() ?>start=<?php echo $sample_req_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sample_req_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sample_req_list->pageUrl() ?>start=<?php echo $sample_req_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sample_req_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sample_req_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sample_req_list->pageUrl() ?>start=<?php echo $sample_req_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sample_req_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sample_req_list->pageUrl() ?>start=<?php echo $sample_req_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sample_req_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sample_req_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sample_req_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sample_req_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sample_req_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sample_req_list->TotalRecs > 0 && (!$sample_req_list->AutoHidePageSizeSelector || $sample_req_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sample_req">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sample_req_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sample_req_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sample_req_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sample_req_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sample_req_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sample_req->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sample_req_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsample_reqlist" id="fsample_reqlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req">
<div id="gmp_sample_req" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($sample_req_list->TotalRecs > 0 || $sample_req->isGridEdit()) { ?>
<table id="tbl_sample_reqlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$sample_req_list->RowType = ROWTYPE_HEADER;

// Render list options
$sample_req_list->renderListOptions();

// Render list options (header, left)
$sample_req_list->ListOptions->render("header", "left");
?>
<?php if ($sample_req->id->Visible) { // id ?>
	<?php if ($sample_req->sortUrl($sample_req->id) == "") { ?>
		<th data-name="id" class="<?php echo $sample_req->id->headerCellClass() ?>"><div id="elh_sample_req_id" class="sample_req_id"><div class="ew-table-header-caption"><?php echo $sample_req->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $sample_req->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req->SortUrl($sample_req->id) ?>',2);"><div id="elh_sample_req_id" class="sample_req_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req->buyer_id->Visible) { // buyer_id ?>
	<?php if ($sample_req->sortUrl($sample_req->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $sample_req->buyer_id->headerCellClass() ?>"><div id="elh_sample_req_buyer_id" class="sample_req_buyer_id"><div class="ew-table-header-caption"><?php echo $sample_req->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $sample_req->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req->SortUrl($sample_req->buyer_id) ?>',2);"><div id="elh_sample_req_buyer_id" class="sample_req_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req->sample_cart_id->Visible) { // sample_cart_id ?>
	<?php if ($sample_req->sortUrl($sample_req->sample_cart_id) == "") { ?>
		<th data-name="sample_cart_id" class="<?php echo $sample_req->sample_cart_id->headerCellClass() ?>"><div id="elh_sample_req_sample_cart_id" class="sample_req_sample_cart_id"><div class="ew-table-header-caption"><?php echo $sample_req->sample_cart_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sample_cart_id" class="<?php echo $sample_req->sample_cart_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req->SortUrl($sample_req->sample_cart_id) ?>',2);"><div id="elh_sample_req_sample_cart_id" class="sample_req_sample_cart_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req->sample_cart_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req->sample_cart_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req->sample_cart_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req->purpose->Visible) { // purpose ?>
	<?php if ($sample_req->sortUrl($sample_req->purpose) == "") { ?>
		<th data-name="purpose" class="<?php echo $sample_req->purpose->headerCellClass() ?>"><div id="elh_sample_req_purpose" class="sample_req_purpose"><div class="ew-table-header-caption"><?php echo $sample_req->purpose->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="purpose" class="<?php echo $sample_req->purpose->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req->SortUrl($sample_req->purpose) ?>',2);"><div id="elh_sample_req_purpose" class="sample_req_purpose">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req->purpose->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req->purpose->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req->purpose->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req->label->Visible) { // label ?>
	<?php if ($sample_req->sortUrl($sample_req->label) == "") { ?>
		<th data-name="label" class="<?php echo $sample_req->label->headerCellClass() ?>"><div id="elh_sample_req_label" class="sample_req_label"><div class="ew-table-header-caption"><?php echo $sample_req->label->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="label" class="<?php echo $sample_req->label->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req->SortUrl($sample_req->label) ?>',2);"><div id="elh_sample_req_label" class="sample_req_label">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req->label->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req->label->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req->label->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req->ssd->Visible) { // ssd ?>
	<?php if ($sample_req->sortUrl($sample_req->ssd) == "") { ?>
		<th data-name="ssd" class="<?php echo $sample_req->ssd->headerCellClass() ?>"><div id="elh_sample_req_ssd" class="sample_req_ssd"><div class="ew-table-header-caption"><?php echo $sample_req->ssd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ssd" class="<?php echo $sample_req->ssd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req->SortUrl($sample_req->ssd) ?>',2);"><div id="elh_sample_req_ssd" class="sample_req_ssd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req->ssd->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req->ssd->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req->ssd->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req->shipping_mode->Visible) { // shipping_mode ?>
	<?php if ($sample_req->sortUrl($sample_req->shipping_mode) == "") { ?>
		<th data-name="shipping_mode" class="<?php echo $sample_req->shipping_mode->headerCellClass() ?>"><div id="elh_sample_req_shipping_mode" class="sample_req_shipping_mode"><div class="ew-table-header-caption"><?php echo $sample_req->shipping_mode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipping_mode" class="<?php echo $sample_req->shipping_mode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req->SortUrl($sample_req->shipping_mode) ?>',2);"><div id="elh_sample_req_shipping_mode" class="sample_req_shipping_mode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req->shipping_mode->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req->shipping_mode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req->shipping_mode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req->delivery_week->Visible) { // delivery_week ?>
	<?php if ($sample_req->sortUrl($sample_req->delivery_week) == "") { ?>
		<th data-name="delivery_week" class="<?php echo $sample_req->delivery_week->headerCellClass() ?>"><div id="elh_sample_req_delivery_week" class="sample_req_delivery_week"><div class="ew-table-header-caption"><?php echo $sample_req->delivery_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_week" class="<?php echo $sample_req->delivery_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req->SortUrl($sample_req->delivery_week) ?>',2);"><div id="elh_sample_req_delivery_week" class="sample_req_delivery_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req->delivery_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req->delivery_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req->delivery_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req->shipping_address->Visible) { // shipping_address ?>
	<?php if ($sample_req->sortUrl($sample_req->shipping_address) == "") { ?>
		<th data-name="shipping_address" class="<?php echo $sample_req->shipping_address->headerCellClass() ?>"><div id="elh_sample_req_shipping_address" class="sample_req_shipping_address"><div class="ew-table-header-caption"><?php echo $sample_req->shipping_address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipping_address" class="<?php echo $sample_req->shipping_address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req->SortUrl($sample_req->shipping_address) ?>',2);"><div id="elh_sample_req_shipping_address" class="sample_req_shipping_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req->shipping_address->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req->shipping_address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req->shipping_address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req->operator->Visible) { // operator ?>
	<?php if ($sample_req->sortUrl($sample_req->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $sample_req->operator->headerCellClass() ?>"><div id="elh_sample_req_operator" class="sample_req_operator"><div class="ew-table-header-caption"><?php echo $sample_req->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $sample_req->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req->SortUrl($sample_req->operator) ?>',2);"><div id="elh_sample_req_operator" class="sample_req_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req->datetime->Visible) { // datetime ?>
	<?php if ($sample_req->sortUrl($sample_req->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $sample_req->datetime->headerCellClass() ?>"><div id="elh_sample_req_datetime" class="sample_req_datetime"><div class="ew-table-header-caption"><?php echo $sample_req->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $sample_req->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req->SortUrl($sample_req->datetime) ?>',2);"><div id="elh_sample_req_datetime" class="sample_req_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sample_req->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sample_req->status->Visible) { // status ?>
	<?php if ($sample_req->sortUrl($sample_req->status) == "") { ?>
		<th data-name="status" class="<?php echo $sample_req->status->headerCellClass() ?>"><div id="elh_sample_req_status" class="sample_req_status"><div class="ew-table-header-caption"><?php echo $sample_req->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $sample_req->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sample_req->SortUrl($sample_req->status) ?>',2);"><div id="elh_sample_req_status" class="sample_req_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sample_req->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($sample_req->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sample_req->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sample_req_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($sample_req->ExportAll && $sample_req->isExport()) {
	$sample_req_list->StopRec = $sample_req_list->TotalRecs;
} else {

	// Set the last record to display
	if ($sample_req_list->TotalRecs > $sample_req_list->StartRec + $sample_req_list->DisplayRecs - 1)
		$sample_req_list->StopRec = $sample_req_list->StartRec + $sample_req_list->DisplayRecs - 1;
	else
		$sample_req_list->StopRec = $sample_req_list->TotalRecs;
}
$sample_req_list->RecCnt = $sample_req_list->StartRec - 1;
if ($sample_req_list->Recordset && !$sample_req_list->Recordset->EOF) {
	$sample_req_list->Recordset->moveFirst();
	$selectLimit = $sample_req_list->UseSelectLimit;
	if (!$selectLimit && $sample_req_list->StartRec > 1)
		$sample_req_list->Recordset->move($sample_req_list->StartRec - 1);
} elseif (!$sample_req->AllowAddDeleteRow && $sample_req_list->StopRec == 0) {
	$sample_req_list->StopRec = $sample_req->GridAddRowCount;
}

// Initialize aggregate
$sample_req->RowType = ROWTYPE_AGGREGATEINIT;
$sample_req->resetAttributes();
$sample_req_list->renderRow();
while ($sample_req_list->RecCnt < $sample_req_list->StopRec) {
	$sample_req_list->RecCnt++;
	if ($sample_req_list->RecCnt >= $sample_req_list->StartRec) {
		$sample_req_list->RowCnt++;

		// Set up key count
		$sample_req_list->KeyCount = $sample_req_list->RowIndex;

		// Init row class and style
		$sample_req->resetAttributes();
		$sample_req->CssClass = "";
		if ($sample_req->isGridAdd()) {
		} else {
			$sample_req_list->loadRowValues($sample_req_list->Recordset); // Load row values
		}
		$sample_req->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$sample_req->RowAttrs = array_merge($sample_req->RowAttrs, array('data-rowindex'=>$sample_req_list->RowCnt, 'id'=>'r' . $sample_req_list->RowCnt . '_sample_req', 'data-rowtype'=>$sample_req->RowType));

		// Render row
		$sample_req_list->renderRow();

		// Render list options
		$sample_req_list->renderListOptions();
?>
	<tr<?php echo $sample_req->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sample_req_list->ListOptions->render("body", "left", $sample_req_list->RowCnt);
?>
	<?php if ($sample_req->id->Visible) { // id ?>
		<td data-name="id"<?php echo $sample_req->id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_list->RowCnt ?>_sample_req_id" class="sample_req_id">
<span<?php echo $sample_req->id->viewAttributes() ?>>
<?php echo $sample_req->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $sample_req->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_list->RowCnt ?>_sample_req_buyer_id" class="sample_req_buyer_id">
<span<?php echo $sample_req->buyer_id->viewAttributes() ?>>
<?php echo $sample_req->buyer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req->sample_cart_id->Visible) { // sample_cart_id ?>
		<td data-name="sample_cart_id"<?php echo $sample_req->sample_cart_id->cellAttributes() ?>>
<span id="el<?php echo $sample_req_list->RowCnt ?>_sample_req_sample_cart_id" class="sample_req_sample_cart_id">
<span<?php echo $sample_req->sample_cart_id->viewAttributes() ?>>
<?php echo $sample_req->sample_cart_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req->purpose->Visible) { // purpose ?>
		<td data-name="purpose"<?php echo $sample_req->purpose->cellAttributes() ?>>
<span id="el<?php echo $sample_req_list->RowCnt ?>_sample_req_purpose" class="sample_req_purpose">
<span<?php echo $sample_req->purpose->viewAttributes() ?>>
<?php echo $sample_req->purpose->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req->label->Visible) { // label ?>
		<td data-name="label"<?php echo $sample_req->label->cellAttributes() ?>>
<span id="el<?php echo $sample_req_list->RowCnt ?>_sample_req_label" class="sample_req_label">
<span<?php echo $sample_req->label->viewAttributes() ?>>
<?php echo $sample_req->label->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req->ssd->Visible) { // ssd ?>
		<td data-name="ssd"<?php echo $sample_req->ssd->cellAttributes() ?>>
<span id="el<?php echo $sample_req_list->RowCnt ?>_sample_req_ssd" class="sample_req_ssd">
<span<?php echo $sample_req->ssd->viewAttributes() ?>>
<?php echo $sample_req->ssd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req->shipping_mode->Visible) { // shipping_mode ?>
		<td data-name="shipping_mode"<?php echo $sample_req->shipping_mode->cellAttributes() ?>>
<span id="el<?php echo $sample_req_list->RowCnt ?>_sample_req_shipping_mode" class="sample_req_shipping_mode">
<span<?php echo $sample_req->shipping_mode->viewAttributes() ?>>
<?php echo $sample_req->shipping_mode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req->delivery_week->Visible) { // delivery_week ?>
		<td data-name="delivery_week"<?php echo $sample_req->delivery_week->cellAttributes() ?>>
<span id="el<?php echo $sample_req_list->RowCnt ?>_sample_req_delivery_week" class="sample_req_delivery_week">
<span<?php echo $sample_req->delivery_week->viewAttributes() ?>>
<?php echo $sample_req->delivery_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req->shipping_address->Visible) { // shipping_address ?>
		<td data-name="shipping_address"<?php echo $sample_req->shipping_address->cellAttributes() ?>>
<span id="el<?php echo $sample_req_list->RowCnt ?>_sample_req_shipping_address" class="sample_req_shipping_address">
<span<?php echo $sample_req->shipping_address->viewAttributes() ?>>
<?php echo $sample_req->shipping_address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $sample_req->operator->cellAttributes() ?>>
<span id="el<?php echo $sample_req_list->RowCnt ?>_sample_req_operator" class="sample_req_operator">
<span<?php echo $sample_req->operator->viewAttributes() ?>>
<?php echo $sample_req->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $sample_req->datetime->cellAttributes() ?>>
<span id="el<?php echo $sample_req_list->RowCnt ?>_sample_req_datetime" class="sample_req_datetime">
<span<?php echo $sample_req->datetime->viewAttributes() ?>>
<?php echo $sample_req->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sample_req->status->Visible) { // status ?>
		<td data-name="status"<?php echo $sample_req->status->cellAttributes() ?>>
<span id="el<?php echo $sample_req_list->RowCnt ?>_sample_req_status" class="sample_req_status">
<span<?php echo $sample_req->status->viewAttributes() ?>>
<?php echo $sample_req->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sample_req_list->ListOptions->render("body", "right", $sample_req_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$sample_req->isGridAdd())
		$sample_req_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$sample_req->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($sample_req_list->Recordset)
	$sample_req_list->Recordset->Close();
?>
<?php if (!$sample_req->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$sample_req->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sample_req_list->Pager)) $sample_req_list->Pager = new PrevNextPager($sample_req_list->StartRec, $sample_req_list->DisplayRecs, $sample_req_list->TotalRecs, $sample_req_list->AutoHidePager) ?>
<?php if ($sample_req_list->Pager->RecordCount > 0 && $sample_req_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sample_req_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sample_req_list->pageUrl() ?>start=<?php echo $sample_req_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sample_req_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sample_req_list->pageUrl() ?>start=<?php echo $sample_req_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sample_req_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sample_req_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sample_req_list->pageUrl() ?>start=<?php echo $sample_req_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sample_req_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sample_req_list->pageUrl() ?>start=<?php echo $sample_req_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sample_req_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sample_req_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sample_req_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sample_req_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sample_req_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sample_req_list->TotalRecs > 0 && (!$sample_req_list->AutoHidePageSizeSelector || $sample_req_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sample_req">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sample_req_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sample_req_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sample_req_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sample_req_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sample_req_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sample_req->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sample_req_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($sample_req_list->TotalRecs == 0 && !$sample_req->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $sample_req_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$sample_req_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sample_req->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$sample_req->isExport()) { ?>
<script>
ew.scrollableTable("gmp_sample_req", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sample_req_list->terminate();
?>