<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_request_receive_edit = new sample_request_receive_edit();

// Run the page
$sample_request_receive_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_request_receive_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fsample_request_receiveedit = currentForm = new ew.Form("fsample_request_receiveedit", "edit");

// Validate form
fsample_request_receiveedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($sample_request_receive_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_request_receive->id->caption(), $sample_request_receive->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_request_receive_edit->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_request_receive->_barcode->caption(), $sample_request_receive->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_request_receive_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_request_receive->remarks->caption(), $sample_request_receive->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_request_receive_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_request_receive->dated->caption(), $sample_request_receive->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sample_request_receive->dated->errorMessage()) ?>");
		<?php if ($sample_request_receive_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_request_receive->operator->caption(), $sample_request_receive->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_request_receive_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_request_receive->datetime->caption(), $sample_request_receive->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsample_request_receiveedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_request_receiveedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_request_receiveedit.lists["x_operator"] = <?php echo $sample_request_receive_edit->operator->Lookup->toClientList() ?>;
fsample_request_receiveedit.lists["x_operator"].options = <?php echo JsonEncode($sample_request_receive_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sample_request_receive_edit->showPageHeader(); ?>
<?php
$sample_request_receive_edit->showMessage();
?>
<form name="fsample_request_receiveedit" id="fsample_request_receiveedit" class="<?php echo $sample_request_receive_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_request_receive_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_request_receive_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_request_receive">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$sample_request_receive_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($sample_request_receive->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_sample_request_receive_id" class="<?php echo $sample_request_receive_edit->LeftColumnClass ?>"><?php echo $sample_request_receive->id->caption() ?><?php echo ($sample_request_receive->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_request_receive_edit->RightColumnClass ?>"><div<?php echo $sample_request_receive->id->cellAttributes() ?>>
<span id="el_sample_request_receive_id">
<span<?php echo $sample_request_receive->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sample_request_receive->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="sample_request_receive" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($sample_request_receive->id->CurrentValue) ?>">
<?php echo $sample_request_receive->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_request_receive->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_sample_request_receive__barcode" for="x__barcode" class="<?php echo $sample_request_receive_edit->LeftColumnClass ?>"><?php echo $sample_request_receive->_barcode->caption() ?><?php echo ($sample_request_receive->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_request_receive_edit->RightColumnClass ?>"><div<?php echo $sample_request_receive->_barcode->cellAttributes() ?>>
<span id="el_sample_request_receive__barcode">
<textarea data-table="sample_request_receive" data-field="x__barcode" name="x__barcode" id="x__barcode" cols="35" rows="4" placeholder="<?php echo HtmlEncode($sample_request_receive->_barcode->getPlaceHolder()) ?>"<?php echo $sample_request_receive->_barcode->editAttributes() ?>><?php echo $sample_request_receive->_barcode->EditValue ?></textarea>
</span>
<?php echo $sample_request_receive->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_request_receive->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_sample_request_receive_remarks" for="x_remarks" class="<?php echo $sample_request_receive_edit->LeftColumnClass ?>"><?php echo $sample_request_receive->remarks->caption() ?><?php echo ($sample_request_receive->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_request_receive_edit->RightColumnClass ?>"><div<?php echo $sample_request_receive->remarks->cellAttributes() ?>>
<span id="el_sample_request_receive_remarks">
<textarea data-table="sample_request_receive" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($sample_request_receive->remarks->getPlaceHolder()) ?>"<?php echo $sample_request_receive->remarks->editAttributes() ?>><?php echo $sample_request_receive->remarks->EditValue ?></textarea>
</span>
<?php echo $sample_request_receive->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_request_receive->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_sample_request_receive_dated" for="x_dated" class="<?php echo $sample_request_receive_edit->LeftColumnClass ?>"><?php echo $sample_request_receive->dated->caption() ?><?php echo ($sample_request_receive->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_request_receive_edit->RightColumnClass ?>"><div<?php echo $sample_request_receive->dated->cellAttributes() ?>>
<span id="el_sample_request_receive_dated">
<input type="text" data-table="sample_request_receive" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($sample_request_receive->dated->getPlaceHolder()) ?>" value="<?php echo $sample_request_receive->dated->EditValue ?>"<?php echo $sample_request_receive->dated->editAttributes() ?>>
<?php if (!$sample_request_receive->dated->ReadOnly && !$sample_request_receive->dated->Disabled && !isset($sample_request_receive->dated->EditAttrs["readonly"]) && !isset($sample_request_receive->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsample_request_receiveedit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $sample_request_receive->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$sample_request_receive_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $sample_request_receive_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $sample_request_receive_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$sample_request_receive_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sample_request_receive_edit->terminate();
?>