<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_request_receive_view = new sample_request_receive_view();

// Run the page
$sample_request_receive_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_request_receive_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sample_request_receive->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fsample_request_receiveview = currentForm = new ew.Form("fsample_request_receiveview", "view");

// Form_CustomValidate event
fsample_request_receiveview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_request_receiveview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_request_receiveview.lists["x_operator"] = <?php echo $sample_request_receive_view->operator->Lookup->toClientList() ?>;
fsample_request_receiveview.lists["x_operator"].options = <?php echo JsonEncode($sample_request_receive_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sample_request_receive->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $sample_request_receive_view->ExportOptions->render("body") ?>
<?php $sample_request_receive_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $sample_request_receive_view->showPageHeader(); ?>
<?php
$sample_request_receive_view->showMessage();
?>
<form name="fsample_request_receiveview" id="fsample_request_receiveview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_request_receive_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_request_receive_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_request_receive">
<input type="hidden" name="modal" value="<?php echo (int)$sample_request_receive_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($sample_request_receive->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $sample_request_receive_view->TableLeftColumnClass ?>"><span id="elh_sample_request_receive_id"><?php echo $sample_request_receive->id->caption() ?></span></td>
		<td data-name="id"<?php echo $sample_request_receive->id->cellAttributes() ?>>
<span id="el_sample_request_receive_id">
<span<?php echo $sample_request_receive->id->viewAttributes() ?>>
<?php echo $sample_request_receive->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_request_receive->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $sample_request_receive_view->TableLeftColumnClass ?>"><span id="elh_sample_request_receive__barcode"><?php echo $sample_request_receive->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $sample_request_receive->_barcode->cellAttributes() ?>>
<span id="el_sample_request_receive__barcode">
<span<?php echo $sample_request_receive->_barcode->viewAttributes() ?>>
<?php echo $sample_request_receive->_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_request_receive->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $sample_request_receive_view->TableLeftColumnClass ?>"><span id="elh_sample_request_receive_remarks"><?php echo $sample_request_receive->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $sample_request_receive->remarks->cellAttributes() ?>>
<span id="el_sample_request_receive_remarks">
<span<?php echo $sample_request_receive->remarks->viewAttributes() ?>>
<?php echo $sample_request_receive->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_request_receive->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $sample_request_receive_view->TableLeftColumnClass ?>"><span id="elh_sample_request_receive_dated"><?php echo $sample_request_receive->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $sample_request_receive->dated->cellAttributes() ?>>
<span id="el_sample_request_receive_dated">
<span<?php echo $sample_request_receive->dated->viewAttributes() ?>>
<?php echo $sample_request_receive->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_request_receive->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $sample_request_receive_view->TableLeftColumnClass ?>"><span id="elh_sample_request_receive_operator"><?php echo $sample_request_receive->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $sample_request_receive->operator->cellAttributes() ?>>
<span id="el_sample_request_receive_operator">
<span<?php echo $sample_request_receive->operator->viewAttributes() ?>>
<?php echo $sample_request_receive->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_request_receive->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $sample_request_receive_view->TableLeftColumnClass ?>"><span id="elh_sample_request_receive_datetime"><?php echo $sample_request_receive->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $sample_request_receive->datetime->cellAttributes() ?>>
<span id="el_sample_request_receive_datetime">
<span<?php echo $sample_request_receive->datetime->viewAttributes() ?>>
<?php echo $sample_request_receive->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$sample_request_receive_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sample_request_receive->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sample_request_receive_view->terminate();
?>