<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_request_status_add = new sample_request_status_add();

// Run the page
$sample_request_status_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_request_status_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fsample_request_statusadd = currentForm = new ew.Form("fsample_request_statusadd", "add");

// Validate form
fsample_request_statusadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($sample_request_status_add->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_request_status->item->caption(), $sample_request_status->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sample_request_status_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_request_status->grp->caption(), $sample_request_status->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sample_request_status->grp->errorMessage()) ?>");
		<?php if ($sample_request_status_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_request_status->status->caption(), $sample_request_status->status->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sample_request_status->status->errorMessage()) ?>");
		<?php if ($sample_request_status_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_request_status->operator->caption(), $sample_request_status->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sample_request_status->operator->errorMessage()) ?>");
		<?php if ($sample_request_status_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sample_request_status->datetime->caption(), $sample_request_status->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sample_request_status->datetime->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsample_request_statusadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_request_statusadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sample_request_status_add->showPageHeader(); ?>
<?php
$sample_request_status_add->showMessage();
?>
<form name="fsample_request_statusadd" id="fsample_request_statusadd" class="<?php echo $sample_request_status_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_request_status_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_request_status_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_request_status">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$sample_request_status_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($sample_request_status->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_sample_request_status_item" for="x_item" class="<?php echo $sample_request_status_add->LeftColumnClass ?>"><?php echo $sample_request_status->item->caption() ?><?php echo ($sample_request_status->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_request_status_add->RightColumnClass ?>"><div<?php echo $sample_request_status->item->cellAttributes() ?>>
<span id="el_sample_request_status_item">
<input type="text" data-table="sample_request_status" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($sample_request_status->item->getPlaceHolder()) ?>" value="<?php echo $sample_request_status->item->EditValue ?>"<?php echo $sample_request_status->item->editAttributes() ?>>
</span>
<?php echo $sample_request_status->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_request_status->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_sample_request_status_grp" for="x_grp" class="<?php echo $sample_request_status_add->LeftColumnClass ?>"><?php echo $sample_request_status->grp->caption() ?><?php echo ($sample_request_status->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_request_status_add->RightColumnClass ?>"><div<?php echo $sample_request_status->grp->cellAttributes() ?>>
<span id="el_sample_request_status_grp">
<input type="text" data-table="sample_request_status" data-field="x_grp" name="x_grp" id="x_grp" size="30" placeholder="<?php echo HtmlEncode($sample_request_status->grp->getPlaceHolder()) ?>" value="<?php echo $sample_request_status->grp->EditValue ?>"<?php echo $sample_request_status->grp->editAttributes() ?>>
</span>
<?php echo $sample_request_status->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_request_status->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_sample_request_status_status" for="x_status" class="<?php echo $sample_request_status_add->LeftColumnClass ?>"><?php echo $sample_request_status->status->caption() ?><?php echo ($sample_request_status->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_request_status_add->RightColumnClass ?>"><div<?php echo $sample_request_status->status->cellAttributes() ?>>
<span id="el_sample_request_status_status">
<input type="text" data-table="sample_request_status" data-field="x_status" name="x_status" id="x_status" size="30" placeholder="<?php echo HtmlEncode($sample_request_status->status->getPlaceHolder()) ?>" value="<?php echo $sample_request_status->status->EditValue ?>"<?php echo $sample_request_status->status->editAttributes() ?>>
</span>
<?php echo $sample_request_status->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_request_status->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label id="elh_sample_request_status_operator" for="x_operator" class="<?php echo $sample_request_status_add->LeftColumnClass ?>"><?php echo $sample_request_status->operator->caption() ?><?php echo ($sample_request_status->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_request_status_add->RightColumnClass ?>"><div<?php echo $sample_request_status->operator->cellAttributes() ?>>
<span id="el_sample_request_status_operator">
<input type="text" data-table="sample_request_status" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($sample_request_status->operator->getPlaceHolder()) ?>" value="<?php echo $sample_request_status->operator->EditValue ?>"<?php echo $sample_request_status->operator->editAttributes() ?>>
</span>
<?php echo $sample_request_status->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($sample_request_status->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label id="elh_sample_request_status_datetime" for="x_datetime" class="<?php echo $sample_request_status_add->LeftColumnClass ?>"><?php echo $sample_request_status->datetime->caption() ?><?php echo ($sample_request_status->datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sample_request_status_add->RightColumnClass ?>"><div<?php echo $sample_request_status->datetime->cellAttributes() ?>>
<span id="el_sample_request_status_datetime">
<input type="text" data-table="sample_request_status" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($sample_request_status->datetime->getPlaceHolder()) ?>" value="<?php echo $sample_request_status->datetime->EditValue ?>"<?php echo $sample_request_status->datetime->editAttributes() ?>>
<?php if (!$sample_request_status->datetime->ReadOnly && !$sample_request_status->datetime->Disabled && !isset($sample_request_status->datetime->EditAttrs["readonly"]) && !isset($sample_request_status->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsample_request_statusadd", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $sample_request_status->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$sample_request_status_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $sample_request_status_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $sample_request_status_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$sample_request_status_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sample_request_status_add->terminate();
?>