<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sample_req_view = new sample_req_view();

// Run the page
$sample_req_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sample_req_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sample_req->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fsample_reqview = currentForm = new ew.Form("fsample_reqview", "view");

// Form_CustomValidate event
fsample_reqview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsample_reqview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsample_reqview.lists["x_buyer_id"] = <?php echo $sample_req_view->buyer_id->Lookup->toClientList() ?>;
fsample_reqview.lists["x_buyer_id"].options = <?php echo JsonEncode($sample_req_view->buyer_id->lookupOptions()) ?>;
fsample_reqview.lists["x_sample_cart_id[]"] = <?php echo $sample_req_view->sample_cart_id->Lookup->toClientList() ?>;
fsample_reqview.lists["x_sample_cart_id[]"].options = <?php echo JsonEncode($sample_req_view->sample_cart_id->lookupOptions()) ?>;
fsample_reqview.lists["x_purpose"] = <?php echo $sample_req_view->purpose->Lookup->toClientList() ?>;
fsample_reqview.lists["x_purpose"].options = <?php echo JsonEncode($sample_req_view->purpose->lookupOptions()) ?>;
fsample_reqview.lists["x_label"] = <?php echo $sample_req_view->label->Lookup->toClientList() ?>;
fsample_reqview.lists["x_label"].options = <?php echo JsonEncode($sample_req_view->label->lookupOptions()) ?>;
fsample_reqview.lists["x_shipping_mode"] = <?php echo $sample_req_view->shipping_mode->Lookup->toClientList() ?>;
fsample_reqview.lists["x_shipping_mode"].options = <?php echo JsonEncode($sample_req_view->shipping_mode->options(FALSE, TRUE)) ?>;
fsample_reqview.lists["x_delivery_week"] = <?php echo $sample_req_view->delivery_week->Lookup->toClientList() ?>;
fsample_reqview.lists["x_delivery_week"].options = <?php echo JsonEncode($sample_req_view->delivery_week->lookupOptions()) ?>;
fsample_reqview.lists["x_shipping_address"] = <?php echo $sample_req_view->shipping_address->Lookup->toClientList() ?>;
fsample_reqview.lists["x_shipping_address"].options = <?php echo JsonEncode($sample_req_view->shipping_address->lookupOptions()) ?>;
fsample_reqview.lists["x_operator"] = <?php echo $sample_req_view->operator->Lookup->toClientList() ?>;
fsample_reqview.lists["x_operator"].options = <?php echo JsonEncode($sample_req_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sample_req->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $sample_req_view->ExportOptions->render("body") ?>
<?php $sample_req_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $sample_req_view->showPageHeader(); ?>
<?php
$sample_req_view->showMessage();
?>
<form name="fsample_reqview" id="fsample_reqview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sample_req_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sample_req_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sample_req">
<input type="hidden" name="modal" value="<?php echo (int)$sample_req_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($sample_req->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $sample_req_view->TableLeftColumnClass ?>"><span id="elh_sample_req_id"><?php echo $sample_req->id->caption() ?></span></td>
		<td data-name="id"<?php echo $sample_req->id->cellAttributes() ?>>
<span id="el_sample_req_id">
<span<?php echo $sample_req->id->viewAttributes() ?>>
<?php echo $sample_req->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req->buyer_id->Visible) { // buyer_id ?>
	<tr id="r_buyer_id">
		<td class="<?php echo $sample_req_view->TableLeftColumnClass ?>"><span id="elh_sample_req_buyer_id"><?php echo $sample_req->buyer_id->caption() ?></span></td>
		<td data-name="buyer_id"<?php echo $sample_req->buyer_id->cellAttributes() ?>>
<span id="el_sample_req_buyer_id">
<span<?php echo $sample_req->buyer_id->viewAttributes() ?>>
<?php echo $sample_req->buyer_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req->sample_cart_id->Visible) { // sample_cart_id ?>
	<tr id="r_sample_cart_id">
		<td class="<?php echo $sample_req_view->TableLeftColumnClass ?>"><span id="elh_sample_req_sample_cart_id"><?php echo $sample_req->sample_cart_id->caption() ?></span></td>
		<td data-name="sample_cart_id"<?php echo $sample_req->sample_cart_id->cellAttributes() ?>>
<span id="el_sample_req_sample_cart_id">
<span<?php echo $sample_req->sample_cart_id->viewAttributes() ?>>
<?php echo $sample_req->sample_cart_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req->purpose->Visible) { // purpose ?>
	<tr id="r_purpose">
		<td class="<?php echo $sample_req_view->TableLeftColumnClass ?>"><span id="elh_sample_req_purpose"><?php echo $sample_req->purpose->caption() ?></span></td>
		<td data-name="purpose"<?php echo $sample_req->purpose->cellAttributes() ?>>
<span id="el_sample_req_purpose">
<span<?php echo $sample_req->purpose->viewAttributes() ?>>
<?php echo $sample_req->purpose->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req->label->Visible) { // label ?>
	<tr id="r_label">
		<td class="<?php echo $sample_req_view->TableLeftColumnClass ?>"><span id="elh_sample_req_label"><?php echo $sample_req->label->caption() ?></span></td>
		<td data-name="label"<?php echo $sample_req->label->cellAttributes() ?>>
<span id="el_sample_req_label">
<span<?php echo $sample_req->label->viewAttributes() ?>>
<?php echo $sample_req->label->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req->ssd->Visible) { // ssd ?>
	<tr id="r_ssd">
		<td class="<?php echo $sample_req_view->TableLeftColumnClass ?>"><span id="elh_sample_req_ssd"><?php echo $sample_req->ssd->caption() ?></span></td>
		<td data-name="ssd"<?php echo $sample_req->ssd->cellAttributes() ?>>
<span id="el_sample_req_ssd">
<span<?php echo $sample_req->ssd->viewAttributes() ?>>
<?php echo $sample_req->ssd->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req->shipping_mode->Visible) { // shipping_mode ?>
	<tr id="r_shipping_mode">
		<td class="<?php echo $sample_req_view->TableLeftColumnClass ?>"><span id="elh_sample_req_shipping_mode"><?php echo $sample_req->shipping_mode->caption() ?></span></td>
		<td data-name="shipping_mode"<?php echo $sample_req->shipping_mode->cellAttributes() ?>>
<span id="el_sample_req_shipping_mode">
<span<?php echo $sample_req->shipping_mode->viewAttributes() ?>>
<?php echo $sample_req->shipping_mode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req->delivery_week->Visible) { // delivery_week ?>
	<tr id="r_delivery_week">
		<td class="<?php echo $sample_req_view->TableLeftColumnClass ?>"><span id="elh_sample_req_delivery_week"><?php echo $sample_req->delivery_week->caption() ?></span></td>
		<td data-name="delivery_week"<?php echo $sample_req->delivery_week->cellAttributes() ?>>
<span id="el_sample_req_delivery_week">
<span<?php echo $sample_req->delivery_week->viewAttributes() ?>>
<?php echo $sample_req->delivery_week->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req->shipping_address->Visible) { // shipping_address ?>
	<tr id="r_shipping_address">
		<td class="<?php echo $sample_req_view->TableLeftColumnClass ?>"><span id="elh_sample_req_shipping_address"><?php echo $sample_req->shipping_address->caption() ?></span></td>
		<td data-name="shipping_address"<?php echo $sample_req->shipping_address->cellAttributes() ?>>
<span id="el_sample_req_shipping_address">
<span<?php echo $sample_req->shipping_address->viewAttributes() ?>>
<?php echo $sample_req->shipping_address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $sample_req_view->TableLeftColumnClass ?>"><span id="elh_sample_req_remarks"><?php echo $sample_req->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $sample_req->remarks->cellAttributes() ?>>
<span id="el_sample_req_remarks">
<span<?php echo $sample_req->remarks->viewAttributes() ?>>
<?php echo $sample_req->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $sample_req_view->TableLeftColumnClass ?>"><span id="elh_sample_req_operator"><?php echo $sample_req->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $sample_req->operator->cellAttributes() ?>>
<span id="el_sample_req_operator">
<span<?php echo $sample_req->operator->viewAttributes() ?>>
<?php echo $sample_req->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($sample_req->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $sample_req_view->TableLeftColumnClass ?>"><span id="elh_sample_req_datetime"><?php echo $sample_req->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $sample_req->datetime->cellAttributes() ?>>
<span id="el_sample_req_datetime">
<span<?php echo $sample_req->datetime->viewAttributes() ?>>
<?php echo $sample_req->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$sample_req_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sample_req->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var label = $("x_label").val();
		if (label == 1)
		{
		$("#r_ssd").show();
		} else {
		$("#r_ssd").hide();
		}
		var ship = $("x_shipping_address").val();
		if (ship == 3)
		{
		$("#r_shipping_address_2").show();
		} else {
		$("#r_shipping_address_2").hide();
		}
</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sample_req_view->terminate();
?>