<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$scouring_dw_list = new scouring_dw_list();

// Run the page
$scouring_dw_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$scouring_dw_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$scouring_dw->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fscouring_dwlist = currentForm = new ew.Form("fscouring_dwlist", "list");
fscouring_dwlist.formKeyCountName = '<?php echo $scouring_dw_list->FormKeyCountName ?>';

// Form_CustomValidate event
fscouring_dwlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fscouring_dwlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fscouring_dwlist.lists["x_product"] = <?php echo $scouring_dw_list->product->Lookup->toClientList() ?>;
fscouring_dwlist.lists["x_product"].options = <?php echo JsonEncode($scouring_dw_list->product->lookupOptions()) ?>;
fscouring_dwlist.lists["x_rid"] = <?php echo $scouring_dw_list->rid->Lookup->toClientList() ?>;
fscouring_dwlist.lists["x_rid"].options = <?php echo JsonEncode($scouring_dw_list->rid->lookupOptions()) ?>;
fscouring_dwlist.lists["x_scouring_type"] = <?php echo $scouring_dw_list->scouring_type->Lookup->toClientList() ?>;
fscouring_dwlist.lists["x_scouring_type"].options = <?php echo JsonEncode($scouring_dw_list->scouring_type->lookupOptions()) ?>;
fscouring_dwlist.lists["x_packing_type"] = <?php echo $scouring_dw_list->packing_type->Lookup->toClientList() ?>;
fscouring_dwlist.lists["x_packing_type"].options = <?php echo JsonEncode($scouring_dw_list->packing_type->lookupOptions()) ?>;
fscouring_dwlist.lists["x_godown"] = <?php echo $scouring_dw_list->godown->Lookup->toClientList() ?>;
fscouring_dwlist.lists["x_godown"].options = <?php echo JsonEncode($scouring_dw_list->godown->lookupOptions()) ?>;

// Form object for search
var fscouring_dwlistsrch = currentSearchForm = new ew.Form("fscouring_dwlistsrch");

// Validate function for search
fscouring_dwlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fscouring_dwlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fscouring_dwlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fscouring_dwlistsrch.lists["x_product"] = <?php echo $scouring_dw_list->product->Lookup->toClientList() ?>;
fscouring_dwlistsrch.lists["x_product"].options = <?php echo JsonEncode($scouring_dw_list->product->lookupOptions()) ?>;
fscouring_dwlistsrch.lists["x_rid"] = <?php echo $scouring_dw_list->rid->Lookup->toClientList() ?>;
fscouring_dwlistsrch.lists["x_rid"].options = <?php echo JsonEncode($scouring_dw_list->rid->lookupOptions()) ?>;

// Filters
fscouring_dwlistsrch.filterList = <?php echo $scouring_dw_list->getFilterList() ?>;

// Init search panel as collapsed
fscouring_dwlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$scouring_dw->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($scouring_dw_list->TotalRecs > 0 && $scouring_dw_list->ExportOptions->visible()) { ?>
<?php $scouring_dw_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($scouring_dw_list->ImportOptions->visible()) { ?>
<?php $scouring_dw_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($scouring_dw_list->SearchOptions->visible()) { ?>
<?php $scouring_dw_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($scouring_dw_list->FilterOptions->visible()) { ?>
<?php $scouring_dw_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$scouring_dw->isExport() || EXPORT_MASTER_RECORD && $scouring_dw->isExport("print")) { ?>
<?php
if ($scouring_dw_list->DbMasterFilter <> "" && $scouring_dw->getCurrentMasterTable() == "scouring_process_shortage") {
	if ($scouring_dw_list->MasterRecordExists) {
		include_once "scouring_process_shortagemaster.php";
	}
}
?>
<?php } ?>
<?php
$scouring_dw_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$scouring_dw->isExport() && !$scouring_dw->CurrentAction) { ?>
<form name="fscouring_dwlistsrch" id="fscouring_dwlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($scouring_dw_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fscouring_dwlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="scouring_dw">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$scouring_dw_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$scouring_dw->RowType = ROWTYPE_SEARCH;

// Render row
$scouring_dw->resetAttributes();
$scouring_dw_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($scouring_dw->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $scouring_dw->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<?php $scouring_dw->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$scouring_dw->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_dw" data-field="x_product" data-value-separator="<?php echo $scouring_dw->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $scouring_dw->product->editAttributes() ?>>
		<?php echo $scouring_dw->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $scouring_dw->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($scouring_dw->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label for="x_rid" class="ew-search-caption ew-label"><?php echo $scouring_dw->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid" id="z_rid" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_dw" data-field="x_rid" data-value-separator="<?php echo $scouring_dw->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $scouring_dw->rid->editAttributes() ?>>
		<?php echo $scouring_dw->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $scouring_dw->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($scouring_dw_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($scouring_dw_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $scouring_dw_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($scouring_dw_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($scouring_dw_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($scouring_dw_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($scouring_dw_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $scouring_dw_list->showPageHeader(); ?>
<?php
$scouring_dw_list->showMessage();
?>
<?php if ($scouring_dw_list->TotalRecs > 0 || $scouring_dw->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($scouring_dw_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> scouring_dw">
<?php if (!$scouring_dw->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$scouring_dw->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($scouring_dw_list->Pager)) $scouring_dw_list->Pager = new PrevNextPager($scouring_dw_list->StartRec, $scouring_dw_list->DisplayRecs, $scouring_dw_list->TotalRecs, $scouring_dw_list->AutoHidePager) ?>
<?php if ($scouring_dw_list->Pager->RecordCount > 0 && $scouring_dw_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($scouring_dw_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $scouring_dw_list->pageUrl() ?>start=<?php echo $scouring_dw_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($scouring_dw_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $scouring_dw_list->pageUrl() ?>start=<?php echo $scouring_dw_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $scouring_dw_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($scouring_dw_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $scouring_dw_list->pageUrl() ?>start=<?php echo $scouring_dw_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($scouring_dw_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $scouring_dw_list->pageUrl() ?>start=<?php echo $scouring_dw_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $scouring_dw_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($scouring_dw_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $scouring_dw_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $scouring_dw_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $scouring_dw_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($scouring_dw_list->TotalRecs > 0 && (!$scouring_dw_list->AutoHidePageSizeSelector || $scouring_dw_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="scouring_dw">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($scouring_dw_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($scouring_dw_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($scouring_dw_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($scouring_dw_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($scouring_dw_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($scouring_dw->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $scouring_dw_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fscouring_dwlist" id="fscouring_dwlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($scouring_dw_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $scouring_dw_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="scouring_dw">
<?php if ($scouring_dw->getCurrentMasterTable() == "scouring_process_shortage" && $scouring_dw->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="scouring_process_shortage">
<input type="hidden" name="fk_tmp_lot" value="<?php echo $scouring_dw->tmp_lot->getSessionValue() ?>">
<?php } ?>
<div id="gmp_scouring_dw" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($scouring_dw_list->TotalRecs > 0 || $scouring_dw->isGridEdit()) { ?>
<table id="tbl_scouring_dwlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$scouring_dw_list->RowType = ROWTYPE_HEADER;

// Render list options
$scouring_dw_list->renderListOptions();

// Render list options (header, left)
$scouring_dw_list->ListOptions->render("header", "left");
?>
<?php if ($scouring_dw->id->Visible) { // id ?>
	<?php if ($scouring_dw->sortUrl($scouring_dw->id) == "") { ?>
		<th data-name="id" class="<?php echo $scouring_dw->id->headerCellClass() ?>"><div id="elh_scouring_dw_id" class="scouring_dw_id"><div class="ew-table-header-caption"><?php echo $scouring_dw->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $scouring_dw->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $scouring_dw->SortUrl($scouring_dw->id) ?>',2);"><div id="elh_scouring_dw_id" class="scouring_dw_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $scouring_dw->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($scouring_dw->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($scouring_dw->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($scouring_dw->dated->Visible) { // dated ?>
	<?php if ($scouring_dw->sortUrl($scouring_dw->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $scouring_dw->dated->headerCellClass() ?>"><div id="elh_scouring_dw_dated" class="scouring_dw_dated"><div class="ew-table-header-caption"><?php echo $scouring_dw->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $scouring_dw->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $scouring_dw->SortUrl($scouring_dw->dated) ?>',2);"><div id="elh_scouring_dw_dated" class="scouring_dw_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $scouring_dw->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($scouring_dw->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($scouring_dw->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($scouring_dw->product->Visible) { // product ?>
	<?php if ($scouring_dw->sortUrl($scouring_dw->product) == "") { ?>
		<th data-name="product" class="<?php echo $scouring_dw->product->headerCellClass() ?>"><div id="elh_scouring_dw_product" class="scouring_dw_product"><div class="ew-table-header-caption"><?php echo $scouring_dw->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $scouring_dw->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $scouring_dw->SortUrl($scouring_dw->product) ?>',2);"><div id="elh_scouring_dw_product" class="scouring_dw_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $scouring_dw->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($scouring_dw->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($scouring_dw->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($scouring_dw->rid->Visible) { // rid ?>
	<?php if ($scouring_dw->sortUrl($scouring_dw->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $scouring_dw->rid->headerCellClass() ?>"><div id="elh_scouring_dw_rid" class="scouring_dw_rid"><div class="ew-table-header-caption"><?php echo $scouring_dw->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $scouring_dw->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $scouring_dw->SortUrl($scouring_dw->rid) ?>',2);"><div id="elh_scouring_dw_rid" class="scouring_dw_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $scouring_dw->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($scouring_dw->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($scouring_dw->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($scouring_dw->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($scouring_dw->sortUrl($scouring_dw->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $scouring_dw->tmp_lot->headerCellClass() ?>"><div id="elh_scouring_dw_tmp_lot" class="scouring_dw_tmp_lot"><div class="ew-table-header-caption"><?php echo $scouring_dw->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $scouring_dw->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $scouring_dw->SortUrl($scouring_dw->tmp_lot) ?>',2);"><div id="elh_scouring_dw_tmp_lot" class="scouring_dw_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $scouring_dw->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($scouring_dw->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($scouring_dw->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($scouring_dw->scouring_type->Visible) { // scouring_type ?>
	<?php if ($scouring_dw->sortUrl($scouring_dw->scouring_type) == "") { ?>
		<th data-name="scouring_type" class="<?php echo $scouring_dw->scouring_type->headerCellClass() ?>"><div id="elh_scouring_dw_scouring_type" class="scouring_dw_scouring_type"><div class="ew-table-header-caption"><?php echo $scouring_dw->scouring_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="scouring_type" class="<?php echo $scouring_dw->scouring_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $scouring_dw->SortUrl($scouring_dw->scouring_type) ?>',2);"><div id="elh_scouring_dw_scouring_type" class="scouring_dw_scouring_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $scouring_dw->scouring_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($scouring_dw->scouring_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($scouring_dw->scouring_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($scouring_dw->IN->Visible) { // IN ?>
	<?php if ($scouring_dw->sortUrl($scouring_dw->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $scouring_dw->IN->headerCellClass() ?>"><div id="elh_scouring_dw_IN" class="scouring_dw_IN"><div class="ew-table-header-caption"><?php echo $scouring_dw->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $scouring_dw->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $scouring_dw->SortUrl($scouring_dw->IN) ?>',2);"><div id="elh_scouring_dw_IN" class="scouring_dw_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $scouring_dw->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($scouring_dw->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($scouring_dw->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($scouring_dw->packets->Visible) { // packets ?>
	<?php if ($scouring_dw->sortUrl($scouring_dw->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $scouring_dw->packets->headerCellClass() ?>"><div id="elh_scouring_dw_packets" class="scouring_dw_packets"><div class="ew-table-header-caption"><?php echo $scouring_dw->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $scouring_dw->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $scouring_dw->SortUrl($scouring_dw->packets) ?>',2);"><div id="elh_scouring_dw_packets" class="scouring_dw_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $scouring_dw->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($scouring_dw->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($scouring_dw->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($scouring_dw->packing_type->Visible) { // packing_type ?>
	<?php if ($scouring_dw->sortUrl($scouring_dw->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $scouring_dw->packing_type->headerCellClass() ?>"><div id="elh_scouring_dw_packing_type" class="scouring_dw_packing_type"><div class="ew-table-header-caption"><?php echo $scouring_dw->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $scouring_dw->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $scouring_dw->SortUrl($scouring_dw->packing_type) ?>',2);"><div id="elh_scouring_dw_packing_type" class="scouring_dw_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $scouring_dw->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($scouring_dw->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($scouring_dw->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($scouring_dw->godown->Visible) { // godown ?>
	<?php if ($scouring_dw->sortUrl($scouring_dw->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $scouring_dw->godown->headerCellClass() ?>"><div id="elh_scouring_dw_godown" class="scouring_dw_godown"><div class="ew-table-header-caption"><?php echo $scouring_dw->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $scouring_dw->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $scouring_dw->SortUrl($scouring_dw->godown) ?>',2);"><div id="elh_scouring_dw_godown" class="scouring_dw_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $scouring_dw->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($scouring_dw->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($scouring_dw->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$scouring_dw_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($scouring_dw->ExportAll && $scouring_dw->isExport()) {
	$scouring_dw_list->StopRec = $scouring_dw_list->TotalRecs;
} else {

	// Set the last record to display
	if ($scouring_dw_list->TotalRecs > $scouring_dw_list->StartRec + $scouring_dw_list->DisplayRecs - 1)
		$scouring_dw_list->StopRec = $scouring_dw_list->StartRec + $scouring_dw_list->DisplayRecs - 1;
	else
		$scouring_dw_list->StopRec = $scouring_dw_list->TotalRecs;
}
$scouring_dw_list->RecCnt = $scouring_dw_list->StartRec - 1;
if ($scouring_dw_list->Recordset && !$scouring_dw_list->Recordset->EOF) {
	$scouring_dw_list->Recordset->moveFirst();
	$selectLimit = $scouring_dw_list->UseSelectLimit;
	if (!$selectLimit && $scouring_dw_list->StartRec > 1)
		$scouring_dw_list->Recordset->move($scouring_dw_list->StartRec - 1);
} elseif (!$scouring_dw->AllowAddDeleteRow && $scouring_dw_list->StopRec == 0) {
	$scouring_dw_list->StopRec = $scouring_dw->GridAddRowCount;
}

// Initialize aggregate
$scouring_dw->RowType = ROWTYPE_AGGREGATEINIT;
$scouring_dw->resetAttributes();
$scouring_dw_list->renderRow();
while ($scouring_dw_list->RecCnt < $scouring_dw_list->StopRec) {
	$scouring_dw_list->RecCnt++;
	if ($scouring_dw_list->RecCnt >= $scouring_dw_list->StartRec) {
		$scouring_dw_list->RowCnt++;

		// Set up key count
		$scouring_dw_list->KeyCount = $scouring_dw_list->RowIndex;

		// Init row class and style
		$scouring_dw->resetAttributes();
		$scouring_dw->CssClass = "";
		if ($scouring_dw->isGridAdd()) {
		} else {
			$scouring_dw_list->loadRowValues($scouring_dw_list->Recordset); // Load row values
		}
		$scouring_dw->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$scouring_dw->RowAttrs = array_merge($scouring_dw->RowAttrs, array('data-rowindex'=>$scouring_dw_list->RowCnt, 'id'=>'r' . $scouring_dw_list->RowCnt . '_scouring_dw', 'data-rowtype'=>$scouring_dw->RowType));

		// Render row
		$scouring_dw_list->renderRow();

		// Render list options
		$scouring_dw_list->renderListOptions();
?>
	<tr<?php echo $scouring_dw->rowAttributes() ?>>
<?php

// Render list options (body, left)
$scouring_dw_list->ListOptions->render("body", "left", $scouring_dw_list->RowCnt);
?>
	<?php if ($scouring_dw->id->Visible) { // id ?>
		<td data-name="id"<?php echo $scouring_dw->id->cellAttributes() ?>>
<span id="el<?php echo $scouring_dw_list->RowCnt ?>_scouring_dw_id" class="scouring_dw_id">
<span<?php echo $scouring_dw->id->viewAttributes() ?>>
<?php echo $scouring_dw->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($scouring_dw->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $scouring_dw->dated->cellAttributes() ?>>
<span id="el<?php echo $scouring_dw_list->RowCnt ?>_scouring_dw_dated" class="scouring_dw_dated">
<span<?php echo $scouring_dw->dated->viewAttributes() ?>>
<?php if ((!EmptyString($scouring_dw->dated->getViewValue())) && $scouring_dw->dated->linkAttributes() <> "") { ?>
<a<?php echo $scouring_dw->dated->linkAttributes() ?>><?php echo $scouring_dw->dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $scouring_dw->dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($scouring_dw->product->Visible) { // product ?>
		<td data-name="product"<?php echo $scouring_dw->product->cellAttributes() ?>>
<span id="el<?php echo $scouring_dw_list->RowCnt ?>_scouring_dw_product" class="scouring_dw_product">
<span<?php echo $scouring_dw->product->viewAttributes() ?>>
<?php if ((!EmptyString($scouring_dw->product->getViewValue())) && $scouring_dw->product->linkAttributes() <> "") { ?>
<a<?php echo $scouring_dw->product->linkAttributes() ?>><?php echo $scouring_dw->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $scouring_dw->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($scouring_dw->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $scouring_dw->rid->cellAttributes() ?>>
<span id="el<?php echo $scouring_dw_list->RowCnt ?>_scouring_dw_rid" class="scouring_dw_rid">
<span<?php echo $scouring_dw->rid->viewAttributes() ?>>
<?php if ((!EmptyString($scouring_dw->rid->getViewValue())) && $scouring_dw->rid->linkAttributes() <> "") { ?>
<a<?php echo $scouring_dw->rid->linkAttributes() ?>><?php echo $scouring_dw->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $scouring_dw->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($scouring_dw->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $scouring_dw->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $scouring_dw_list->RowCnt ?>_scouring_dw_tmp_lot" class="scouring_dw_tmp_lot">
<span<?php echo $scouring_dw->tmp_lot->viewAttributes() ?>>
<?php if ((!EmptyString($scouring_dw->tmp_lot->getViewValue())) && $scouring_dw->tmp_lot->linkAttributes() <> "") { ?>
<a<?php echo $scouring_dw->tmp_lot->linkAttributes() ?>><?php echo $scouring_dw->tmp_lot->getViewValue() ?></a>
<?php } else { ?>
<?php echo $scouring_dw->tmp_lot->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($scouring_dw->scouring_type->Visible) { // scouring_type ?>
		<td data-name="scouring_type"<?php echo $scouring_dw->scouring_type->cellAttributes() ?>>
<span id="el<?php echo $scouring_dw_list->RowCnt ?>_scouring_dw_scouring_type" class="scouring_dw_scouring_type">
<span<?php echo $scouring_dw->scouring_type->viewAttributes() ?>>
<?php if ((!EmptyString($scouring_dw->scouring_type->getViewValue())) && $scouring_dw->scouring_type->linkAttributes() <> "") { ?>
<a<?php echo $scouring_dw->scouring_type->linkAttributes() ?>><?php echo $scouring_dw->scouring_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $scouring_dw->scouring_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($scouring_dw->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $scouring_dw->IN->cellAttributes() ?>>
<span id="el<?php echo $scouring_dw_list->RowCnt ?>_scouring_dw_IN" class="scouring_dw_IN">
<span<?php echo $scouring_dw->IN->viewAttributes() ?>>
<?php echo $scouring_dw->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($scouring_dw->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $scouring_dw->packets->cellAttributes() ?>>
<span id="el<?php echo $scouring_dw_list->RowCnt ?>_scouring_dw_packets" class="scouring_dw_packets">
<span<?php echo $scouring_dw->packets->viewAttributes() ?>>
<?php echo $scouring_dw->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($scouring_dw->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $scouring_dw->packing_type->cellAttributes() ?>>
<span id="el<?php echo $scouring_dw_list->RowCnt ?>_scouring_dw_packing_type" class="scouring_dw_packing_type">
<span<?php echo $scouring_dw->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($scouring_dw->packing_type->getViewValue())) && $scouring_dw->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $scouring_dw->packing_type->linkAttributes() ?>><?php echo $scouring_dw->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $scouring_dw->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($scouring_dw->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $scouring_dw->godown->cellAttributes() ?>>
<span id="el<?php echo $scouring_dw_list->RowCnt ?>_scouring_dw_godown" class="scouring_dw_godown">
<span<?php echo $scouring_dw->godown->viewAttributes() ?>>
<?php if ((!EmptyString($scouring_dw->godown->getViewValue())) && $scouring_dw->godown->linkAttributes() <> "") { ?>
<a<?php echo $scouring_dw->godown->linkAttributes() ?>><?php echo $scouring_dw->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $scouring_dw->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$scouring_dw_list->ListOptions->render("body", "right", $scouring_dw_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$scouring_dw->isGridAdd())
		$scouring_dw_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$scouring_dw->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($scouring_dw_list->Recordset)
	$scouring_dw_list->Recordset->Close();
?>
<?php if (!$scouring_dw->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$scouring_dw->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($scouring_dw_list->Pager)) $scouring_dw_list->Pager = new PrevNextPager($scouring_dw_list->StartRec, $scouring_dw_list->DisplayRecs, $scouring_dw_list->TotalRecs, $scouring_dw_list->AutoHidePager) ?>
<?php if ($scouring_dw_list->Pager->RecordCount > 0 && $scouring_dw_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($scouring_dw_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $scouring_dw_list->pageUrl() ?>start=<?php echo $scouring_dw_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($scouring_dw_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $scouring_dw_list->pageUrl() ?>start=<?php echo $scouring_dw_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $scouring_dw_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($scouring_dw_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $scouring_dw_list->pageUrl() ?>start=<?php echo $scouring_dw_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($scouring_dw_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $scouring_dw_list->pageUrl() ?>start=<?php echo $scouring_dw_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $scouring_dw_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($scouring_dw_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $scouring_dw_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $scouring_dw_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $scouring_dw_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($scouring_dw_list->TotalRecs > 0 && (!$scouring_dw_list->AutoHidePageSizeSelector || $scouring_dw_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="scouring_dw">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($scouring_dw_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($scouring_dw_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($scouring_dw_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($scouring_dw_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($scouring_dw_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($scouring_dw->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $scouring_dw_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($scouring_dw_list->TotalRecs == 0 && !$scouring_dw->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $scouring_dw_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$scouring_dw_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$scouring_dw->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$scouring_dw->isExport()) { ?>
<script>
ew.scrollableTable("gmp_scouring_dw", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$scouring_dw_list->terminate();
?>