<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$scouring_table_add = new scouring_table_add();

// Run the page
$scouring_table_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$scouring_table_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fscouring_tableadd = currentForm = new ew.Form("fscouring_tableadd", "add");

// Validate form
fscouring_tableadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($scouring_table_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->product->caption(), $scouring_table->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->ref->Required) { ?>
			elm = this.getElements("x" + infix + "_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->ref->caption(), $scouring_table->ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->scouring_type->Required) { ?>
			elm = this.getElements("x" + infix + "_scouring_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->scouring_type->caption(), $scouring_table->scouring_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->packing_type->caption(), $scouring_table->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->quantity_avg_act->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity_avg_act");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->quantity_avg_act->caption(), $scouring_table->quantity_avg_act->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->packets->caption(), $scouring_table->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($scouring_table->packets->errorMessage()) ?>");
		<?php if ($scouring_table_add->avg_yield->Required) { ?>
			elm = this.getElements("x" + infix + "_avg_yield");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->avg_yield->caption(), $scouring_table->avg_yield->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->quantity->caption(), $scouring_table->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($scouring_table->quantity->errorMessage()) ?>");
		<?php if ($scouring_table_add->max_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_max_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->max_qty->caption(), $scouring_table->max_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->godown->caption(), $scouring_table->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->dated->caption(), $scouring_table->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($scouring_table->dated->errorMessage()) ?>");
		<?php if ($scouring_table_add->employee_id->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_id[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->employee_id->caption(), $scouring_table->employee_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->next_issue_yn->Required) { ?>
			elm = this.getElements("x" + infix + "_next_issue_yn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->next_issue_yn->caption(), $scouring_table->next_issue_yn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->next_process->Required) { ?>
			elm = this.getElements("x" + infix + "_next_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->next_process->caption(), $scouring_table->next_process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->next_godown->Required) { ?>
			elm = this.getElements("x" + infix + "_next_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->next_godown->caption(), $scouring_table->next_godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->remarks->caption(), $scouring_table->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->operator->caption(), $scouring_table->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($scouring_table_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $scouring_table->datetime->caption(), $scouring_table->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fscouring_tableadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fscouring_tableadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fscouring_tableadd.lists["x_product"] = <?php echo $scouring_table_add->product->Lookup->toClientList() ?>;
fscouring_tableadd.lists["x_product"].options = <?php echo JsonEncode($scouring_table_add->product->lookupOptions()) ?>;
fscouring_tableadd.lists["x_ref"] = <?php echo $scouring_table_add->ref->Lookup->toClientList() ?>;
fscouring_tableadd.lists["x_ref"].options = <?php echo JsonEncode($scouring_table_add->ref->lookupOptions()) ?>;
fscouring_tableadd.lists["x_scouring_type"] = <?php echo $scouring_table_add->scouring_type->Lookup->toClientList() ?>;
fscouring_tableadd.lists["x_scouring_type"].options = <?php echo JsonEncode($scouring_table_add->scouring_type->lookupOptions()) ?>;
fscouring_tableadd.lists["x_packing_type"] = <?php echo $scouring_table_add->packing_type->Lookup->toClientList() ?>;
fscouring_tableadd.lists["x_packing_type"].options = <?php echo JsonEncode($scouring_table_add->packing_type->lookupOptions()) ?>;
fscouring_tableadd.lists["x_quantity_avg_act"] = <?php echo $scouring_table_add->quantity_avg_act->Lookup->toClientList() ?>;
fscouring_tableadd.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($scouring_table_add->quantity_avg_act->options(FALSE, TRUE)) ?>;
fscouring_tableadd.lists["x_godown"] = <?php echo $scouring_table_add->godown->Lookup->toClientList() ?>;
fscouring_tableadd.lists["x_godown"].options = <?php echo JsonEncode($scouring_table_add->godown->lookupOptions()) ?>;
fscouring_tableadd.lists["x_employee_id[]"] = <?php echo $scouring_table_add->employee_id->Lookup->toClientList() ?>;
fscouring_tableadd.lists["x_employee_id[]"].options = <?php echo JsonEncode($scouring_table_add->employee_id->lookupOptions()) ?>;
fscouring_tableadd.lists["x_next_issue_yn"] = <?php echo $scouring_table_add->next_issue_yn->Lookup->toClientList() ?>;
fscouring_tableadd.lists["x_next_issue_yn"].options = <?php echo JsonEncode($scouring_table_add->next_issue_yn->options(FALSE, TRUE)) ?>;
fscouring_tableadd.lists["x_next_process"] = <?php echo $scouring_table_add->next_process->Lookup->toClientList() ?>;
fscouring_tableadd.lists["x_next_process"].options = <?php echo JsonEncode($scouring_table_add->next_process->lookupOptions()) ?>;
fscouring_tableadd.lists["x_next_godown"] = <?php echo $scouring_table_add->next_godown->Lookup->toClientList() ?>;
fscouring_tableadd.lists["x_next_godown"].options = <?php echo JsonEncode($scouring_table_add->next_godown->lookupOptions()) ?>;
fscouring_tableadd.lists["x_operator"] = <?php echo $scouring_table_add->operator->Lookup->toClientList() ?>;
fscouring_tableadd.lists["x_operator"].options = <?php echo JsonEncode($scouring_table_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $scouring_table_add->showPageHeader(); ?>
<?php
$scouring_table_add->showMessage();
?>
<form name="fscouring_tableadd" id="fscouring_tableadd" class="<?php echo $scouring_table_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($scouring_table_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $scouring_table_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="scouring_table">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$scouring_table_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($scouring_table->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_scouring_table_product" for="x_product" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->product->caption() ?><?php echo ($scouring_table->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->product->cellAttributes() ?>>
<span id="el_scouring_table_product">
<?php $scouring_table->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$scouring_table->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_table" data-field="x_product" data-value-separator="<?php echo $scouring_table->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $scouring_table->product->editAttributes() ?>>
		<?php echo $scouring_table->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $scouring_table->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $scouring_table->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label id="elh_scouring_table_ref" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->ref->caption() ?><?php echo ($scouring_table->ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->ref->cellAttributes() ?>>
<span id="el_scouring_table_ref">
<?php $scouring_table->ref->EditAttrs["onclick"] = "ew.autoFill(this); " . @$scouring_table->ref->EditAttrs["onclick"]; ?>
<div id="tp_x_ref" class="ew-template"><input type="radio" class="form-check-input" data-table="scouring_table" data-field="x_ref" data-value-separator="<?php echo $scouring_table->ref->displayValueSeparatorAttribute() ?>" name="x_ref" id="x_ref" value="{value}"<?php echo $scouring_table->ref->editAttributes() ?>></div>
<div id="dsl_x_ref" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $scouring_table->ref->radioButtonListHtml(FALSE, "x_ref") ?>
</div></div>
<?php echo $scouring_table->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
<?php echo $scouring_table->ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->scouring_type->Visible) { // scouring_type ?>
	<div id="r_scouring_type" class="form-group row">
		<label id="elh_scouring_table_scouring_type" for="x_scouring_type" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->scouring_type->caption() ?><?php echo ($scouring_table->scouring_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->scouring_type->cellAttributes() ?>>
<span id="el_scouring_table_scouring_type">
<?php $scouring_table->scouring_type->EditAttrs["onchange"] = "ew.autoFill(this);" . @$scouring_table->scouring_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_table" data-field="x_scouring_type" data-value-separator="<?php echo $scouring_table->scouring_type->displayValueSeparatorAttribute() ?>" id="x_scouring_type" name="x_scouring_type"<?php echo $scouring_table->scouring_type->editAttributes() ?>>
		<?php echo $scouring_table->scouring_type->selectOptionListHtml("x_scouring_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "process_type_f") && !$scouring_table->scouring_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_scouring_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $scouring_table->scouring_type->caption() ?>" data-title="<?php echo $scouring_table->scouring_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_scouring_type',url:'process_type_faddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $scouring_table->scouring_type->Lookup->getParamTag("p_x_scouring_type") ?>
</span>
<?php echo $scouring_table->scouring_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_scouring_table_packing_type" for="x_packing_type" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->packing_type->caption() ?><?php echo ($scouring_table->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->packing_type->cellAttributes() ?>>
<span id="el_scouring_table_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_table" data-field="x_packing_type" data-value-separator="<?php echo $scouring_table->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $scouring_table->packing_type->editAttributes() ?>>
		<?php echo $scouring_table->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "packing_type") && !$scouring_table->packing_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_packing_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $scouring_table->packing_type->caption() ?>" data-title="<?php echo $scouring_table->packing_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_packing_type',url:'packing_typeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $scouring_table->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $scouring_table->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<div id="r_quantity_avg_act" class="form-group row">
		<label id="elh_scouring_table_quantity_avg_act" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->quantity_avg_act->caption() ?><?php echo ($scouring_table->quantity_avg_act->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->quantity_avg_act->cellAttributes() ?>>
<span id="el_scouring_table_quantity_avg_act">
<div id="tp_x_quantity_avg_act" class="ew-template"><input type="radio" class="form-check-input" data-table="scouring_table" data-field="x_quantity_avg_act" data-value-separator="<?php echo $scouring_table->quantity_avg_act->displayValueSeparatorAttribute() ?>" name="x_quantity_avg_act" id="x_quantity_avg_act" value="{value}"<?php echo $scouring_table->quantity_avg_act->editAttributes() ?>></div>
<div id="dsl_x_quantity_avg_act" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $scouring_table->quantity_avg_act->radioButtonListHtml(FALSE, "x_quantity_avg_act") ?>
</div></div>
</span>
<?php echo $scouring_table->quantity_avg_act->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_scouring_table_packets" for="x_packets" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->packets->caption() ?><?php echo ($scouring_table->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->packets->cellAttributes() ?>>
<span id="el_scouring_table_packets">
<input type="text" data-table="scouring_table" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($scouring_table->packets->getPlaceHolder()) ?>" value="<?php echo $scouring_table->packets->EditValue ?>"<?php echo $scouring_table->packets->editAttributes() ?>>
</span>
<?php echo $scouring_table->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->avg_yield->Visible) { // avg_yield ?>
	<div id="r_avg_yield" class="form-group row">
		<label id="elh_scouring_table_avg_yield" for="x_avg_yield" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->avg_yield->caption() ?><?php echo ($scouring_table->avg_yield->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->avg_yield->cellAttributes() ?>>
<span id="el_scouring_table_avg_yield">
<input type="text" data-table="scouring_table" data-field="x_avg_yield" name="x_avg_yield" id="x_avg_yield" placeholder="<?php echo HtmlEncode($scouring_table->avg_yield->getPlaceHolder()) ?>" value="<?php echo $scouring_table->avg_yield->EditValue ?>"<?php echo $scouring_table->avg_yield->editAttributes() ?>>
</span>
<?php echo $scouring_table->avg_yield->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_scouring_table_quantity" for="x_quantity" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->quantity->caption() ?><?php echo ($scouring_table->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->quantity->cellAttributes() ?>>
<span id="el_scouring_table_quantity">
<input type="text" data-table="scouring_table" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($scouring_table->quantity->getPlaceHolder()) ?>" value="<?php echo $scouring_table->quantity->EditValue ?>"<?php echo $scouring_table->quantity->editAttributes() ?>>
</span>
<?php echo $scouring_table->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->max_qty->Visible) { // max_qty ?>
	<div id="r_max_qty" class="form-group row">
		<label id="elh_scouring_table_max_qty" for="x_max_qty" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->max_qty->caption() ?><?php echo ($scouring_table->max_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->max_qty->cellAttributes() ?>>
<span id="el_scouring_table_max_qty">
<input type="text" data-table="scouring_table" data-field="x_max_qty" name="x_max_qty" id="x_max_qty" placeholder="<?php echo HtmlEncode($scouring_table->max_qty->getPlaceHolder()) ?>" value="<?php echo $scouring_table->max_qty->EditValue ?>"<?php echo $scouring_table->max_qty->editAttributes() ?>>
</span>
<?php echo $scouring_table->max_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_scouring_table_godown" for="x_godown" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->godown->caption() ?><?php echo ($scouring_table->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->godown->cellAttributes() ?>>
<span id="el_scouring_table_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_table" data-field="x_godown" data-value-separator="<?php echo $scouring_table->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $scouring_table->godown->editAttributes() ?>>
		<?php echo $scouring_table->godown->selectOptionListHtml("x_godown") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "godown") && !$scouring_table->godown->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_godown" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $scouring_table->godown->caption() ?>" data-title="<?php echo $scouring_table->godown->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_godown',url:'godownaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $scouring_table->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $scouring_table->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_scouring_table_dated" for="x_dated" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->dated->caption() ?><?php echo ($scouring_table->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->dated->cellAttributes() ?>>
<span id="el_scouring_table_dated">
<input type="text" data-table="scouring_table" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($scouring_table->dated->getPlaceHolder()) ?>" value="<?php echo $scouring_table->dated->EditValue ?>"<?php echo $scouring_table->dated->editAttributes() ?>>
<?php if (!$scouring_table->dated->ReadOnly && !$scouring_table->dated->Disabled && !isset($scouring_table->dated->EditAttrs["readonly"]) && !isset($scouring_table->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fscouring_tableadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $scouring_table->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label id="elh_scouring_table_employee_id" for="x_employee_id" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->employee_id->caption() ?><?php echo ($scouring_table->employee_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->employee_id->cellAttributes() ?>>
<span id="el_scouring_table_employee_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($scouring_table->employee_id->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($scouring_table->employee_id->ViewValue) : $scouring_table->employee_id->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($scouring_table->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($scouring_table->employee_id->ReadOnly || $scouring_table->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:20});"><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "production_employee_f") && !$scouring_table->employee_id->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_employee_id" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $scouring_table->employee_id->caption() ?>" data-title="<?php echo $scouring_table->employee_id->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_employee_id[]',url:'production_employee_faddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
	</div>
</div>
<?php echo $scouring_table->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="scouring_table" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $scouring_table->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $scouring_table->employee_id->CurrentValue ?>"<?php echo $scouring_table->employee_id->editAttributes() ?>>
</span>
<?php echo $scouring_table->employee_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->next_issue_yn->Visible) { // next_issue_yn ?>
	<div id="r_next_issue_yn" class="form-group row">
		<label id="elh_scouring_table_next_issue_yn" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->next_issue_yn->caption() ?><?php echo ($scouring_table->next_issue_yn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->next_issue_yn->cellAttributes() ?>>
<span id="el_scouring_table_next_issue_yn">
<div id="tp_x_next_issue_yn" class="ew-template"><input type="radio" class="form-check-input" data-table="scouring_table" data-field="x_next_issue_yn" data-value-separator="<?php echo $scouring_table->next_issue_yn->displayValueSeparatorAttribute() ?>" name="x_next_issue_yn" id="x_next_issue_yn" value="{value}"<?php echo $scouring_table->next_issue_yn->editAttributes() ?>></div>
<div id="dsl_x_next_issue_yn" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $scouring_table->next_issue_yn->radioButtonListHtml(FALSE, "x_next_issue_yn") ?>
</div></div>
</span>
<?php echo $scouring_table->next_issue_yn->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->next_process->Visible) { // next_process ?>
	<div id="r_next_process" class="form-group row">
		<label id="elh_scouring_table_next_process" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->next_process->caption() ?><?php echo ($scouring_table->next_process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->next_process->cellAttributes() ?>>
<span id="el_scouring_table_next_process">
<div id="tp_x_next_process" class="ew-template"><input type="radio" class="form-check-input" data-table="scouring_table" data-field="x_next_process" data-value-separator="<?php echo $scouring_table->next_process->displayValueSeparatorAttribute() ?>" name="x_next_process" id="x_next_process" value="{value}"<?php echo $scouring_table->next_process->editAttributes() ?>></div>
<div id="dsl_x_next_process" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $scouring_table->next_process->radioButtonListHtml(FALSE, "x_next_process") ?>
</div></div>
<?php echo $scouring_table->next_process->Lookup->getParamTag("p_x_next_process") ?>
</span>
<?php echo $scouring_table->next_process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->next_godown->Visible) { // next_godown ?>
	<div id="r_next_godown" class="form-group row">
		<label id="elh_scouring_table_next_godown" for="x_next_godown" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->next_godown->caption() ?><?php echo ($scouring_table->next_godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->next_godown->cellAttributes() ?>>
<span id="el_scouring_table_next_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_table" data-field="x_next_godown" data-value-separator="<?php echo $scouring_table->next_godown->displayValueSeparatorAttribute() ?>" id="x_next_godown" name="x_next_godown"<?php echo $scouring_table->next_godown->editAttributes() ?>>
		<?php echo $scouring_table->next_godown->selectOptionListHtml("x_next_godown") ?>
	</select>
</div>
<?php echo $scouring_table->next_godown->Lookup->getParamTag("p_x_next_godown") ?>
</span>
<?php echo $scouring_table->next_godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_scouring_table_remarks" for="x_remarks" class="<?php echo $scouring_table_add->LeftColumnClass ?>"><?php echo $scouring_table->remarks->caption() ?><?php echo ($scouring_table->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $scouring_table_add->RightColumnClass ?>"><div<?php echo $scouring_table->remarks->cellAttributes() ?>>
<span id="el_scouring_table_remarks">
<textarea data-table="scouring_table" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($scouring_table->remarks->getPlaceHolder()) ?>"<?php echo $scouring_table->remarks->editAttributes() ?>><?php echo $scouring_table->remarks->EditValue ?></textarea>
</span>
<?php echo $scouring_table->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$scouring_table_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $scouring_table_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $scouring_table_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$scouring_table_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

$("#r_next_process").addClass('hide');
$("#r_next_godown").addClass('hide');
</script>
<?php include_once "footer.php" ?>
<?php
$scouring_table_add->terminate();
?>