<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$scouring_table_search = new scouring_table_search();

// Run the page
$scouring_table_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$scouring_table_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($scouring_table_search->IsModal) { ?>
var fscouring_tablesearch = currentAdvancedSearchForm = new ew.Form("fscouring_tablesearch", "search");
<?php } else { ?>
var fscouring_tablesearch = currentForm = new ew.Form("fscouring_tablesearch", "search");
<?php } ?>

// Form_CustomValidate event
fscouring_tablesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fscouring_tablesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fscouring_tablesearch.lists["x_rid"] = <?php echo $scouring_table_search->rid->Lookup->toClientList() ?>;
fscouring_tablesearch.lists["x_rid"].options = <?php echo JsonEncode($scouring_table_search->rid->lookupOptions()) ?>;
fscouring_tablesearch.lists["x_product"] = <?php echo $scouring_table_search->product->Lookup->toClientList() ?>;
fscouring_tablesearch.lists["x_product"].options = <?php echo JsonEncode($scouring_table_search->product->lookupOptions()) ?>;
fscouring_tablesearch.lists["x_ref"] = <?php echo $scouring_table_search->ref->Lookup->toClientList() ?>;
fscouring_tablesearch.lists["x_ref"].options = <?php echo JsonEncode($scouring_table_search->ref->lookupOptions()) ?>;
fscouring_tablesearch.lists["x_scouring_type"] = <?php echo $scouring_table_search->scouring_type->Lookup->toClientList() ?>;
fscouring_tablesearch.lists["x_scouring_type"].options = <?php echo JsonEncode($scouring_table_search->scouring_type->lookupOptions()) ?>;
fscouring_tablesearch.lists["x_packing_type"] = <?php echo $scouring_table_search->packing_type->Lookup->toClientList() ?>;
fscouring_tablesearch.lists["x_packing_type"].options = <?php echo JsonEncode($scouring_table_search->packing_type->lookupOptions()) ?>;
fscouring_tablesearch.lists["x_quantity_avg_act"] = <?php echo $scouring_table_search->quantity_avg_act->Lookup->toClientList() ?>;
fscouring_tablesearch.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($scouring_table_search->quantity_avg_act->options(FALSE, TRUE)) ?>;
fscouring_tablesearch.lists["x_godown"] = <?php echo $scouring_table_search->godown->Lookup->toClientList() ?>;
fscouring_tablesearch.lists["x_godown"].options = <?php echo JsonEncode($scouring_table_search->godown->lookupOptions()) ?>;
fscouring_tablesearch.lists["x_employee_id[]"] = <?php echo $scouring_table_search->employee_id->Lookup->toClientList() ?>;
fscouring_tablesearch.lists["x_employee_id[]"].options = <?php echo JsonEncode($scouring_table_search->employee_id->lookupOptions()) ?>;
fscouring_tablesearch.lists["x_next_issue_yn"] = <?php echo $scouring_table_search->next_issue_yn->Lookup->toClientList() ?>;
fscouring_tablesearch.lists["x_next_issue_yn"].options = <?php echo JsonEncode($scouring_table_search->next_issue_yn->options(FALSE, TRUE)) ?>;
fscouring_tablesearch.lists["x_next_process"] = <?php echo $scouring_table_search->next_process->Lookup->toClientList() ?>;
fscouring_tablesearch.lists["x_next_process"].options = <?php echo JsonEncode($scouring_table_search->next_process->lookupOptions()) ?>;
fscouring_tablesearch.lists["x_next_godown"] = <?php echo $scouring_table_search->next_godown->Lookup->toClientList() ?>;
fscouring_tablesearch.lists["x_next_godown"].options = <?php echo JsonEncode($scouring_table_search->next_godown->lookupOptions()) ?>;
fscouring_tablesearch.lists["x_operator"] = <?php echo $scouring_table_search->operator->Lookup->toClientList() ?>;
fscouring_tablesearch.lists["x_operator"].options = <?php echo JsonEncode($scouring_table_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fscouring_tablesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($scouring_table->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($scouring_table->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($scouring_table->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($scouring_table->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $scouring_table_search->showPageHeader(); ?>
<?php
$scouring_table_search->showMessage();
?>
<form name="fscouring_tablesearch" id="fscouring_tablesearch" class="<?php echo $scouring_table_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($scouring_table_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $scouring_table_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="scouring_table">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$scouring_table_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($scouring_table->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_id"><?php echo $scouring_table->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->id->cellAttributes() ?>>
			<span id="el_scouring_table_id">
<input type="text" data-table="scouring_table" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($scouring_table->id->getPlaceHolder()) ?>" value="<?php echo $scouring_table->id->EditValue ?>"<?php echo $scouring_table->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_rid"><?php echo $scouring_table->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->rid->cellAttributes() ?>>
			<span id="el_scouring_table_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_table" data-field="x_rid" data-value-separator="<?php echo $scouring_table->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $scouring_table->rid->editAttributes() ?>>
		<?php echo $scouring_table->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $scouring_table->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_product"><?php echo $scouring_table->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->product->cellAttributes() ?>>
			<span id="el_scouring_table_product">
<?php $scouring_table->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$scouring_table->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_table" data-field="x_product" data-value-separator="<?php echo $scouring_table->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $scouring_table->product->editAttributes() ?>>
		<?php echo $scouring_table->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $scouring_table->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_ref"><?php echo $scouring_table->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ref" id="z_ref" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->ref->cellAttributes() ?>>
			<span id="el_scouring_table_ref">
<div id="tp_x_ref" class="ew-template"><input type="radio" class="form-check-input" data-table="scouring_table" data-field="x_ref" data-value-separator="<?php echo $scouring_table->ref->displayValueSeparatorAttribute() ?>" name="x_ref" id="x_ref" value="{value}"<?php echo $scouring_table->ref->editAttributes() ?>></div>
<div id="dsl_x_ref" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $scouring_table->ref->radioButtonListHtml(FALSE, "x_ref") ?>
</div></div>
<?php echo $scouring_table->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->scouring_type->Visible) { // scouring_type ?>
	<div id="r_scouring_type" class="form-group row">
		<label for="x_scouring_type" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_scouring_type"><?php echo $scouring_table->scouring_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_scouring_type" id="z_scouring_type" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->scouring_type->cellAttributes() ?>>
			<span id="el_scouring_table_scouring_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_table" data-field="x_scouring_type" data-value-separator="<?php echo $scouring_table->scouring_type->displayValueSeparatorAttribute() ?>" id="x_scouring_type" name="x_scouring_type"<?php echo $scouring_table->scouring_type->editAttributes() ?>>
		<?php echo $scouring_table->scouring_type->selectOptionListHtml("x_scouring_type") ?>
	</select>
</div>
<?php echo $scouring_table->scouring_type->Lookup->getParamTag("p_x_scouring_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_packing_type"><?php echo $scouring_table->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->packing_type->cellAttributes() ?>>
			<span id="el_scouring_table_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_table" data-field="x_packing_type" data-value-separator="<?php echo $scouring_table->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $scouring_table->packing_type->editAttributes() ?>>
		<?php echo $scouring_table->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $scouring_table->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<div id="r_quantity_avg_act" class="form-group row">
		<label class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_quantity_avg_act"><?php echo $scouring_table->quantity_avg_act->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity_avg_act" id="z_quantity_avg_act" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->quantity_avg_act->cellAttributes() ?>>
			<span id="el_scouring_table_quantity_avg_act">
<div id="tp_x_quantity_avg_act" class="ew-template"><input type="radio" class="form-check-input" data-table="scouring_table" data-field="x_quantity_avg_act" data-value-separator="<?php echo $scouring_table->quantity_avg_act->displayValueSeparatorAttribute() ?>" name="x_quantity_avg_act" id="x_quantity_avg_act" value="{value}"<?php echo $scouring_table->quantity_avg_act->editAttributes() ?>></div>
<div id="dsl_x_quantity_avg_act" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $scouring_table->quantity_avg_act->radioButtonListHtml(FALSE, "x_quantity_avg_act") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_packets"><?php echo $scouring_table->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->packets->cellAttributes() ?>>
			<span id="el_scouring_table_packets">
<input type="text" data-table="scouring_table" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($scouring_table->packets->getPlaceHolder()) ?>" value="<?php echo $scouring_table->packets->EditValue ?>"<?php echo $scouring_table->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->avg_yield->Visible) { // avg_yield ?>
	<div id="r_avg_yield" class="form-group row">
		<label for="x_avg_yield" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_avg_yield"><?php echo $scouring_table->avg_yield->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_avg_yield" id="z_avg_yield" value="LIKE"></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->avg_yield->cellAttributes() ?>>
			<span id="el_scouring_table_avg_yield">
<input type="text" data-table="scouring_table" data-field="x_avg_yield" name="x_avg_yield" id="x_avg_yield" placeholder="<?php echo HtmlEncode($scouring_table->avg_yield->getPlaceHolder()) ?>" value="<?php echo $scouring_table->avg_yield->EditValue ?>"<?php echo $scouring_table->avg_yield->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_quantity"><?php echo $scouring_table->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->quantity->cellAttributes() ?>>
			<span id="el_scouring_table_quantity">
<input type="text" data-table="scouring_table" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($scouring_table->quantity->getPlaceHolder()) ?>" value="<?php echo $scouring_table->quantity->EditValue ?>"<?php echo $scouring_table->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->max_qty->Visible) { // max_qty ?>
	<div id="r_max_qty" class="form-group row">
		<label for="x_max_qty" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_max_qty"><?php echo $scouring_table->max_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_max_qty" id="z_max_qty" value="LIKE"></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->max_qty->cellAttributes() ?>>
			<span id="el_scouring_table_max_qty">
<input type="text" data-table="scouring_table" data-field="x_max_qty" name="x_max_qty" id="x_max_qty" placeholder="<?php echo HtmlEncode($scouring_table->max_qty->getPlaceHolder()) ?>" value="<?php echo $scouring_table->max_qty->EditValue ?>"<?php echo $scouring_table->max_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_godown"><?php echo $scouring_table->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->godown->cellAttributes() ?>>
			<span id="el_scouring_table_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_table" data-field="x_godown" data-value-separator="<?php echo $scouring_table->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $scouring_table->godown->editAttributes() ?>>
		<?php echo $scouring_table->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $scouring_table->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_dated"><?php echo $scouring_table->dated->caption() ?></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($scouring_table->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($scouring_table->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($scouring_table->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($scouring_table->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($scouring_table->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($scouring_table->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($scouring_table->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($scouring_table->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($scouring_table->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_scouring_table_dated">
<input type="text" data-table="scouring_table" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($scouring_table->dated->getPlaceHolder()) ?>" value="<?php echo $scouring_table->dated->EditValue ?>"<?php echo $scouring_table->dated->editAttributes() ?>>
<?php if (!$scouring_table->dated->ReadOnly && !$scouring_table->dated->Disabled && !isset($scouring_table->dated->EditAttrs["readonly"]) && !isset($scouring_table->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fscouring_tablesearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_scouring_table_dated" class="btw1_dated d-none">
<input type="text" data-table="scouring_table" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($scouring_table->dated->getPlaceHolder()) ?>" value="<?php echo $scouring_table->dated->EditValue2 ?>"<?php echo $scouring_table->dated->editAttributes() ?>>
<?php if (!$scouring_table->dated->ReadOnly && !$scouring_table->dated->Disabled && !isset($scouring_table->dated->EditAttrs["readonly"]) && !isset($scouring_table->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fscouring_tablesearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label for="x_employee_id" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_employee_id"><?php echo $scouring_table->employee_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_employee_id" id="z_employee_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->employee_id->cellAttributes() ?>>
			<span id="el_scouring_table_employee_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_employee_id"><?php echo strval($scouring_table->employee_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($scouring_table->employee_id->AdvancedSearch->ViewValue) : $scouring_table->employee_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($scouring_table->employee_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($scouring_table->employee_id->ReadOnly || $scouring_table->employee_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_employee_id[]',m:1,n:20});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $scouring_table->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
<input type="hidden" data-table="scouring_table" data-field="x_employee_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $scouring_table->employee_id->displayValueSeparatorAttribute() ?>" name="x_employee_id[]" id="x_employee_id[]" value="<?php echo $scouring_table->employee_id->AdvancedSearch->SearchValue ?>"<?php echo $scouring_table->employee_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->next_issue_yn->Visible) { // next_issue_yn ?>
	<div id="r_next_issue_yn" class="form-group row">
		<label class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_next_issue_yn"><?php echo $scouring_table->next_issue_yn->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_next_issue_yn" id="z_next_issue_yn" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->next_issue_yn->cellAttributes() ?>>
			<span id="el_scouring_table_next_issue_yn">
<div id="tp_x_next_issue_yn" class="ew-template"><input type="radio" class="form-check-input" data-table="scouring_table" data-field="x_next_issue_yn" data-value-separator="<?php echo $scouring_table->next_issue_yn->displayValueSeparatorAttribute() ?>" name="x_next_issue_yn" id="x_next_issue_yn" value="{value}"<?php echo $scouring_table->next_issue_yn->editAttributes() ?>></div>
<div id="dsl_x_next_issue_yn" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $scouring_table->next_issue_yn->radioButtonListHtml(FALSE, "x_next_issue_yn") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->next_process->Visible) { // next_process ?>
	<div id="r_next_process" class="form-group row">
		<label class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_next_process"><?php echo $scouring_table->next_process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_next_process" id="z_next_process" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->next_process->cellAttributes() ?>>
			<span id="el_scouring_table_next_process">
<div id="tp_x_next_process" class="ew-template"><input type="radio" class="form-check-input" data-table="scouring_table" data-field="x_next_process" data-value-separator="<?php echo $scouring_table->next_process->displayValueSeparatorAttribute() ?>" name="x_next_process" id="x_next_process" value="{value}"<?php echo $scouring_table->next_process->editAttributes() ?>></div>
<div id="dsl_x_next_process" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $scouring_table->next_process->radioButtonListHtml(FALSE, "x_next_process") ?>
</div></div>
<?php echo $scouring_table->next_process->Lookup->getParamTag("p_x_next_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->next_godown->Visible) { // next_godown ?>
	<div id="r_next_godown" class="form-group row">
		<label for="x_next_godown" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_next_godown"><?php echo $scouring_table->next_godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_next_godown" id="z_next_godown" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->next_godown->cellAttributes() ?>>
			<span id="el_scouring_table_next_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_table" data-field="x_next_godown" data-value-separator="<?php echo $scouring_table->next_godown->displayValueSeparatorAttribute() ?>" id="x_next_godown" name="x_next_godown"<?php echo $scouring_table->next_godown->editAttributes() ?>>
		<?php echo $scouring_table->next_godown->selectOptionListHtml("x_next_godown") ?>
	</select>
</div>
<?php echo $scouring_table->next_godown->Lookup->getParamTag("p_x_next_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_remarks"><?php echo $scouring_table->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->remarks->cellAttributes() ?>>
			<span id="el_scouring_table_remarks">
<input type="text" data-table="scouring_table" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="40" placeholder="<?php echo HtmlEncode($scouring_table->remarks->getPlaceHolder()) ?>" value="<?php echo $scouring_table->remarks->EditValue ?>"<?php echo $scouring_table->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_operator"><?php echo $scouring_table->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->operator->cellAttributes() ?>>
			<span id="el_scouring_table_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="scouring_table" data-field="x_operator" data-value-separator="<?php echo $scouring_table->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $scouring_table->operator->editAttributes() ?>>
		<?php echo $scouring_table->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $scouring_table->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($scouring_table->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $scouring_table_search->LeftColumnClass ?>"><span id="elh_scouring_table_datetime"><?php echo $scouring_table->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $scouring_table_search->RightColumnClass ?>"><div<?php echo $scouring_table->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($scouring_table->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($scouring_table->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($scouring_table->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($scouring_table->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($scouring_table->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($scouring_table->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($scouring_table->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($scouring_table->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($scouring_table->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_scouring_table_datetime">
<input type="text" data-table="scouring_table" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($scouring_table->datetime->getPlaceHolder()) ?>" value="<?php echo $scouring_table->datetime->EditValue ?>"<?php echo $scouring_table->datetime->editAttributes() ?>>
<?php if (!$scouring_table->datetime->ReadOnly && !$scouring_table->datetime->Disabled && !isset($scouring_table->datetime->EditAttrs["readonly"]) && !isset($scouring_table->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fscouring_tablesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_scouring_table_datetime" class="btw1_datetime d-none">
<input type="text" data-table="scouring_table" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($scouring_table->datetime->getPlaceHolder()) ?>" value="<?php echo $scouring_table->datetime->EditValue2 ?>"<?php echo $scouring_table->datetime->editAttributes() ?>>
<?php if (!$scouring_table->datetime->ReadOnly && !$scouring_table->datetime->Disabled && !isset($scouring_table->datetime->EditAttrs["readonly"]) && !isset($scouring_table->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fscouring_tablesearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$scouring_table_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $scouring_table_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$scouring_table_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$scouring_table_search->terminate();
?>