<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$service_misc_list = new service_misc_list();

// Run the page
$service_misc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$service_misc_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$service_misc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fservice_misclist = currentForm = new ew.Form("fservice_misclist", "list");
fservice_misclist.formKeyCountName = '<?php echo $service_misc_list->FormKeyCountName ?>';

// Form_CustomValidate event
fservice_misclist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fservice_misclist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fservice_misclist.lists["x_grp"] = <?php echo $service_misc_list->grp->Lookup->toClientList() ?>;
fservice_misclist.lists["x_grp"].options = <?php echo JsonEncode($service_misc_list->grp->lookupOptions()) ?>;
fservice_misclist.lists["x_status"] = <?php echo $service_misc_list->status->Lookup->toClientList() ?>;
fservice_misclist.lists["x_status"].options = <?php echo JsonEncode($service_misc_list->status->options(FALSE, TRUE)) ?>;
fservice_misclist.lists["x_operator"] = <?php echo $service_misc_list->operator->Lookup->toClientList() ?>;
fservice_misclist.lists["x_operator"].options = <?php echo JsonEncode($service_misc_list->operator->lookupOptions()) ?>;

// Form object for search
var fservice_misclistsrch = currentSearchForm = new ew.Form("fservice_misclistsrch");

// Filters
fservice_misclistsrch.filterList = <?php echo $service_misc_list->getFilterList() ?>;

// Init search panel as collapsed
fservice_misclistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$service_misc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($service_misc_list->TotalRecs > 0 && $service_misc_list->ExportOptions->visible()) { ?>
<?php $service_misc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($service_misc_list->ImportOptions->visible()) { ?>
<?php $service_misc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($service_misc_list->SearchOptions->visible()) { ?>
<?php $service_misc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($service_misc_list->FilterOptions->visible()) { ?>
<?php $service_misc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$service_misc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$service_misc->isExport() && !$service_misc->CurrentAction) { ?>
<form name="fservice_misclistsrch" id="fservice_misclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($service_misc_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fservice_misclistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="service_misc">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($service_misc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($service_misc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $service_misc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($service_misc_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($service_misc_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($service_misc_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($service_misc_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $service_misc_list->showPageHeader(); ?>
<?php
$service_misc_list->showMessage();
?>
<?php if ($service_misc_list->TotalRecs > 0 || $service_misc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($service_misc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> service_misc">
<?php if (!$service_misc->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$service_misc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($service_misc_list->Pager)) $service_misc_list->Pager = new PrevNextPager($service_misc_list->StartRec, $service_misc_list->DisplayRecs, $service_misc_list->TotalRecs, $service_misc_list->AutoHidePager) ?>
<?php if ($service_misc_list->Pager->RecordCount > 0 && $service_misc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($service_misc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $service_misc_list->pageUrl() ?>start=<?php echo $service_misc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($service_misc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $service_misc_list->pageUrl() ?>start=<?php echo $service_misc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $service_misc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($service_misc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $service_misc_list->pageUrl() ?>start=<?php echo $service_misc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($service_misc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $service_misc_list->pageUrl() ?>start=<?php echo $service_misc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $service_misc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($service_misc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $service_misc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $service_misc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $service_misc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($service_misc_list->TotalRecs > 0 && (!$service_misc_list->AutoHidePageSizeSelector || $service_misc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="service_misc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($service_misc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($service_misc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($service_misc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($service_misc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($service_misc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($service_misc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $service_misc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fservice_misclist" id="fservice_misclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($service_misc_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $service_misc_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="service_misc">
<div id="gmp_service_misc" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($service_misc_list->TotalRecs > 0 || $service_misc->isGridEdit()) { ?>
<table id="tbl_service_misclist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$service_misc_list->RowType = ROWTYPE_HEADER;

// Render list options
$service_misc_list->renderListOptions();

// Render list options (header, left)
$service_misc_list->ListOptions->render("header", "left");
?>
<?php if ($service_misc->id->Visible) { // id ?>
	<?php if ($service_misc->sortUrl($service_misc->id) == "") { ?>
		<th data-name="id" class="<?php echo $service_misc->id->headerCellClass() ?>"><div id="elh_service_misc_id" class="service_misc_id"><div class="ew-table-header-caption"><?php echo $service_misc->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $service_misc->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_misc->SortUrl($service_misc->id) ?>',2);"><div id="elh_service_misc_id" class="service_misc_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_misc->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_misc->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_misc->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_misc->item->Visible) { // item ?>
	<?php if ($service_misc->sortUrl($service_misc->item) == "") { ?>
		<th data-name="item" class="<?php echo $service_misc->item->headerCellClass() ?>"><div id="elh_service_misc_item" class="service_misc_item"><div class="ew-table-header-caption"><?php echo $service_misc->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $service_misc->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_misc->SortUrl($service_misc->item) ?>',2);"><div id="elh_service_misc_item" class="service_misc_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_misc->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($service_misc->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_misc->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_misc->grp->Visible) { // grp ?>
	<?php if ($service_misc->sortUrl($service_misc->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $service_misc->grp->headerCellClass() ?>"><div id="elh_service_misc_grp" class="service_misc_grp"><div class="ew-table-header-caption"><?php echo $service_misc->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $service_misc->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_misc->SortUrl($service_misc->grp) ?>',2);"><div id="elh_service_misc_grp" class="service_misc_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_misc->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_misc->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_misc->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_misc->status->Visible) { // status ?>
	<?php if ($service_misc->sortUrl($service_misc->status) == "") { ?>
		<th data-name="status" class="<?php echo $service_misc->status->headerCellClass() ?>"><div id="elh_service_misc_status" class="service_misc_status"><div class="ew-table-header-caption"><?php echo $service_misc->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $service_misc->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_misc->SortUrl($service_misc->status) ?>',2);"><div id="elh_service_misc_status" class="service_misc_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_misc->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_misc->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_misc->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_misc->operator->Visible) { // operator ?>
	<?php if ($service_misc->sortUrl($service_misc->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $service_misc->operator->headerCellClass() ?>"><div id="elh_service_misc_operator" class="service_misc_operator"><div class="ew-table-header-caption"><?php echo $service_misc->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $service_misc->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_misc->SortUrl($service_misc->operator) ?>',2);"><div id="elh_service_misc_operator" class="service_misc_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_misc->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_misc->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_misc->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_misc->datetime->Visible) { // datetime ?>
	<?php if ($service_misc->sortUrl($service_misc->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $service_misc->datetime->headerCellClass() ?>"><div id="elh_service_misc_datetime" class="service_misc_datetime"><div class="ew-table-header-caption"><?php echo $service_misc->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $service_misc->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_misc->SortUrl($service_misc->datetime) ?>',2);"><div id="elh_service_misc_datetime" class="service_misc_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_misc->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_misc->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_misc->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$service_misc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($service_misc->ExportAll && $service_misc->isExport()) {
	$service_misc_list->StopRec = $service_misc_list->TotalRecs;
} else {

	// Set the last record to display
	if ($service_misc_list->TotalRecs > $service_misc_list->StartRec + $service_misc_list->DisplayRecs - 1)
		$service_misc_list->StopRec = $service_misc_list->StartRec + $service_misc_list->DisplayRecs - 1;
	else
		$service_misc_list->StopRec = $service_misc_list->TotalRecs;
}
$service_misc_list->RecCnt = $service_misc_list->StartRec - 1;
if ($service_misc_list->Recordset && !$service_misc_list->Recordset->EOF) {
	$service_misc_list->Recordset->moveFirst();
	$selectLimit = $service_misc_list->UseSelectLimit;
	if (!$selectLimit && $service_misc_list->StartRec > 1)
		$service_misc_list->Recordset->move($service_misc_list->StartRec - 1);
} elseif (!$service_misc->AllowAddDeleteRow && $service_misc_list->StopRec == 0) {
	$service_misc_list->StopRec = $service_misc->GridAddRowCount;
}

// Initialize aggregate
$service_misc->RowType = ROWTYPE_AGGREGATEINIT;
$service_misc->resetAttributes();
$service_misc_list->renderRow();
while ($service_misc_list->RecCnt < $service_misc_list->StopRec) {
	$service_misc_list->RecCnt++;
	if ($service_misc_list->RecCnt >= $service_misc_list->StartRec) {
		$service_misc_list->RowCnt++;

		// Set up key count
		$service_misc_list->KeyCount = $service_misc_list->RowIndex;

		// Init row class and style
		$service_misc->resetAttributes();
		$service_misc->CssClass = "";
		if ($service_misc->isGridAdd()) {
		} else {
			$service_misc_list->loadRowValues($service_misc_list->Recordset); // Load row values
		}
		$service_misc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$service_misc->RowAttrs = array_merge($service_misc->RowAttrs, array('data-rowindex'=>$service_misc_list->RowCnt, 'id'=>'r' . $service_misc_list->RowCnt . '_service_misc', 'data-rowtype'=>$service_misc->RowType));

		// Render row
		$service_misc_list->renderRow();

		// Render list options
		$service_misc_list->renderListOptions();
?>
	<tr<?php echo $service_misc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$service_misc_list->ListOptions->render("body", "left", $service_misc_list->RowCnt);
?>
	<?php if ($service_misc->id->Visible) { // id ?>
		<td data-name="id"<?php echo $service_misc->id->cellAttributes() ?>>
<span id="el<?php echo $service_misc_list->RowCnt ?>_service_misc_id" class="service_misc_id">
<span<?php echo $service_misc->id->viewAttributes() ?>>
<?php echo $service_misc->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_misc->item->Visible) { // item ?>
		<td data-name="item"<?php echo $service_misc->item->cellAttributes() ?>>
<span id="el<?php echo $service_misc_list->RowCnt ?>_service_misc_item" class="service_misc_item">
<span<?php echo $service_misc->item->viewAttributes() ?>>
<?php echo $service_misc->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_misc->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $service_misc->grp->cellAttributes() ?>>
<span id="el<?php echo $service_misc_list->RowCnt ?>_service_misc_grp" class="service_misc_grp">
<span<?php echo $service_misc->grp->viewAttributes() ?>>
<?php echo $service_misc->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_misc->status->Visible) { // status ?>
		<td data-name="status"<?php echo $service_misc->status->cellAttributes() ?>>
<span id="el<?php echo $service_misc_list->RowCnt ?>_service_misc_status" class="service_misc_status">
<span<?php echo $service_misc->status->viewAttributes() ?>>
<?php echo $service_misc->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_misc->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $service_misc->operator->cellAttributes() ?>>
<span id="el<?php echo $service_misc_list->RowCnt ?>_service_misc_operator" class="service_misc_operator">
<span<?php echo $service_misc->operator->viewAttributes() ?>>
<?php echo $service_misc->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_misc->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $service_misc->datetime->cellAttributes() ?>>
<span id="el<?php echo $service_misc_list->RowCnt ?>_service_misc_datetime" class="service_misc_datetime">
<span<?php echo $service_misc->datetime->viewAttributes() ?>>
<?php echo $service_misc->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$service_misc_list->ListOptions->render("body", "right", $service_misc_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$service_misc->isGridAdd())
		$service_misc_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$service_misc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($service_misc_list->Recordset)
	$service_misc_list->Recordset->Close();
?>
<?php if (!$service_misc->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$service_misc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($service_misc_list->Pager)) $service_misc_list->Pager = new PrevNextPager($service_misc_list->StartRec, $service_misc_list->DisplayRecs, $service_misc_list->TotalRecs, $service_misc_list->AutoHidePager) ?>
<?php if ($service_misc_list->Pager->RecordCount > 0 && $service_misc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($service_misc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $service_misc_list->pageUrl() ?>start=<?php echo $service_misc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($service_misc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $service_misc_list->pageUrl() ?>start=<?php echo $service_misc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $service_misc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($service_misc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $service_misc_list->pageUrl() ?>start=<?php echo $service_misc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($service_misc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $service_misc_list->pageUrl() ?>start=<?php echo $service_misc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $service_misc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($service_misc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $service_misc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $service_misc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $service_misc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($service_misc_list->TotalRecs > 0 && (!$service_misc_list->AutoHidePageSizeSelector || $service_misc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="service_misc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($service_misc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($service_misc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($service_misc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($service_misc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($service_misc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($service_misc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $service_misc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($service_misc_list->TotalRecs == 0 && !$service_misc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $service_misc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$service_misc_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$service_misc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$service_misc->isExport()) { ?>
<script>
ew.scrollableTable("gmp_service_misc", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$service_misc_list->terminate();
?>