<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$service_report_delete = new service_report_delete();

// Run the page
$service_report_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$service_report_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fservice_reportdelete = currentForm = new ew.Form("fservice_reportdelete", "delete");

// Form_CustomValidate event
fservice_reportdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fservice_reportdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fservice_reportdelete.lists["x_hardware_id"] = <?php echo $service_report_delete->hardware_id->Lookup->toClientList() ?>;
fservice_reportdelete.lists["x_hardware_id"].options = <?php echo JsonEncode($service_report_delete->hardware_id->lookupOptions()) ?>;
fservice_reportdelete.lists["x_service_executive"] = <?php echo $service_report_delete->service_executive->Lookup->toClientList() ?>;
fservice_reportdelete.lists["x_service_executive"].options = <?php echo JsonEncode($service_report_delete->service_executive->lookupOptions()) ?>;
fservice_reportdelete.autoSuggests["x_service_executive"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fservice_reportdelete.lists["x_complaint"] = <?php echo $service_report_delete->complaint->Lookup->toClientList() ?>;
fservice_reportdelete.lists["x_complaint"].options = <?php echo JsonEncode($service_report_delete->complaint->lookupOptions()) ?>;
fservice_reportdelete.lists["x_product_replaced[]"] = <?php echo $service_report_delete->product_replaced->Lookup->toClientList() ?>;
fservice_reportdelete.lists["x_product_replaced[]"].options = <?php echo JsonEncode($service_report_delete->product_replaced->lookupOptions()) ?>;
fservice_reportdelete.lists["x_consumable_replaced[]"] = <?php echo $service_report_delete->consumable_replaced->Lookup->toClientList() ?>;
fservice_reportdelete.lists["x_consumable_replaced[]"].options = <?php echo JsonEncode($service_report_delete->consumable_replaced->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $service_report_delete->showPageHeader(); ?>
<?php
$service_report_delete->showMessage();
?>
<form name="fservice_reportdelete" id="fservice_reportdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($service_report_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $service_report_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="service_report">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($service_report_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($service_report->id->Visible) { // id ?>
		<th class="<?php echo $service_report->id->headerCellClass() ?>"><span id="elh_service_report_id" class="service_report_id"><?php echo $service_report->id->caption() ?></span></th>
<?php } ?>
<?php if ($service_report->hardware_id->Visible) { // hardware_id ?>
		<th class="<?php echo $service_report->hardware_id->headerCellClass() ?>"><span id="elh_service_report_hardware_id" class="service_report_hardware_id"><?php echo $service_report->hardware_id->caption() ?></span></th>
<?php } ?>
<?php if ($service_report->service_executive->Visible) { // service_executive ?>
		<th class="<?php echo $service_report->service_executive->headerCellClass() ?>"><span id="elh_service_report_service_executive" class="service_report_service_executive"><?php echo $service_report->service_executive->caption() ?></span></th>
<?php } ?>
<?php if ($service_report->current_reading->Visible) { // current_reading ?>
		<th class="<?php echo $service_report->current_reading->headerCellClass() ?>"><span id="elh_service_report_current_reading" class="service_report_current_reading"><?php echo $service_report->current_reading->caption() ?></span></th>
<?php } ?>
<?php if ($service_report->complaint->Visible) { // complaint ?>
		<th class="<?php echo $service_report->complaint->headerCellClass() ?>"><span id="elh_service_report_complaint" class="service_report_complaint"><?php echo $service_report->complaint->caption() ?></span></th>
<?php } ?>
<?php if ($service_report->product_replaced->Visible) { // product_replaced ?>
		<th class="<?php echo $service_report->product_replaced->headerCellClass() ?>"><span id="elh_service_report_product_replaced" class="service_report_product_replaced"><?php echo $service_report->product_replaced->caption() ?></span></th>
<?php } ?>
<?php if ($service_report->consumable_replaced->Visible) { // consumable_replaced ?>
		<th class="<?php echo $service_report->consumable_replaced->headerCellClass() ?>"><span id="elh_service_report_consumable_replaced" class="service_report_consumable_replaced"><?php echo $service_report->consumable_replaced->caption() ?></span></th>
<?php } ?>
<?php if ($service_report->out_time->Visible) { // out_time ?>
		<th class="<?php echo $service_report->out_time->headerCellClass() ?>"><span id="elh_service_report_out_time" class="service_report_out_time"><?php echo $service_report->out_time->caption() ?></span></th>
<?php } ?>
<?php if ($service_report->work_detail->Visible) { // work_detail ?>
		<th class="<?php echo $service_report->work_detail->headerCellClass() ?>"><span id="elh_service_report_work_detail" class="service_report_work_detail"><?php echo $service_report->work_detail->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$service_report_delete->RecCnt = 0;
$i = 0;
while (!$service_report_delete->Recordset->EOF) {
	$service_report_delete->RecCnt++;
	$service_report_delete->RowCnt++;

	// Set row properties
	$service_report->resetAttributes();
	$service_report->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$service_report_delete->loadRowValues($service_report_delete->Recordset);

	// Render row
	$service_report_delete->renderRow();
?>
	<tr<?php echo $service_report->rowAttributes() ?>>
<?php if ($service_report->id->Visible) { // id ?>
		<td<?php echo $service_report->id->cellAttributes() ?>>
<span id="el<?php echo $service_report_delete->RowCnt ?>_service_report_id" class="service_report_id">
<span<?php echo $service_report->id->viewAttributes() ?>>
<?php echo $service_report->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($service_report->hardware_id->Visible) { // hardware_id ?>
		<td<?php echo $service_report->hardware_id->cellAttributes() ?>>
<span id="el<?php echo $service_report_delete->RowCnt ?>_service_report_hardware_id" class="service_report_hardware_id">
<span<?php echo $service_report->hardware_id->viewAttributes() ?>>
<?php echo $service_report->hardware_id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($service_report->service_executive->Visible) { // service_executive ?>
		<td<?php echo $service_report->service_executive->cellAttributes() ?>>
<span id="el<?php echo $service_report_delete->RowCnt ?>_service_report_service_executive" class="service_report_service_executive">
<span<?php echo $service_report->service_executive->viewAttributes() ?>>
<?php echo $service_report->service_executive->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($service_report->current_reading->Visible) { // current_reading ?>
		<td<?php echo $service_report->current_reading->cellAttributes() ?>>
<span id="el<?php echo $service_report_delete->RowCnt ?>_service_report_current_reading" class="service_report_current_reading">
<span<?php echo $service_report->current_reading->viewAttributes() ?>>
<?php echo $service_report->current_reading->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($service_report->complaint->Visible) { // complaint ?>
		<td<?php echo $service_report->complaint->cellAttributes() ?>>
<span id="el<?php echo $service_report_delete->RowCnt ?>_service_report_complaint" class="service_report_complaint">
<span<?php echo $service_report->complaint->viewAttributes() ?>>
<?php echo $service_report->complaint->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($service_report->product_replaced->Visible) { // product_replaced ?>
		<td<?php echo $service_report->product_replaced->cellAttributes() ?>>
<span id="el<?php echo $service_report_delete->RowCnt ?>_service_report_product_replaced" class="service_report_product_replaced">
<span<?php echo $service_report->product_replaced->viewAttributes() ?>>
<?php echo $service_report->product_replaced->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($service_report->consumable_replaced->Visible) { // consumable_replaced ?>
		<td<?php echo $service_report->consumable_replaced->cellAttributes() ?>>
<span id="el<?php echo $service_report_delete->RowCnt ?>_service_report_consumable_replaced" class="service_report_consumable_replaced">
<span<?php echo $service_report->consumable_replaced->viewAttributes() ?>>
<?php echo $service_report->consumable_replaced->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($service_report->out_time->Visible) { // out_time ?>
		<td<?php echo $service_report->out_time->cellAttributes() ?>>
<span id="el<?php echo $service_report_delete->RowCnt ?>_service_report_out_time" class="service_report_out_time">
<span<?php echo $service_report->out_time->viewAttributes() ?>>
<?php echo $service_report->out_time->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($service_report->work_detail->Visible) { // work_detail ?>
		<td<?php echo $service_report->work_detail->cellAttributes() ?>>
<span id="el<?php echo $service_report_delete->RowCnt ?>_service_report_work_detail" class="service_report_work_detail">
<span<?php echo $service_report->work_detail->viewAttributes() ?>>
<?php echo $service_report->work_detail->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$service_report_delete->Recordset->moveNext();
}
$service_report_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $service_report_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$service_report_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$service_report_delete->terminate();
?>