<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$service_report_edit = new service_report_edit();

// Run the page
$service_report_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$service_report_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fservice_reportedit = currentForm = new ew.Form("fservice_reportedit", "edit");

// Validate form
fservice_reportedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($service_report_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->id->caption(), $service_report->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->buyer_id->caption(), $service_report->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->hardware_id->Required) { ?>
			elm = this.getElements("x" + infix + "_hardware_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->hardware_id->caption(), $service_report->hardware_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->service_executive->Required) { ?>
			elm = this.getElements("x" + infix + "_service_executive");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->service_executive->caption(), $service_report->service_executive->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->current_reading->Required) { ?>
			elm = this.getElements("x" + infix + "_current_reading");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->current_reading->caption(), $service_report->current_reading->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_current_reading");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($service_report->current_reading->errorMessage()) ?>");
		<?php if ($service_report_edit->error_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_error_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->error_ref->caption(), $service_report->error_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->service_type->Required) { ?>
			elm = this.getElements("x" + infix + "_service_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->service_type->caption(), $service_report->service_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->complaint->Required) { ?>
			elm = this.getElements("x" + infix + "_complaint");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->complaint->caption(), $service_report->complaint->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->observation->Required) { ?>
			elm = this.getElements("x" + infix + "_observation");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->observation->caption(), $service_report->observation->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->product_replaced->Required) { ?>
			elm = this.getElements("x" + infix + "_product_replaced[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->product_replaced->caption(), $service_report->product_replaced->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->consumable_replaced->Required) { ?>
			elm = this.getElements("x" + infix + "_consumable_replaced[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->consumable_replaced->caption(), $service_report->consumable_replaced->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->out_time->Required) { ?>
			elm = this.getElements("x" + infix + "_out_time");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->out_time->caption(), $service_report->out_time->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_out_time");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($service_report->out_time->errorMessage()) ?>");
		<?php if ($service_report_edit->work_detail->Required) { ?>
			elm = this.getElements("x" + infix + "_work_detail");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->work_detail->caption(), $service_report->work_detail->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->future_task->Required) { ?>
			elm = this.getElements("x" + infix + "_future_task");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->future_task->caption(), $service_report->future_task->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->last_status->Required) { ?>
			elm = this.getElements("x" + infix + "_last_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->last_status->caption(), $service_report->last_status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->operator->caption(), $service_report->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->invoice->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->invoice->caption(), $service_report->invoice->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_report_edit->invoice_date->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->invoice_date->caption(), $service_report->invoice_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_invoice_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($service_report->invoice_date->errorMessage()) ?>");
		<?php if ($service_report_edit->uploads->Required) { ?>
			elm = this.getElements("x" + infix + "_uploads");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_report->uploads->caption(), $service_report->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fservice_reportedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fservice_reportedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fservice_reportedit.lists["x_buyer_id"] = <?php echo $service_report_edit->buyer_id->Lookup->toClientList() ?>;
fservice_reportedit.lists["x_buyer_id"].options = <?php echo JsonEncode($service_report_edit->buyer_id->lookupOptions()) ?>;
fservice_reportedit.autoSuggests["x_buyer_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fservice_reportedit.lists["x_hardware_id"] = <?php echo $service_report_edit->hardware_id->Lookup->toClientList() ?>;
fservice_reportedit.lists["x_hardware_id"].options = <?php echo JsonEncode($service_report_edit->hardware_id->lookupOptions()) ?>;
fservice_reportedit.lists["x_service_executive"] = <?php echo $service_report_edit->service_executive->Lookup->toClientList() ?>;
fservice_reportedit.lists["x_service_executive"].options = <?php echo JsonEncode($service_report_edit->service_executive->lookupOptions()) ?>;
fservice_reportedit.autoSuggests["x_service_executive"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fservice_reportedit.lists["x_error_ref"] = <?php echo $service_report_edit->error_ref->Lookup->toClientList() ?>;
fservice_reportedit.lists["x_error_ref"].options = <?php echo JsonEncode($service_report_edit->error_ref->lookupOptions()) ?>;
fservice_reportedit.lists["x_service_type"] = <?php echo $service_report_edit->service_type->Lookup->toClientList() ?>;
fservice_reportedit.lists["x_service_type"].options = <?php echo JsonEncode($service_report_edit->service_type->lookupOptions()) ?>;
fservice_reportedit.lists["x_complaint"] = <?php echo $service_report_edit->complaint->Lookup->toClientList() ?>;
fservice_reportedit.lists["x_complaint"].options = <?php echo JsonEncode($service_report_edit->complaint->lookupOptions()) ?>;
fservice_reportedit.lists["x_product_replaced[]"] = <?php echo $service_report_edit->product_replaced->Lookup->toClientList() ?>;
fservice_reportedit.lists["x_product_replaced[]"].options = <?php echo JsonEncode($service_report_edit->product_replaced->lookupOptions()) ?>;
fservice_reportedit.lists["x_consumable_replaced[]"] = <?php echo $service_report_edit->consumable_replaced->Lookup->toClientList() ?>;
fservice_reportedit.lists["x_consumable_replaced[]"].options = <?php echo JsonEncode($service_report_edit->consumable_replaced->lookupOptions()) ?>;
fservice_reportedit.lists["x_last_status"] = <?php echo $service_report_edit->last_status->Lookup->toClientList() ?>;
fservice_reportedit.lists["x_last_status"].options = <?php echo JsonEncode($service_report_edit->last_status->lookupOptions()) ?>;
fservice_reportedit.lists["x_operator"] = <?php echo $service_report_edit->operator->Lookup->toClientList() ?>;
fservice_reportedit.lists["x_operator"].options = <?php echo JsonEncode($service_report_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $service_report_edit->showPageHeader(); ?>
<?php
$service_report_edit->showMessage();
?>
<form name="fservice_reportedit" id="fservice_reportedit" class="<?php echo $service_report_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($service_report_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $service_report_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="service_report">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$service_report_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($service_report->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_service_report_id" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->id->caption() ?><?php echo ($service_report->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->id->cellAttributes() ?>>
<span id="el_service_report_id">
<span<?php echo $service_report->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($service_report->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="service_report" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($service_report->id->CurrentValue) ?>">
<?php echo $service_report->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label id="elh_service_report_buyer_id" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->buyer_id->caption() ?><?php echo ($service_report->buyer_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->buyer_id->cellAttributes() ?>>
<span id="el_service_report_buyer_id">
<span<?php echo $service_report->buyer_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($service_report->buyer_id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="service_report" data-field="x_buyer_id" name="x_buyer_id" id="x_buyer_id" value="<?php echo HtmlEncode($service_report->buyer_id->CurrentValue) ?>">
<?php echo $service_report->buyer_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->hardware_id->Visible) { // hardware_id ?>
	<div id="r_hardware_id" class="form-group row">
		<label id="elh_service_report_hardware_id" for="x_hardware_id" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->hardware_id->caption() ?><?php echo ($service_report->hardware_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->hardware_id->cellAttributes() ?>>
<span id="el_service_report_hardware_id">
<span<?php echo $service_report->hardware_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($service_report->hardware_id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="service_report" data-field="x_hardware_id" name="x_hardware_id" id="x_hardware_id" value="<?php echo HtmlEncode($service_report->hardware_id->CurrentValue) ?>">
<?php echo $service_report->hardware_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->service_executive->Visible) { // service_executive ?>
	<div id="r_service_executive" class="form-group row">
		<label id="elh_service_report_service_executive" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->service_executive->caption() ?><?php echo ($service_report->service_executive->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->service_executive->cellAttributes() ?>>
<span id="el_service_report_service_executive">
<span<?php echo $service_report->service_executive->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($service_report->service_executive->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="service_report" data-field="x_service_executive" name="x_service_executive" id="x_service_executive" value="<?php echo HtmlEncode($service_report->service_executive->CurrentValue) ?>">
<?php echo $service_report->service_executive->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->current_reading->Visible) { // current_reading ?>
	<div id="r_current_reading" class="form-group row">
		<label id="elh_service_report_current_reading" for="x_current_reading" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->current_reading->caption() ?><?php echo ($service_report->current_reading->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->current_reading->cellAttributes() ?>>
<span id="el_service_report_current_reading">
<input type="text" data-table="service_report" data-field="x_current_reading" name="x_current_reading" id="x_current_reading" size="30" placeholder="<?php echo HtmlEncode($service_report->current_reading->getPlaceHolder()) ?>" value="<?php echo $service_report->current_reading->EditValue ?>"<?php echo $service_report->current_reading->editAttributes() ?>>
</span>
<?php echo $service_report->current_reading->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->error_ref->Visible) { // error_ref ?>
	<div id="r_error_ref" class="form-group row">
		<label id="elh_service_report_error_ref" for="x_error_ref" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->error_ref->caption() ?><?php echo ($service_report->error_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->error_ref->cellAttributes() ?>>
<span id="el_service_report_error_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_report" data-field="x_error_ref" data-value-separator="<?php echo $service_report->error_ref->displayValueSeparatorAttribute() ?>" id="x_error_ref" name="x_error_ref"<?php echo $service_report->error_ref->editAttributes() ?>>
		<?php echo $service_report->error_ref->selectOptionListHtml("x_error_ref") ?>
	</select>
</div>
<?php echo $service_report->error_ref->Lookup->getParamTag("p_x_error_ref") ?>
</span>
<?php echo $service_report->error_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->service_type->Visible) { // service_type ?>
	<div id="r_service_type" class="form-group row">
		<label id="elh_service_report_service_type" for="x_service_type" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->service_type->caption() ?><?php echo ($service_report->service_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->service_type->cellAttributes() ?>>
<span id="el_service_report_service_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_report" data-field="x_service_type" data-value-separator="<?php echo $service_report->service_type->displayValueSeparatorAttribute() ?>" id="x_service_type" name="x_service_type"<?php echo $service_report->service_type->editAttributes() ?>>
		<?php echo $service_report->service_type->selectOptionListHtml("x_service_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "service_misc") && !$service_report->service_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_service_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $service_report->service_type->caption() ?>" data-title="<?php echo $service_report->service_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_service_type',url:'service_miscaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $service_report->service_type->Lookup->getParamTag("p_x_service_type") ?>
</span>
<?php echo $service_report->service_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->complaint->Visible) { // complaint ?>
	<div id="r_complaint" class="form-group row">
		<label id="elh_service_report_complaint" for="x_complaint" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->complaint->caption() ?><?php echo ($service_report->complaint->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->complaint->cellAttributes() ?>>
<span id="el_service_report_complaint">
<span<?php echo $service_report->complaint->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($service_report->complaint->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="service_report" data-field="x_complaint" name="x_complaint" id="x_complaint" value="<?php echo HtmlEncode($service_report->complaint->CurrentValue) ?>">
<?php echo $service_report->complaint->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->observation->Visible) { // observation ?>
	<div id="r_observation" class="form-group row">
		<label id="elh_service_report_observation" for="x_observation" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->observation->caption() ?><?php echo ($service_report->observation->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->observation->cellAttributes() ?>>
<span id="el_service_report_observation">
<textarea data-table="service_report" data-field="x_observation" name="x_observation" id="x_observation" cols="35" rows="4" placeholder="<?php echo HtmlEncode($service_report->observation->getPlaceHolder()) ?>"<?php echo $service_report->observation->editAttributes() ?>><?php echo $service_report->observation->EditValue ?></textarea>
</span>
<?php echo $service_report->observation->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->product_replaced->Visible) { // product_replaced ?>
	<div id="r_product_replaced" class="form-group row">
		<label id="elh_service_report_product_replaced" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->product_replaced->caption() ?><?php echo ($service_report->product_replaced->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->product_replaced->cellAttributes() ?>>
<span id="el_service_report_product_replaced">
<div id="tp_x_product_replaced" class="ew-template"><input type="checkbox" class="form-check-input" data-table="service_report" data-field="x_product_replaced" data-value-separator="<?php echo $service_report->product_replaced->displayValueSeparatorAttribute() ?>" name="x_product_replaced[]" id="x_product_replaced[]" value="{value}"<?php echo $service_report->product_replaced->editAttributes() ?>></div>
<div id="dsl_x_product_replaced" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $service_report->product_replaced->checkBoxListHtml(FALSE, "x_product_replaced[]") ?>
</div></div>
<?php echo $service_report->product_replaced->Lookup->getParamTag("p_x_product_replaced") ?>
</span>
<?php echo $service_report->product_replaced->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->consumable_replaced->Visible) { // consumable_replaced ?>
	<div id="r_consumable_replaced" class="form-group row">
		<label id="elh_service_report_consumable_replaced" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->consumable_replaced->caption() ?><?php echo ($service_report->consumable_replaced->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->consumable_replaced->cellAttributes() ?>>
<span id="el_service_report_consumable_replaced">
<div id="tp_x_consumable_replaced" class="ew-template"><input type="checkbox" class="form-check-input" data-table="service_report" data-field="x_consumable_replaced" data-value-separator="<?php echo $service_report->consumable_replaced->displayValueSeparatorAttribute() ?>" name="x_consumable_replaced[]" id="x_consumable_replaced[]" value="{value}"<?php echo $service_report->consumable_replaced->editAttributes() ?>></div>
<div id="dsl_x_consumable_replaced" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $service_report->consumable_replaced->checkBoxListHtml(FALSE, "x_consumable_replaced[]") ?>
</div></div>
<?php echo $service_report->consumable_replaced->Lookup->getParamTag("p_x_consumable_replaced") ?>
</span>
<?php echo $service_report->consumable_replaced->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->out_time->Visible) { // out_time ?>
	<div id="r_out_time" class="form-group row">
		<label id="elh_service_report_out_time" for="x_out_time" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->out_time->caption() ?><?php echo ($service_report->out_time->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->out_time->cellAttributes() ?>>
<span id="el_service_report_out_time">
<input type="text" data-table="service_report" data-field="x_out_time" name="x_out_time" id="x_out_time" placeholder="<?php echo HtmlEncode($service_report->out_time->getPlaceHolder()) ?>" value="<?php echo $service_report->out_time->EditValue ?>"<?php echo $service_report->out_time->editAttributes() ?>>
<?php if (!$service_report->out_time->ReadOnly && !$service_report->out_time->Disabled && !isset($service_report->out_time->EditAttrs["readonly"]) && !isset($service_report->out_time->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fservice_reportedit", "x_out_time", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $service_report->out_time->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->work_detail->Visible) { // work_detail ?>
	<div id="r_work_detail" class="form-group row">
		<label id="elh_service_report_work_detail" for="x_work_detail" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->work_detail->caption() ?><?php echo ($service_report->work_detail->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->work_detail->cellAttributes() ?>>
<span id="el_service_report_work_detail">
<textarea data-table="service_report" data-field="x_work_detail" name="x_work_detail" id="x_work_detail" cols="35" rows="4" placeholder="<?php echo HtmlEncode($service_report->work_detail->getPlaceHolder()) ?>"<?php echo $service_report->work_detail->editAttributes() ?>><?php echo $service_report->work_detail->EditValue ?></textarea>
</span>
<?php echo $service_report->work_detail->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->future_task->Visible) { // future_task ?>
	<div id="r_future_task" class="form-group row">
		<label id="elh_service_report_future_task" for="x_future_task" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->future_task->caption() ?><?php echo ($service_report->future_task->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->future_task->cellAttributes() ?>>
<span id="el_service_report_future_task">
<textarea data-table="service_report" data-field="x_future_task" name="x_future_task" id="x_future_task" cols="35" rows="4" placeholder="<?php echo HtmlEncode($service_report->future_task->getPlaceHolder()) ?>"<?php echo $service_report->future_task->editAttributes() ?>><?php echo $service_report->future_task->EditValue ?></textarea>
</span>
<?php echo $service_report->future_task->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->last_status->Visible) { // last_status ?>
	<div id="r_last_status" class="form-group row">
		<label id="elh_service_report_last_status" for="x_last_status" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->last_status->caption() ?><?php echo ($service_report->last_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->last_status->cellAttributes() ?>>
<span id="el_service_report_last_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_report" data-field="x_last_status" data-value-separator="<?php echo $service_report->last_status->displayValueSeparatorAttribute() ?>" id="x_last_status" name="x_last_status"<?php echo $service_report->last_status->editAttributes() ?>>
		<?php echo $service_report->last_status->selectOptionListHtml("x_last_status") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "service_misc") && !$service_report->last_status->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_last_status" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $service_report->last_status->caption() ?>" data-title="<?php echo $service_report->last_status->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_last_status',url:'service_miscaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $service_report->last_status->Lookup->getParamTag("p_x_last_status") ?>
</span>
<?php echo $service_report->last_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->invoice->Visible) { // invoice ?>
	<div id="r_invoice" class="form-group row">
		<label id="elh_service_report_invoice" for="x_invoice" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->invoice->caption() ?><?php echo ($service_report->invoice->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->invoice->cellAttributes() ?>>
<span id="el_service_report_invoice">
<input type="text" data-table="service_report" data-field="x_invoice" name="x_invoice" id="x_invoice" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($service_report->invoice->getPlaceHolder()) ?>" value="<?php echo $service_report->invoice->EditValue ?>"<?php echo $service_report->invoice->editAttributes() ?>>
</span>
<?php echo $service_report->invoice->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->invoice_date->Visible) { // invoice_date ?>
	<div id="r_invoice_date" class="form-group row">
		<label id="elh_service_report_invoice_date" for="x_invoice_date" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->invoice_date->caption() ?><?php echo ($service_report->invoice_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->invoice_date->cellAttributes() ?>>
<span id="el_service_report_invoice_date">
<input type="text" data-table="service_report" data-field="x_invoice_date" name="x_invoice_date" id="x_invoice_date" placeholder="<?php echo HtmlEncode($service_report->invoice_date->getPlaceHolder()) ?>" value="<?php echo $service_report->invoice_date->EditValue ?>"<?php echo $service_report->invoice_date->editAttributes() ?>>
<?php if (!$service_report->invoice_date->ReadOnly && !$service_report->invoice_date->Disabled && !isset($service_report->invoice_date->EditAttrs["readonly"]) && !isset($service_report->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fservice_reportedit", "x_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $service_report->invoice_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_report->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_service_report_uploads" for="x_uploads" class="<?php echo $service_report_edit->LeftColumnClass ?>"><?php echo $service_report->uploads->caption() ?><?php echo ($service_report->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_report_edit->RightColumnClass ?>"><div<?php echo $service_report->uploads->cellAttributes() ?>>
<span id="el_service_report_uploads">
<textarea data-table="service_report" data-field="x_uploads" name="x_uploads" id="x_uploads" cols="35" rows="4" placeholder="<?php echo HtmlEncode($service_report->uploads->getPlaceHolder()) ?>"<?php echo $service_report->uploads->editAttributes() ?>><?php echo $service_report->uploads->EditValue ?></textarea>
</span>
<?php echo $service_report->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$service_report_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $service_report_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $service_report_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$service_report_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var HI = $('#x_hardware_id').val();
		document.cookie = "HI="+HI;
		if (HI.length > 0)
		{
		$('#errorh').remove();
		$.getJSON("apcajax_tc.php?clientlastdata="+HI,function(data){
			$("#r_hardware_id").append('<span style="color:red" id="errorh">'+data+'</span>')
		});
		}
$("#dsl_x_product_replaced").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_product_replaced" title="" data-title="Add Replaced Spares" onclick="ew.modalDialogShow({lnk:this,btn:\'AddBtn\',url:\'material_out_wbcadd.php?P=3,4,8,10&O=\'});" data-original-title="Add Replaced Spares"><i class="fa fa-plus ew-icon"></i></button></div>');
$("#dsl_x_consumable_replaced").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_consumable_replaced" title="" data-title="Add Consumables Delivered" onclick="ew.modalDialogShow({lnk:this,btn:\'AddBtn\',url:\'material_out_wbcadd.php?P=5,6,7,9&O=\'});" data-original-title="Add Consumables Delivered"><i class="fa fa-plus ew-icon"></i></button></div>');
</script>
<?php include_once "footer.php" ?>
<?php
$service_report_edit->terminate();
?>