<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$service_report_list = new service_report_list();

// Run the page
$service_report_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$service_report_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$service_report->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fservice_reportlist = currentForm = new ew.Form("fservice_reportlist", "list");
fservice_reportlist.formKeyCountName = '<?php echo $service_report_list->FormKeyCountName ?>';

// Form_CustomValidate event
fservice_reportlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fservice_reportlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fservice_reportlist.lists["x_hardware_id"] = <?php echo $service_report_list->hardware_id->Lookup->toClientList() ?>;
fservice_reportlist.lists["x_hardware_id"].options = <?php echo JsonEncode($service_report_list->hardware_id->lookupOptions()) ?>;
fservice_reportlist.lists["x_service_executive"] = <?php echo $service_report_list->service_executive->Lookup->toClientList() ?>;
fservice_reportlist.lists["x_service_executive"].options = <?php echo JsonEncode($service_report_list->service_executive->lookupOptions()) ?>;
fservice_reportlist.autoSuggests["x_service_executive"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fservice_reportlist.lists["x_complaint"] = <?php echo $service_report_list->complaint->Lookup->toClientList() ?>;
fservice_reportlist.lists["x_complaint"].options = <?php echo JsonEncode($service_report_list->complaint->lookupOptions()) ?>;
fservice_reportlist.lists["x_product_replaced[]"] = <?php echo $service_report_list->product_replaced->Lookup->toClientList() ?>;
fservice_reportlist.lists["x_product_replaced[]"].options = <?php echo JsonEncode($service_report_list->product_replaced->lookupOptions()) ?>;
fservice_reportlist.lists["x_consumable_replaced[]"] = <?php echo $service_report_list->consumable_replaced->Lookup->toClientList() ?>;
fservice_reportlist.lists["x_consumable_replaced[]"].options = <?php echo JsonEncode($service_report_list->consumable_replaced->lookupOptions()) ?>;

// Form object for search
var fservice_reportlistsrch = currentSearchForm = new ew.Form("fservice_reportlistsrch");

// Filters
fservice_reportlistsrch.filterList = <?php echo $service_report_list->getFilterList() ?>;

// Init search panel as collapsed
fservice_reportlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$service_report->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($service_report_list->TotalRecs > 0 && $service_report_list->ExportOptions->visible()) { ?>
<?php $service_report_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($service_report_list->ImportOptions->visible()) { ?>
<?php $service_report_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($service_report_list->SearchOptions->visible()) { ?>
<?php $service_report_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($service_report_list->FilterOptions->visible()) { ?>
<?php $service_report_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$service_report_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$service_report->isExport() && !$service_report->CurrentAction) { ?>
<form name="fservice_reportlistsrch" id="fservice_reportlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($service_report_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fservice_reportlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="service_report">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($service_report_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($service_report_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $service_report_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($service_report_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($service_report_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($service_report_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($service_report_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $service_report_list->showPageHeader(); ?>
<?php
$service_report_list->showMessage();
?>
<?php if ($service_report_list->TotalRecs > 0 || $service_report->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($service_report_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> service_report">
<?php if (!$service_report->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$service_report->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($service_report_list->Pager)) $service_report_list->Pager = new PrevNextPager($service_report_list->StartRec, $service_report_list->DisplayRecs, $service_report_list->TotalRecs, $service_report_list->AutoHidePager) ?>
<?php if ($service_report_list->Pager->RecordCount > 0 && $service_report_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($service_report_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $service_report_list->pageUrl() ?>start=<?php echo $service_report_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($service_report_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $service_report_list->pageUrl() ?>start=<?php echo $service_report_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $service_report_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($service_report_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $service_report_list->pageUrl() ?>start=<?php echo $service_report_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($service_report_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $service_report_list->pageUrl() ?>start=<?php echo $service_report_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $service_report_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($service_report_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $service_report_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $service_report_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $service_report_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($service_report_list->TotalRecs > 0 && (!$service_report_list->AutoHidePageSizeSelector || $service_report_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="service_report">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($service_report_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($service_report_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($service_report_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($service_report_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($service_report_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($service_report->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $service_report_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fservice_reportlist" id="fservice_reportlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($service_report_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $service_report_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="service_report">
<div id="gmp_service_report" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($service_report_list->TotalRecs > 0 || $service_report->isGridEdit()) { ?>
<table id="tbl_service_reportlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$service_report_list->RowType = ROWTYPE_HEADER;

// Render list options
$service_report_list->renderListOptions();

// Render list options (header, left)
$service_report_list->ListOptions->render("header", "left");
?>
<?php if ($service_report->id->Visible) { // id ?>
	<?php if ($service_report->sortUrl($service_report->id) == "") { ?>
		<th data-name="id" class="<?php echo $service_report->id->headerCellClass() ?>"><div id="elh_service_report_id" class="service_report_id"><div class="ew-table-header-caption"><?php echo $service_report->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $service_report->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_report->SortUrl($service_report->id) ?>',2);"><div id="elh_service_report_id" class="service_report_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_report->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_report->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_report->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_report->hardware_id->Visible) { // hardware_id ?>
	<?php if ($service_report->sortUrl($service_report->hardware_id) == "") { ?>
		<th data-name="hardware_id" class="<?php echo $service_report->hardware_id->headerCellClass() ?>"><div id="elh_service_report_hardware_id" class="service_report_hardware_id"><div class="ew-table-header-caption"><?php echo $service_report->hardware_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="hardware_id" class="<?php echo $service_report->hardware_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_report->SortUrl($service_report->hardware_id) ?>',2);"><div id="elh_service_report_hardware_id" class="service_report_hardware_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_report->hardware_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_report->hardware_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_report->hardware_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_report->service_executive->Visible) { // service_executive ?>
	<?php if ($service_report->sortUrl($service_report->service_executive) == "") { ?>
		<th data-name="service_executive" class="<?php echo $service_report->service_executive->headerCellClass() ?>"><div id="elh_service_report_service_executive" class="service_report_service_executive"><div class="ew-table-header-caption"><?php echo $service_report->service_executive->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="service_executive" class="<?php echo $service_report->service_executive->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_report->SortUrl($service_report->service_executive) ?>',2);"><div id="elh_service_report_service_executive" class="service_report_service_executive">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_report->service_executive->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_report->service_executive->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_report->service_executive->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_report->current_reading->Visible) { // current_reading ?>
	<?php if ($service_report->sortUrl($service_report->current_reading) == "") { ?>
		<th data-name="current_reading" class="<?php echo $service_report->current_reading->headerCellClass() ?>"><div id="elh_service_report_current_reading" class="service_report_current_reading"><div class="ew-table-header-caption"><?php echo $service_report->current_reading->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_reading" class="<?php echo $service_report->current_reading->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_report->SortUrl($service_report->current_reading) ?>',2);"><div id="elh_service_report_current_reading" class="service_report_current_reading">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_report->current_reading->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_report->current_reading->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_report->current_reading->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_report->complaint->Visible) { // complaint ?>
	<?php if ($service_report->sortUrl($service_report->complaint) == "") { ?>
		<th data-name="complaint" class="<?php echo $service_report->complaint->headerCellClass() ?>"><div id="elh_service_report_complaint" class="service_report_complaint"><div class="ew-table-header-caption"><?php echo $service_report->complaint->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="complaint" class="<?php echo $service_report->complaint->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_report->SortUrl($service_report->complaint) ?>',2);"><div id="elh_service_report_complaint" class="service_report_complaint">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_report->complaint->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_report->complaint->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_report->complaint->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_report->product_replaced->Visible) { // product_replaced ?>
	<?php if ($service_report->sortUrl($service_report->product_replaced) == "") { ?>
		<th data-name="product_replaced" class="<?php echo $service_report->product_replaced->headerCellClass() ?>"><div id="elh_service_report_product_replaced" class="service_report_product_replaced"><div class="ew-table-header-caption"><?php echo $service_report->product_replaced->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_replaced" class="<?php echo $service_report->product_replaced->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_report->SortUrl($service_report->product_replaced) ?>',2);"><div id="elh_service_report_product_replaced" class="service_report_product_replaced">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_report->product_replaced->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_report->product_replaced->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_report->product_replaced->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_report->consumable_replaced->Visible) { // consumable_replaced ?>
	<?php if ($service_report->sortUrl($service_report->consumable_replaced) == "") { ?>
		<th data-name="consumable_replaced" class="<?php echo $service_report->consumable_replaced->headerCellClass() ?>"><div id="elh_service_report_consumable_replaced" class="service_report_consumable_replaced"><div class="ew-table-header-caption"><?php echo $service_report->consumable_replaced->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consumable_replaced" class="<?php echo $service_report->consumable_replaced->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_report->SortUrl($service_report->consumable_replaced) ?>',2);"><div id="elh_service_report_consumable_replaced" class="service_report_consumable_replaced">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_report->consumable_replaced->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_report->consumable_replaced->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_report->consumable_replaced->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_report->out_time->Visible) { // out_time ?>
	<?php if ($service_report->sortUrl($service_report->out_time) == "") { ?>
		<th data-name="out_time" class="<?php echo $service_report->out_time->headerCellClass() ?>"><div id="elh_service_report_out_time" class="service_report_out_time"><div class="ew-table-header-caption"><?php echo $service_report->out_time->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="out_time" class="<?php echo $service_report->out_time->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_report->SortUrl($service_report->out_time) ?>',2);"><div id="elh_service_report_out_time" class="service_report_out_time">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_report->out_time->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_report->out_time->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_report->out_time->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_report->work_detail->Visible) { // work_detail ?>
	<?php if ($service_report->sortUrl($service_report->work_detail) == "") { ?>
		<th data-name="work_detail" class="<?php echo $service_report->work_detail->headerCellClass() ?>"><div id="elh_service_report_work_detail" class="service_report_work_detail"><div class="ew-table-header-caption"><?php echo $service_report->work_detail->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="work_detail" class="<?php echo $service_report->work_detail->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_report->SortUrl($service_report->work_detail) ?>',2);"><div id="elh_service_report_work_detail" class="service_report_work_detail">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_report->work_detail->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($service_report->work_detail->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_report->work_detail->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$service_report_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($service_report->ExportAll && $service_report->isExport()) {
	$service_report_list->StopRec = $service_report_list->TotalRecs;
} else {

	// Set the last record to display
	if ($service_report_list->TotalRecs > $service_report_list->StartRec + $service_report_list->DisplayRecs - 1)
		$service_report_list->StopRec = $service_report_list->StartRec + $service_report_list->DisplayRecs - 1;
	else
		$service_report_list->StopRec = $service_report_list->TotalRecs;
}
$service_report_list->RecCnt = $service_report_list->StartRec - 1;
if ($service_report_list->Recordset && !$service_report_list->Recordset->EOF) {
	$service_report_list->Recordset->moveFirst();
	$selectLimit = $service_report_list->UseSelectLimit;
	if (!$selectLimit && $service_report_list->StartRec > 1)
		$service_report_list->Recordset->move($service_report_list->StartRec - 1);
} elseif (!$service_report->AllowAddDeleteRow && $service_report_list->StopRec == 0) {
	$service_report_list->StopRec = $service_report->GridAddRowCount;
}

// Initialize aggregate
$service_report->RowType = ROWTYPE_AGGREGATEINIT;
$service_report->resetAttributes();
$service_report_list->renderRow();
while ($service_report_list->RecCnt < $service_report_list->StopRec) {
	$service_report_list->RecCnt++;
	if ($service_report_list->RecCnt >= $service_report_list->StartRec) {
		$service_report_list->RowCnt++;

		// Set up key count
		$service_report_list->KeyCount = $service_report_list->RowIndex;

		// Init row class and style
		$service_report->resetAttributes();
		$service_report->CssClass = "";
		if ($service_report->isGridAdd()) {
		} else {
			$service_report_list->loadRowValues($service_report_list->Recordset); // Load row values
		}
		$service_report->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$service_report->RowAttrs = array_merge($service_report->RowAttrs, array('data-rowindex'=>$service_report_list->RowCnt, 'id'=>'r' . $service_report_list->RowCnt . '_service_report', 'data-rowtype'=>$service_report->RowType));

		// Render row
		$service_report_list->renderRow();

		// Render list options
		$service_report_list->renderListOptions();
?>
	<tr<?php echo $service_report->rowAttributes() ?>>
<?php

// Render list options (body, left)
$service_report_list->ListOptions->render("body", "left", $service_report_list->RowCnt);
?>
	<?php if ($service_report->id->Visible) { // id ?>
		<td data-name="id"<?php echo $service_report->id->cellAttributes() ?>>
<span id="el<?php echo $service_report_list->RowCnt ?>_service_report_id" class="service_report_id">
<span<?php echo $service_report->id->viewAttributes() ?>>
<?php echo $service_report->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_report->hardware_id->Visible) { // hardware_id ?>
		<td data-name="hardware_id"<?php echo $service_report->hardware_id->cellAttributes() ?>>
<span id="el<?php echo $service_report_list->RowCnt ?>_service_report_hardware_id" class="service_report_hardware_id">
<span<?php echo $service_report->hardware_id->viewAttributes() ?>>
<?php echo $service_report->hardware_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_report->service_executive->Visible) { // service_executive ?>
		<td data-name="service_executive"<?php echo $service_report->service_executive->cellAttributes() ?>>
<span id="el<?php echo $service_report_list->RowCnt ?>_service_report_service_executive" class="service_report_service_executive">
<span<?php echo $service_report->service_executive->viewAttributes() ?>>
<?php echo $service_report->service_executive->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_report->current_reading->Visible) { // current_reading ?>
		<td data-name="current_reading"<?php echo $service_report->current_reading->cellAttributes() ?>>
<span id="el<?php echo $service_report_list->RowCnt ?>_service_report_current_reading" class="service_report_current_reading">
<span<?php echo $service_report->current_reading->viewAttributes() ?>>
<?php echo $service_report->current_reading->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_report->complaint->Visible) { // complaint ?>
		<td data-name="complaint"<?php echo $service_report->complaint->cellAttributes() ?>>
<span id="el<?php echo $service_report_list->RowCnt ?>_service_report_complaint" class="service_report_complaint">
<span<?php echo $service_report->complaint->viewAttributes() ?>>
<?php echo $service_report->complaint->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_report->product_replaced->Visible) { // product_replaced ?>
		<td data-name="product_replaced"<?php echo $service_report->product_replaced->cellAttributes() ?>>
<span id="el<?php echo $service_report_list->RowCnt ?>_service_report_product_replaced" class="service_report_product_replaced">
<span<?php echo $service_report->product_replaced->viewAttributes() ?>>
<?php echo $service_report->product_replaced->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_report->consumable_replaced->Visible) { // consumable_replaced ?>
		<td data-name="consumable_replaced"<?php echo $service_report->consumable_replaced->cellAttributes() ?>>
<span id="el<?php echo $service_report_list->RowCnt ?>_service_report_consumable_replaced" class="service_report_consumable_replaced">
<span<?php echo $service_report->consumable_replaced->viewAttributes() ?>>
<?php echo $service_report->consumable_replaced->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_report->out_time->Visible) { // out_time ?>
		<td data-name="out_time"<?php echo $service_report->out_time->cellAttributes() ?>>
<span id="el<?php echo $service_report_list->RowCnt ?>_service_report_out_time" class="service_report_out_time">
<span<?php echo $service_report->out_time->viewAttributes() ?>>
<?php echo $service_report->out_time->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_report->work_detail->Visible) { // work_detail ?>
		<td data-name="work_detail"<?php echo $service_report->work_detail->cellAttributes() ?>>
<span id="el<?php echo $service_report_list->RowCnt ?>_service_report_work_detail" class="service_report_work_detail">
<span<?php echo $service_report->work_detail->viewAttributes() ?>>
<?php echo $service_report->work_detail->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$service_report_list->ListOptions->render("body", "right", $service_report_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$service_report->isGridAdd())
		$service_report_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$service_report->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($service_report_list->Recordset)
	$service_report_list->Recordset->Close();
?>
<?php if (!$service_report->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$service_report->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($service_report_list->Pager)) $service_report_list->Pager = new PrevNextPager($service_report_list->StartRec, $service_report_list->DisplayRecs, $service_report_list->TotalRecs, $service_report_list->AutoHidePager) ?>
<?php if ($service_report_list->Pager->RecordCount > 0 && $service_report_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($service_report_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $service_report_list->pageUrl() ?>start=<?php echo $service_report_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($service_report_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $service_report_list->pageUrl() ?>start=<?php echo $service_report_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $service_report_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($service_report_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $service_report_list->pageUrl() ?>start=<?php echo $service_report_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($service_report_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $service_report_list->pageUrl() ?>start=<?php echo $service_report_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $service_report_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($service_report_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $service_report_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $service_report_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $service_report_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($service_report_list->TotalRecs > 0 && (!$service_report_list->AutoHidePageSizeSelector || $service_report_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="service_report">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($service_report_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($service_report_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($service_report_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($service_report_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($service_report_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($service_report->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $service_report_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($service_report_list->TotalRecs == 0 && !$service_report->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $service_report_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$service_report_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$service_report->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$service_report->isExport()) { ?>
<script>
ew.scrollableTable("gmp_service_report", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$service_report_list->terminate();
?>