<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$service_report_search = new service_report_search();

// Run the page
$service_report_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$service_report_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($service_report_search->IsModal) { ?>
var fservice_reportsearch = currentAdvancedSearchForm = new ew.Form("fservice_reportsearch", "search");
<?php } else { ?>
var fservice_reportsearch = currentForm = new ew.Form("fservice_reportsearch", "search");
<?php } ?>

// Form_CustomValidate event
fservice_reportsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fservice_reportsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fservice_reportsearch.lists["x_buyer_id"] = <?php echo $service_report_search->buyer_id->Lookup->toClientList() ?>;
fservice_reportsearch.lists["x_buyer_id"].options = <?php echo JsonEncode($service_report_search->buyer_id->lookupOptions()) ?>;
fservice_reportsearch.autoSuggests["x_buyer_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fservice_reportsearch.lists["x_hardware_id"] = <?php echo $service_report_search->hardware_id->Lookup->toClientList() ?>;
fservice_reportsearch.lists["x_hardware_id"].options = <?php echo JsonEncode($service_report_search->hardware_id->lookupOptions()) ?>;
fservice_reportsearch.lists["x_service_executive"] = <?php echo $service_report_search->service_executive->Lookup->toClientList() ?>;
fservice_reportsearch.lists["x_service_executive"].options = <?php echo JsonEncode($service_report_search->service_executive->lookupOptions()) ?>;
fservice_reportsearch.autoSuggests["x_service_executive"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fservice_reportsearch.lists["x_error_ref"] = <?php echo $service_report_search->error_ref->Lookup->toClientList() ?>;
fservice_reportsearch.lists["x_error_ref"].options = <?php echo JsonEncode($service_report_search->error_ref->lookupOptions()) ?>;
fservice_reportsearch.lists["x_service_type"] = <?php echo $service_report_search->service_type->Lookup->toClientList() ?>;
fservice_reportsearch.lists["x_service_type"].options = <?php echo JsonEncode($service_report_search->service_type->lookupOptions()) ?>;
fservice_reportsearch.lists["x_complaint"] = <?php echo $service_report_search->complaint->Lookup->toClientList() ?>;
fservice_reportsearch.lists["x_complaint"].options = <?php echo JsonEncode($service_report_search->complaint->lookupOptions()) ?>;
fservice_reportsearch.lists["x_product_replaced[]"] = <?php echo $service_report_search->product_replaced->Lookup->toClientList() ?>;
fservice_reportsearch.lists["x_product_replaced[]"].options = <?php echo JsonEncode($service_report_search->product_replaced->lookupOptions()) ?>;
fservice_reportsearch.lists["x_consumable_replaced[]"] = <?php echo $service_report_search->consumable_replaced->Lookup->toClientList() ?>;
fservice_reportsearch.lists["x_consumable_replaced[]"].options = <?php echo JsonEncode($service_report_search->consumable_replaced->lookupOptions()) ?>;
fservice_reportsearch.lists["x_last_status"] = <?php echo $service_report_search->last_status->Lookup->toClientList() ?>;
fservice_reportsearch.lists["x_last_status"].options = <?php echo JsonEncode($service_report_search->last_status->lookupOptions()) ?>;
fservice_reportsearch.lists["x_operator"] = <?php echo $service_report_search->operator->Lookup->toClientList() ?>;
fservice_reportsearch.lists["x_operator"].options = <?php echo JsonEncode($service_report_search->operator->lookupOptions()) ?>;
fservice_reportsearch.lists["x_a_operator"] = <?php echo $service_report_search->a_operator->Lookup->toClientList() ?>;
fservice_reportsearch.lists["x_a_operator"].options = <?php echo JsonEncode($service_report_search->a_operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fservice_reportsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_report->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_buyer_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_report->buyer_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_service_executive");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_report->service_executive->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_entry_time");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_report->entry_time->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_current_reading");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_report->current_reading->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_out_time");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_report->out_time->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_report->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_invoice_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_report->invoice_date->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $service_report_search->showPageHeader(); ?>
<?php
$service_report_search->showMessage();
?>
<form name="fservice_reportsearch" id="fservice_reportsearch" class="<?php echo $service_report_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($service_report_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $service_report_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="service_report">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$service_report_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($service_report->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_id"><?php echo $service_report->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->id->cellAttributes() ?>>
			<span id="el_service_report_id">
<input type="text" data-table="service_report" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($service_report->id->getPlaceHolder()) ?>" value="<?php echo $service_report->id->EditValue ?>"<?php echo $service_report->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_buyer_id"><?php echo $service_report->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->buyer_id->cellAttributes() ?>>
			<span id="el_service_report_buyer_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$service_report->buyer_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$service_report->buyer_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer_id" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer_id" id="sv_x_buyer_id" value="<?php echo RemoveHtml($service_report->buyer_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($service_report->buyer_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($service_report->buyer_id->getPlaceHolder()) ?>"<?php echo $service_report->buyer_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($service_report->buyer_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($service_report->buyer_id->ReadOnly || $service_report->buyer_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="service_report" data-field="x_buyer_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $service_report->buyer_id->displayValueSeparatorAttribute() ?>" name="x_buyer_id" id="x_buyer_id" value="<?php echo HtmlEncode($service_report->buyer_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fservice_reportsearch.createAutoSuggest({"id":"x_buyer_id","forceSelect":true});
</script>
<?php echo $service_report->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->hardware_id->Visible) { // hardware_id ?>
	<div id="r_hardware_id" class="form-group row">
		<label for="x_hardware_id" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_hardware_id"><?php echo $service_report->hardware_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_hardware_id" id="z_hardware_id" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->hardware_id->cellAttributes() ?>>
			<span id="el_service_report_hardware_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_report" data-field="x_hardware_id" data-value-separator="<?php echo $service_report->hardware_id->displayValueSeparatorAttribute() ?>" id="x_hardware_id" name="x_hardware_id"<?php echo $service_report->hardware_id->editAttributes() ?>>
		<?php echo $service_report->hardware_id->selectOptionListHtml("x_hardware_id") ?>
	</select>
</div>
<?php echo $service_report->hardware_id->Lookup->getParamTag("p_x_hardware_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->service_executive->Visible) { // service_executive ?>
	<div id="r_service_executive" class="form-group row">
		<label class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_service_executive"><?php echo $service_report->service_executive->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_service_executive" id="z_service_executive" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->service_executive->cellAttributes() ?>>
			<span id="el_service_report_service_executive">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$service_report->service_executive->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$service_report->service_executive->EditAttrs["onchange"] = "";
?>
<span id="as_x_service_executive" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_service_executive" id="sv_x_service_executive" value="<?php echo RemoveHtml($service_report->service_executive->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($service_report->service_executive->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($service_report->service_executive->getPlaceHolder()) ?>"<?php echo $service_report->service_executive->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($service_report->service_executive->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_service_executive',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($service_report->service_executive->ReadOnly || $service_report->service_executive->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="service_report" data-field="x_service_executive" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $service_report->service_executive->displayValueSeparatorAttribute() ?>" name="x_service_executive" id="x_service_executive" value="<?php echo HtmlEncode($service_report->service_executive->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fservice_reportsearch.createAutoSuggest({"id":"x_service_executive","forceSelect":true});
</script>
<?php echo $service_report->service_executive->Lookup->getParamTag("p_x_service_executive") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->entry_time->Visible) { // entry_time ?>
	<div id="r_entry_time" class="form-group row">
		<label for="x_entry_time" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_entry_time"><?php echo $service_report->entry_time->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_entry_time" id="z_entry_time" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->entry_time->cellAttributes() ?>>
			<span id="el_service_report_entry_time">
<input type="text" data-table="service_report" data-field="x_entry_time" name="x_entry_time" id="x_entry_time" placeholder="<?php echo HtmlEncode($service_report->entry_time->getPlaceHolder()) ?>" value="<?php echo $service_report->entry_time->EditValue ?>"<?php echo $service_report->entry_time->editAttributes() ?>>
<?php if (!$service_report->entry_time->ReadOnly && !$service_report->entry_time->Disabled && !isset($service_report->entry_time->EditAttrs["readonly"]) && !isset($service_report->entry_time->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fservice_reportsearch", "x_entry_time", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->current_reading->Visible) { // current_reading ?>
	<div id="r_current_reading" class="form-group row">
		<label for="x_current_reading" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_current_reading"><?php echo $service_report->current_reading->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_reading" id="z_current_reading" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->current_reading->cellAttributes() ?>>
			<span id="el_service_report_current_reading">
<input type="text" data-table="service_report" data-field="x_current_reading" name="x_current_reading" id="x_current_reading" size="30" placeholder="<?php echo HtmlEncode($service_report->current_reading->getPlaceHolder()) ?>" value="<?php echo $service_report->current_reading->EditValue ?>"<?php echo $service_report->current_reading->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->error_ref->Visible) { // error_ref ?>
	<div id="r_error_ref" class="form-group row">
		<label for="x_error_ref" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_error_ref"><?php echo $service_report->error_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_error_ref" id="z_error_ref" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->error_ref->cellAttributes() ?>>
			<span id="el_service_report_error_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_report" data-field="x_error_ref" data-value-separator="<?php echo $service_report->error_ref->displayValueSeparatorAttribute() ?>" id="x_error_ref" name="x_error_ref"<?php echo $service_report->error_ref->editAttributes() ?>>
		<?php echo $service_report->error_ref->selectOptionListHtml("x_error_ref") ?>
	</select>
</div>
<?php echo $service_report->error_ref->Lookup->getParamTag("p_x_error_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->service_type->Visible) { // service_type ?>
	<div id="r_service_type" class="form-group row">
		<label for="x_service_type" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_service_type"><?php echo $service_report->service_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_service_type" id="z_service_type" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->service_type->cellAttributes() ?>>
			<span id="el_service_report_service_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_report" data-field="x_service_type" data-value-separator="<?php echo $service_report->service_type->displayValueSeparatorAttribute() ?>" id="x_service_type" name="x_service_type"<?php echo $service_report->service_type->editAttributes() ?>>
		<?php echo $service_report->service_type->selectOptionListHtml("x_service_type") ?>
	</select>
</div>
<?php echo $service_report->service_type->Lookup->getParamTag("p_x_service_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->complaint->Visible) { // complaint ?>
	<div id="r_complaint" class="form-group row">
		<label for="x_complaint" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_complaint"><?php echo $service_report->complaint->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_complaint" id="z_complaint" value="LIKE"></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->complaint->cellAttributes() ?>>
			<span id="el_service_report_complaint">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_report" data-field="x_complaint" data-value-separator="<?php echo $service_report->complaint->displayValueSeparatorAttribute() ?>" id="x_complaint" name="x_complaint"<?php echo $service_report->complaint->editAttributes() ?>>
		<?php echo $service_report->complaint->selectOptionListHtml("x_complaint") ?>
	</select>
</div>
<?php echo $service_report->complaint->Lookup->getParamTag("p_x_complaint") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->observation->Visible) { // observation ?>
	<div id="r_observation" class="form-group row">
		<label for="x_observation" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_observation"><?php echo $service_report->observation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_observation" id="z_observation" value="LIKE"></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->observation->cellAttributes() ?>>
			<span id="el_service_report_observation">
<input type="text" data-table="service_report" data-field="x_observation" name="x_observation" id="x_observation" maxlength="255" placeholder="<?php echo HtmlEncode($service_report->observation->getPlaceHolder()) ?>" value="<?php echo $service_report->observation->EditValue ?>"<?php echo $service_report->observation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->product_replaced->Visible) { // product_replaced ?>
	<div id="r_product_replaced" class="form-group row">
		<label class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_product_replaced"><?php echo $service_report->product_replaced->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_replaced" id="z_product_replaced" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->product_replaced->cellAttributes() ?>>
			<span id="el_service_report_product_replaced">
<div id="tp_x_product_replaced" class="ew-template"><input type="checkbox" class="form-check-input" data-table="service_report" data-field="x_product_replaced" data-value-separator="<?php echo $service_report->product_replaced->displayValueSeparatorAttribute() ?>" name="x_product_replaced[]" id="x_product_replaced[]" value="{value}"<?php echo $service_report->product_replaced->editAttributes() ?>></div>
<div id="dsl_x_product_replaced" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $service_report->product_replaced->checkBoxListHtml(FALSE, "x_product_replaced[]") ?>
</div></div>
<?php echo $service_report->product_replaced->Lookup->getParamTag("p_x_product_replaced") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->consumable_replaced->Visible) { // consumable_replaced ?>
	<div id="r_consumable_replaced" class="form-group row">
		<label class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_consumable_replaced"><?php echo $service_report->consumable_replaced->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_consumable_replaced" id="z_consumable_replaced" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->consumable_replaced->cellAttributes() ?>>
			<span id="el_service_report_consumable_replaced">
<div id="tp_x_consumable_replaced" class="ew-template"><input type="checkbox" class="form-check-input" data-table="service_report" data-field="x_consumable_replaced" data-value-separator="<?php echo $service_report->consumable_replaced->displayValueSeparatorAttribute() ?>" name="x_consumable_replaced[]" id="x_consumable_replaced[]" value="{value}"<?php echo $service_report->consumable_replaced->editAttributes() ?>></div>
<div id="dsl_x_consumable_replaced" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $service_report->consumable_replaced->checkBoxListHtml(FALSE, "x_consumable_replaced[]") ?>
</div></div>
<?php echo $service_report->consumable_replaced->Lookup->getParamTag("p_x_consumable_replaced") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->out_time->Visible) { // out_time ?>
	<div id="r_out_time" class="form-group row">
		<label for="x_out_time" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_out_time"><?php echo $service_report->out_time->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_out_time" id="z_out_time" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->out_time->cellAttributes() ?>>
			<span id="el_service_report_out_time">
<input type="text" data-table="service_report" data-field="x_out_time" name="x_out_time" id="x_out_time" placeholder="<?php echo HtmlEncode($service_report->out_time->getPlaceHolder()) ?>" value="<?php echo $service_report->out_time->EditValue ?>"<?php echo $service_report->out_time->editAttributes() ?>>
<?php if (!$service_report->out_time->ReadOnly && !$service_report->out_time->Disabled && !isset($service_report->out_time->EditAttrs["readonly"]) && !isset($service_report->out_time->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fservice_reportsearch", "x_out_time", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->work_detail->Visible) { // work_detail ?>
	<div id="r_work_detail" class="form-group row">
		<label for="x_work_detail" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_work_detail"><?php echo $service_report->work_detail->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_work_detail" id="z_work_detail" value="LIKE"></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->work_detail->cellAttributes() ?>>
			<span id="el_service_report_work_detail">
<input type="text" data-table="service_report" data-field="x_work_detail" name="x_work_detail" id="x_work_detail" maxlength="255" placeholder="<?php echo HtmlEncode($service_report->work_detail->getPlaceHolder()) ?>" value="<?php echo $service_report->work_detail->EditValue ?>"<?php echo $service_report->work_detail->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->future_task->Visible) { // future_task ?>
	<div id="r_future_task" class="form-group row">
		<label for="x_future_task" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_future_task"><?php echo $service_report->future_task->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_future_task" id="z_future_task" value="LIKE"></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->future_task->cellAttributes() ?>>
			<span id="el_service_report_future_task">
<input type="text" data-table="service_report" data-field="x_future_task" name="x_future_task" id="x_future_task" size="35" placeholder="<?php echo HtmlEncode($service_report->future_task->getPlaceHolder()) ?>" value="<?php echo $service_report->future_task->EditValue ?>"<?php echo $service_report->future_task->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->last_status->Visible) { // last_status ?>
	<div id="r_last_status" class="form-group row">
		<label for="x_last_status" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_last_status"><?php echo $service_report->last_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_last_status" id="z_last_status" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->last_status->cellAttributes() ?>>
			<span id="el_service_report_last_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_report" data-field="x_last_status" data-value-separator="<?php echo $service_report->last_status->displayValueSeparatorAttribute() ?>" id="x_last_status" name="x_last_status"<?php echo $service_report->last_status->editAttributes() ?>>
		<?php echo $service_report->last_status->selectOptionListHtml("x_last_status") ?>
	</select>
</div>
<?php echo $service_report->last_status->Lookup->getParamTag("p_x_last_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_operator"><?php echo $service_report->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->operator->cellAttributes() ?>>
			<span id="el_service_report_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_report" data-field="x_operator" data-value-separator="<?php echo $service_report->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $service_report->operator->editAttributes() ?>>
		<?php echo $service_report->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $service_report->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_datetime"><?php echo $service_report->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->datetime->cellAttributes() ?>>
			<span id="el_service_report_datetime">
<input type="text" data-table="service_report" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($service_report->datetime->getPlaceHolder()) ?>" value="<?php echo $service_report->datetime->EditValue ?>"<?php echo $service_report->datetime->editAttributes() ?>>
<?php if (!$service_report->datetime->ReadOnly && !$service_report->datetime->Disabled && !isset($service_report->datetime->EditAttrs["readonly"]) && !isset($service_report->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fservice_reportsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label for="x_a_operator" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_a_operator"><?php echo $service_report->a_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_operator" id="z_a_operator" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->a_operator->cellAttributes() ?>>
			<span id="el_service_report_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_report" data-field="x_a_operator" data-value-separator="<?php echo $service_report->a_operator->displayValueSeparatorAttribute() ?>" id="x_a_operator" name="x_a_operator"<?php echo $service_report->a_operator->editAttributes() ?>>
		<?php echo $service_report->a_operator->selectOptionListHtml("x_a_operator") ?>
	</select>
</div>
<?php echo $service_report->a_operator->Lookup->getParamTag("p_x_a_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->invoice->Visible) { // invoice ?>
	<div id="r_invoice" class="form-group row">
		<label for="x_invoice" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_invoice"><?php echo $service_report->invoice->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_invoice" id="z_invoice" value="LIKE"></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->invoice->cellAttributes() ?>>
			<span id="el_service_report_invoice">
<input type="text" data-table="service_report" data-field="x_invoice" name="x_invoice" id="x_invoice" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($service_report->invoice->getPlaceHolder()) ?>" value="<?php echo $service_report->invoice->EditValue ?>"<?php echo $service_report->invoice->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->invoice_date->Visible) { // invoice_date ?>
	<div id="r_invoice_date" class="form-group row">
		<label for="x_invoice_date" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_invoice_date"><?php echo $service_report->invoice_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_invoice_date" id="z_invoice_date" value="="></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->invoice_date->cellAttributes() ?>>
			<span id="el_service_report_invoice_date">
<input type="text" data-table="service_report" data-field="x_invoice_date" name="x_invoice_date" id="x_invoice_date" placeholder="<?php echo HtmlEncode($service_report->invoice_date->getPlaceHolder()) ?>" value="<?php echo $service_report->invoice_date->EditValue ?>"<?php echo $service_report->invoice_date->editAttributes() ?>>
<?php if (!$service_report->invoice_date->ReadOnly && !$service_report->invoice_date->Disabled && !isset($service_report->invoice_date->EditAttrs["readonly"]) && !isset($service_report->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fservice_reportsearch", "x_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_report->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label for="x_uploads" class="<?php echo $service_report_search->LeftColumnClass ?>"><span id="elh_service_report_uploads"><?php echo $service_report->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $service_report_search->RightColumnClass ?>"><div<?php echo $service_report->uploads->cellAttributes() ?>>
			<span id="el_service_report_uploads">
<input type="text" data-table="service_report" data-field="x_uploads" name="x_uploads" id="x_uploads" size="35" placeholder="<?php echo HtmlEncode($service_report->uploads->getPlaceHolder()) ?>" value="<?php echo $service_report->uploads->EditValue ?>"<?php echo $service_report->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$service_report_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $service_report_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$service_report_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$service_report_search->terminate();
?>