<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$service_report_view = new service_report_view();

// Run the page
$service_report_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$service_report_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$service_report->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fservice_reportview = currentForm = new ew.Form("fservice_reportview", "view");

// Form_CustomValidate event
fservice_reportview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fservice_reportview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fservice_reportview.lists["x_buyer_id"] = <?php echo $service_report_view->buyer_id->Lookup->toClientList() ?>;
fservice_reportview.lists["x_buyer_id"].options = <?php echo JsonEncode($service_report_view->buyer_id->lookupOptions()) ?>;
fservice_reportview.autoSuggests["x_buyer_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fservice_reportview.lists["x_hardware_id"] = <?php echo $service_report_view->hardware_id->Lookup->toClientList() ?>;
fservice_reportview.lists["x_hardware_id"].options = <?php echo JsonEncode($service_report_view->hardware_id->lookupOptions()) ?>;
fservice_reportview.lists["x_service_executive"] = <?php echo $service_report_view->service_executive->Lookup->toClientList() ?>;
fservice_reportview.lists["x_service_executive"].options = <?php echo JsonEncode($service_report_view->service_executive->lookupOptions()) ?>;
fservice_reportview.autoSuggests["x_service_executive"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fservice_reportview.lists["x_error_ref"] = <?php echo $service_report_view->error_ref->Lookup->toClientList() ?>;
fservice_reportview.lists["x_error_ref"].options = <?php echo JsonEncode($service_report_view->error_ref->lookupOptions()) ?>;
fservice_reportview.lists["x_service_type"] = <?php echo $service_report_view->service_type->Lookup->toClientList() ?>;
fservice_reportview.lists["x_service_type"].options = <?php echo JsonEncode($service_report_view->service_type->lookupOptions()) ?>;
fservice_reportview.lists["x_complaint"] = <?php echo $service_report_view->complaint->Lookup->toClientList() ?>;
fservice_reportview.lists["x_complaint"].options = <?php echo JsonEncode($service_report_view->complaint->lookupOptions()) ?>;
fservice_reportview.lists["x_product_replaced[]"] = <?php echo $service_report_view->product_replaced->Lookup->toClientList() ?>;
fservice_reportview.lists["x_product_replaced[]"].options = <?php echo JsonEncode($service_report_view->product_replaced->lookupOptions()) ?>;
fservice_reportview.lists["x_consumable_replaced[]"] = <?php echo $service_report_view->consumable_replaced->Lookup->toClientList() ?>;
fservice_reportview.lists["x_consumable_replaced[]"].options = <?php echo JsonEncode($service_report_view->consumable_replaced->lookupOptions()) ?>;
fservice_reportview.lists["x_last_status"] = <?php echo $service_report_view->last_status->Lookup->toClientList() ?>;
fservice_reportview.lists["x_last_status"].options = <?php echo JsonEncode($service_report_view->last_status->lookupOptions()) ?>;
fservice_reportview.lists["x_a_operator"] = <?php echo $service_report_view->a_operator->Lookup->toClientList() ?>;
fservice_reportview.lists["x_a_operator"].options = <?php echo JsonEncode($service_report_view->a_operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$service_report->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $service_report_view->ExportOptions->render("body") ?>
<?php $service_report_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $service_report_view->showPageHeader(); ?>
<?php
$service_report_view->showMessage();
?>
<form name="fservice_reportview" id="fservice_reportview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($service_report_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $service_report_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="service_report">
<input type="hidden" name="modal" value="<?php echo (int)$service_report_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($service_report->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_id"><?php echo $service_report->id->caption() ?></span></td>
		<td data-name="id"<?php echo $service_report->id->cellAttributes() ?>>
<span id="el_service_report_id">
<span<?php echo $service_report->id->viewAttributes() ?>>
<?php echo $service_report->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->buyer_id->Visible) { // buyer_id ?>
	<tr id="r_buyer_id">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_buyer_id"><?php echo $service_report->buyer_id->caption() ?></span></td>
		<td data-name="buyer_id"<?php echo $service_report->buyer_id->cellAttributes() ?>>
<span id="el_service_report_buyer_id">
<span<?php echo $service_report->buyer_id->viewAttributes() ?>>
<?php echo $service_report->buyer_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->hardware_id->Visible) { // hardware_id ?>
	<tr id="r_hardware_id">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_hardware_id"><?php echo $service_report->hardware_id->caption() ?></span></td>
		<td data-name="hardware_id"<?php echo $service_report->hardware_id->cellAttributes() ?>>
<span id="el_service_report_hardware_id">
<span<?php echo $service_report->hardware_id->viewAttributes() ?>>
<?php echo $service_report->hardware_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->service_executive->Visible) { // service_executive ?>
	<tr id="r_service_executive">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_service_executive"><?php echo $service_report->service_executive->caption() ?></span></td>
		<td data-name="service_executive"<?php echo $service_report->service_executive->cellAttributes() ?>>
<span id="el_service_report_service_executive">
<span<?php echo $service_report->service_executive->viewAttributes() ?>>
<?php echo $service_report->service_executive->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->entry_time->Visible) { // entry_time ?>
	<tr id="r_entry_time">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_entry_time"><?php echo $service_report->entry_time->caption() ?></span></td>
		<td data-name="entry_time"<?php echo $service_report->entry_time->cellAttributes() ?>>
<span id="el_service_report_entry_time">
<span<?php echo $service_report->entry_time->viewAttributes() ?>>
<?php echo $service_report->entry_time->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->current_reading->Visible) { // current_reading ?>
	<tr id="r_current_reading">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_current_reading"><?php echo $service_report->current_reading->caption() ?></span></td>
		<td data-name="current_reading"<?php echo $service_report->current_reading->cellAttributes() ?>>
<span id="el_service_report_current_reading">
<span<?php echo $service_report->current_reading->viewAttributes() ?>>
<?php echo $service_report->current_reading->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->error_ref->Visible) { // error_ref ?>
	<tr id="r_error_ref">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_error_ref"><?php echo $service_report->error_ref->caption() ?></span></td>
		<td data-name="error_ref"<?php echo $service_report->error_ref->cellAttributes() ?>>
<span id="el_service_report_error_ref">
<span<?php echo $service_report->error_ref->viewAttributes() ?>>
<?php echo $service_report->error_ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->service_type->Visible) { // service_type ?>
	<tr id="r_service_type">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_service_type"><?php echo $service_report->service_type->caption() ?></span></td>
		<td data-name="service_type"<?php echo $service_report->service_type->cellAttributes() ?>>
<span id="el_service_report_service_type">
<span<?php echo $service_report->service_type->viewAttributes() ?>>
<?php echo $service_report->service_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->complaint->Visible) { // complaint ?>
	<tr id="r_complaint">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_complaint"><?php echo $service_report->complaint->caption() ?></span></td>
		<td data-name="complaint"<?php echo $service_report->complaint->cellAttributes() ?>>
<span id="el_service_report_complaint">
<span<?php echo $service_report->complaint->viewAttributes() ?>>
<?php echo $service_report->complaint->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->observation->Visible) { // observation ?>
	<tr id="r_observation">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_observation"><?php echo $service_report->observation->caption() ?></span></td>
		<td data-name="observation"<?php echo $service_report->observation->cellAttributes() ?>>
<span id="el_service_report_observation">
<span<?php echo $service_report->observation->viewAttributes() ?>>
<?php echo $service_report->observation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->product_replaced->Visible) { // product_replaced ?>
	<tr id="r_product_replaced">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_product_replaced"><?php echo $service_report->product_replaced->caption() ?></span></td>
		<td data-name="product_replaced"<?php echo $service_report->product_replaced->cellAttributes() ?>>
<span id="el_service_report_product_replaced">
<span<?php echo $service_report->product_replaced->viewAttributes() ?>>
<?php echo $service_report->product_replaced->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->consumable_replaced->Visible) { // consumable_replaced ?>
	<tr id="r_consumable_replaced">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_consumable_replaced"><?php echo $service_report->consumable_replaced->caption() ?></span></td>
		<td data-name="consumable_replaced"<?php echo $service_report->consumable_replaced->cellAttributes() ?>>
<span id="el_service_report_consumable_replaced">
<span<?php echo $service_report->consumable_replaced->viewAttributes() ?>>
<?php echo $service_report->consumable_replaced->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->out_time->Visible) { // out_time ?>
	<tr id="r_out_time">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_out_time"><?php echo $service_report->out_time->caption() ?></span></td>
		<td data-name="out_time"<?php echo $service_report->out_time->cellAttributes() ?>>
<span id="el_service_report_out_time">
<span<?php echo $service_report->out_time->viewAttributes() ?>>
<?php echo $service_report->out_time->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->work_detail->Visible) { // work_detail ?>
	<tr id="r_work_detail">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_work_detail"><?php echo $service_report->work_detail->caption() ?></span></td>
		<td data-name="work_detail"<?php echo $service_report->work_detail->cellAttributes() ?>>
<span id="el_service_report_work_detail">
<span<?php echo $service_report->work_detail->viewAttributes() ?>>
<?php echo $service_report->work_detail->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->future_task->Visible) { // future_task ?>
	<tr id="r_future_task">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_future_task"><?php echo $service_report->future_task->caption() ?></span></td>
		<td data-name="future_task"<?php echo $service_report->future_task->cellAttributes() ?>>
<span id="el_service_report_future_task">
<span<?php echo $service_report->future_task->viewAttributes() ?>>
<?php echo $service_report->future_task->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->last_status->Visible) { // last_status ?>
	<tr id="r_last_status">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_last_status"><?php echo $service_report->last_status->caption() ?></span></td>
		<td data-name="last_status"<?php echo $service_report->last_status->cellAttributes() ?>>
<span id="el_service_report_last_status">
<span<?php echo $service_report->last_status->viewAttributes() ?>>
<?php echo $service_report->last_status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_datetime"><?php echo $service_report->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $service_report->datetime->cellAttributes() ?>>
<span id="el_service_report_datetime">
<span<?php echo $service_report->datetime->viewAttributes() ?>>
<?php echo $service_report->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->a_operator->Visible) { // a_operator ?>
	<tr id="r_a_operator">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_a_operator"><?php echo $service_report->a_operator->caption() ?></span></td>
		<td data-name="a_operator"<?php echo $service_report->a_operator->cellAttributes() ?>>
<span id="el_service_report_a_operator">
<span<?php echo $service_report->a_operator->viewAttributes() ?>>
<?php echo $service_report->a_operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->invoice->Visible) { // invoice ?>
	<tr id="r_invoice">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_invoice"><?php echo $service_report->invoice->caption() ?></span></td>
		<td data-name="invoice"<?php echo $service_report->invoice->cellAttributes() ?>>
<span id="el_service_report_invoice">
<span<?php echo $service_report->invoice->viewAttributes() ?>>
<?php echo $service_report->invoice->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->invoice_date->Visible) { // invoice_date ?>
	<tr id="r_invoice_date">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_invoice_date"><?php echo $service_report->invoice_date->caption() ?></span></td>
		<td data-name="invoice_date"<?php echo $service_report->invoice_date->cellAttributes() ?>>
<span id="el_service_report_invoice_date">
<span<?php echo $service_report->invoice_date->viewAttributes() ?>>
<?php echo $service_report->invoice_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_report->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $service_report_view->TableLeftColumnClass ?>"><span id="elh_service_report_uploads"><?php echo $service_report->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $service_report->uploads->cellAttributes() ?>>
<span id="el_service_report_uploads">
<span<?php echo $service_report->uploads->viewAttributes() ?>>
<?php echo $service_report->uploads->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$service_report_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$service_report->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var HI = $('#x_hardware_id').val();
		document.cookie = "HI="+HI;
		if (HI.length > 0)
		{
		$('#errorh').remove();
		$.getJSON("apcajax_tc.php?clientlastdata="+HI,function(data){
			$("#r_hardware_id").append('<span style="color:red" id="errorh">'+data+'</span>')
		});
		}
</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$service_report_view->terminate();
?>