<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$service_request_add = new service_request_add();

// Run the page
$service_request_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$service_request_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fservice_requestadd = currentForm = new ew.Form("fservice_requestadd", "add");

// Validate form
fservice_requestadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($service_request_add->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_request->buyer_id->caption(), $service_request->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_request_add->product_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_product_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_request->product_ref->caption(), $service_request->product_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_request_add->current_reading->Required) { ?>
			elm = this.getElements("x" + infix + "_current_reading");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_request->current_reading->caption(), $service_request->current_reading->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_current_reading");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($service_request->current_reading->errorMessage()) ?>");
		<?php if ($service_request_add->product_status->Required) { ?>
			elm = this.getElements("x" + infix + "_product_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_request->product_status->caption(), $service_request->product_status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_request_add->error->Required) { ?>
			elm = this.getElements("x" + infix + "_error");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_request->error->caption(), $service_request->error->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_request_add->query_by->Required) { ?>
			elm = this.getElements("x" + infix + "_query_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_request->query_by->caption(), $service_request->query_by->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_request_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_request->operator->caption(), $service_request->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_request_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_request->datetime->caption(), $service_request->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($service_request_add->master_reading->Required) { ?>
			elm = this.getElements("x" + infix + "_master_reading");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $service_request->master_reading->caption(), $service_request->master_reading->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_master_reading");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($service_request->master_reading->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fservice_requestadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fservice_requestadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fservice_requestadd.lists["x_buyer_id"] = <?php echo $service_request_add->buyer_id->Lookup->toClientList() ?>;
fservice_requestadd.lists["x_buyer_id"].options = <?php echo JsonEncode($service_request_add->buyer_id->lookupOptions()) ?>;
fservice_requestadd.autoSuggests["x_buyer_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fservice_requestadd.lists["x_product_ref"] = <?php echo $service_request_add->product_ref->Lookup->toClientList() ?>;
fservice_requestadd.lists["x_product_ref"].options = <?php echo JsonEncode($service_request_add->product_ref->lookupOptions()) ?>;
fservice_requestadd.lists["x_product_status"] = <?php echo $service_request_add->product_status->Lookup->toClientList() ?>;
fservice_requestadd.lists["x_product_status"].options = <?php echo JsonEncode($service_request_add->product_status->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $service_request_add->showPageHeader(); ?>
<?php
$service_request_add->showMessage();
?>
<form name="fservice_requestadd" id="fservice_requestadd" class="<?php echo $service_request_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($service_request_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $service_request_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="service_request">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$service_request_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($service_request->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label id="elh_service_request_buyer_id" class="<?php echo $service_request_add->LeftColumnClass ?>"><?php echo $service_request->buyer_id->caption() ?><?php echo ($service_request->buyer_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_request_add->RightColumnClass ?>"><div<?php echo $service_request->buyer_id->cellAttributes() ?>>
<span id="el_service_request_buyer_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$service_request->buyer_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$service_request->buyer_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer_id" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer_id" id="sv_x_buyer_id" value="<?php echo RemoveHtml($service_request->buyer_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($service_request->buyer_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($service_request->buyer_id->getPlaceHolder()) ?>"<?php echo $service_request->buyer_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($service_request->buyer_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($service_request->buyer_id->ReadOnly || $service_request->buyer_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$service_request->buyer_id->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_buyer_id" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $service_request->buyer_id->caption() ?>" data-title="<?php echo $service_request->buyer_id->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_buyer_id',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="service_request" data-field="x_buyer_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $service_request->buyer_id->displayValueSeparatorAttribute() ?>" name="x_buyer_id" id="x_buyer_id" value="<?php echo HtmlEncode($service_request->buyer_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fservice_requestadd.createAutoSuggest({"id":"x_buyer_id","forceSelect":true});
</script>
<?php echo $service_request->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
<?php echo $service_request->buyer_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_request->product_ref->Visible) { // product_ref ?>
	<div id="r_product_ref" class="form-group row">
		<label id="elh_service_request_product_ref" for="x_product_ref" class="<?php echo $service_request_add->LeftColumnClass ?>"><?php echo $service_request->product_ref->caption() ?><?php echo ($service_request->product_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_request_add->RightColumnClass ?>"><div<?php echo $service_request->product_ref->cellAttributes() ?>>
<span id="el_service_request_product_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_request" data-field="x_product_ref" data-value-separator="<?php echo $service_request->product_ref->displayValueSeparatorAttribute() ?>" id="x_product_ref" name="x_product_ref"<?php echo $service_request->product_ref->editAttributes() ?>>
		<?php echo $service_request->product_ref->selectOptionListHtml("x_product_ref") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "client_hardware_data") && !$service_request->product_ref->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_product_ref" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $service_request->product_ref->caption() ?>" data-title="<?php echo $service_request->product_ref->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_product_ref',url:'client_hardware_dataaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $service_request->product_ref->Lookup->getParamTag("p_x_product_ref") ?>
</span>
<?php echo $service_request->product_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_request->current_reading->Visible) { // current_reading ?>
	<div id="r_current_reading" class="form-group row">
		<label id="elh_service_request_current_reading" for="x_current_reading" class="<?php echo $service_request_add->LeftColumnClass ?>"><?php echo $service_request->current_reading->caption() ?><?php echo ($service_request->current_reading->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_request_add->RightColumnClass ?>"><div<?php echo $service_request->current_reading->cellAttributes() ?>>
<span id="el_service_request_current_reading">
<input type="text" data-table="service_request" data-field="x_current_reading" name="x_current_reading" id="x_current_reading" size="30" placeholder="<?php echo HtmlEncode($service_request->current_reading->getPlaceHolder()) ?>" value="<?php echo $service_request->current_reading->EditValue ?>"<?php echo $service_request->current_reading->editAttributes() ?>>
</span>
<?php echo $service_request->current_reading->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_request->product_status->Visible) { // product_status ?>
	<div id="r_product_status" class="form-group row">
		<label id="elh_service_request_product_status" for="x_product_status" class="<?php echo $service_request_add->LeftColumnClass ?>"><?php echo $service_request->product_status->caption() ?><?php echo ($service_request->product_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_request_add->RightColumnClass ?>"><div<?php echo $service_request->product_status->cellAttributes() ?>>
<span id="el_service_request_product_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_request" data-field="x_product_status" data-value-separator="<?php echo $service_request->product_status->displayValueSeparatorAttribute() ?>" id="x_product_status" name="x_product_status"<?php echo $service_request->product_status->editAttributes() ?>>
		<?php echo $service_request->product_status->selectOptionListHtml("x_product_status") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "service_misc") && !$service_request->product_status->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_product_status" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $service_request->product_status->caption() ?>" data-title="<?php echo $service_request->product_status->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_product_status',url:'service_miscaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $service_request->product_status->Lookup->getParamTag("p_x_product_status") ?>
</span>
<?php echo $service_request->product_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_request->error->Visible) { // error ?>
	<div id="r_error" class="form-group row">
		<label id="elh_service_request_error" for="x_error" class="<?php echo $service_request_add->LeftColumnClass ?>"><?php echo $service_request->error->caption() ?><?php echo ($service_request->error->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_request_add->RightColumnClass ?>"><div<?php echo $service_request->error->cellAttributes() ?>>
<span id="el_service_request_error">
<textarea data-table="service_request" data-field="x_error" name="x_error" id="x_error" cols="35" rows="4" placeholder="<?php echo HtmlEncode($service_request->error->getPlaceHolder()) ?>"<?php echo $service_request->error->editAttributes() ?>><?php echo $service_request->error->EditValue ?></textarea>
</span>
<?php echo $service_request->error->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_request->query_by->Visible) { // query_by ?>
	<div id="r_query_by" class="form-group row">
		<label id="elh_service_request_query_by" for="x_query_by" class="<?php echo $service_request_add->LeftColumnClass ?>"><?php echo $service_request->query_by->caption() ?><?php echo ($service_request->query_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_request_add->RightColumnClass ?>"><div<?php echo $service_request->query_by->cellAttributes() ?>>
<span id="el_service_request_query_by">
<input type="text" data-table="service_request" data-field="x_query_by" name="x_query_by" id="x_query_by" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($service_request->query_by->getPlaceHolder()) ?>" value="<?php echo $service_request->query_by->EditValue ?>"<?php echo $service_request->query_by->editAttributes() ?>>
</span>
<?php echo $service_request->query_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($service_request->master_reading->Visible) { // master_reading ?>
	<div id="r_master_reading" class="form-group row">
		<label id="elh_service_request_master_reading" for="x_master_reading" class="<?php echo $service_request_add->LeftColumnClass ?>"><?php echo $service_request->master_reading->caption() ?><?php echo ($service_request->master_reading->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $service_request_add->RightColumnClass ?>"><div<?php echo $service_request->master_reading->cellAttributes() ?>>
<span id="el_service_request_master_reading">
<input type="text" data-table="service_request" data-field="x_master_reading" name="x_master_reading" id="x_master_reading" size="30" placeholder="<?php echo HtmlEncode($service_request->master_reading->getPlaceHolder()) ?>" value="<?php echo $service_request->master_reading->EditValue ?>"<?php echo $service_request->master_reading->editAttributes() ?>>
</span>
<?php echo $service_request->master_reading->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$service_request_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $service_request_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $service_request_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$service_request_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$service_request_add->terminate();
?>