<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$service_request_list = new service_request_list();

// Run the page
$service_request_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$service_request_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$service_request->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fservice_requestlist = currentForm = new ew.Form("fservice_requestlist", "list");
fservice_requestlist.formKeyCountName = '<?php echo $service_request_list->FormKeyCountName ?>';

// Form_CustomValidate event
fservice_requestlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fservice_requestlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fservice_requestlist.lists["x_status"] = <?php echo $service_request_list->status->Lookup->toClientList() ?>;
fservice_requestlist.lists["x_status"].options = <?php echo JsonEncode($service_request_list->status->options(FALSE, TRUE)) ?>;
fservice_requestlist.lists["x_buyer_id"] = <?php echo $service_request_list->buyer_id->Lookup->toClientList() ?>;
fservice_requestlist.lists["x_buyer_id"].options = <?php echo JsonEncode($service_request_list->buyer_id->lookupOptions()) ?>;
fservice_requestlist.autoSuggests["x_buyer_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fservice_requestlist.lists["x_product_ref"] = <?php echo $service_request_list->product_ref->Lookup->toClientList() ?>;
fservice_requestlist.lists["x_product_ref"].options = <?php echo JsonEncode($service_request_list->product_ref->lookupOptions()) ?>;
fservice_requestlist.lists["x_product_status"] = <?php echo $service_request_list->product_status->Lookup->toClientList() ?>;
fservice_requestlist.lists["x_product_status"].options = <?php echo JsonEncode($service_request_list->product_status->lookupOptions()) ?>;
fservice_requestlist.lists["x_last_serve_by"] = <?php echo $service_request_list->last_serve_by->Lookup->toClientList() ?>;
fservice_requestlist.lists["x_last_serve_by"].options = <?php echo JsonEncode($service_request_list->last_serve_by->lookupOptions()) ?>;
fservice_requestlist.lists["x_service_executive"] = <?php echo $service_request_list->service_executive->Lookup->toClientList() ?>;
fservice_requestlist.lists["x_service_executive"].options = <?php echo JsonEncode($service_request_list->service_executive->lookupOptions()) ?>;

// Form object for search
var fservice_requestlistsrch = currentSearchForm = new ew.Form("fservice_requestlistsrch");

// Filters
fservice_requestlistsrch.filterList = <?php echo $service_request_list->getFilterList() ?>;

// Init search panel as collapsed
fservice_requestlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$service_request->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($service_request_list->TotalRecs > 0 && $service_request_list->ExportOptions->visible()) { ?>
<?php $service_request_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($service_request_list->ImportOptions->visible()) { ?>
<?php $service_request_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($service_request_list->SearchOptions->visible()) { ?>
<?php $service_request_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($service_request_list->FilterOptions->visible()) { ?>
<?php $service_request_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$service_request_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$service_request->isExport() && !$service_request->CurrentAction) { ?>
<form name="fservice_requestlistsrch" id="fservice_requestlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($service_request_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fservice_requestlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="service_request">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($service_request_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($service_request_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $service_request_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($service_request_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($service_request_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($service_request_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($service_request_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $service_request_list->showPageHeader(); ?>
<?php
$service_request_list->showMessage();
?>
<?php if ($service_request_list->TotalRecs > 0 || $service_request->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($service_request_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> service_request">
<?php if (!$service_request->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$service_request->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($service_request_list->Pager)) $service_request_list->Pager = new PrevNextPager($service_request_list->StartRec, $service_request_list->DisplayRecs, $service_request_list->TotalRecs, $service_request_list->AutoHidePager) ?>
<?php if ($service_request_list->Pager->RecordCount > 0 && $service_request_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($service_request_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $service_request_list->pageUrl() ?>start=<?php echo $service_request_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($service_request_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $service_request_list->pageUrl() ?>start=<?php echo $service_request_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $service_request_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($service_request_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $service_request_list->pageUrl() ?>start=<?php echo $service_request_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($service_request_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $service_request_list->pageUrl() ?>start=<?php echo $service_request_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $service_request_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($service_request_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $service_request_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $service_request_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $service_request_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($service_request_list->TotalRecs > 0 && (!$service_request_list->AutoHidePageSizeSelector || $service_request_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="service_request">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($service_request_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($service_request_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($service_request_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($service_request_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($service_request_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($service_request->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $service_request_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fservice_requestlist" id="fservice_requestlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($service_request_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $service_request_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="service_request">
<div id="gmp_service_request" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($service_request_list->TotalRecs > 0 || $service_request->isGridEdit()) { ?>
<table id="tbl_service_requestlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$service_request_list->RowType = ROWTYPE_HEADER;

// Render list options
$service_request_list->renderListOptions();

// Render list options (header, left)
$service_request_list->ListOptions->render("header", "left");
?>
<?php if ($service_request->id->Visible) { // id ?>
	<?php if ($service_request->sortUrl($service_request->id) == "") { ?>
		<th data-name="id" class="<?php echo $service_request->id->headerCellClass() ?>"><div id="elh_service_request_id" class="service_request_id"><div class="ew-table-header-caption"><?php echo $service_request->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $service_request->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->id) ?>',2);"><div id="elh_service_request_id" class="service_request_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->status->Visible) { // status ?>
	<?php if ($service_request->sortUrl($service_request->status) == "") { ?>
		<th data-name="status" class="<?php echo $service_request->status->headerCellClass() ?>"><div id="elh_service_request_status" class="service_request_status"><div class="ew-table-header-caption"><?php echo $service_request->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $service_request->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->status) ?>',2);"><div id="elh_service_request_status" class="service_request_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->buyer_id->Visible) { // buyer_id ?>
	<?php if ($service_request->sortUrl($service_request->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $service_request->buyer_id->headerCellClass() ?>"><div id="elh_service_request_buyer_id" class="service_request_buyer_id"><div class="ew-table-header-caption"><?php echo $service_request->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $service_request->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->buyer_id) ?>',2);"><div id="elh_service_request_buyer_id" class="service_request_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->product_ref->Visible) { // product_ref ?>
	<?php if ($service_request->sortUrl($service_request->product_ref) == "") { ?>
		<th data-name="product_ref" class="<?php echo $service_request->product_ref->headerCellClass() ?>"><div id="elh_service_request_product_ref" class="service_request_product_ref"><div class="ew-table-header-caption"><?php echo $service_request->product_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_ref" class="<?php echo $service_request->product_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->product_ref) ?>',2);"><div id="elh_service_request_product_ref" class="service_request_product_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->product_ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->product_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->product_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->current_reading->Visible) { // current_reading ?>
	<?php if ($service_request->sortUrl($service_request->current_reading) == "") { ?>
		<th data-name="current_reading" class="<?php echo $service_request->current_reading->headerCellClass() ?>"><div id="elh_service_request_current_reading" class="service_request_current_reading"><div class="ew-table-header-caption"><?php echo $service_request->current_reading->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_reading" class="<?php echo $service_request->current_reading->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->current_reading) ?>',2);"><div id="elh_service_request_current_reading" class="service_request_current_reading">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->current_reading->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->current_reading->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->current_reading->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->product_status->Visible) { // product_status ?>
	<?php if ($service_request->sortUrl($service_request->product_status) == "") { ?>
		<th data-name="product_status" class="<?php echo $service_request->product_status->headerCellClass() ?>"><div id="elh_service_request_product_status" class="service_request_product_status"><div class="ew-table-header-caption"><?php echo $service_request->product_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_status" class="<?php echo $service_request->product_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->product_status) ?>',2);"><div id="elh_service_request_product_status" class="service_request_product_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->product_status->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->product_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->product_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->last_serve->Visible) { // last_serve ?>
	<?php if ($service_request->sortUrl($service_request->last_serve) == "") { ?>
		<th data-name="last_serve" class="<?php echo $service_request->last_serve->headerCellClass() ?>"><div id="elh_service_request_last_serve" class="service_request_last_serve"><div class="ew-table-header-caption"><?php echo $service_request->last_serve->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="last_serve" class="<?php echo $service_request->last_serve->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->last_serve) ?>',2);"><div id="elh_service_request_last_serve" class="service_request_last_serve">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->last_serve->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->last_serve->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->last_serve->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->last_serve_by->Visible) { // last_serve_by ?>
	<?php if ($service_request->sortUrl($service_request->last_serve_by) == "") { ?>
		<th data-name="last_serve_by" class="<?php echo $service_request->last_serve_by->headerCellClass() ?>"><div id="elh_service_request_last_serve_by" class="service_request_last_serve_by"><div class="ew-table-header-caption"><?php echo $service_request->last_serve_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="last_serve_by" class="<?php echo $service_request->last_serve_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->last_serve_by) ?>',2);"><div id="elh_service_request_last_serve_by" class="service_request_last_serve_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->last_serve_by->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->last_serve_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->last_serve_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->query_by->Visible) { // query_by ?>
	<?php if ($service_request->sortUrl($service_request->query_by) == "") { ?>
		<th data-name="query_by" class="<?php echo $service_request->query_by->headerCellClass() ?>"><div id="elh_service_request_query_by" class="service_request_query_by"><div class="ew-table-header-caption"><?php echo $service_request->query_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="query_by" class="<?php echo $service_request->query_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->query_by) ?>',2);"><div id="elh_service_request_query_by" class="service_request_query_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->query_by->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($service_request->query_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->query_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->service_executive->Visible) { // service_executive ?>
	<?php if ($service_request->sortUrl($service_request->service_executive) == "") { ?>
		<th data-name="service_executive" class="<?php echo $service_request->service_executive->headerCellClass() ?>"><div id="elh_service_request_service_executive" class="service_request_service_executive"><div class="ew-table-header-caption"><?php echo $service_request->service_executive->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="service_executive" class="<?php echo $service_request->service_executive->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->service_executive) ?>',2);"><div id="elh_service_request_service_executive" class="service_request_service_executive">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->service_executive->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->service_executive->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->service_executive->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->operator->Visible) { // operator ?>
	<?php if ($service_request->sortUrl($service_request->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $service_request->operator->headerCellClass() ?>"><div id="elh_service_request_operator" class="service_request_operator"><div class="ew-table-header-caption"><?php echo $service_request->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $service_request->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->operator) ?>',2);"><div id="elh_service_request_operator" class="service_request_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->datetime->Visible) { // datetime ?>
	<?php if ($service_request->sortUrl($service_request->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $service_request->datetime->headerCellClass() ?>"><div id="elh_service_request_datetime" class="service_request_datetime"><div class="ew-table-header-caption"><?php echo $service_request->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $service_request->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->datetime) ?>',2);"><div id="elh_service_request_datetime" class="service_request_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->o_operator->Visible) { // o_operator ?>
	<?php if ($service_request->sortUrl($service_request->o_operator) == "") { ?>
		<th data-name="o_operator" class="<?php echo $service_request->o_operator->headerCellClass() ?>"><div id="elh_service_request_o_operator" class="service_request_o_operator"><div class="ew-table-header-caption"><?php echo $service_request->o_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="o_operator" class="<?php echo $service_request->o_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->o_operator) ?>',2);"><div id="elh_service_request_o_operator" class="service_request_o_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->o_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->o_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->o_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->o_datetime->Visible) { // o_datetime ?>
	<?php if ($service_request->sortUrl($service_request->o_datetime) == "") { ?>
		<th data-name="o_datetime" class="<?php echo $service_request->o_datetime->headerCellClass() ?>"><div id="elh_service_request_o_datetime" class="service_request_o_datetime"><div class="ew-table-header-caption"><?php echo $service_request->o_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="o_datetime" class="<?php echo $service_request->o_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->o_datetime) ?>',2);"><div id="elh_service_request_o_datetime" class="service_request_o_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->o_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->o_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->o_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($service_request->master_reading->Visible) { // master_reading ?>
	<?php if ($service_request->sortUrl($service_request->master_reading) == "") { ?>
		<th data-name="master_reading" class="<?php echo $service_request->master_reading->headerCellClass() ?>"><div id="elh_service_request_master_reading" class="service_request_master_reading"><div class="ew-table-header-caption"><?php echo $service_request->master_reading->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="master_reading" class="<?php echo $service_request->master_reading->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $service_request->SortUrl($service_request->master_reading) ?>',2);"><div id="elh_service_request_master_reading" class="service_request_master_reading">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $service_request->master_reading->caption() ?></span><span class="ew-table-header-sort"><?php if ($service_request->master_reading->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($service_request->master_reading->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$service_request_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($service_request->ExportAll && $service_request->isExport()) {
	$service_request_list->StopRec = $service_request_list->TotalRecs;
} else {

	// Set the last record to display
	if ($service_request_list->TotalRecs > $service_request_list->StartRec + $service_request_list->DisplayRecs - 1)
		$service_request_list->StopRec = $service_request_list->StartRec + $service_request_list->DisplayRecs - 1;
	else
		$service_request_list->StopRec = $service_request_list->TotalRecs;
}
$service_request_list->RecCnt = $service_request_list->StartRec - 1;
if ($service_request_list->Recordset && !$service_request_list->Recordset->EOF) {
	$service_request_list->Recordset->moveFirst();
	$selectLimit = $service_request_list->UseSelectLimit;
	if (!$selectLimit && $service_request_list->StartRec > 1)
		$service_request_list->Recordset->move($service_request_list->StartRec - 1);
} elseif (!$service_request->AllowAddDeleteRow && $service_request_list->StopRec == 0) {
	$service_request_list->StopRec = $service_request->GridAddRowCount;
}

// Initialize aggregate
$service_request->RowType = ROWTYPE_AGGREGATEINIT;
$service_request->resetAttributes();
$service_request_list->renderRow();
while ($service_request_list->RecCnt < $service_request_list->StopRec) {
	$service_request_list->RecCnt++;
	if ($service_request_list->RecCnt >= $service_request_list->StartRec) {
		$service_request_list->RowCnt++;

		// Set up key count
		$service_request_list->KeyCount = $service_request_list->RowIndex;

		// Init row class and style
		$service_request->resetAttributes();
		$service_request->CssClass = "";
		if ($service_request->isGridAdd()) {
		} else {
			$service_request_list->loadRowValues($service_request_list->Recordset); // Load row values
		}
		$service_request->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$service_request->RowAttrs = array_merge($service_request->RowAttrs, array('data-rowindex'=>$service_request_list->RowCnt, 'id'=>'r' . $service_request_list->RowCnt . '_service_request', 'data-rowtype'=>$service_request->RowType));

		// Render row
		$service_request_list->renderRow();

		// Render list options
		$service_request_list->renderListOptions();
?>
	<tr<?php echo $service_request->rowAttributes() ?>>
<?php

// Render list options (body, left)
$service_request_list->ListOptions->render("body", "left", $service_request_list->RowCnt);
?>
	<?php if ($service_request->id->Visible) { // id ?>
		<td data-name="id"<?php echo $service_request->id->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_id" class="service_request_id">
<span<?php echo $service_request->id->viewAttributes() ?>>
<?php echo $service_request->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->status->Visible) { // status ?>
		<td data-name="status"<?php echo $service_request->status->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_status" class="service_request_status">
<span<?php echo $service_request->status->viewAttributes() ?>>
<?php echo $service_request->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $service_request->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_buyer_id" class="service_request_buyer_id">
<span<?php echo $service_request->buyer_id->viewAttributes() ?>>
<?php echo $service_request->buyer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->product_ref->Visible) { // product_ref ?>
		<td data-name="product_ref"<?php echo $service_request->product_ref->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_product_ref" class="service_request_product_ref">
<span<?php echo $service_request->product_ref->viewAttributes() ?>>
<?php echo $service_request->product_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->current_reading->Visible) { // current_reading ?>
		<td data-name="current_reading"<?php echo $service_request->current_reading->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_current_reading" class="service_request_current_reading">
<span<?php echo $service_request->current_reading->viewAttributes() ?>>
<?php echo $service_request->current_reading->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->product_status->Visible) { // product_status ?>
		<td data-name="product_status"<?php echo $service_request->product_status->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_product_status" class="service_request_product_status">
<span<?php echo $service_request->product_status->viewAttributes() ?>>
<?php echo $service_request->product_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->last_serve->Visible) { // last_serve ?>
		<td data-name="last_serve"<?php echo $service_request->last_serve->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_last_serve" class="service_request_last_serve">
<span<?php echo $service_request->last_serve->viewAttributes() ?>>
<?php echo $service_request->last_serve->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->last_serve_by->Visible) { // last_serve_by ?>
		<td data-name="last_serve_by"<?php echo $service_request->last_serve_by->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_last_serve_by" class="service_request_last_serve_by">
<span<?php echo $service_request->last_serve_by->viewAttributes() ?>>
<?php echo $service_request->last_serve_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->query_by->Visible) { // query_by ?>
		<td data-name="query_by"<?php echo $service_request->query_by->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_query_by" class="service_request_query_by">
<span<?php echo $service_request->query_by->viewAttributes() ?>>
<?php echo $service_request->query_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->service_executive->Visible) { // service_executive ?>
		<td data-name="service_executive"<?php echo $service_request->service_executive->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_service_executive" class="service_request_service_executive">
<span<?php echo $service_request->service_executive->viewAttributes() ?>>
<?php echo $service_request->service_executive->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $service_request->operator->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_operator" class="service_request_operator">
<span<?php echo $service_request->operator->viewAttributes() ?>>
<?php echo $service_request->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $service_request->datetime->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_datetime" class="service_request_datetime">
<span<?php echo $service_request->datetime->viewAttributes() ?>>
<?php echo $service_request->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->o_operator->Visible) { // o_operator ?>
		<td data-name="o_operator"<?php echo $service_request->o_operator->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_o_operator" class="service_request_o_operator">
<span<?php echo $service_request->o_operator->viewAttributes() ?>>
<?php echo $service_request->o_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->o_datetime->Visible) { // o_datetime ?>
		<td data-name="o_datetime"<?php echo $service_request->o_datetime->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_o_datetime" class="service_request_o_datetime">
<span<?php echo $service_request->o_datetime->viewAttributes() ?>>
<?php echo $service_request->o_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($service_request->master_reading->Visible) { // master_reading ?>
		<td data-name="master_reading"<?php echo $service_request->master_reading->cellAttributes() ?>>
<span id="el<?php echo $service_request_list->RowCnt ?>_service_request_master_reading" class="service_request_master_reading">
<span<?php echo $service_request->master_reading->viewAttributes() ?>>
<?php echo $service_request->master_reading->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$service_request_list->ListOptions->render("body", "right", $service_request_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$service_request->isGridAdd())
		$service_request_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$service_request->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($service_request_list->Recordset)
	$service_request_list->Recordset->Close();
?>
<?php if (!$service_request->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$service_request->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($service_request_list->Pager)) $service_request_list->Pager = new PrevNextPager($service_request_list->StartRec, $service_request_list->DisplayRecs, $service_request_list->TotalRecs, $service_request_list->AutoHidePager) ?>
<?php if ($service_request_list->Pager->RecordCount > 0 && $service_request_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($service_request_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $service_request_list->pageUrl() ?>start=<?php echo $service_request_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($service_request_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $service_request_list->pageUrl() ?>start=<?php echo $service_request_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $service_request_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($service_request_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $service_request_list->pageUrl() ?>start=<?php echo $service_request_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($service_request_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $service_request_list->pageUrl() ?>start=<?php echo $service_request_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $service_request_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($service_request_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $service_request_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $service_request_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $service_request_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($service_request_list->TotalRecs > 0 && (!$service_request_list->AutoHidePageSizeSelector || $service_request_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="service_request">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($service_request_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($service_request_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($service_request_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($service_request_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($service_request_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($service_request->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $service_request_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($service_request_list->TotalRecs == 0 && !$service_request->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $service_request_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$service_request_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$service_request->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$service_request->isExport()) { ?>
<script>
ew.scrollableTable("gmp_service_request", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$service_request_list->terminate();
?>