<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$service_request_search = new service_request_search();

// Run the page
$service_request_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$service_request_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($service_request_search->IsModal) { ?>
var fservice_requestsearch = currentAdvancedSearchForm = new ew.Form("fservice_requestsearch", "search");
<?php } else { ?>
var fservice_requestsearch = currentForm = new ew.Form("fservice_requestsearch", "search");
<?php } ?>

// Form_CustomValidate event
fservice_requestsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fservice_requestsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fservice_requestsearch.lists["x_status"] = <?php echo $service_request_search->status->Lookup->toClientList() ?>;
fservice_requestsearch.lists["x_status"].options = <?php echo JsonEncode($service_request_search->status->options(FALSE, TRUE)) ?>;
fservice_requestsearch.lists["x_buyer_id"] = <?php echo $service_request_search->buyer_id->Lookup->toClientList() ?>;
fservice_requestsearch.lists["x_buyer_id"].options = <?php echo JsonEncode($service_request_search->buyer_id->lookupOptions()) ?>;
fservice_requestsearch.autoSuggests["x_buyer_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fservice_requestsearch.lists["x_product_ref"] = <?php echo $service_request_search->product_ref->Lookup->toClientList() ?>;
fservice_requestsearch.lists["x_product_ref"].options = <?php echo JsonEncode($service_request_search->product_ref->lookupOptions()) ?>;
fservice_requestsearch.lists["x_product_status"] = <?php echo $service_request_search->product_status->Lookup->toClientList() ?>;
fservice_requestsearch.lists["x_product_status"].options = <?php echo JsonEncode($service_request_search->product_status->lookupOptions()) ?>;
fservice_requestsearch.lists["x_last_serve_by"] = <?php echo $service_request_search->last_serve_by->Lookup->toClientList() ?>;
fservice_requestsearch.lists["x_last_serve_by"].options = <?php echo JsonEncode($service_request_search->last_serve_by->lookupOptions()) ?>;
fservice_requestsearch.lists["x_service_executive"] = <?php echo $service_request_search->service_executive->Lookup->toClientList() ?>;
fservice_requestsearch.lists["x_service_executive"].options = <?php echo JsonEncode($service_request_search->service_executive->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fservice_requestsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_request->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_current_reading");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_request->current_reading->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_last_serve");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_request->last_serve->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_request->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_request->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_o_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_request->o_operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_o_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_request->o_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_master_reading");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($service_request->master_reading->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $service_request_search->showPageHeader(); ?>
<?php
$service_request_search->showMessage();
?>
<form name="fservice_requestsearch" id="fservice_requestsearch" class="<?php echo $service_request_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($service_request_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $service_request_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="service_request">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$service_request_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($service_request->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_id"><?php echo $service_request->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->id->cellAttributes() ?>>
			<span id="el_service_request_id">
<input type="text" data-table="service_request" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($service_request->id->getPlaceHolder()) ?>" value="<?php echo $service_request->id->EditValue ?>"<?php echo $service_request->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_status"><?php echo $service_request->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->status->cellAttributes() ?>>
			<span id="el_service_request_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_request" data-field="x_status" data-value-separator="<?php echo $service_request->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $service_request->status->editAttributes() ?>>
		<?php echo $service_request->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_buyer_id"><?php echo $service_request->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->buyer_id->cellAttributes() ?>>
			<span id="el_service_request_buyer_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$service_request->buyer_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$service_request->buyer_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer_id" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer_id" id="sv_x_buyer_id" value="<?php echo RemoveHtml($service_request->buyer_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($service_request->buyer_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($service_request->buyer_id->getPlaceHolder()) ?>"<?php echo $service_request->buyer_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($service_request->buyer_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer_id',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($service_request->buyer_id->ReadOnly || $service_request->buyer_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="service_request" data-field="x_buyer_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $service_request->buyer_id->displayValueSeparatorAttribute() ?>" name="x_buyer_id" id="x_buyer_id" value="<?php echo HtmlEncode($service_request->buyer_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fservice_requestsearch.createAutoSuggest({"id":"x_buyer_id","forceSelect":false});
</script>
<?php echo $service_request->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->product_ref->Visible) { // product_ref ?>
	<div id="r_product_ref" class="form-group row">
		<label for="x_product_ref" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_product_ref"><?php echo $service_request->product_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_ref" id="z_product_ref" value="="></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->product_ref->cellAttributes() ?>>
			<span id="el_service_request_product_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_request" data-field="x_product_ref" data-value-separator="<?php echo $service_request->product_ref->displayValueSeparatorAttribute() ?>" id="x_product_ref" name="x_product_ref"<?php echo $service_request->product_ref->editAttributes() ?>>
		<?php echo $service_request->product_ref->selectOptionListHtml("x_product_ref") ?>
	</select>
</div>
<?php echo $service_request->product_ref->Lookup->getParamTag("p_x_product_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->current_reading->Visible) { // current_reading ?>
	<div id="r_current_reading" class="form-group row">
		<label for="x_current_reading" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_current_reading"><?php echo $service_request->current_reading->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_reading" id="z_current_reading" value="="></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->current_reading->cellAttributes() ?>>
			<span id="el_service_request_current_reading">
<input type="text" data-table="service_request" data-field="x_current_reading" name="x_current_reading" id="x_current_reading" size="30" placeholder="<?php echo HtmlEncode($service_request->current_reading->getPlaceHolder()) ?>" value="<?php echo $service_request->current_reading->EditValue ?>"<?php echo $service_request->current_reading->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->product_status->Visible) { // product_status ?>
	<div id="r_product_status" class="form-group row">
		<label for="x_product_status" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_product_status"><?php echo $service_request->product_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_status" id="z_product_status" value="LIKE"></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->product_status->cellAttributes() ?>>
			<span id="el_service_request_product_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_request" data-field="x_product_status" data-value-separator="<?php echo $service_request->product_status->displayValueSeparatorAttribute() ?>" id="x_product_status" name="x_product_status"<?php echo $service_request->product_status->editAttributes() ?>>
		<?php echo $service_request->product_status->selectOptionListHtml("x_product_status") ?>
	</select>
</div>
<?php echo $service_request->product_status->Lookup->getParamTag("p_x_product_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->error->Visible) { // error ?>
	<div id="r_error" class="form-group row">
		<label for="x_error" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_error"><?php echo $service_request->error->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_error" id="z_error" value="LIKE"></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->error->cellAttributes() ?>>
			<span id="el_service_request_error">
<input type="text" data-table="service_request" data-field="x_error" name="x_error" id="x_error" size="35" placeholder="<?php echo HtmlEncode($service_request->error->getPlaceHolder()) ?>" value="<?php echo $service_request->error->EditValue ?>"<?php echo $service_request->error->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->last_serve->Visible) { // last_serve ?>
	<div id="r_last_serve" class="form-group row">
		<label for="x_last_serve" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_last_serve"><?php echo $service_request->last_serve->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_last_serve" id="z_last_serve" value="="></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->last_serve->cellAttributes() ?>>
			<span id="el_service_request_last_serve">
<input type="text" data-table="service_request" data-field="x_last_serve" name="x_last_serve" id="x_last_serve" placeholder="<?php echo HtmlEncode($service_request->last_serve->getPlaceHolder()) ?>" value="<?php echo $service_request->last_serve->EditValue ?>"<?php echo $service_request->last_serve->editAttributes() ?>>
<?php if (!$service_request->last_serve->ReadOnly && !$service_request->last_serve->Disabled && !isset($service_request->last_serve->EditAttrs["readonly"]) && !isset($service_request->last_serve->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fservice_requestsearch", "x_last_serve", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->last_serve_by->Visible) { // last_serve_by ?>
	<div id="r_last_serve_by" class="form-group row">
		<label for="x_last_serve_by" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_last_serve_by"><?php echo $service_request->last_serve_by->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_last_serve_by" id="z_last_serve_by" value="="></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->last_serve_by->cellAttributes() ?>>
			<span id="el_service_request_last_serve_by">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_request" data-field="x_last_serve_by" data-value-separator="<?php echo $service_request->last_serve_by->displayValueSeparatorAttribute() ?>" id="x_last_serve_by" name="x_last_serve_by"<?php echo $service_request->last_serve_by->editAttributes() ?>>
		<?php echo $service_request->last_serve_by->selectOptionListHtml("x_last_serve_by") ?>
	</select>
</div>
<?php echo $service_request->last_serve_by->Lookup->getParamTag("p_x_last_serve_by") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->query_by->Visible) { // query_by ?>
	<div id="r_query_by" class="form-group row">
		<label for="x_query_by" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_query_by"><?php echo $service_request->query_by->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_query_by" id="z_query_by" value="LIKE"></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->query_by->cellAttributes() ?>>
			<span id="el_service_request_query_by">
<input type="text" data-table="service_request" data-field="x_query_by" name="x_query_by" id="x_query_by" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($service_request->query_by->getPlaceHolder()) ?>" value="<?php echo $service_request->query_by->EditValue ?>"<?php echo $service_request->query_by->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->service_executive->Visible) { // service_executive ?>
	<div id="r_service_executive" class="form-group row">
		<label for="x_service_executive" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_service_executive"><?php echo $service_request->service_executive->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_service_executive" id="z_service_executive" value="="></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->service_executive->cellAttributes() ?>>
			<span id="el_service_request_service_executive">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="service_request" data-field="x_service_executive" data-value-separator="<?php echo $service_request->service_executive->displayValueSeparatorAttribute() ?>" id="x_service_executive" name="x_service_executive"<?php echo $service_request->service_executive->editAttributes() ?>>
		<?php echo $service_request->service_executive->selectOptionListHtml("x_service_executive") ?>
	</select>
</div>
<?php echo $service_request->service_executive->Lookup->getParamTag("p_x_service_executive") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->Ins_service_executive->Visible) { // Ins_service_executive ?>
	<div id="r_Ins_service_executive" class="form-group row">
		<label for="x_Ins_service_executive" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_Ins_service_executive"><?php echo $service_request->Ins_service_executive->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Ins_service_executive" id="z_Ins_service_executive" value="LIKE"></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->Ins_service_executive->cellAttributes() ?>>
			<span id="el_service_request_Ins_service_executive">
<input type="text" data-table="service_request" data-field="x_Ins_service_executive" name="x_Ins_service_executive" id="x_Ins_service_executive" size="35" placeholder="<?php echo HtmlEncode($service_request->Ins_service_executive->getPlaceHolder()) ?>" value="<?php echo $service_request->Ins_service_executive->EditValue ?>"<?php echo $service_request->Ins_service_executive->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_operator"><?php echo $service_request->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->operator->cellAttributes() ?>>
			<span id="el_service_request_operator">
<input type="text" data-table="service_request" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($service_request->operator->getPlaceHolder()) ?>" value="<?php echo $service_request->operator->EditValue ?>"<?php echo $service_request->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_datetime"><?php echo $service_request->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->datetime->cellAttributes() ?>>
			<span id="el_service_request_datetime">
<input type="text" data-table="service_request" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($service_request->datetime->getPlaceHolder()) ?>" value="<?php echo $service_request->datetime->EditValue ?>"<?php echo $service_request->datetime->editAttributes() ?>>
<?php if (!$service_request->datetime->ReadOnly && !$service_request->datetime->Disabled && !isset($service_request->datetime->EditAttrs["readonly"]) && !isset($service_request->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fservice_requestsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->o_operator->Visible) { // o_operator ?>
	<div id="r_o_operator" class="form-group row">
		<label for="x_o_operator" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_o_operator"><?php echo $service_request->o_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_o_operator" id="z_o_operator" value="="></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->o_operator->cellAttributes() ?>>
			<span id="el_service_request_o_operator">
<input type="text" data-table="service_request" data-field="x_o_operator" name="x_o_operator" id="x_o_operator" size="30" placeholder="<?php echo HtmlEncode($service_request->o_operator->getPlaceHolder()) ?>" value="<?php echo $service_request->o_operator->EditValue ?>"<?php echo $service_request->o_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->o_datetime->Visible) { // o_datetime ?>
	<div id="r_o_datetime" class="form-group row">
		<label for="x_o_datetime" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_o_datetime"><?php echo $service_request->o_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_o_datetime" id="z_o_datetime" value="="></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->o_datetime->cellAttributes() ?>>
			<span id="el_service_request_o_datetime">
<input type="text" data-table="service_request" data-field="x_o_datetime" name="x_o_datetime" id="x_o_datetime" placeholder="<?php echo HtmlEncode($service_request->o_datetime->getPlaceHolder()) ?>" value="<?php echo $service_request->o_datetime->EditValue ?>"<?php echo $service_request->o_datetime->editAttributes() ?>>
<?php if (!$service_request->o_datetime->ReadOnly && !$service_request->o_datetime->Disabled && !isset($service_request->o_datetime->EditAttrs["readonly"]) && !isset($service_request->o_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fservice_requestsearch", "x_o_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($service_request->master_reading->Visible) { // master_reading ?>
	<div id="r_master_reading" class="form-group row">
		<label for="x_master_reading" class="<?php echo $service_request_search->LeftColumnClass ?>"><span id="elh_service_request_master_reading"><?php echo $service_request->master_reading->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_master_reading" id="z_master_reading" value="="></span>
		</label>
		<div class="<?php echo $service_request_search->RightColumnClass ?>"><div<?php echo $service_request->master_reading->cellAttributes() ?>>
			<span id="el_service_request_master_reading">
<input type="text" data-table="service_request" data-field="x_master_reading" name="x_master_reading" id="x_master_reading" size="30" placeholder="<?php echo HtmlEncode($service_request->master_reading->getPlaceHolder()) ?>" value="<?php echo $service_request->master_reading->EditValue ?>"<?php echo $service_request->master_reading->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$service_request_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $service_request_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$service_request_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$service_request_search->terminate();
?>