<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$service_request_view = new service_request_view();

// Run the page
$service_request_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$service_request_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$service_request->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fservice_requestview = currentForm = new ew.Form("fservice_requestview", "view");

// Form_CustomValidate event
fservice_requestview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fservice_requestview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fservice_requestview.lists["x_status"] = <?php echo $service_request_view->status->Lookup->toClientList() ?>;
fservice_requestview.lists["x_status"].options = <?php echo JsonEncode($service_request_view->status->options(FALSE, TRUE)) ?>;
fservice_requestview.lists["x_buyer_id"] = <?php echo $service_request_view->buyer_id->Lookup->toClientList() ?>;
fservice_requestview.lists["x_buyer_id"].options = <?php echo JsonEncode($service_request_view->buyer_id->lookupOptions()) ?>;
fservice_requestview.autoSuggests["x_buyer_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fservice_requestview.lists["x_product_ref"] = <?php echo $service_request_view->product_ref->Lookup->toClientList() ?>;
fservice_requestview.lists["x_product_ref"].options = <?php echo JsonEncode($service_request_view->product_ref->lookupOptions()) ?>;
fservice_requestview.lists["x_product_status"] = <?php echo $service_request_view->product_status->Lookup->toClientList() ?>;
fservice_requestview.lists["x_product_status"].options = <?php echo JsonEncode($service_request_view->product_status->lookupOptions()) ?>;
fservice_requestview.lists["x_last_serve_by"] = <?php echo $service_request_view->last_serve_by->Lookup->toClientList() ?>;
fservice_requestview.lists["x_last_serve_by"].options = <?php echo JsonEncode($service_request_view->last_serve_by->lookupOptions()) ?>;
fservice_requestview.lists["x_service_executive"] = <?php echo $service_request_view->service_executive->Lookup->toClientList() ?>;
fservice_requestview.lists["x_service_executive"].options = <?php echo JsonEncode($service_request_view->service_executive->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$service_request->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $service_request_view->ExportOptions->render("body") ?>
<?php $service_request_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $service_request_view->showPageHeader(); ?>
<?php
$service_request_view->showMessage();
?>
<form name="fservice_requestview" id="fservice_requestview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($service_request_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $service_request_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="service_request">
<input type="hidden" name="modal" value="<?php echo (int)$service_request_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($service_request->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_id"><?php echo $service_request->id->caption() ?></span></td>
		<td data-name="id"<?php echo $service_request->id->cellAttributes() ?>>
<span id="el_service_request_id">
<span<?php echo $service_request->id->viewAttributes() ?>>
<?php echo $service_request->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_status"><?php echo $service_request->status->caption() ?></span></td>
		<td data-name="status"<?php echo $service_request->status->cellAttributes() ?>>
<span id="el_service_request_status">
<span<?php echo $service_request->status->viewAttributes() ?>>
<?php echo $service_request->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->buyer_id->Visible) { // buyer_id ?>
	<tr id="r_buyer_id">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_buyer_id"><?php echo $service_request->buyer_id->caption() ?></span></td>
		<td data-name="buyer_id"<?php echo $service_request->buyer_id->cellAttributes() ?>>
<span id="el_service_request_buyer_id">
<span<?php echo $service_request->buyer_id->viewAttributes() ?>>
<?php echo $service_request->buyer_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->product_ref->Visible) { // product_ref ?>
	<tr id="r_product_ref">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_product_ref"><?php echo $service_request->product_ref->caption() ?></span></td>
		<td data-name="product_ref"<?php echo $service_request->product_ref->cellAttributes() ?>>
<span id="el_service_request_product_ref">
<span<?php echo $service_request->product_ref->viewAttributes() ?>>
<?php echo $service_request->product_ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->current_reading->Visible) { // current_reading ?>
	<tr id="r_current_reading">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_current_reading"><?php echo $service_request->current_reading->caption() ?></span></td>
		<td data-name="current_reading"<?php echo $service_request->current_reading->cellAttributes() ?>>
<span id="el_service_request_current_reading">
<span<?php echo $service_request->current_reading->viewAttributes() ?>>
<?php echo $service_request->current_reading->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->product_status->Visible) { // product_status ?>
	<tr id="r_product_status">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_product_status"><?php echo $service_request->product_status->caption() ?></span></td>
		<td data-name="product_status"<?php echo $service_request->product_status->cellAttributes() ?>>
<span id="el_service_request_product_status">
<span<?php echo $service_request->product_status->viewAttributes() ?>>
<?php echo $service_request->product_status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->error->Visible) { // error ?>
	<tr id="r_error">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_error"><?php echo $service_request->error->caption() ?></span></td>
		<td data-name="error"<?php echo $service_request->error->cellAttributes() ?>>
<span id="el_service_request_error">
<span<?php echo $service_request->error->viewAttributes() ?>>
<?php echo $service_request->error->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->last_serve->Visible) { // last_serve ?>
	<tr id="r_last_serve">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_last_serve"><?php echo $service_request->last_serve->caption() ?></span></td>
		<td data-name="last_serve"<?php echo $service_request->last_serve->cellAttributes() ?>>
<span id="el_service_request_last_serve">
<span<?php echo $service_request->last_serve->viewAttributes() ?>>
<?php echo $service_request->last_serve->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->last_serve_by->Visible) { // last_serve_by ?>
	<tr id="r_last_serve_by">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_last_serve_by"><?php echo $service_request->last_serve_by->caption() ?></span></td>
		<td data-name="last_serve_by"<?php echo $service_request->last_serve_by->cellAttributes() ?>>
<span id="el_service_request_last_serve_by">
<span<?php echo $service_request->last_serve_by->viewAttributes() ?>>
<?php echo $service_request->last_serve_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->query_by->Visible) { // query_by ?>
	<tr id="r_query_by">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_query_by"><?php echo $service_request->query_by->caption() ?></span></td>
		<td data-name="query_by"<?php echo $service_request->query_by->cellAttributes() ?>>
<span id="el_service_request_query_by">
<span<?php echo $service_request->query_by->viewAttributes() ?>>
<?php echo $service_request->query_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->service_executive->Visible) { // service_executive ?>
	<tr id="r_service_executive">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_service_executive"><?php echo $service_request->service_executive->caption() ?></span></td>
		<td data-name="service_executive"<?php echo $service_request->service_executive->cellAttributes() ?>>
<span id="el_service_request_service_executive">
<span<?php echo $service_request->service_executive->viewAttributes() ?>>
<?php echo $service_request->service_executive->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->Ins_service_executive->Visible) { // Ins_service_executive ?>
	<tr id="r_Ins_service_executive">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_Ins_service_executive"><?php echo $service_request->Ins_service_executive->caption() ?></span></td>
		<td data-name="Ins_service_executive"<?php echo $service_request->Ins_service_executive->cellAttributes() ?>>
<span id="el_service_request_Ins_service_executive">
<span<?php echo $service_request->Ins_service_executive->viewAttributes() ?>>
<?php echo $service_request->Ins_service_executive->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_operator"><?php echo $service_request->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $service_request->operator->cellAttributes() ?>>
<span id="el_service_request_operator">
<span<?php echo $service_request->operator->viewAttributes() ?>>
<?php echo $service_request->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_datetime"><?php echo $service_request->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $service_request->datetime->cellAttributes() ?>>
<span id="el_service_request_datetime">
<span<?php echo $service_request->datetime->viewAttributes() ?>>
<?php echo $service_request->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->o_operator->Visible) { // o_operator ?>
	<tr id="r_o_operator">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_o_operator"><?php echo $service_request->o_operator->caption() ?></span></td>
		<td data-name="o_operator"<?php echo $service_request->o_operator->cellAttributes() ?>>
<span id="el_service_request_o_operator">
<span<?php echo $service_request->o_operator->viewAttributes() ?>>
<?php echo $service_request->o_operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->o_datetime->Visible) { // o_datetime ?>
	<tr id="r_o_datetime">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_o_datetime"><?php echo $service_request->o_datetime->caption() ?></span></td>
		<td data-name="o_datetime"<?php echo $service_request->o_datetime->cellAttributes() ?>>
<span id="el_service_request_o_datetime">
<span<?php echo $service_request->o_datetime->viewAttributes() ?>>
<?php echo $service_request->o_datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($service_request->master_reading->Visible) { // master_reading ?>
	<tr id="r_master_reading">
		<td class="<?php echo $service_request_view->TableLeftColumnClass ?>"><span id="elh_service_request_master_reading"><?php echo $service_request->master_reading->caption() ?></span></td>
		<td data-name="master_reading"<?php echo $service_request->master_reading->cellAttributes() ?>>
<span id="el_service_request_master_reading">
<span<?php echo $service_request->master_reading->viewAttributes() ?>>
<?php echo $service_request->master_reading->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$service_request_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$service_request->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$service_request_view->terminate();
?>