<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shade_type_add = new shade_type_add();

// Run the page
$shade_type_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shade_type_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fshade_typeadd = currentForm = new ew.Form("fshade_typeadd", "add");

// Validate form
fshade_typeadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($shade_type_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shade_type->name->caption(), $shade_type->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shade_type_add->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shade_type->code->caption(), $shade_type->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){4,4}$/))
				return this.onError(elm, "<?php echo JsEncode($shade_type->code->errorMessage()) ?>");
		<?php if ($shade_type_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shade_type->status->caption(), $shade_type->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shade_type_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shade_type->operator->caption(), $shade_type->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shade_type_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shade_type->datetime->caption(), $shade_type->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fshade_typeadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshade_typeadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshade_typeadd.lists["x_status"] = <?php echo $shade_type_add->status->Lookup->toClientList() ?>;
fshade_typeadd.lists["x_status"].options = <?php echo JsonEncode($shade_type_add->status->options(FALSE, TRUE)) ?>;
fshade_typeadd.lists["x_operator"] = <?php echo $shade_type_add->operator->Lookup->toClientList() ?>;
fshade_typeadd.lists["x_operator"].options = <?php echo JsonEncode($shade_type_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shade_type_add->showPageHeader(); ?>
<?php
$shade_type_add->showMessage();
?>
<form name="fshade_typeadd" id="fshade_typeadd" class="<?php echo $shade_type_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shade_type_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shade_type_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shade_type">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$shade_type_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($shade_type->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_shade_type_name" for="x_name" class="<?php echo $shade_type_add->LeftColumnClass ?>"><?php echo $shade_type->name->caption() ?><?php echo ($shade_type->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shade_type_add->RightColumnClass ?>"><div<?php echo $shade_type->name->cellAttributes() ?>>
<span id="el_shade_type_name">
<input type="text" data-table="shade_type" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($shade_type->name->getPlaceHolder()) ?>" value="<?php echo $shade_type->name->EditValue ?>"<?php echo $shade_type->name->editAttributes() ?>>
</span>
<?php echo $shade_type->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shade_type->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_shade_type_code" for="x_code" class="<?php echo $shade_type_add->LeftColumnClass ?>"><?php echo $shade_type->code->caption() ?><?php echo ($shade_type->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shade_type_add->RightColumnClass ?>"><div<?php echo $shade_type->code->cellAttributes() ?>>
<span id="el_shade_type_code">
<input type="text" data-table="shade_type" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($shade_type->code->getPlaceHolder()) ?>" value="<?php echo $shade_type->code->EditValue ?>"<?php echo $shade_type->code->editAttributes() ?>>
</span>
<?php echo $shade_type->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shade_type->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_shade_type_status" for="x_status" class="<?php echo $shade_type_add->LeftColumnClass ?>"><?php echo $shade_type->status->caption() ?><?php echo ($shade_type->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shade_type_add->RightColumnClass ?>"><div<?php echo $shade_type->status->cellAttributes() ?>>
<span id="el_shade_type_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shade_type" data-field="x_status" data-value-separator="<?php echo $shade_type->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $shade_type->status->editAttributes() ?>>
		<?php echo $shade_type->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $shade_type->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$shade_type_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $shade_type_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $shade_type_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$shade_type_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shade_type_add->terminate();
?>