<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shade_type_edit = new shade_type_edit();

// Run the page
$shade_type_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shade_type_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fshade_typeedit = currentForm = new ew.Form("fshade_typeedit", "edit");

// Validate form
fshade_typeedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($shade_type_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shade_type->id->caption(), $shade_type->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shade_type_edit->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shade_type->name->caption(), $shade_type->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shade_type_edit->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shade_type->code->caption(), $shade_type->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){4,4}$/))
				return this.onError(elm, "<?php echo JsEncode($shade_type->code->errorMessage()) ?>");
		<?php if ($shade_type_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shade_type->status->caption(), $shade_type->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shade_type_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shade_type->operator->caption(), $shade_type->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shade_type_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shade_type->datetime->caption(), $shade_type->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fshade_typeedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshade_typeedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshade_typeedit.lists["x_status"] = <?php echo $shade_type_edit->status->Lookup->toClientList() ?>;
fshade_typeedit.lists["x_status"].options = <?php echo JsonEncode($shade_type_edit->status->options(FALSE, TRUE)) ?>;
fshade_typeedit.lists["x_operator"] = <?php echo $shade_type_edit->operator->Lookup->toClientList() ?>;
fshade_typeedit.lists["x_operator"].options = <?php echo JsonEncode($shade_type_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shade_type_edit->showPageHeader(); ?>
<?php
$shade_type_edit->showMessage();
?>
<form name="fshade_typeedit" id="fshade_typeedit" class="<?php echo $shade_type_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shade_type_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shade_type_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shade_type">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$shade_type_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($shade_type->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_shade_type_id" class="<?php echo $shade_type_edit->LeftColumnClass ?>"><?php echo $shade_type->id->caption() ?><?php echo ($shade_type->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shade_type_edit->RightColumnClass ?>"><div<?php echo $shade_type->id->cellAttributes() ?>>
<span id="el_shade_type_id">
<span<?php echo $shade_type->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($shade_type->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="shade_type" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($shade_type->id->CurrentValue) ?>">
<?php echo $shade_type->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shade_type->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_shade_type_name" for="x_name" class="<?php echo $shade_type_edit->LeftColumnClass ?>"><?php echo $shade_type->name->caption() ?><?php echo ($shade_type->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shade_type_edit->RightColumnClass ?>"><div<?php echo $shade_type->name->cellAttributes() ?>>
<span id="el_shade_type_name">
<input type="text" data-table="shade_type" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($shade_type->name->getPlaceHolder()) ?>" value="<?php echo $shade_type->name->EditValue ?>"<?php echo $shade_type->name->editAttributes() ?>>
</span>
<?php echo $shade_type->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shade_type->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_shade_type_code" for="x_code" class="<?php echo $shade_type_edit->LeftColumnClass ?>"><?php echo $shade_type->code->caption() ?><?php echo ($shade_type->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shade_type_edit->RightColumnClass ?>"><div<?php echo $shade_type->code->cellAttributes() ?>>
<span id="el_shade_type_code">
<input type="text" data-table="shade_type" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($shade_type->code->getPlaceHolder()) ?>" value="<?php echo $shade_type->code->EditValue ?>"<?php echo $shade_type->code->editAttributes() ?>>
</span>
<?php echo $shade_type->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shade_type->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_shade_type_status" for="x_status" class="<?php echo $shade_type_edit->LeftColumnClass ?>"><?php echo $shade_type->status->caption() ?><?php echo ($shade_type->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shade_type_edit->RightColumnClass ?>"><div<?php echo $shade_type->status->cellAttributes() ?>>
<span id="el_shade_type_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shade_type" data-field="x_status" data-value-separator="<?php echo $shade_type->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $shade_type->status->editAttributes() ?>>
		<?php echo $shade_type->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $shade_type->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$shade_type_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $shade_type_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $shade_type_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$shade_type_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shade_type_edit->terminate();
?>