<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shade_type_list = new shade_type_list();

// Run the page
$shade_type_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shade_type_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$shade_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fshade_typelist = currentForm = new ew.Form("fshade_typelist", "list");
fshade_typelist.formKeyCountName = '<?php echo $shade_type_list->FormKeyCountName ?>';

// Form_CustomValidate event
fshade_typelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshade_typelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshade_typelist.lists["x_status"] = <?php echo $shade_type_list->status->Lookup->toClientList() ?>;
fshade_typelist.lists["x_status"].options = <?php echo JsonEncode($shade_type_list->status->options(FALSE, TRUE)) ?>;
fshade_typelist.lists["x_operator"] = <?php echo $shade_type_list->operator->Lookup->toClientList() ?>;
fshade_typelist.lists["x_operator"].options = <?php echo JsonEncode($shade_type_list->operator->lookupOptions()) ?>;

// Form object for search
var fshade_typelistsrch = currentSearchForm = new ew.Form("fshade_typelistsrch");

// Filters
fshade_typelistsrch.filterList = <?php echo $shade_type_list->getFilterList() ?>;

// Init search panel as collapsed
fshade_typelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$shade_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($shade_type_list->TotalRecs > 0 && $shade_type_list->ExportOptions->visible()) { ?>
<?php $shade_type_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($shade_type_list->ImportOptions->visible()) { ?>
<?php $shade_type_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($shade_type_list->SearchOptions->visible()) { ?>
<?php $shade_type_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($shade_type_list->FilterOptions->visible()) { ?>
<?php $shade_type_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$shade_type_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$shade_type->isExport() && !$shade_type->CurrentAction) { ?>
<form name="fshade_typelistsrch" id="fshade_typelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($shade_type_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fshade_typelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="shade_type">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($shade_type_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($shade_type_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $shade_type_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($shade_type_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($shade_type_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($shade_type_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($shade_type_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $shade_type_list->showPageHeader(); ?>
<?php
$shade_type_list->showMessage();
?>
<?php if ($shade_type_list->TotalRecs > 0 || $shade_type->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($shade_type_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> shade_type">
<?php if (!$shade_type->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$shade_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shade_type_list->Pager)) $shade_type_list->Pager = new PrevNextPager($shade_type_list->StartRec, $shade_type_list->DisplayRecs, $shade_type_list->TotalRecs, $shade_type_list->AutoHidePager) ?>
<?php if ($shade_type_list->Pager->RecordCount > 0 && $shade_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shade_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shade_type_list->pageUrl() ?>start=<?php echo $shade_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shade_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shade_type_list->pageUrl() ?>start=<?php echo $shade_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shade_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shade_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shade_type_list->pageUrl() ?>start=<?php echo $shade_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shade_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shade_type_list->pageUrl() ?>start=<?php echo $shade_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shade_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shade_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shade_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shade_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shade_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shade_type_list->TotalRecs > 0 && (!$shade_type_list->AutoHidePageSizeSelector || $shade_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shade_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shade_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shade_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shade_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shade_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shade_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shade_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shade_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fshade_typelist" id="fshade_typelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shade_type_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shade_type_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shade_type">
<div id="gmp_shade_type" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($shade_type_list->TotalRecs > 0 || $shade_type->isGridEdit()) { ?>
<table id="tbl_shade_typelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$shade_type_list->RowType = ROWTYPE_HEADER;

// Render list options
$shade_type_list->renderListOptions();

// Render list options (header, left)
$shade_type_list->ListOptions->render("header", "left");
?>
<?php if ($shade_type->id->Visible) { // id ?>
	<?php if ($shade_type->sortUrl($shade_type->id) == "") { ?>
		<th data-name="id" class="<?php echo $shade_type->id->headerCellClass() ?>"><div id="elh_shade_type_id" class="shade_type_id"><div class="ew-table-header-caption"><?php echo $shade_type->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $shade_type->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shade_type->SortUrl($shade_type->id) ?>',2);"><div id="elh_shade_type_id" class="shade_type_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shade_type->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($shade_type->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shade_type->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shade_type->name->Visible) { // name ?>
	<?php if ($shade_type->sortUrl($shade_type->name) == "") { ?>
		<th data-name="name" class="<?php echo $shade_type->name->headerCellClass() ?>"><div id="elh_shade_type_name" class="shade_type_name"><div class="ew-table-header-caption"><?php echo $shade_type->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $shade_type->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shade_type->SortUrl($shade_type->name) ?>',2);"><div id="elh_shade_type_name" class="shade_type_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shade_type->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shade_type->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shade_type->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shade_type->code->Visible) { // code ?>
	<?php if ($shade_type->sortUrl($shade_type->code) == "") { ?>
		<th data-name="code" class="<?php echo $shade_type->code->headerCellClass() ?>"><div id="elh_shade_type_code" class="shade_type_code"><div class="ew-table-header-caption"><?php echo $shade_type->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $shade_type->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shade_type->SortUrl($shade_type->code) ?>',2);"><div id="elh_shade_type_code" class="shade_type_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shade_type->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shade_type->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shade_type->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shade_type->status->Visible) { // status ?>
	<?php if ($shade_type->sortUrl($shade_type->status) == "") { ?>
		<th data-name="status" class="<?php echo $shade_type->status->headerCellClass() ?>"><div id="elh_shade_type_status" class="shade_type_status"><div class="ew-table-header-caption"><?php echo $shade_type->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $shade_type->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shade_type->SortUrl($shade_type->status) ?>',2);"><div id="elh_shade_type_status" class="shade_type_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shade_type->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($shade_type->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shade_type->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shade_type->operator->Visible) { // operator ?>
	<?php if ($shade_type->sortUrl($shade_type->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $shade_type->operator->headerCellClass() ?>"><div id="elh_shade_type_operator" class="shade_type_operator"><div class="ew-table-header-caption"><?php echo $shade_type->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $shade_type->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shade_type->SortUrl($shade_type->operator) ?>',2);"><div id="elh_shade_type_operator" class="shade_type_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shade_type->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($shade_type->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shade_type->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shade_type->datetime->Visible) { // datetime ?>
	<?php if ($shade_type->sortUrl($shade_type->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $shade_type->datetime->headerCellClass() ?>"><div id="elh_shade_type_datetime" class="shade_type_datetime"><div class="ew-table-header-caption"><?php echo $shade_type->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $shade_type->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shade_type->SortUrl($shade_type->datetime) ?>',2);"><div id="elh_shade_type_datetime" class="shade_type_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shade_type->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($shade_type->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shade_type->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$shade_type_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($shade_type->ExportAll && $shade_type->isExport()) {
	$shade_type_list->StopRec = $shade_type_list->TotalRecs;
} else {

	// Set the last record to display
	if ($shade_type_list->TotalRecs > $shade_type_list->StartRec + $shade_type_list->DisplayRecs - 1)
		$shade_type_list->StopRec = $shade_type_list->StartRec + $shade_type_list->DisplayRecs - 1;
	else
		$shade_type_list->StopRec = $shade_type_list->TotalRecs;
}
$shade_type_list->RecCnt = $shade_type_list->StartRec - 1;
if ($shade_type_list->Recordset && !$shade_type_list->Recordset->EOF) {
	$shade_type_list->Recordset->moveFirst();
	$selectLimit = $shade_type_list->UseSelectLimit;
	if (!$selectLimit && $shade_type_list->StartRec > 1)
		$shade_type_list->Recordset->move($shade_type_list->StartRec - 1);
} elseif (!$shade_type->AllowAddDeleteRow && $shade_type_list->StopRec == 0) {
	$shade_type_list->StopRec = $shade_type->GridAddRowCount;
}

// Initialize aggregate
$shade_type->RowType = ROWTYPE_AGGREGATEINIT;
$shade_type->resetAttributes();
$shade_type_list->renderRow();
while ($shade_type_list->RecCnt < $shade_type_list->StopRec) {
	$shade_type_list->RecCnt++;
	if ($shade_type_list->RecCnt >= $shade_type_list->StartRec) {
		$shade_type_list->RowCnt++;

		// Set up key count
		$shade_type_list->KeyCount = $shade_type_list->RowIndex;

		// Init row class and style
		$shade_type->resetAttributes();
		$shade_type->CssClass = "";
		if ($shade_type->isGridAdd()) {
		} else {
			$shade_type_list->loadRowValues($shade_type_list->Recordset); // Load row values
		}
		$shade_type->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$shade_type->RowAttrs = array_merge($shade_type->RowAttrs, array('data-rowindex'=>$shade_type_list->RowCnt, 'id'=>'r' . $shade_type_list->RowCnt . '_shade_type', 'data-rowtype'=>$shade_type->RowType));

		// Render row
		$shade_type_list->renderRow();

		// Render list options
		$shade_type_list->renderListOptions();
?>
	<tr<?php echo $shade_type->rowAttributes() ?>>
<?php

// Render list options (body, left)
$shade_type_list->ListOptions->render("body", "left", $shade_type_list->RowCnt);
?>
	<?php if ($shade_type->id->Visible) { // id ?>
		<td data-name="id"<?php echo $shade_type->id->cellAttributes() ?>>
<span id="el<?php echo $shade_type_list->RowCnt ?>_shade_type_id" class="shade_type_id">
<span<?php echo $shade_type->id->viewAttributes() ?>>
<?php echo $shade_type->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shade_type->name->Visible) { // name ?>
		<td data-name="name"<?php echo $shade_type->name->cellAttributes() ?>>
<span id="el<?php echo $shade_type_list->RowCnt ?>_shade_type_name" class="shade_type_name">
<span<?php echo $shade_type->name->viewAttributes() ?>>
<?php echo $shade_type->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shade_type->code->Visible) { // code ?>
		<td data-name="code"<?php echo $shade_type->code->cellAttributes() ?>>
<span id="el<?php echo $shade_type_list->RowCnt ?>_shade_type_code" class="shade_type_code">
<span<?php echo $shade_type->code->viewAttributes() ?>>
<?php echo $shade_type->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shade_type->status->Visible) { // status ?>
		<td data-name="status"<?php echo $shade_type->status->cellAttributes() ?>>
<span id="el<?php echo $shade_type_list->RowCnt ?>_shade_type_status" class="shade_type_status">
<span<?php echo $shade_type->status->viewAttributes() ?>>
<?php echo $shade_type->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shade_type->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $shade_type->operator->cellAttributes() ?>>
<span id="el<?php echo $shade_type_list->RowCnt ?>_shade_type_operator" class="shade_type_operator">
<span<?php echo $shade_type->operator->viewAttributes() ?>>
<?php echo $shade_type->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shade_type->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $shade_type->datetime->cellAttributes() ?>>
<span id="el<?php echo $shade_type_list->RowCnt ?>_shade_type_datetime" class="shade_type_datetime">
<span<?php echo $shade_type->datetime->viewAttributes() ?>>
<?php echo $shade_type->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$shade_type_list->ListOptions->render("body", "right", $shade_type_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$shade_type->isGridAdd())
		$shade_type_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$shade_type->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($shade_type_list->Recordset)
	$shade_type_list->Recordset->Close();
?>
<?php if (!$shade_type->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$shade_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shade_type_list->Pager)) $shade_type_list->Pager = new PrevNextPager($shade_type_list->StartRec, $shade_type_list->DisplayRecs, $shade_type_list->TotalRecs, $shade_type_list->AutoHidePager) ?>
<?php if ($shade_type_list->Pager->RecordCount > 0 && $shade_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shade_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shade_type_list->pageUrl() ?>start=<?php echo $shade_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shade_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shade_type_list->pageUrl() ?>start=<?php echo $shade_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shade_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shade_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shade_type_list->pageUrl() ?>start=<?php echo $shade_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shade_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shade_type_list->pageUrl() ?>start=<?php echo $shade_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shade_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shade_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shade_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shade_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shade_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shade_type_list->TotalRecs > 0 && (!$shade_type_list->AutoHidePageSizeSelector || $shade_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shade_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shade_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shade_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shade_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shade_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shade_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shade_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shade_type_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($shade_type_list->TotalRecs == 0 && !$shade_type->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $shade_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$shade_type_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$shade_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$shade_type->isExport()) { ?>
<script>
ew.scrollableTable("gmp_shade_type", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$shade_type_list->terminate();
?>