<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shade_type_view = new shade_type_view();

// Run the page
$shade_type_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shade_type_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$shade_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fshade_typeview = currentForm = new ew.Form("fshade_typeview", "view");

// Form_CustomValidate event
fshade_typeview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshade_typeview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshade_typeview.lists["x_status"] = <?php echo $shade_type_view->status->Lookup->toClientList() ?>;
fshade_typeview.lists["x_status"].options = <?php echo JsonEncode($shade_type_view->status->options(FALSE, TRUE)) ?>;
fshade_typeview.lists["x_operator"] = <?php echo $shade_type_view->operator->Lookup->toClientList() ?>;
fshade_typeview.lists["x_operator"].options = <?php echo JsonEncode($shade_type_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$shade_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $shade_type_view->ExportOptions->render("body") ?>
<?php $shade_type_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $shade_type_view->showPageHeader(); ?>
<?php
$shade_type_view->showMessage();
?>
<form name="fshade_typeview" id="fshade_typeview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shade_type_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shade_type_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shade_type">
<input type="hidden" name="modal" value="<?php echo (int)$shade_type_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($shade_type->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $shade_type_view->TableLeftColumnClass ?>"><span id="elh_shade_type_id"><?php echo $shade_type->id->caption() ?></span></td>
		<td data-name="id"<?php echo $shade_type->id->cellAttributes() ?>>
<span id="el_shade_type_id">
<span<?php echo $shade_type->id->viewAttributes() ?>>
<?php echo $shade_type->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shade_type->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $shade_type_view->TableLeftColumnClass ?>"><span id="elh_shade_type_name"><?php echo $shade_type->name->caption() ?></span></td>
		<td data-name="name"<?php echo $shade_type->name->cellAttributes() ?>>
<span id="el_shade_type_name">
<span<?php echo $shade_type->name->viewAttributes() ?>>
<?php echo $shade_type->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shade_type->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $shade_type_view->TableLeftColumnClass ?>"><span id="elh_shade_type_code"><?php echo $shade_type->code->caption() ?></span></td>
		<td data-name="code"<?php echo $shade_type->code->cellAttributes() ?>>
<span id="el_shade_type_code">
<span<?php echo $shade_type->code->viewAttributes() ?>>
<?php echo $shade_type->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shade_type->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $shade_type_view->TableLeftColumnClass ?>"><span id="elh_shade_type_status"><?php echo $shade_type->status->caption() ?></span></td>
		<td data-name="status"<?php echo $shade_type->status->cellAttributes() ?>>
<span id="el_shade_type_status">
<span<?php echo $shade_type->status->viewAttributes() ?>>
<?php echo $shade_type->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shade_type->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $shade_type_view->TableLeftColumnClass ?>"><span id="elh_shade_type_operator"><?php echo $shade_type->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $shade_type->operator->cellAttributes() ?>>
<span id="el_shade_type_operator">
<span<?php echo $shade_type->operator->viewAttributes() ?>>
<?php echo $shade_type->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shade_type->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $shade_type_view->TableLeftColumnClass ?>"><span id="elh_shade_type_datetime"><?php echo $shade_type->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $shade_type->datetime->cellAttributes() ?>>
<span id="el_shade_type_datetime">
<span<?php echo $shade_type->datetime->viewAttributes() ?>>
<?php echo $shade_type->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$shade_type_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$shade_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$shade_type_view->terminate();
?>