<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shape_edit = new shape_edit();

// Run the page
$shape_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shape_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fshapeedit = currentForm = new ew.Form("fshapeedit", "edit");

// Validate form
fshapeedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($shape_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shape->id->caption(), $shape->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shape_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shape->item->caption(), $shape->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shape_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shape->status->caption(), $shape->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shape_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shape->operator->caption(), $shape->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shape_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shape->datetime->caption(), $shape->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fshapeedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshapeedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshapeedit.lists["x_status"] = <?php echo $shape_edit->status->Lookup->toClientList() ?>;
fshapeedit.lists["x_status"].options = <?php echo JsonEncode($shape_edit->status->options(FALSE, TRUE)) ?>;
fshapeedit.lists["x_operator"] = <?php echo $shape_edit->operator->Lookup->toClientList() ?>;
fshapeedit.lists["x_operator"].options = <?php echo JsonEncode($shape_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shape_edit->showPageHeader(); ?>
<?php
$shape_edit->showMessage();
?>
<form name="fshapeedit" id="fshapeedit" class="<?php echo $shape_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shape_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shape_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shape">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$shape_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($shape->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_shape_id" class="<?php echo $shape_edit->LeftColumnClass ?>"><?php echo $shape->id->caption() ?><?php echo ($shape->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shape_edit->RightColumnClass ?>"><div<?php echo $shape->id->cellAttributes() ?>>
<span id="el_shape_id">
<span<?php echo $shape->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($shape->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="shape" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($shape->id->CurrentValue) ?>">
<?php echo $shape->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shape->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_shape_item" for="x_item" class="<?php echo $shape_edit->LeftColumnClass ?>"><?php echo $shape->item->caption() ?><?php echo ($shape->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shape_edit->RightColumnClass ?>"><div<?php echo $shape->item->cellAttributes() ?>>
<span id="el_shape_item">
<input type="text" data-table="shape" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($shape->item->getPlaceHolder()) ?>" value="<?php echo $shape->item->EditValue ?>"<?php echo $shape->item->editAttributes() ?>>
</span>
<?php echo $shape->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shape->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_shape_status" for="x_status" class="<?php echo $shape_edit->LeftColumnClass ?>"><?php echo $shape->status->caption() ?><?php echo ($shape->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shape_edit->RightColumnClass ?>"><div<?php echo $shape->status->cellAttributes() ?>>
<span id="el_shape_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shape" data-field="x_status" data-value-separator="<?php echo $shape->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $shape->status->editAttributes() ?>>
		<?php echo $shape->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $shape->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$shape_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $shape_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $shape_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$shape_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shape_edit->terminate();
?>