<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shape_list = new shape_list();

// Run the page
$shape_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shape_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$shape->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fshapelist = currentForm = new ew.Form("fshapelist", "list");
fshapelist.formKeyCountName = '<?php echo $shape_list->FormKeyCountName ?>';

// Form_CustomValidate event
fshapelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshapelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshapelist.lists["x_status"] = <?php echo $shape_list->status->Lookup->toClientList() ?>;
fshapelist.lists["x_status"].options = <?php echo JsonEncode($shape_list->status->options(FALSE, TRUE)) ?>;
fshapelist.lists["x_operator"] = <?php echo $shape_list->operator->Lookup->toClientList() ?>;
fshapelist.lists["x_operator"].options = <?php echo JsonEncode($shape_list->operator->lookupOptions()) ?>;

// Form object for search
var fshapelistsrch = currentSearchForm = new ew.Form("fshapelistsrch");

// Filters
fshapelistsrch.filterList = <?php echo $shape_list->getFilterList() ?>;

// Init search panel as collapsed
fshapelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$shape->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($shape_list->TotalRecs > 0 && $shape_list->ExportOptions->visible()) { ?>
<?php $shape_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($shape_list->ImportOptions->visible()) { ?>
<?php $shape_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($shape_list->SearchOptions->visible()) { ?>
<?php $shape_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($shape_list->FilterOptions->visible()) { ?>
<?php $shape_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$shape_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$shape->isExport() && !$shape->CurrentAction) { ?>
<form name="fshapelistsrch" id="fshapelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($shape_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fshapelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="shape">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($shape_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($shape_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $shape_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($shape_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($shape_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($shape_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($shape_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $shape_list->showPageHeader(); ?>
<?php
$shape_list->showMessage();
?>
<?php if ($shape_list->TotalRecs > 0 || $shape->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($shape_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> shape">
<?php if (!$shape->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$shape->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shape_list->Pager)) $shape_list->Pager = new PrevNextPager($shape_list->StartRec, $shape_list->DisplayRecs, $shape_list->TotalRecs, $shape_list->AutoHidePager) ?>
<?php if ($shape_list->Pager->RecordCount > 0 && $shape_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shape_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shape_list->pageUrl() ?>start=<?php echo $shape_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shape_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shape_list->pageUrl() ?>start=<?php echo $shape_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shape_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shape_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shape_list->pageUrl() ?>start=<?php echo $shape_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shape_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shape_list->pageUrl() ?>start=<?php echo $shape_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shape_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shape_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shape_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shape_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shape_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shape_list->TotalRecs > 0 && (!$shape_list->AutoHidePageSizeSelector || $shape_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shape">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shape_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shape_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shape_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shape_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shape_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shape->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shape_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fshapelist" id="fshapelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shape_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shape_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shape">
<div id="gmp_shape" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($shape_list->TotalRecs > 0 || $shape->isGridEdit()) { ?>
<table id="tbl_shapelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$shape_list->RowType = ROWTYPE_HEADER;

// Render list options
$shape_list->renderListOptions();

// Render list options (header, left)
$shape_list->ListOptions->render("header", "left");
?>
<?php if ($shape->id->Visible) { // id ?>
	<?php if ($shape->sortUrl($shape->id) == "") { ?>
		<th data-name="id" class="<?php echo $shape->id->headerCellClass() ?>"><div id="elh_shape_id" class="shape_id"><div class="ew-table-header-caption"><?php echo $shape->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $shape->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shape->SortUrl($shape->id) ?>',2);"><div id="elh_shape_id" class="shape_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shape->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($shape->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shape->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shape->item->Visible) { // item ?>
	<?php if ($shape->sortUrl($shape->item) == "") { ?>
		<th data-name="item" class="<?php echo $shape->item->headerCellClass() ?>"><div id="elh_shape_item" class="shape_item"><div class="ew-table-header-caption"><?php echo $shape->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $shape->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shape->SortUrl($shape->item) ?>',2);"><div id="elh_shape_item" class="shape_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shape->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shape->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shape->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shape->status->Visible) { // status ?>
	<?php if ($shape->sortUrl($shape->status) == "") { ?>
		<th data-name="status" class="<?php echo $shape->status->headerCellClass() ?>"><div id="elh_shape_status" class="shape_status"><div class="ew-table-header-caption"><?php echo $shape->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $shape->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shape->SortUrl($shape->status) ?>',2);"><div id="elh_shape_status" class="shape_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shape->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($shape->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shape->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shape->operator->Visible) { // operator ?>
	<?php if ($shape->sortUrl($shape->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $shape->operator->headerCellClass() ?>"><div id="elh_shape_operator" class="shape_operator"><div class="ew-table-header-caption"><?php echo $shape->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $shape->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shape->SortUrl($shape->operator) ?>',2);"><div id="elh_shape_operator" class="shape_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shape->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($shape->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shape->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shape->datetime->Visible) { // datetime ?>
	<?php if ($shape->sortUrl($shape->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $shape->datetime->headerCellClass() ?>"><div id="elh_shape_datetime" class="shape_datetime"><div class="ew-table-header-caption"><?php echo $shape->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $shape->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shape->SortUrl($shape->datetime) ?>',2);"><div id="elh_shape_datetime" class="shape_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shape->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($shape->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shape->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$shape_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($shape->ExportAll && $shape->isExport()) {
	$shape_list->StopRec = $shape_list->TotalRecs;
} else {

	// Set the last record to display
	if ($shape_list->TotalRecs > $shape_list->StartRec + $shape_list->DisplayRecs - 1)
		$shape_list->StopRec = $shape_list->StartRec + $shape_list->DisplayRecs - 1;
	else
		$shape_list->StopRec = $shape_list->TotalRecs;
}
$shape_list->RecCnt = $shape_list->StartRec - 1;
if ($shape_list->Recordset && !$shape_list->Recordset->EOF) {
	$shape_list->Recordset->moveFirst();
	$selectLimit = $shape_list->UseSelectLimit;
	if (!$selectLimit && $shape_list->StartRec > 1)
		$shape_list->Recordset->move($shape_list->StartRec - 1);
} elseif (!$shape->AllowAddDeleteRow && $shape_list->StopRec == 0) {
	$shape_list->StopRec = $shape->GridAddRowCount;
}

// Initialize aggregate
$shape->RowType = ROWTYPE_AGGREGATEINIT;
$shape->resetAttributes();
$shape_list->renderRow();
while ($shape_list->RecCnt < $shape_list->StopRec) {
	$shape_list->RecCnt++;
	if ($shape_list->RecCnt >= $shape_list->StartRec) {
		$shape_list->RowCnt++;

		// Set up key count
		$shape_list->KeyCount = $shape_list->RowIndex;

		// Init row class and style
		$shape->resetAttributes();
		$shape->CssClass = "";
		if ($shape->isGridAdd()) {
		} else {
			$shape_list->loadRowValues($shape_list->Recordset); // Load row values
		}
		$shape->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$shape->RowAttrs = array_merge($shape->RowAttrs, array('data-rowindex'=>$shape_list->RowCnt, 'id'=>'r' . $shape_list->RowCnt . '_shape', 'data-rowtype'=>$shape->RowType));

		// Render row
		$shape_list->renderRow();

		// Render list options
		$shape_list->renderListOptions();
?>
	<tr<?php echo $shape->rowAttributes() ?>>
<?php

// Render list options (body, left)
$shape_list->ListOptions->render("body", "left", $shape_list->RowCnt);
?>
	<?php if ($shape->id->Visible) { // id ?>
		<td data-name="id"<?php echo $shape->id->cellAttributes() ?>>
<span id="el<?php echo $shape_list->RowCnt ?>_shape_id" class="shape_id">
<span<?php echo $shape->id->viewAttributes() ?>>
<?php echo $shape->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shape->item->Visible) { // item ?>
		<td data-name="item"<?php echo $shape->item->cellAttributes() ?>>
<span id="el<?php echo $shape_list->RowCnt ?>_shape_item" class="shape_item">
<span<?php echo $shape->item->viewAttributes() ?>>
<?php echo $shape->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shape->status->Visible) { // status ?>
		<td data-name="status"<?php echo $shape->status->cellAttributes() ?>>
<span id="el<?php echo $shape_list->RowCnt ?>_shape_status" class="shape_status">
<span<?php echo $shape->status->viewAttributes() ?>>
<?php echo $shape->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shape->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $shape->operator->cellAttributes() ?>>
<span id="el<?php echo $shape_list->RowCnt ?>_shape_operator" class="shape_operator">
<span<?php echo $shape->operator->viewAttributes() ?>>
<?php echo $shape->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shape->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $shape->datetime->cellAttributes() ?>>
<span id="el<?php echo $shape_list->RowCnt ?>_shape_datetime" class="shape_datetime">
<span<?php echo $shape->datetime->viewAttributes() ?>>
<?php echo $shape->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$shape_list->ListOptions->render("body", "right", $shape_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$shape->isGridAdd())
		$shape_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$shape->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($shape_list->Recordset)
	$shape_list->Recordset->Close();
?>
<?php if (!$shape->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$shape->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shape_list->Pager)) $shape_list->Pager = new PrevNextPager($shape_list->StartRec, $shape_list->DisplayRecs, $shape_list->TotalRecs, $shape_list->AutoHidePager) ?>
<?php if ($shape_list->Pager->RecordCount > 0 && $shape_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shape_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shape_list->pageUrl() ?>start=<?php echo $shape_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shape_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shape_list->pageUrl() ?>start=<?php echo $shape_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shape_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shape_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shape_list->pageUrl() ?>start=<?php echo $shape_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shape_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shape_list->pageUrl() ?>start=<?php echo $shape_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shape_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shape_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shape_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shape_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shape_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shape_list->TotalRecs > 0 && (!$shape_list->AutoHidePageSizeSelector || $shape_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shape">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shape_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shape_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shape_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shape_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shape_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shape->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shape_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($shape_list->TotalRecs == 0 && !$shape->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $shape_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$shape_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$shape->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$shape->isExport()) { ?>
<script>
ew.scrollableTable("gmp_shape", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$shape_list->terminate();
?>