<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shape_search = new shape_search();

// Run the page
$shape_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shape_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($shape_search->IsModal) { ?>
var fshapesearch = currentAdvancedSearchForm = new ew.Form("fshapesearch", "search");
<?php } else { ?>
var fshapesearch = currentForm = new ew.Form("fshapesearch", "search");
<?php } ?>

// Form_CustomValidate event
fshapesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshapesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshapesearch.lists["x_status"] = <?php echo $shape_search->status->Lookup->toClientList() ?>;
fshapesearch.lists["x_status"].options = <?php echo JsonEncode($shape_search->status->options(FALSE, TRUE)) ?>;
fshapesearch.lists["x_operator"] = <?php echo $shape_search->operator->Lookup->toClientList() ?>;
fshapesearch.lists["x_operator"].options = <?php echo JsonEncode($shape_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fshapesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($shape->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shape_search->showPageHeader(); ?>
<?php
$shape_search->showMessage();
?>
<form name="fshapesearch" id="fshapesearch" class="<?php echo $shape_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shape_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shape_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shape">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$shape_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($shape->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $shape_search->LeftColumnClass ?>"><span id="elh_shape_id"><?php echo $shape->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $shape_search->RightColumnClass ?>"><div<?php echo $shape->id->cellAttributes() ?>>
			<span id="el_shape_id">
<input type="text" data-table="shape" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($shape->id->getPlaceHolder()) ?>" value="<?php echo $shape->id->EditValue ?>"<?php echo $shape->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($shape->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $shape_search->LeftColumnClass ?>"><span id="elh_shape_item"><?php echo $shape->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $shape_search->RightColumnClass ?>"><div<?php echo $shape->item->cellAttributes() ?>>
			<span id="el_shape_item">
<input type="text" data-table="shape" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($shape->item->getPlaceHolder()) ?>" value="<?php echo $shape->item->EditValue ?>"<?php echo $shape->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($shape->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $shape_search->LeftColumnClass ?>"><span id="elh_shape_status"><?php echo $shape->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $shape_search->RightColumnClass ?>"><div<?php echo $shape->status->cellAttributes() ?>>
			<span id="el_shape_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shape" data-field="x_status" data-value-separator="<?php echo $shape->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $shape->status->editAttributes() ?>>
		<?php echo $shape->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($shape->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $shape_search->LeftColumnClass ?>"><span id="elh_shape_operator"><?php echo $shape->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $shape_search->RightColumnClass ?>"><div<?php echo $shape->operator->cellAttributes() ?>>
			<span id="el_shape_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shape" data-field="x_operator" data-value-separator="<?php echo $shape->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $shape->operator->editAttributes() ?>>
		<?php echo $shape->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $shape->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($shape->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $shape_search->LeftColumnClass ?>"><span id="elh_shape_datetime"><?php echo $shape->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $shape_search->RightColumnClass ?>"><div<?php echo $shape->datetime->cellAttributes() ?>>
			<span id="el_shape_datetime">
<input type="text" data-table="shape" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($shape->datetime->getPlaceHolder()) ?>" value="<?php echo $shape->datetime->EditValue ?>"<?php echo $shape->datetime->editAttributes() ?>>
<?php if (!$shape->datetime->ReadOnly && !$shape->datetime->Disabled && !isset($shape->datetime->EditAttrs["readonly"]) && !isset($shape->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fshapesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$shape_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $shape_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$shape_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shape_search->terminate();
?>