<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$share_transfer_add = new share_transfer_add();

// Run the page
$share_transfer_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$share_transfer_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fshare_transferadd = currentForm = new ew.Form("fshare_transferadd", "add");

// Validate form
fshare_transferadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($share_transfer_add->folio_new->Required) { ?>
			elm = this.getElements("x" + infix + "_folio_new");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $share_transfer->folio_new->caption(), $share_transfer->folio_new->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($share_transfer_add->folio_old->Required) { ?>
			elm = this.getElements("x" + infix + "_folio_old");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $share_transfer->folio_old->caption(), $share_transfer->folio_old->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($share_transfer_add->adviser->Required) { ?>
			elm = this.getElements("x" + infix + "_adviser");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $share_transfer->adviser->caption(), $share_transfer->adviser->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($share_transfer_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $share_transfer->quantity->caption(), $share_transfer->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($share_transfer->quantity->errorMessage()) ?>");
		<?php if ($share_transfer_add->transfer_date->Required) { ?>
			elm = this.getElements("x" + infix + "_transfer_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $share_transfer->transfer_date->caption(), $share_transfer->transfer_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_transfer_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($share_transfer->transfer_date->errorMessage()) ?>");
		<?php if ($share_transfer_add->share_no_start->Required) { ?>
			elm = this.getElements("x" + infix + "_share_no_start");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $share_transfer->share_no_start->caption(), $share_transfer->share_no_start->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_share_no_start");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($share_transfer->share_no_start->errorMessage()) ?>");
		<?php if ($share_transfer_add->share_no_end->Required) { ?>
			elm = this.getElements("x" + infix + "_share_no_end");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $share_transfer->share_no_end->caption(), $share_transfer->share_no_end->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_share_no_end");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($share_transfer->share_no_end->errorMessage()) ?>");
		<?php if ($share_transfer_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $share_transfer->operator->caption(), $share_transfer->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($share_transfer_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $share_transfer->datetime->caption(), $share_transfer->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fshare_transferadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshare_transferadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshare_transferadd.lists["x_folio_new"] = <?php echo $share_transfer_add->folio_new->Lookup->toClientList() ?>;
fshare_transferadd.lists["x_folio_new"].options = <?php echo JsonEncode($share_transfer_add->folio_new->lookupOptions()) ?>;
fshare_transferadd.autoSuggests["x_folio_new"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fshare_transferadd.lists["x_folio_old"] = <?php echo $share_transfer_add->folio_old->Lookup->toClientList() ?>;
fshare_transferadd.lists["x_folio_old"].options = <?php echo JsonEncode($share_transfer_add->folio_old->lookupOptions()) ?>;
fshare_transferadd.autoSuggests["x_folio_old"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fshare_transferadd.lists["x_adviser"] = <?php echo $share_transfer_add->adviser->Lookup->toClientList() ?>;
fshare_transferadd.lists["x_adviser"].options = <?php echo JsonEncode($share_transfer_add->adviser->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $share_transfer_add->showPageHeader(); ?>
<?php
$share_transfer_add->showMessage();
?>
<form name="fshare_transferadd" id="fshare_transferadd" class="<?php echo $share_transfer_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($share_transfer_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $share_transfer_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="share_transfer">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$share_transfer_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($share_transfer->folio_new->Visible) { // folio_new ?>
	<div id="r_folio_new" class="form-group row">
		<label id="elh_share_transfer_folio_new" class="<?php echo $share_transfer_add->LeftColumnClass ?>"><?php echo $share_transfer->folio_new->caption() ?><?php echo ($share_transfer->folio_new->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $share_transfer_add->RightColumnClass ?>"><div<?php echo $share_transfer->folio_new->cellAttributes() ?>>
<span id="el_share_transfer_folio_new">
<?php
$wrkonchange = "" . trim(@$share_transfer->folio_new->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$share_transfer->folio_new->EditAttrs["onchange"] = "";
?>
<span id="as_x_folio_new" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_folio_new" id="sv_x_folio_new" value="<?php echo RemoveHtml($share_transfer->folio_new->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($share_transfer->folio_new->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($share_transfer->folio_new->getPlaceHolder()) ?>"<?php echo $share_transfer->folio_new->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($share_transfer->folio_new->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_folio_new',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($share_transfer->folio_new->ReadOnly || $share_transfer->folio_new->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="share_transfer" data-field="x_folio_new" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $share_transfer->folio_new->displayValueSeparatorAttribute() ?>" name="x_folio_new" id="x_folio_new" value="<?php echo HtmlEncode($share_transfer->folio_new->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fshare_transferadd.createAutoSuggest({"id":"x_folio_new","forceSelect":true});
</script>
<?php echo $share_transfer->folio_new->Lookup->getParamTag("p_x_folio_new") ?>
</span>
<?php echo $share_transfer->folio_new->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->folio_old->Visible) { // folio_old ?>
	<div id="r_folio_old" class="form-group row">
		<label id="elh_share_transfer_folio_old" class="<?php echo $share_transfer_add->LeftColumnClass ?>"><?php echo $share_transfer->folio_old->caption() ?><?php echo ($share_transfer->folio_old->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $share_transfer_add->RightColumnClass ?>"><div<?php echo $share_transfer->folio_old->cellAttributes() ?>>
<span id="el_share_transfer_folio_old">
<?php
$wrkonchange = "" . trim(@$share_transfer->folio_old->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$share_transfer->folio_old->EditAttrs["onchange"] = "";
?>
<span id="as_x_folio_old" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_folio_old" id="sv_x_folio_old" value="<?php echo RemoveHtml($share_transfer->folio_old->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($share_transfer->folio_old->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($share_transfer->folio_old->getPlaceHolder()) ?>"<?php echo $share_transfer->folio_old->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($share_transfer->folio_old->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_folio_old',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($share_transfer->folio_old->ReadOnly || $share_transfer->folio_old->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="share_transfer" data-field="x_folio_old" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $share_transfer->folio_old->displayValueSeparatorAttribute() ?>" name="x_folio_old" id="x_folio_old" value="<?php echo HtmlEncode($share_transfer->folio_old->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fshare_transferadd.createAutoSuggest({"id":"x_folio_old","forceSelect":true});
</script>
<?php echo $share_transfer->folio_old->Lookup->getParamTag("p_x_folio_old") ?>
</span>
<?php echo $share_transfer->folio_old->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->adviser->Visible) { // adviser ?>
	<div id="r_adviser" class="form-group row">
		<label id="elh_share_transfer_adviser" for="x_adviser" class="<?php echo $share_transfer_add->LeftColumnClass ?>"><?php echo $share_transfer->adviser->caption() ?><?php echo ($share_transfer->adviser->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $share_transfer_add->RightColumnClass ?>"><div<?php echo $share_transfer->adviser->cellAttributes() ?>>
<span id="el_share_transfer_adviser">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="share_transfer" data-field="x_adviser" data-value-separator="<?php echo $share_transfer->adviser->displayValueSeparatorAttribute() ?>" id="x_adviser" name="x_adviser"<?php echo $share_transfer->adviser->editAttributes() ?>>
		<?php echo $share_transfer->adviser->selectOptionListHtml("x_adviser") ?>
	</select>
</div>
<?php echo $share_transfer->adviser->Lookup->getParamTag("p_x_adviser") ?>
</span>
<?php echo $share_transfer->adviser->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_share_transfer_quantity" for="x_quantity" class="<?php echo $share_transfer_add->LeftColumnClass ?>"><?php echo $share_transfer->quantity->caption() ?><?php echo ($share_transfer->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $share_transfer_add->RightColumnClass ?>"><div<?php echo $share_transfer->quantity->cellAttributes() ?>>
<span id="el_share_transfer_quantity">
<input type="text" data-table="share_transfer" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($share_transfer->quantity->getPlaceHolder()) ?>" value="<?php echo $share_transfer->quantity->EditValue ?>"<?php echo $share_transfer->quantity->editAttributes() ?>>
</span>
<?php echo $share_transfer->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->transfer_date->Visible) { // transfer_date ?>
	<div id="r_transfer_date" class="form-group row">
		<label id="elh_share_transfer_transfer_date" for="x_transfer_date" class="<?php echo $share_transfer_add->LeftColumnClass ?>"><?php echo $share_transfer->transfer_date->caption() ?><?php echo ($share_transfer->transfer_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $share_transfer_add->RightColumnClass ?>"><div<?php echo $share_transfer->transfer_date->cellAttributes() ?>>
<span id="el_share_transfer_transfer_date">
<input type="text" data-table="share_transfer" data-field="x_transfer_date" data-format="2" name="x_transfer_date" id="x_transfer_date" size="30" placeholder="<?php echo HtmlEncode($share_transfer->transfer_date->getPlaceHolder()) ?>" value="<?php echo $share_transfer->transfer_date->EditValue ?>"<?php echo $share_transfer->transfer_date->editAttributes() ?>>
<?php if (!$share_transfer->transfer_date->ReadOnly && !$share_transfer->transfer_date->Disabled && !isset($share_transfer->transfer_date->EditAttrs["readonly"]) && !isset($share_transfer->transfer_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fshare_transferadd", "x_transfer_date", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
<?php echo $share_transfer->transfer_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->share_no_start->Visible) { // share_no_start ?>
	<div id="r_share_no_start" class="form-group row">
		<label id="elh_share_transfer_share_no_start" for="x_share_no_start" class="<?php echo $share_transfer_add->LeftColumnClass ?>"><?php echo $share_transfer->share_no_start->caption() ?><?php echo ($share_transfer->share_no_start->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $share_transfer_add->RightColumnClass ?>"><div<?php echo $share_transfer->share_no_start->cellAttributes() ?>>
<span id="el_share_transfer_share_no_start">
<input type="text" data-table="share_transfer" data-field="x_share_no_start" name="x_share_no_start" id="x_share_no_start" size="30" placeholder="<?php echo HtmlEncode($share_transfer->share_no_start->getPlaceHolder()) ?>" value="<?php echo $share_transfer->share_no_start->EditValue ?>"<?php echo $share_transfer->share_no_start->editAttributes() ?>>
</span>
<?php echo $share_transfer->share_no_start->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->share_no_end->Visible) { // share_no_end ?>
	<div id="r_share_no_end" class="form-group row">
		<label id="elh_share_transfer_share_no_end" for="x_share_no_end" class="<?php echo $share_transfer_add->LeftColumnClass ?>"><?php echo $share_transfer->share_no_end->caption() ?><?php echo ($share_transfer->share_no_end->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $share_transfer_add->RightColumnClass ?>"><div<?php echo $share_transfer->share_no_end->cellAttributes() ?>>
<span id="el_share_transfer_share_no_end">
<input type="text" data-table="share_transfer" data-field="x_share_no_end" name="x_share_no_end" id="x_share_no_end" size="30" placeholder="<?php echo HtmlEncode($share_transfer->share_no_end->getPlaceHolder()) ?>" value="<?php echo $share_transfer->share_no_end->EditValue ?>"<?php echo $share_transfer->share_no_end->editAttributes() ?>>
</span>
<?php echo $share_transfer->share_no_end->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$share_transfer_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $share_transfer_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $share_transfer_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$share_transfer_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$share_transfer_add->terminate();
?>