<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$share_transfer_list = new share_transfer_list();

// Run the page
$share_transfer_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$share_transfer_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$share_transfer->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fshare_transferlist = currentForm = new ew.Form("fshare_transferlist", "list");
fshare_transferlist.formKeyCountName = '<?php echo $share_transfer_list->FormKeyCountName ?>';

// Form_CustomValidate event
fshare_transferlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshare_transferlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshare_transferlist.lists["x_folio_new"] = <?php echo $share_transfer_list->folio_new->Lookup->toClientList() ?>;
fshare_transferlist.lists["x_folio_new"].options = <?php echo JsonEncode($share_transfer_list->folio_new->lookupOptions()) ?>;
fshare_transferlist.autoSuggests["x_folio_new"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fshare_transferlist.lists["x_folio_old"] = <?php echo $share_transfer_list->folio_old->Lookup->toClientList() ?>;
fshare_transferlist.lists["x_folio_old"].options = <?php echo JsonEncode($share_transfer_list->folio_old->lookupOptions()) ?>;
fshare_transferlist.autoSuggests["x_folio_old"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fshare_transferlist.lists["x_adviser"] = <?php echo $share_transfer_list->adviser->Lookup->toClientList() ?>;
fshare_transferlist.lists["x_adviser"].options = <?php echo JsonEncode($share_transfer_list->adviser->lookupOptions()) ?>;

// Form object for search
var fshare_transferlistsrch = currentSearchForm = new ew.Form("fshare_transferlistsrch");

// Validate function for search
fshare_transferlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fshare_transferlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshare_transferlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshare_transferlistsrch.lists["x_folio_new"] = <?php echo $share_transfer_list->folio_new->Lookup->toClientList() ?>;
fshare_transferlistsrch.lists["x_folio_new"].options = <?php echo JsonEncode($share_transfer_list->folio_new->lookupOptions()) ?>;
fshare_transferlistsrch.autoSuggests["x_folio_new"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fshare_transferlistsrch.lists["x_folio_old"] = <?php echo $share_transfer_list->folio_old->Lookup->toClientList() ?>;
fshare_transferlistsrch.lists["x_folio_old"].options = <?php echo JsonEncode($share_transfer_list->folio_old->lookupOptions()) ?>;
fshare_transferlistsrch.autoSuggests["x_folio_old"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fshare_transferlistsrch.lists["x_adviser"] = <?php echo $share_transfer_list->adviser->Lookup->toClientList() ?>;
fshare_transferlistsrch.lists["x_adviser"].options = <?php echo JsonEncode($share_transfer_list->adviser->lookupOptions()) ?>;

// Filters
fshare_transferlistsrch.filterList = <?php echo $share_transfer_list->getFilterList() ?>;

// Init search panel as collapsed
fshare_transferlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$share_transfer->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($share_transfer_list->TotalRecs > 0 && $share_transfer_list->ExportOptions->visible()) { ?>
<?php $share_transfer_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($share_transfer_list->ImportOptions->visible()) { ?>
<?php $share_transfer_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($share_transfer_list->SearchOptions->visible()) { ?>
<?php $share_transfer_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($share_transfer_list->FilterOptions->visible()) { ?>
<?php $share_transfer_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$share_transfer_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$share_transfer->isExport() && !$share_transfer->CurrentAction) { ?>
<form name="fshare_transferlistsrch" id="fshare_transferlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($share_transfer_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fshare_transferlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="share_transfer">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$share_transfer_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$share_transfer->RowType = ROWTYPE_SEARCH;

// Render row
$share_transfer->resetAttributes();
$share_transfer_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($share_transfer->folio_new->Visible) { // folio_new ?>
	<div id="xsc_folio_new" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $share_transfer->folio_new->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_folio_new" id="z_folio_new" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$share_transfer->folio_new->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$share_transfer->folio_new->EditAttrs["onchange"] = "";
?>
<span id="as_x_folio_new" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_folio_new" id="sv_x_folio_new" value="<?php echo RemoveHtml($share_transfer->folio_new->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($share_transfer->folio_new->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($share_transfer->folio_new->getPlaceHolder()) ?>"<?php echo $share_transfer->folio_new->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($share_transfer->folio_new->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_folio_new',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($share_transfer->folio_new->ReadOnly || $share_transfer->folio_new->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="share_transfer" data-field="x_folio_new" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $share_transfer->folio_new->displayValueSeparatorAttribute() ?>" name="x_folio_new" id="x_folio_new" value="<?php echo HtmlEncode($share_transfer->folio_new->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fshare_transferlistsrch.createAutoSuggest({"id":"x_folio_new","forceSelect":false});
</script>
<?php echo $share_transfer->folio_new->Lookup->getParamTag("p_x_folio_new") ?>
</span>
	</div>
<?php } ?>
<?php if ($share_transfer->folio_old->Visible) { // folio_old ?>
	<div id="xsc_folio_old" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $share_transfer->folio_old->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_folio_old" id="z_folio_old" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$share_transfer->folio_old->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$share_transfer->folio_old->EditAttrs["onchange"] = "";
?>
<span id="as_x_folio_old" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_folio_old" id="sv_x_folio_old" value="<?php echo RemoveHtml($share_transfer->folio_old->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($share_transfer->folio_old->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($share_transfer->folio_old->getPlaceHolder()) ?>"<?php echo $share_transfer->folio_old->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($share_transfer->folio_old->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_folio_old',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($share_transfer->folio_old->ReadOnly || $share_transfer->folio_old->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="share_transfer" data-field="x_folio_old" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $share_transfer->folio_old->displayValueSeparatorAttribute() ?>" name="x_folio_old" id="x_folio_old" value="<?php echo HtmlEncode($share_transfer->folio_old->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fshare_transferlistsrch.createAutoSuggest({"id":"x_folio_old","forceSelect":false});
</script>
<?php echo $share_transfer->folio_old->Lookup->getParamTag("p_x_folio_old") ?>
</span>
	</div>
<?php } ?>
<?php if ($share_transfer->adviser->Visible) { // adviser ?>
	<div id="xsc_adviser" class="ew-cell form-group">
		<label for="x_adviser" class="ew-search-caption ew-label"><?php echo $share_transfer->adviser->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_adviser" id="z_adviser" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="share_transfer" data-field="x_adviser" data-value-separator="<?php echo $share_transfer->adviser->displayValueSeparatorAttribute() ?>" id="x_adviser" name="x_adviser"<?php echo $share_transfer->adviser->editAttributes() ?>>
		<?php echo $share_transfer->adviser->selectOptionListHtml("x_adviser") ?>
	</select>
</div>
<?php echo $share_transfer->adviser->Lookup->getParamTag("p_x_adviser") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($share_transfer_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($share_transfer_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $share_transfer_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($share_transfer_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($share_transfer_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($share_transfer_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($share_transfer_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $share_transfer_list->showPageHeader(); ?>
<?php
$share_transfer_list->showMessage();
?>
<?php if ($share_transfer_list->TotalRecs > 0 || $share_transfer->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($share_transfer_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> share_transfer">
<?php if (!$share_transfer->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$share_transfer->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($share_transfer_list->Pager)) $share_transfer_list->Pager = new PrevNextPager($share_transfer_list->StartRec, $share_transfer_list->DisplayRecs, $share_transfer_list->TotalRecs, $share_transfer_list->AutoHidePager) ?>
<?php if ($share_transfer_list->Pager->RecordCount > 0 && $share_transfer_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($share_transfer_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $share_transfer_list->pageUrl() ?>start=<?php echo $share_transfer_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($share_transfer_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $share_transfer_list->pageUrl() ?>start=<?php echo $share_transfer_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $share_transfer_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($share_transfer_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $share_transfer_list->pageUrl() ?>start=<?php echo $share_transfer_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($share_transfer_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $share_transfer_list->pageUrl() ?>start=<?php echo $share_transfer_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $share_transfer_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($share_transfer_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $share_transfer_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $share_transfer_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $share_transfer_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($share_transfer_list->TotalRecs > 0 && (!$share_transfer_list->AutoHidePageSizeSelector || $share_transfer_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="share_transfer">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($share_transfer_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($share_transfer_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($share_transfer_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($share_transfer_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($share_transfer_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($share_transfer->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $share_transfer_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fshare_transferlist" id="fshare_transferlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($share_transfer_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $share_transfer_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="share_transfer">
<div id="gmp_share_transfer" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($share_transfer_list->TotalRecs > 0 || $share_transfer->isGridEdit()) { ?>
<table id="tbl_share_transferlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$share_transfer_list->RowType = ROWTYPE_HEADER;

// Render list options
$share_transfer_list->renderListOptions();

// Render list options (header, left)
$share_transfer_list->ListOptions->render("header", "left");
?>
<?php if ($share_transfer->id->Visible) { // id ?>
	<?php if ($share_transfer->sortUrl($share_transfer->id) == "") { ?>
		<th data-name="id" class="<?php echo $share_transfer->id->headerCellClass() ?>"><div id="elh_share_transfer_id" class="share_transfer_id"><div class="ew-table-header-caption"><?php echo $share_transfer->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $share_transfer->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->id) ?>',2);"><div id="elh_share_transfer_id" class="share_transfer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($share_transfer->folio_new->Visible) { // folio_new ?>
	<?php if ($share_transfer->sortUrl($share_transfer->folio_new) == "") { ?>
		<th data-name="folio_new" class="<?php echo $share_transfer->folio_new->headerCellClass() ?>"><div id="elh_share_transfer_folio_new" class="share_transfer_folio_new"><div class="ew-table-header-caption"><?php echo $share_transfer->folio_new->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="folio_new" class="<?php echo $share_transfer->folio_new->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->folio_new) ?>',2);"><div id="elh_share_transfer_folio_new" class="share_transfer_folio_new">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->folio_new->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->folio_new->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->folio_new->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($share_transfer->folio_old->Visible) { // folio_old ?>
	<?php if ($share_transfer->sortUrl($share_transfer->folio_old) == "") { ?>
		<th data-name="folio_old" class="<?php echo $share_transfer->folio_old->headerCellClass() ?>"><div id="elh_share_transfer_folio_old" class="share_transfer_folio_old"><div class="ew-table-header-caption"><?php echo $share_transfer->folio_old->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="folio_old" class="<?php echo $share_transfer->folio_old->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->folio_old) ?>',2);"><div id="elh_share_transfer_folio_old" class="share_transfer_folio_old">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->folio_old->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->folio_old->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->folio_old->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($share_transfer->adviser->Visible) { // adviser ?>
	<?php if ($share_transfer->sortUrl($share_transfer->adviser) == "") { ?>
		<th data-name="adviser" class="<?php echo $share_transfer->adviser->headerCellClass() ?>"><div id="elh_share_transfer_adviser" class="share_transfer_adviser"><div class="ew-table-header-caption"><?php echo $share_transfer->adviser->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="adviser" class="<?php echo $share_transfer->adviser->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->adviser) ?>',2);"><div id="elh_share_transfer_adviser" class="share_transfer_adviser">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->adviser->caption() ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->adviser->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->adviser->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($share_transfer->quantity->Visible) { // quantity ?>
	<?php if ($share_transfer->sortUrl($share_transfer->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $share_transfer->quantity->headerCellClass() ?>"><div id="elh_share_transfer_quantity" class="share_transfer_quantity"><div class="ew-table-header-caption"><?php echo $share_transfer->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $share_transfer->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->quantity) ?>',2);"><div id="elh_share_transfer_quantity" class="share_transfer_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($share_transfer->transfer_date->Visible) { // transfer_date ?>
	<?php if ($share_transfer->sortUrl($share_transfer->transfer_date) == "") { ?>
		<th data-name="transfer_date" class="<?php echo $share_transfer->transfer_date->headerCellClass() ?>"><div id="elh_share_transfer_transfer_date" class="share_transfer_transfer_date"><div class="ew-table-header-caption"><?php echo $share_transfer->transfer_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="transfer_date" class="<?php echo $share_transfer->transfer_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->transfer_date) ?>',2);"><div id="elh_share_transfer_transfer_date" class="share_transfer_transfer_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->transfer_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->transfer_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->transfer_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($share_transfer->share_no_start->Visible) { // share_no_start ?>
	<?php if ($share_transfer->sortUrl($share_transfer->share_no_start) == "") { ?>
		<th data-name="share_no_start" class="<?php echo $share_transfer->share_no_start->headerCellClass() ?>"><div id="elh_share_transfer_share_no_start" class="share_transfer_share_no_start"><div class="ew-table-header-caption"><?php echo $share_transfer->share_no_start->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="share_no_start" class="<?php echo $share_transfer->share_no_start->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->share_no_start) ?>',2);"><div id="elh_share_transfer_share_no_start" class="share_transfer_share_no_start">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->share_no_start->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->share_no_start->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->share_no_start->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($share_transfer->share_no_end->Visible) { // share_no_end ?>
	<?php if ($share_transfer->sortUrl($share_transfer->share_no_end) == "") { ?>
		<th data-name="share_no_end" class="<?php echo $share_transfer->share_no_end->headerCellClass() ?>"><div id="elh_share_transfer_share_no_end" class="share_transfer_share_no_end"><div class="ew-table-header-caption"><?php echo $share_transfer->share_no_end->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="share_no_end" class="<?php echo $share_transfer->share_no_end->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->share_no_end) ?>',2);"><div id="elh_share_transfer_share_no_end" class="share_transfer_share_no_end">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->share_no_end->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->share_no_end->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->share_no_end->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($share_transfer->pan->Visible) { // pan ?>
	<?php if ($share_transfer->sortUrl($share_transfer->pan) == "") { ?>
		<th data-name="pan" class="<?php echo $share_transfer->pan->headerCellClass() ?>"><div id="elh_share_transfer_pan" class="share_transfer_pan"><div class="ew-table-header-caption"><?php echo $share_transfer->pan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pan" class="<?php echo $share_transfer->pan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->pan) ?>',2);"><div id="elh_share_transfer_pan" class="share_transfer_pan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->pan->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->pan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->pan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($share_transfer->aadhaar->Visible) { // aadhaar ?>
	<?php if ($share_transfer->sortUrl($share_transfer->aadhaar) == "") { ?>
		<th data-name="aadhaar" class="<?php echo $share_transfer->aadhaar->headerCellClass() ?>"><div id="elh_share_transfer_aadhaar" class="share_transfer_aadhaar"><div class="ew-table-header-caption"><?php echo $share_transfer->aadhaar->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="aadhaar" class="<?php echo $share_transfer->aadhaar->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->aadhaar) ?>',2);"><div id="elh_share_transfer_aadhaar" class="share_transfer_aadhaar">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->aadhaar->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->aadhaar->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->aadhaar->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($share_transfer->duty_folio_new->Visible) { // duty_folio_new ?>
	<?php if ($share_transfer->sortUrl($share_transfer->duty_folio_new) == "") { ?>
		<th data-name="duty_folio_new" class="<?php echo $share_transfer->duty_folio_new->headerCellClass() ?>"><div id="elh_share_transfer_duty_folio_new" class="share_transfer_duty_folio_new"><div class="ew-table-header-caption"><?php echo $share_transfer->duty_folio_new->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="duty_folio_new" class="<?php echo $share_transfer->duty_folio_new->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->duty_folio_new) ?>',2);"><div id="elh_share_transfer_duty_folio_new" class="share_transfer_duty_folio_new">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->duty_folio_new->caption() ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->duty_folio_new->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->duty_folio_new->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($share_transfer->duty_company->Visible) { // duty_company ?>
	<?php if ($share_transfer->sortUrl($share_transfer->duty_company) == "") { ?>
		<th data-name="duty_company" class="<?php echo $share_transfer->duty_company->headerCellClass() ?>"><div id="elh_share_transfer_duty_company" class="share_transfer_duty_company"><div class="ew-table-header-caption"><?php echo $share_transfer->duty_company->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="duty_company" class="<?php echo $share_transfer->duty_company->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->duty_company) ?>',2);"><div id="elh_share_transfer_duty_company" class="share_transfer_duty_company">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->duty_company->caption() ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->duty_company->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->duty_company->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($share_transfer->operator->Visible) { // operator ?>
	<?php if ($share_transfer->sortUrl($share_transfer->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $share_transfer->operator->headerCellClass() ?>"><div id="elh_share_transfer_operator" class="share_transfer_operator"><div class="ew-table-header-caption"><?php echo $share_transfer->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $share_transfer->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->operator) ?>',2);"><div id="elh_share_transfer_operator" class="share_transfer_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($share_transfer->datetime->Visible) { // datetime ?>
	<?php if ($share_transfer->sortUrl($share_transfer->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $share_transfer->datetime->headerCellClass() ?>"><div id="elh_share_transfer_datetime" class="share_transfer_datetime"><div class="ew-table-header-caption"><?php echo $share_transfer->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $share_transfer->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $share_transfer->SortUrl($share_transfer->datetime) ?>',2);"><div id="elh_share_transfer_datetime" class="share_transfer_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $share_transfer->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($share_transfer->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($share_transfer->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$share_transfer_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($share_transfer->ExportAll && $share_transfer->isExport()) {
	$share_transfer_list->StopRec = $share_transfer_list->TotalRecs;
} else {

	// Set the last record to display
	if ($share_transfer_list->TotalRecs > $share_transfer_list->StartRec + $share_transfer_list->DisplayRecs - 1)
		$share_transfer_list->StopRec = $share_transfer_list->StartRec + $share_transfer_list->DisplayRecs - 1;
	else
		$share_transfer_list->StopRec = $share_transfer_list->TotalRecs;
}
$share_transfer_list->RecCnt = $share_transfer_list->StartRec - 1;
if ($share_transfer_list->Recordset && !$share_transfer_list->Recordset->EOF) {
	$share_transfer_list->Recordset->moveFirst();
	$selectLimit = $share_transfer_list->UseSelectLimit;
	if (!$selectLimit && $share_transfer_list->StartRec > 1)
		$share_transfer_list->Recordset->move($share_transfer_list->StartRec - 1);
} elseif (!$share_transfer->AllowAddDeleteRow && $share_transfer_list->StopRec == 0) {
	$share_transfer_list->StopRec = $share_transfer->GridAddRowCount;
}

// Initialize aggregate
$share_transfer->RowType = ROWTYPE_AGGREGATEINIT;
$share_transfer->resetAttributes();
$share_transfer_list->renderRow();
while ($share_transfer_list->RecCnt < $share_transfer_list->StopRec) {
	$share_transfer_list->RecCnt++;
	if ($share_transfer_list->RecCnt >= $share_transfer_list->StartRec) {
		$share_transfer_list->RowCnt++;

		// Set up key count
		$share_transfer_list->KeyCount = $share_transfer_list->RowIndex;

		// Init row class and style
		$share_transfer->resetAttributes();
		$share_transfer->CssClass = "";
		if ($share_transfer->isGridAdd()) {
		} else {
			$share_transfer_list->loadRowValues($share_transfer_list->Recordset); // Load row values
		}
		$share_transfer->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$share_transfer->RowAttrs = array_merge($share_transfer->RowAttrs, array('data-rowindex'=>$share_transfer_list->RowCnt, 'id'=>'r' . $share_transfer_list->RowCnt . '_share_transfer', 'data-rowtype'=>$share_transfer->RowType));

		// Render row
		$share_transfer_list->renderRow();

		// Render list options
		$share_transfer_list->renderListOptions();
?>
	<tr<?php echo $share_transfer->rowAttributes() ?>>
<?php

// Render list options (body, left)
$share_transfer_list->ListOptions->render("body", "left", $share_transfer_list->RowCnt);
?>
	<?php if ($share_transfer->id->Visible) { // id ?>
		<td data-name="id"<?php echo $share_transfer->id->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_id" class="share_transfer_id">
<span<?php echo $share_transfer->id->viewAttributes() ?>>
<?php echo $share_transfer->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($share_transfer->folio_new->Visible) { // folio_new ?>
		<td data-name="folio_new"<?php echo $share_transfer->folio_new->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_folio_new" class="share_transfer_folio_new">
<span<?php echo $share_transfer->folio_new->viewAttributes() ?>>
<?php echo $share_transfer->folio_new->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($share_transfer->folio_old->Visible) { // folio_old ?>
		<td data-name="folio_old"<?php echo $share_transfer->folio_old->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_folio_old" class="share_transfer_folio_old">
<span<?php echo $share_transfer->folio_old->viewAttributes() ?>>
<?php echo $share_transfer->folio_old->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($share_transfer->adviser->Visible) { // adviser ?>
		<td data-name="adviser"<?php echo $share_transfer->adviser->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_adviser" class="share_transfer_adviser">
<span<?php echo $share_transfer->adviser->viewAttributes() ?>>
<?php echo $share_transfer->adviser->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($share_transfer->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $share_transfer->quantity->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_quantity" class="share_transfer_quantity">
<span<?php echo $share_transfer->quantity->viewAttributes() ?>>
<?php echo $share_transfer->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($share_transfer->transfer_date->Visible) { // transfer_date ?>
		<td data-name="transfer_date"<?php echo $share_transfer->transfer_date->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_transfer_date" class="share_transfer_transfer_date">
<span<?php echo $share_transfer->transfer_date->viewAttributes() ?>>
<?php echo $share_transfer->transfer_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($share_transfer->share_no_start->Visible) { // share_no_start ?>
		<td data-name="share_no_start"<?php echo $share_transfer->share_no_start->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_share_no_start" class="share_transfer_share_no_start">
<span<?php echo $share_transfer->share_no_start->viewAttributes() ?>>
<?php echo $share_transfer->share_no_start->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($share_transfer->share_no_end->Visible) { // share_no_end ?>
		<td data-name="share_no_end"<?php echo $share_transfer->share_no_end->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_share_no_end" class="share_transfer_share_no_end">
<span<?php echo $share_transfer->share_no_end->viewAttributes() ?>>
<?php echo $share_transfer->share_no_end->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($share_transfer->pan->Visible) { // pan ?>
		<td data-name="pan"<?php echo $share_transfer->pan->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_pan" class="share_transfer_pan">
<span<?php echo $share_transfer->pan->viewAttributes() ?>>
<?php echo $share_transfer->pan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($share_transfer->aadhaar->Visible) { // aadhaar ?>
		<td data-name="aadhaar"<?php echo $share_transfer->aadhaar->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_aadhaar" class="share_transfer_aadhaar">
<span<?php echo $share_transfer->aadhaar->viewAttributes() ?>>
<?php echo $share_transfer->aadhaar->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($share_transfer->duty_folio_new->Visible) { // duty_folio_new ?>
		<td data-name="duty_folio_new"<?php echo $share_transfer->duty_folio_new->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_duty_folio_new" class="share_transfer_duty_folio_new">
<span<?php echo $share_transfer->duty_folio_new->viewAttributes() ?>>
<?php echo $share_transfer->duty_folio_new->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($share_transfer->duty_company->Visible) { // duty_company ?>
		<td data-name="duty_company"<?php echo $share_transfer->duty_company->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_duty_company" class="share_transfer_duty_company">
<span<?php echo $share_transfer->duty_company->viewAttributes() ?>>
<?php echo $share_transfer->duty_company->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($share_transfer->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $share_transfer->operator->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_operator" class="share_transfer_operator">
<span<?php echo $share_transfer->operator->viewAttributes() ?>>
<?php echo $share_transfer->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($share_transfer->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $share_transfer->datetime->cellAttributes() ?>>
<span id="el<?php echo $share_transfer_list->RowCnt ?>_share_transfer_datetime" class="share_transfer_datetime">
<span<?php echo $share_transfer->datetime->viewAttributes() ?>>
<?php echo $share_transfer->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$share_transfer_list->ListOptions->render("body", "right", $share_transfer_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$share_transfer->isGridAdd())
		$share_transfer_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$share_transfer->RowType = ROWTYPE_AGGREGATE;
$share_transfer->resetAttributes();
$share_transfer_list->renderRow();
?>
<?php if ($share_transfer_list->TotalRecs > 0 && !$share_transfer->isGridAdd() && !$share_transfer->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$share_transfer_list->renderListOptions();

// Render list options (footer, left)
$share_transfer_list->ListOptions->render("footer", "left");
?>
	<?php if ($share_transfer->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $share_transfer->id->footerCellClass() ?>"><span id="elf_share_transfer_id" class="share_transfer_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($share_transfer->folio_new->Visible) { // folio_new ?>
		<td data-name="folio_new" class="<?php echo $share_transfer->folio_new->footerCellClass() ?>"><span id="elf_share_transfer_folio_new" class="share_transfer_folio_new">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($share_transfer->folio_old->Visible) { // folio_old ?>
		<td data-name="folio_old" class="<?php echo $share_transfer->folio_old->footerCellClass() ?>"><span id="elf_share_transfer_folio_old" class="share_transfer_folio_old">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($share_transfer->adviser->Visible) { // adviser ?>
		<td data-name="adviser" class="<?php echo $share_transfer->adviser->footerCellClass() ?>"><span id="elf_share_transfer_adviser" class="share_transfer_adviser">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($share_transfer->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $share_transfer->quantity->footerCellClass() ?>"><span id="elf_share_transfer_quantity" class="share_transfer_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $share_transfer->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($share_transfer->transfer_date->Visible) { // transfer_date ?>
		<td data-name="transfer_date" class="<?php echo $share_transfer->transfer_date->footerCellClass() ?>"><span id="elf_share_transfer_transfer_date" class="share_transfer_transfer_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($share_transfer->share_no_start->Visible) { // share_no_start ?>
		<td data-name="share_no_start" class="<?php echo $share_transfer->share_no_start->footerCellClass() ?>"><span id="elf_share_transfer_share_no_start" class="share_transfer_share_no_start">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($share_transfer->share_no_end->Visible) { // share_no_end ?>
		<td data-name="share_no_end" class="<?php echo $share_transfer->share_no_end->footerCellClass() ?>"><span id="elf_share_transfer_share_no_end" class="share_transfer_share_no_end">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($share_transfer->pan->Visible) { // pan ?>
		<td data-name="pan" class="<?php echo $share_transfer->pan->footerCellClass() ?>"><span id="elf_share_transfer_pan" class="share_transfer_pan">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($share_transfer->aadhaar->Visible) { // aadhaar ?>
		<td data-name="aadhaar" class="<?php echo $share_transfer->aadhaar->footerCellClass() ?>"><span id="elf_share_transfer_aadhaar" class="share_transfer_aadhaar">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($share_transfer->duty_folio_new->Visible) { // duty_folio_new ?>
		<td data-name="duty_folio_new" class="<?php echo $share_transfer->duty_folio_new->footerCellClass() ?>"><span id="elf_share_transfer_duty_folio_new" class="share_transfer_duty_folio_new">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($share_transfer->duty_company->Visible) { // duty_company ?>
		<td data-name="duty_company" class="<?php echo $share_transfer->duty_company->footerCellClass() ?>"><span id="elf_share_transfer_duty_company" class="share_transfer_duty_company">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($share_transfer->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $share_transfer->operator->footerCellClass() ?>"><span id="elf_share_transfer_operator" class="share_transfer_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($share_transfer->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $share_transfer->datetime->footerCellClass() ?>"><span id="elf_share_transfer_datetime" class="share_transfer_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$share_transfer_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$share_transfer->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($share_transfer_list->Recordset)
	$share_transfer_list->Recordset->Close();
?>
<?php if (!$share_transfer->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$share_transfer->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($share_transfer_list->Pager)) $share_transfer_list->Pager = new PrevNextPager($share_transfer_list->StartRec, $share_transfer_list->DisplayRecs, $share_transfer_list->TotalRecs, $share_transfer_list->AutoHidePager) ?>
<?php if ($share_transfer_list->Pager->RecordCount > 0 && $share_transfer_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($share_transfer_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $share_transfer_list->pageUrl() ?>start=<?php echo $share_transfer_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($share_transfer_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $share_transfer_list->pageUrl() ?>start=<?php echo $share_transfer_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $share_transfer_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($share_transfer_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $share_transfer_list->pageUrl() ?>start=<?php echo $share_transfer_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($share_transfer_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $share_transfer_list->pageUrl() ?>start=<?php echo $share_transfer_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $share_transfer_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($share_transfer_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $share_transfer_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $share_transfer_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $share_transfer_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($share_transfer_list->TotalRecs > 0 && (!$share_transfer_list->AutoHidePageSizeSelector || $share_transfer_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="share_transfer">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($share_transfer_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($share_transfer_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($share_transfer_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($share_transfer_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($share_transfer_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($share_transfer->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $share_transfer_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($share_transfer_list->TotalRecs == 0 && !$share_transfer->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $share_transfer_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$share_transfer_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$share_transfer->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$share_transfer->isExport()) { ?>
<script>
ew.scrollableTable("gmp_share_transfer", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$share_transfer_list->terminate();
?>