<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$share_transfer_search = new share_transfer_search();

// Run the page
$share_transfer_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$share_transfer_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($share_transfer_search->IsModal) { ?>
var fshare_transfersearch = currentAdvancedSearchForm = new ew.Form("fshare_transfersearch", "search");
<?php } else { ?>
var fshare_transfersearch = currentForm = new ew.Form("fshare_transfersearch", "search");
<?php } ?>

// Form_CustomValidate event
fshare_transfersearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshare_transfersearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshare_transfersearch.lists["x_folio_new"] = <?php echo $share_transfer_search->folio_new->Lookup->toClientList() ?>;
fshare_transfersearch.lists["x_folio_new"].options = <?php echo JsonEncode($share_transfer_search->folio_new->lookupOptions()) ?>;
fshare_transfersearch.autoSuggests["x_folio_new"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fshare_transfersearch.lists["x_folio_old"] = <?php echo $share_transfer_search->folio_old->Lookup->toClientList() ?>;
fshare_transfersearch.lists["x_folio_old"].options = <?php echo JsonEncode($share_transfer_search->folio_old->lookupOptions()) ?>;
fshare_transfersearch.autoSuggests["x_folio_old"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fshare_transfersearch.lists["x_adviser"] = <?php echo $share_transfer_search->adviser->Lookup->toClientList() ?>;
fshare_transfersearch.lists["x_adviser"].options = <?php echo JsonEncode($share_transfer_search->adviser->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fshare_transfersearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($share_transfer->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($share_transfer->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_transfer_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($share_transfer->transfer_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_share_no_start");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($share_transfer->share_no_start->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_share_no_end");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($share_transfer->share_no_end->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_duty_folio_new");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($share_transfer->duty_folio_new->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_duty_company");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($share_transfer->duty_company->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($share_transfer->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($share_transfer->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $share_transfer_search->showPageHeader(); ?>
<?php
$share_transfer_search->showMessage();
?>
<form name="fshare_transfersearch" id="fshare_transfersearch" class="<?php echo $share_transfer_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($share_transfer_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $share_transfer_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="share_transfer">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$share_transfer_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($share_transfer->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_id"><?php echo $share_transfer->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->id->cellAttributes() ?>>
			<span id="el_share_transfer_id">
<input type="text" data-table="share_transfer" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($share_transfer->id->getPlaceHolder()) ?>" value="<?php echo $share_transfer->id->EditValue ?>"<?php echo $share_transfer->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->folio_new->Visible) { // folio_new ?>
	<div id="r_folio_new" class="form-group row">
		<label class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_folio_new"><?php echo $share_transfer->folio_new->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_folio_new" id="z_folio_new" value="LIKE"></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->folio_new->cellAttributes() ?>>
			<span id="el_share_transfer_folio_new">
<?php
$wrkonchange = "" . trim(@$share_transfer->folio_new->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$share_transfer->folio_new->EditAttrs["onchange"] = "";
?>
<span id="as_x_folio_new" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_folio_new" id="sv_x_folio_new" value="<?php echo RemoveHtml($share_transfer->folio_new->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($share_transfer->folio_new->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($share_transfer->folio_new->getPlaceHolder()) ?>"<?php echo $share_transfer->folio_new->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($share_transfer->folio_new->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_folio_new',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($share_transfer->folio_new->ReadOnly || $share_transfer->folio_new->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="share_transfer" data-field="x_folio_new" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $share_transfer->folio_new->displayValueSeparatorAttribute() ?>" name="x_folio_new" id="x_folio_new" value="<?php echo HtmlEncode($share_transfer->folio_new->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fshare_transfersearch.createAutoSuggest({"id":"x_folio_new","forceSelect":false});
</script>
<?php echo $share_transfer->folio_new->Lookup->getParamTag("p_x_folio_new") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->folio_old->Visible) { // folio_old ?>
	<div id="r_folio_old" class="form-group row">
		<label class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_folio_old"><?php echo $share_transfer->folio_old->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_folio_old" id="z_folio_old" value="LIKE"></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->folio_old->cellAttributes() ?>>
			<span id="el_share_transfer_folio_old">
<?php
$wrkonchange = "" . trim(@$share_transfer->folio_old->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$share_transfer->folio_old->EditAttrs["onchange"] = "";
?>
<span id="as_x_folio_old" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_folio_old" id="sv_x_folio_old" value="<?php echo RemoveHtml($share_transfer->folio_old->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($share_transfer->folio_old->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($share_transfer->folio_old->getPlaceHolder()) ?>"<?php echo $share_transfer->folio_old->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($share_transfer->folio_old->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_folio_old',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($share_transfer->folio_old->ReadOnly || $share_transfer->folio_old->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="share_transfer" data-field="x_folio_old" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $share_transfer->folio_old->displayValueSeparatorAttribute() ?>" name="x_folio_old" id="x_folio_old" value="<?php echo HtmlEncode($share_transfer->folio_old->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fshare_transfersearch.createAutoSuggest({"id":"x_folio_old","forceSelect":false});
</script>
<?php echo $share_transfer->folio_old->Lookup->getParamTag("p_x_folio_old") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->adviser->Visible) { // adviser ?>
	<div id="r_adviser" class="form-group row">
		<label for="x_adviser" class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_adviser"><?php echo $share_transfer->adviser->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_adviser" id="z_adviser" value="="></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->adviser->cellAttributes() ?>>
			<span id="el_share_transfer_adviser">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="share_transfer" data-field="x_adviser" data-value-separator="<?php echo $share_transfer->adviser->displayValueSeparatorAttribute() ?>" id="x_adviser" name="x_adviser"<?php echo $share_transfer->adviser->editAttributes() ?>>
		<?php echo $share_transfer->adviser->selectOptionListHtml("x_adviser") ?>
	</select>
</div>
<?php echo $share_transfer->adviser->Lookup->getParamTag("p_x_adviser") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_quantity"><?php echo $share_transfer->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->quantity->cellAttributes() ?>>
			<span id="el_share_transfer_quantity">
<input type="text" data-table="share_transfer" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($share_transfer->quantity->getPlaceHolder()) ?>" value="<?php echo $share_transfer->quantity->EditValue ?>"<?php echo $share_transfer->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->transfer_date->Visible) { // transfer_date ?>
	<div id="r_transfer_date" class="form-group row">
		<label for="x_transfer_date" class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_transfer_date"><?php echo $share_transfer->transfer_date->caption() ?></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->transfer_date->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_transfer_date" id="z_transfer_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($share_transfer->transfer_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($share_transfer->transfer_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($share_transfer->transfer_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($share_transfer->transfer_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($share_transfer->transfer_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($share_transfer->transfer_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($share_transfer->transfer_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($share_transfer->transfer_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($share_transfer->transfer_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_share_transfer_transfer_date">
<input type="text" data-table="share_transfer" data-field="x_transfer_date" data-format="2" name="x_transfer_date" id="x_transfer_date" size="30" placeholder="<?php echo HtmlEncode($share_transfer->transfer_date->getPlaceHolder()) ?>" value="<?php echo $share_transfer->transfer_date->EditValue ?>"<?php echo $share_transfer->transfer_date->editAttributes() ?>>
<?php if (!$share_transfer->transfer_date->ReadOnly && !$share_transfer->transfer_date->Disabled && !isset($share_transfer->transfer_date->EditAttrs["readonly"]) && !isset($share_transfer->transfer_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fshare_transfersearch", "x_transfer_date", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_transfer_date d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_share_transfer_transfer_date" class="btw1_transfer_date d-none">
<input type="text" data-table="share_transfer" data-field="x_transfer_date" data-format="2" name="y_transfer_date" id="y_transfer_date" size="30" placeholder="<?php echo HtmlEncode($share_transfer->transfer_date->getPlaceHolder()) ?>" value="<?php echo $share_transfer->transfer_date->EditValue2 ?>"<?php echo $share_transfer->transfer_date->editAttributes() ?>>
<?php if (!$share_transfer->transfer_date->ReadOnly && !$share_transfer->transfer_date->Disabled && !isset($share_transfer->transfer_date->EditAttrs["readonly"]) && !isset($share_transfer->transfer_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fshare_transfersearch", "y_transfer_date", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->share_no_start->Visible) { // share_no_start ?>
	<div id="r_share_no_start" class="form-group row">
		<label for="x_share_no_start" class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_share_no_start"><?php echo $share_transfer->share_no_start->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_share_no_start" id="z_share_no_start" value="="></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->share_no_start->cellAttributes() ?>>
			<span id="el_share_transfer_share_no_start">
<input type="text" data-table="share_transfer" data-field="x_share_no_start" name="x_share_no_start" id="x_share_no_start" size="30" placeholder="<?php echo HtmlEncode($share_transfer->share_no_start->getPlaceHolder()) ?>" value="<?php echo $share_transfer->share_no_start->EditValue ?>"<?php echo $share_transfer->share_no_start->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->share_no_end->Visible) { // share_no_end ?>
	<div id="r_share_no_end" class="form-group row">
		<label for="x_share_no_end" class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_share_no_end"><?php echo $share_transfer->share_no_end->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_share_no_end" id="z_share_no_end" value="="></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->share_no_end->cellAttributes() ?>>
			<span id="el_share_transfer_share_no_end">
<input type="text" data-table="share_transfer" data-field="x_share_no_end" name="x_share_no_end" id="x_share_no_end" size="30" placeholder="<?php echo HtmlEncode($share_transfer->share_no_end->getPlaceHolder()) ?>" value="<?php echo $share_transfer->share_no_end->EditValue ?>"<?php echo $share_transfer->share_no_end->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->pan->Visible) { // pan ?>
	<div id="r_pan" class="form-group row">
		<label for="x_pan" class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_pan"><?php echo $share_transfer->pan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pan" id="z_pan" value="LIKE"></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->pan->cellAttributes() ?>>
			<span id="el_share_transfer_pan">
<input type="text" data-table="share_transfer" data-field="x_pan" name="x_pan" id="x_pan" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($share_transfer->pan->getPlaceHolder()) ?>" value="<?php echo $share_transfer->pan->EditValue ?>"<?php echo $share_transfer->pan->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->aadhaar->Visible) { // aadhaar ?>
	<div id="r_aadhaar" class="form-group row">
		<label for="x_aadhaar" class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_aadhaar"><?php echo $share_transfer->aadhaar->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_aadhaar" id="z_aadhaar" value="LIKE"></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->aadhaar->cellAttributes() ?>>
			<span id="el_share_transfer_aadhaar">
<input type="text" data-table="share_transfer" data-field="x_aadhaar" name="x_aadhaar" id="x_aadhaar" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($share_transfer->aadhaar->getPlaceHolder()) ?>" value="<?php echo $share_transfer->aadhaar->EditValue ?>"<?php echo $share_transfer->aadhaar->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->duty_folio_new->Visible) { // duty_folio_new ?>
	<div id="r_duty_folio_new" class="form-group row">
		<label for="x_duty_folio_new" class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_duty_folio_new"><?php echo $share_transfer->duty_folio_new->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_duty_folio_new" id="z_duty_folio_new" value="="></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->duty_folio_new->cellAttributes() ?>>
			<span id="el_share_transfer_duty_folio_new">
<input type="text" data-table="share_transfer" data-field="x_duty_folio_new" name="x_duty_folio_new" id="x_duty_folio_new" size="30" placeholder="<?php echo HtmlEncode($share_transfer->duty_folio_new->getPlaceHolder()) ?>" value="<?php echo $share_transfer->duty_folio_new->EditValue ?>"<?php echo $share_transfer->duty_folio_new->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->duty_company->Visible) { // duty_company ?>
	<div id="r_duty_company" class="form-group row">
		<label for="x_duty_company" class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_duty_company"><?php echo $share_transfer->duty_company->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_duty_company" id="z_duty_company" value="="></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->duty_company->cellAttributes() ?>>
			<span id="el_share_transfer_duty_company">
<input type="text" data-table="share_transfer" data-field="x_duty_company" name="x_duty_company" id="x_duty_company" size="30" placeholder="<?php echo HtmlEncode($share_transfer->duty_company->getPlaceHolder()) ?>" value="<?php echo $share_transfer->duty_company->EditValue ?>"<?php echo $share_transfer->duty_company->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_operator"><?php echo $share_transfer->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->operator->cellAttributes() ?>>
			<span id="el_share_transfer_operator">
<input type="text" data-table="share_transfer" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($share_transfer->operator->getPlaceHolder()) ?>" value="<?php echo $share_transfer->operator->EditValue ?>"<?php echo $share_transfer->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($share_transfer->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $share_transfer_search->LeftColumnClass ?>"><span id="elh_share_transfer_datetime"><?php echo $share_transfer->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $share_transfer_search->RightColumnClass ?>"><div<?php echo $share_transfer->datetime->cellAttributes() ?>>
			<span id="el_share_transfer_datetime">
<input type="text" data-table="share_transfer" data-field="x_datetime" name="x_datetime" id="x_datetime" size="30" placeholder="<?php echo HtmlEncode($share_transfer->datetime->getPlaceHolder()) ?>" value="<?php echo $share_transfer->datetime->EditValue ?>"<?php echo $share_transfer->datetime->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$share_transfer_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $share_transfer_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$share_transfer_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$share_transfer_search->terminate();
?>