<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$share_transfer_view = new share_transfer_view();

// Run the page
$share_transfer_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$share_transfer_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$share_transfer->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fshare_transferview = currentForm = new ew.Form("fshare_transferview", "view");

// Form_CustomValidate event
fshare_transferview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshare_transferview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshare_transferview.lists["x_folio_new"] = <?php echo $share_transfer_view->folio_new->Lookup->toClientList() ?>;
fshare_transferview.lists["x_folio_new"].options = <?php echo JsonEncode($share_transfer_view->folio_new->lookupOptions()) ?>;
fshare_transferview.autoSuggests["x_folio_new"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fshare_transferview.lists["x_folio_old"] = <?php echo $share_transfer_view->folio_old->Lookup->toClientList() ?>;
fshare_transferview.lists["x_folio_old"].options = <?php echo JsonEncode($share_transfer_view->folio_old->lookupOptions()) ?>;
fshare_transferview.autoSuggests["x_folio_old"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fshare_transferview.lists["x_adviser"] = <?php echo $share_transfer_view->adviser->Lookup->toClientList() ?>;
fshare_transferview.lists["x_adviser"].options = <?php echo JsonEncode($share_transfer_view->adviser->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$share_transfer->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $share_transfer_view->ExportOptions->render("body") ?>
<?php $share_transfer_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $share_transfer_view->showPageHeader(); ?>
<?php
$share_transfer_view->showMessage();
?>
<form name="fshare_transferview" id="fshare_transferview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($share_transfer_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $share_transfer_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="share_transfer">
<input type="hidden" name="modal" value="<?php echo (int)$share_transfer_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($share_transfer->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_id"><?php echo $share_transfer->id->caption() ?></span></td>
		<td data-name="id"<?php echo $share_transfer->id->cellAttributes() ?>>
<span id="el_share_transfer_id">
<span<?php echo $share_transfer->id->viewAttributes() ?>>
<?php echo $share_transfer->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->folio_new->Visible) { // folio_new ?>
	<tr id="r_folio_new">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_folio_new"><?php echo $share_transfer->folio_new->caption() ?></span></td>
		<td data-name="folio_new"<?php echo $share_transfer->folio_new->cellAttributes() ?>>
<span id="el_share_transfer_folio_new">
<span<?php echo $share_transfer->folio_new->viewAttributes() ?>>
<?php echo $share_transfer->folio_new->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->folio_old->Visible) { // folio_old ?>
	<tr id="r_folio_old">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_folio_old"><?php echo $share_transfer->folio_old->caption() ?></span></td>
		<td data-name="folio_old"<?php echo $share_transfer->folio_old->cellAttributes() ?>>
<span id="el_share_transfer_folio_old">
<span<?php echo $share_transfer->folio_old->viewAttributes() ?>>
<?php echo $share_transfer->folio_old->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->adviser->Visible) { // adviser ?>
	<tr id="r_adviser">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_adviser"><?php echo $share_transfer->adviser->caption() ?></span></td>
		<td data-name="adviser"<?php echo $share_transfer->adviser->cellAttributes() ?>>
<span id="el_share_transfer_adviser">
<span<?php echo $share_transfer->adviser->viewAttributes() ?>>
<?php echo $share_transfer->adviser->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_quantity"><?php echo $share_transfer->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $share_transfer->quantity->cellAttributes() ?>>
<span id="el_share_transfer_quantity">
<span<?php echo $share_transfer->quantity->viewAttributes() ?>>
<?php echo $share_transfer->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->transfer_date->Visible) { // transfer_date ?>
	<tr id="r_transfer_date">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_transfer_date"><?php echo $share_transfer->transfer_date->caption() ?></span></td>
		<td data-name="transfer_date"<?php echo $share_transfer->transfer_date->cellAttributes() ?>>
<span id="el_share_transfer_transfer_date">
<span<?php echo $share_transfer->transfer_date->viewAttributes() ?>>
<?php echo $share_transfer->transfer_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->share_no_start->Visible) { // share_no_start ?>
	<tr id="r_share_no_start">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_share_no_start"><?php echo $share_transfer->share_no_start->caption() ?></span></td>
		<td data-name="share_no_start"<?php echo $share_transfer->share_no_start->cellAttributes() ?>>
<span id="el_share_transfer_share_no_start">
<span<?php echo $share_transfer->share_no_start->viewAttributes() ?>>
<?php echo $share_transfer->share_no_start->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->share_no_end->Visible) { // share_no_end ?>
	<tr id="r_share_no_end">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_share_no_end"><?php echo $share_transfer->share_no_end->caption() ?></span></td>
		<td data-name="share_no_end"<?php echo $share_transfer->share_no_end->cellAttributes() ?>>
<span id="el_share_transfer_share_no_end">
<span<?php echo $share_transfer->share_no_end->viewAttributes() ?>>
<?php echo $share_transfer->share_no_end->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->pan->Visible) { // pan ?>
	<tr id="r_pan">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_pan"><?php echo $share_transfer->pan->caption() ?></span></td>
		<td data-name="pan"<?php echo $share_transfer->pan->cellAttributes() ?>>
<span id="el_share_transfer_pan">
<span<?php echo $share_transfer->pan->viewAttributes() ?>>
<?php echo $share_transfer->pan->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->aadhaar->Visible) { // aadhaar ?>
	<tr id="r_aadhaar">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_aadhaar"><?php echo $share_transfer->aadhaar->caption() ?></span></td>
		<td data-name="aadhaar"<?php echo $share_transfer->aadhaar->cellAttributes() ?>>
<span id="el_share_transfer_aadhaar">
<span<?php echo $share_transfer->aadhaar->viewAttributes() ?>>
<?php echo $share_transfer->aadhaar->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->duty_folio_new->Visible) { // duty_folio_new ?>
	<tr id="r_duty_folio_new">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_duty_folio_new"><?php echo $share_transfer->duty_folio_new->caption() ?></span></td>
		<td data-name="duty_folio_new"<?php echo $share_transfer->duty_folio_new->cellAttributes() ?>>
<span id="el_share_transfer_duty_folio_new">
<span<?php echo $share_transfer->duty_folio_new->viewAttributes() ?>>
<?php echo $share_transfer->duty_folio_new->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->duty_company->Visible) { // duty_company ?>
	<tr id="r_duty_company">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_duty_company"><?php echo $share_transfer->duty_company->caption() ?></span></td>
		<td data-name="duty_company"<?php echo $share_transfer->duty_company->cellAttributes() ?>>
<span id="el_share_transfer_duty_company">
<span<?php echo $share_transfer->duty_company->viewAttributes() ?>>
<?php echo $share_transfer->duty_company->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_operator"><?php echo $share_transfer->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $share_transfer->operator->cellAttributes() ?>>
<span id="el_share_transfer_operator">
<span<?php echo $share_transfer->operator->viewAttributes() ?>>
<?php echo $share_transfer->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_datetime"><?php echo $share_transfer->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $share_transfer->datetime->cellAttributes() ?>>
<span id="el_share_transfer_datetime">
<span<?php echo $share_transfer->datetime->viewAttributes() ?>>
<?php echo $share_transfer->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($share_transfer->updated->Visible) { // updated ?>
	<tr id="r_updated">
		<td class="<?php echo $share_transfer_view->TableLeftColumnClass ?>"><span id="elh_share_transfer_updated"><?php echo $share_transfer->updated->caption() ?></span></td>
		<td data-name="updated"<?php echo $share_transfer->updated->cellAttributes() ?>>
<span id="el_share_transfer_updated">
<span<?php echo $share_transfer->updated->viewAttributes() ?>>
<?php echo $share_transfer->updated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$share_transfer_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$share_transfer->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$share_transfer_view->terminate();
?>