<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_address_edit = new shipping_address_edit();

// Run the page
$shipping_address_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_address_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fshipping_addressedit = currentForm = new ew.Form("fshipping_addressedit", "edit");

// Validate form
fshipping_addressedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($shipping_address_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->id->caption(), $shipping_address->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->type->caption(), $shipping_address->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->_userid->Required) { ?>
			elm = this.getElements("x" + infix + "__userid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->_userid->caption(), $shipping_address->_userid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->formal_name->Required) { ?>
			elm = this.getElements("x" + infix + "_formal_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->formal_name->caption(), $shipping_address->formal_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->country->Required) { ?>
			elm = this.getElements("x" + infix + "_country");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->country->caption(), $shipping_address->country->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->state->Required) { ?>
			elm = this.getElements("x" + infix + "_state");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->state->caption(), $shipping_address->state->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->city->Required) { ?>
			elm = this.getElements("x" + infix + "_city");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->city->caption(), $shipping_address->city->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->address->caption(), $shipping_address->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->zipcode->Required) { ?>
			elm = this.getElements("x" + infix + "_zipcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->zipcode->caption(), $shipping_address->zipcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->name->caption(), $shipping_address->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->_email->caption(), $shipping_address->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->mobile->caption(), $shipping_address->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->gst_number->Required) { ?>
			elm = this.getElements("x" + infix + "_gst_number");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->gst_number->caption(), $shipping_address->gst_number->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->status->caption(), $shipping_address->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->operator->caption(), $shipping_address->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_address_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_address->datetime->caption(), $shipping_address->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fshipping_addressedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_addressedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_addressedit.lists["x_type"] = <?php echo $shipping_address_edit->type->Lookup->toClientList() ?>;
fshipping_addressedit.lists["x_type"].options = <?php echo JsonEncode($shipping_address_edit->type->options(FALSE, TRUE)) ?>;
fshipping_addressedit.lists["x__userid"] = <?php echo $shipping_address_edit->_userid->Lookup->toClientList() ?>;
fshipping_addressedit.lists["x__userid"].options = <?php echo JsonEncode($shipping_address_edit->_userid->lookupOptions()) ?>;
fshipping_addressedit.lists["x_country"] = <?php echo $shipping_address_edit->country->Lookup->toClientList() ?>;
fshipping_addressedit.lists["x_country"].options = <?php echo JsonEncode($shipping_address_edit->country->lookupOptions()) ?>;
fshipping_addressedit.lists["x_state"] = <?php echo $shipping_address_edit->state->Lookup->toClientList() ?>;
fshipping_addressedit.lists["x_state"].options = <?php echo JsonEncode($shipping_address_edit->state->lookupOptions()) ?>;
fshipping_addressedit.lists["x_city"] = <?php echo $shipping_address_edit->city->Lookup->toClientList() ?>;
fshipping_addressedit.lists["x_city"].options = <?php echo JsonEncode($shipping_address_edit->city->lookupOptions()) ?>;
fshipping_addressedit.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fshipping_addressedit.lists["x_status"] = <?php echo $shipping_address_edit->status->Lookup->toClientList() ?>;
fshipping_addressedit.lists["x_status"].options = <?php echo JsonEncode($shipping_address_edit->status->options(FALSE, TRUE)) ?>;
fshipping_addressedit.lists["x_operator"] = <?php echo $shipping_address_edit->operator->Lookup->toClientList() ?>;
fshipping_addressedit.lists["x_operator"].options = <?php echo JsonEncode($shipping_address_edit->operator->lookupOptions()) ?>;
fshipping_addressedit.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shipping_address_edit->showPageHeader(); ?>
<?php
$shipping_address_edit->showMessage();
?>
<form name="fshipping_addressedit" id="fshipping_addressedit" class="<?php echo $shipping_address_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_address_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_address_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_address">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$shipping_address_edit->IsModal ?>">
<?php if ($shipping_address->getCurrentMasterTable() == "production_partner") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="production_partner">
<input type="hidden" name="fk_id" value="<?php echo $shipping_address->_userid->getSessionValue() ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($shipping_address->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_shipping_address_id" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->id->caption() ?><?php echo ($shipping_address->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->id->cellAttributes() ?>>
<span id="el_shipping_address_id">
<span<?php echo $shipping_address->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($shipping_address->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="shipping_address" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($shipping_address->id->CurrentValue) ?>">
<?php echo $shipping_address->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_address->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_shipping_address_type" for="x_type" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->type->caption() ?><?php echo ($shipping_address->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->type->cellAttributes() ?>>
<span id="el_shipping_address_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shipping_address" data-field="x_type" data-value-separator="<?php echo $shipping_address->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $shipping_address->type->editAttributes() ?>>
		<?php echo $shipping_address->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
<?php echo $shipping_address->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_address->_userid->Visible) { // userid ?>
	<div id="r__userid" class="form-group row">
		<label id="elh_shipping_address__userid" for="x__userid" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->_userid->caption() ?><?php echo ($shipping_address->_userid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->_userid->cellAttributes() ?>>
<?php if ($shipping_address->_userid->getSessionValue() <> "") { ?>
<span id="el_shipping_address__userid">
<span<?php echo $shipping_address->_userid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($shipping_address->_userid->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x__userid" name="x__userid" value="<?php echo HtmlEncode($shipping_address->_userid->CurrentValue) ?>">
<?php } else { ?>
<span id="el_shipping_address__userid">
<?php $shipping_address->_userid->EditAttrs["onchange"] = "ew.autoFill(this);" . @$shipping_address->_userid->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shipping_address" data-field="x__userid" data-value-separator="<?php echo $shipping_address->_userid->displayValueSeparatorAttribute() ?>" id="x__userid" name="x__userid"<?php echo $shipping_address->_userid->editAttributes() ?>>
		<?php echo $shipping_address->_userid->selectOptionListHtml("x__userid") ?>
	</select>
</div>
<?php echo $shipping_address->_userid->Lookup->getParamTag("p_x__userid") ?>
</span>
<?php } ?>
<?php echo $shipping_address->_userid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_address->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label id="elh_shipping_address_formal_name" for="x_formal_name" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->formal_name->caption() ?><?php echo ($shipping_address->formal_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->formal_name->cellAttributes() ?>>
<span id="el_shipping_address_formal_name">
<input type="text" data-table="shipping_address" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($shipping_address->formal_name->getPlaceHolder()) ?>" value="<?php echo $shipping_address->formal_name->EditValue ?>"<?php echo $shipping_address->formal_name->editAttributes() ?>>
</span>
<?php echo $shipping_address->formal_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_address->country->Visible) { // country ?>
	<div id="r_country" class="form-group row">
		<label id="elh_shipping_address_country" for="x_country" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->country->caption() ?><?php echo ($shipping_address->country->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->country->cellAttributes() ?>>
<span id="el_shipping_address_country">
<?php $shipping_address->country->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$shipping_address->country->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shipping_address" data-field="x_country" data-value-separator="<?php echo $shipping_address->country->displayValueSeparatorAttribute() ?>" id="x_country" name="x_country"<?php echo $shipping_address->country->editAttributes() ?>>
		<?php echo $shipping_address->country->selectOptionListHtml("x_country") ?>
	</select>
</div>
<?php echo $shipping_address->country->Lookup->getParamTag("p_x_country") ?>
</span>
<?php echo $shipping_address->country->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_address->state->Visible) { // state ?>
	<div id="r_state" class="form-group row">
		<label id="elh_shipping_address_state" for="x_state" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->state->caption() ?><?php echo ($shipping_address->state->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->state->cellAttributes() ?>>
<span id="el_shipping_address_state">
<?php $shipping_address->state->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$shipping_address->state->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shipping_address" data-field="x_state" data-value-separator="<?php echo $shipping_address->state->displayValueSeparatorAttribute() ?>" id="x_state" name="x_state"<?php echo $shipping_address->state->editAttributes() ?>>
		<?php echo $shipping_address->state->selectOptionListHtml("x_state") ?>
	</select>
</div>
<?php echo $shipping_address->state->Lookup->getParamTag("p_x_state") ?>
</span>
<?php echo $shipping_address->state->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_address->city->Visible) { // city ?>
	<div id="r_city" class="form-group row">
		<label id="elh_shipping_address_city" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->city->caption() ?><?php echo ($shipping_address->city->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->city->cellAttributes() ?>>
<span id="el_shipping_address_city">
<?php
$wrkonchange = "" . trim(@$shipping_address->city->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$shipping_address->city->EditAttrs["onchange"] = "";
?>
<span id="as_x_city" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_city" id="sv_x_city" value="<?php echo RemoveHtml($shipping_address->city->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($shipping_address->city->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($shipping_address->city->getPlaceHolder()) ?>"<?php echo $shipping_address->city->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($shipping_address->city->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_city',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($shipping_address->city->ReadOnly || $shipping_address->city->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="shipping_address" data-field="x_city" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $shipping_address->city->displayValueSeparatorAttribute() ?>" name="x_city" id="x_city" value="<?php echo HtmlEncode($shipping_address->city->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fshipping_addressedit.createAutoSuggest({"id":"x_city","forceSelect":true});
</script>
<?php echo $shipping_address->city->Lookup->getParamTag("p_x_city") ?>
</span>
<?php echo $shipping_address->city->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_address->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label id="elh_shipping_address_address" for="x_address" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->address->caption() ?><?php echo ($shipping_address->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->address->cellAttributes() ?>>
<span id="el_shipping_address_address">
<textarea data-table="shipping_address" data-field="x_address" name="x_address" id="x_address" cols="35" rows="3" placeholder="<?php echo HtmlEncode($shipping_address->address->getPlaceHolder()) ?>"<?php echo $shipping_address->address->editAttributes() ?>><?php echo $shipping_address->address->EditValue ?></textarea>
</span>
<?php echo $shipping_address->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_address->zipcode->Visible) { // zipcode ?>
	<div id="r_zipcode" class="form-group row">
		<label id="elh_shipping_address_zipcode" for="x_zipcode" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->zipcode->caption() ?><?php echo ($shipping_address->zipcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->zipcode->cellAttributes() ?>>
<span id="el_shipping_address_zipcode">
<input type="text" data-table="shipping_address" data-field="x_zipcode" name="x_zipcode" id="x_zipcode" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($shipping_address->zipcode->getPlaceHolder()) ?>" value="<?php echo $shipping_address->zipcode->EditValue ?>"<?php echo $shipping_address->zipcode->editAttributes() ?>>
</span>
<?php echo $shipping_address->zipcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_address->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_shipping_address_name" for="x_name" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->name->caption() ?><?php echo ($shipping_address->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->name->cellAttributes() ?>>
<span id="el_shipping_address_name">
<input type="text" data-table="shipping_address" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($shipping_address->name->getPlaceHolder()) ?>" value="<?php echo $shipping_address->name->EditValue ?>"<?php echo $shipping_address->name->editAttributes() ?>>
</span>
<?php echo $shipping_address->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_address->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_shipping_address__email" for="x__email" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->_email->caption() ?><?php echo ($shipping_address->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->_email->cellAttributes() ?>>
<span id="el_shipping_address__email">
<input type="text" data-table="shipping_address" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($shipping_address->_email->getPlaceHolder()) ?>" value="<?php echo $shipping_address->_email->EditValue ?>"<?php echo $shipping_address->_email->editAttributes() ?>>
</span>
<?php echo $shipping_address->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_address->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_shipping_address_mobile" for="x_mobile" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->mobile->caption() ?><?php echo ($shipping_address->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->mobile->cellAttributes() ?>>
<span id="el_shipping_address_mobile">
<input type="text" data-table="shipping_address" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($shipping_address->mobile->getPlaceHolder()) ?>" value="<?php echo $shipping_address->mobile->EditValue ?>"<?php echo $shipping_address->mobile->editAttributes() ?>>
</span>
<?php echo $shipping_address->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_address->gst_number->Visible) { // gst_number ?>
	<div id="r_gst_number" class="form-group row">
		<label id="elh_shipping_address_gst_number" for="x_gst_number" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->gst_number->caption() ?><?php echo ($shipping_address->gst_number->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->gst_number->cellAttributes() ?>>
<span id="el_shipping_address_gst_number">
<input type="text" data-table="shipping_address" data-field="x_gst_number" name="x_gst_number" id="x_gst_number" size="30" maxlength="16" placeholder="<?php echo HtmlEncode($shipping_address->gst_number->getPlaceHolder()) ?>" value="<?php echo $shipping_address->gst_number->EditValue ?>"<?php echo $shipping_address->gst_number->editAttributes() ?>>
</span>
<?php echo $shipping_address->gst_number->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_address->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_shipping_address_status" for="x_status" class="<?php echo $shipping_address_edit->LeftColumnClass ?>"><?php echo $shipping_address->status->caption() ?><?php echo ($shipping_address->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_address_edit->RightColumnClass ?>"><div<?php echo $shipping_address->status->cellAttributes() ?>>
<span id="el_shipping_address_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="shipping_address" data-field="x_status" data-value-separator="<?php echo $shipping_address->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $shipping_address->status->editAttributes() ?>>
		<?php echo $shipping_address->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $shipping_address->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$shipping_address_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $shipping_address_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $shipping_address_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$shipping_address_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shipping_address_edit->terminate();
?>