<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_address_list = new shipping_address_list();

// Run the page
$shipping_address_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_address_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$shipping_address->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fshipping_addresslist = currentForm = new ew.Form("fshipping_addresslist", "list");
fshipping_addresslist.formKeyCountName = '<?php echo $shipping_address_list->FormKeyCountName ?>';

// Form_CustomValidate event
fshipping_addresslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_addresslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_addresslist.lists["x_type"] = <?php echo $shipping_address_list->type->Lookup->toClientList() ?>;
fshipping_addresslist.lists["x_type"].options = <?php echo JsonEncode($shipping_address_list->type->options(FALSE, TRUE)) ?>;
fshipping_addresslist.lists["x__userid"] = <?php echo $shipping_address_list->_userid->Lookup->toClientList() ?>;
fshipping_addresslist.lists["x__userid"].options = <?php echo JsonEncode($shipping_address_list->_userid->lookupOptions()) ?>;
fshipping_addresslist.lists["x_country"] = <?php echo $shipping_address_list->country->Lookup->toClientList() ?>;
fshipping_addresslist.lists["x_country"].options = <?php echo JsonEncode($shipping_address_list->country->lookupOptions()) ?>;
fshipping_addresslist.lists["x_state"] = <?php echo $shipping_address_list->state->Lookup->toClientList() ?>;
fshipping_addresslist.lists["x_state"].options = <?php echo JsonEncode($shipping_address_list->state->lookupOptions()) ?>;
fshipping_addresslist.lists["x_status"] = <?php echo $shipping_address_list->status->Lookup->toClientList() ?>;
fshipping_addresslist.lists["x_status"].options = <?php echo JsonEncode($shipping_address_list->status->options(FALSE, TRUE)) ?>;
fshipping_addresslist.lists["x_operator"] = <?php echo $shipping_address_list->operator->Lookup->toClientList() ?>;
fshipping_addresslist.lists["x_operator"].options = <?php echo JsonEncode($shipping_address_list->operator->lookupOptions()) ?>;
fshipping_addresslist.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fshipping_addresslistsrch = currentSearchForm = new ew.Form("fshipping_addresslistsrch");

// Filters
fshipping_addresslistsrch.filterList = <?php echo $shipping_address_list->getFilterList() ?>;

// Init search panel as collapsed
fshipping_addresslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$shipping_address->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($shipping_address_list->TotalRecs > 0 && $shipping_address_list->ExportOptions->visible()) { ?>
<?php $shipping_address_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_address_list->ImportOptions->visible()) { ?>
<?php $shipping_address_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_address_list->SearchOptions->visible()) { ?>
<?php $shipping_address_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($shipping_address_list->FilterOptions->visible()) { ?>
<?php $shipping_address_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$shipping_address->isExport() || EXPORT_MASTER_RECORD && $shipping_address->isExport("print")) { ?>
<?php
if ($shipping_address_list->DbMasterFilter <> "" && $shipping_address->getCurrentMasterTable() == "production_partner") {
	if ($shipping_address_list->MasterRecordExists) {
		include_once "production_partnermaster.php";
	}
}
?>
<?php } ?>
<?php
$shipping_address_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$shipping_address->isExport() && !$shipping_address->CurrentAction) { ?>
<form name="fshipping_addresslistsrch" id="fshipping_addresslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($shipping_address_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fshipping_addresslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="shipping_address">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($shipping_address_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($shipping_address_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $shipping_address_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($shipping_address_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($shipping_address_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($shipping_address_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($shipping_address_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $shipping_address_list->showPageHeader(); ?>
<?php
$shipping_address_list->showMessage();
?>
<?php if ($shipping_address_list->TotalRecs > 0 || $shipping_address->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($shipping_address_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> shipping_address">
<?php if (!$shipping_address->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$shipping_address->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shipping_address_list->Pager)) $shipping_address_list->Pager = new PrevNextPager($shipping_address_list->StartRec, $shipping_address_list->DisplayRecs, $shipping_address_list->TotalRecs, $shipping_address_list->AutoHidePager) ?>
<?php if ($shipping_address_list->Pager->RecordCount > 0 && $shipping_address_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shipping_address_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shipping_address_list->pageUrl() ?>start=<?php echo $shipping_address_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shipping_address_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shipping_address_list->pageUrl() ?>start=<?php echo $shipping_address_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shipping_address_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shipping_address_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shipping_address_list->pageUrl() ?>start=<?php echo $shipping_address_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shipping_address_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shipping_address_list->pageUrl() ?>start=<?php echo $shipping_address_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shipping_address_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shipping_address_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shipping_address_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shipping_address_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shipping_address_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shipping_address_list->TotalRecs > 0 && (!$shipping_address_list->AutoHidePageSizeSelector || $shipping_address_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shipping_address">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shipping_address_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shipping_address_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shipping_address_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shipping_address_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shipping_address_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shipping_address->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shipping_address_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fshipping_addresslist" id="fshipping_addresslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_address_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_address_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_address">
<?php if ($shipping_address->getCurrentMasterTable() == "production_partner" && $shipping_address->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="production_partner">
<input type="hidden" name="fk_id" value="<?php echo $shipping_address->_userid->getSessionValue() ?>">
<?php } ?>
<div id="gmp_shipping_address" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($shipping_address_list->TotalRecs > 0 || $shipping_address->isGridEdit()) { ?>
<table id="tbl_shipping_addresslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$shipping_address_list->RowType = ROWTYPE_HEADER;

// Render list options
$shipping_address_list->renderListOptions();

// Render list options (header, left)
$shipping_address_list->ListOptions->render("header", "left");
?>
<?php if ($shipping_address->id->Visible) { // id ?>
	<?php if ($shipping_address->sortUrl($shipping_address->id) == "") { ?>
		<th data-name="id" class="<?php echo $shipping_address->id->headerCellClass() ?>"><div id="elh_shipping_address_id" class="shipping_address_id"><div class="ew-table-header-caption"><?php echo $shipping_address->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $shipping_address->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->id) ?>',2);"><div id="elh_shipping_address_id" class="shipping_address_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->type->Visible) { // type ?>
	<?php if ($shipping_address->sortUrl($shipping_address->type) == "") { ?>
		<th data-name="type" class="<?php echo $shipping_address->type->headerCellClass() ?>"><div id="elh_shipping_address_type" class="shipping_address_type"><div class="ew-table-header-caption"><?php echo $shipping_address->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $shipping_address->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->type) ?>',2);"><div id="elh_shipping_address_type" class="shipping_address_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->_userid->Visible) { // userid ?>
	<?php if ($shipping_address->sortUrl($shipping_address->_userid) == "") { ?>
		<th data-name="_userid" class="<?php echo $shipping_address->_userid->headerCellClass() ?>"><div id="elh_shipping_address__userid" class="shipping_address__userid"><div class="ew-table-header-caption"><?php echo $shipping_address->_userid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_userid" class="<?php echo $shipping_address->_userid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->_userid) ?>',2);"><div id="elh_shipping_address__userid" class="shipping_address__userid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->_userid->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->_userid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->_userid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->formal_name->Visible) { // formal_name ?>
	<?php if ($shipping_address->sortUrl($shipping_address->formal_name) == "") { ?>
		<th data-name="formal_name" class="<?php echo $shipping_address->formal_name->headerCellClass() ?>"><div id="elh_shipping_address_formal_name" class="shipping_address_formal_name"><div class="ew-table-header-caption"><?php echo $shipping_address->formal_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="formal_name" class="<?php echo $shipping_address->formal_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->formal_name) ?>',2);"><div id="elh_shipping_address_formal_name" class="shipping_address_formal_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->formal_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->formal_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->formal_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->country->Visible) { // country ?>
	<?php if ($shipping_address->sortUrl($shipping_address->country) == "") { ?>
		<th data-name="country" class="<?php echo $shipping_address->country->headerCellClass() ?>"><div id="elh_shipping_address_country" class="shipping_address_country"><div class="ew-table-header-caption"><?php echo $shipping_address->country->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="country" class="<?php echo $shipping_address->country->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->country) ?>',2);"><div id="elh_shipping_address_country" class="shipping_address_country">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->country->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->country->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->country->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->state->Visible) { // state ?>
	<?php if ($shipping_address->sortUrl($shipping_address->state) == "") { ?>
		<th data-name="state" class="<?php echo $shipping_address->state->headerCellClass() ?>"><div id="elh_shipping_address_state" class="shipping_address_state"><div class="ew-table-header-caption"><?php echo $shipping_address->state->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="state" class="<?php echo $shipping_address->state->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->state) ?>',2);"><div id="elh_shipping_address_state" class="shipping_address_state">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->state->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->state->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->state->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->address->Visible) { // address ?>
	<?php if ($shipping_address->sortUrl($shipping_address->address) == "") { ?>
		<th data-name="address" class="<?php echo $shipping_address->address->headerCellClass() ?>"><div id="elh_shipping_address_address" class="shipping_address_address"><div class="ew-table-header-caption"><?php echo $shipping_address->address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="address" class="<?php echo $shipping_address->address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->address) ?>',2);"><div id="elh_shipping_address_address" class="shipping_address_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->city_name->Visible) { // city_name ?>
	<?php if ($shipping_address->sortUrl($shipping_address->city_name) == "") { ?>
		<th data-name="city_name" class="<?php echo $shipping_address->city_name->headerCellClass() ?>"><div id="elh_shipping_address_city_name" class="shipping_address_city_name"><div class="ew-table-header-caption"><?php echo $shipping_address->city_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="city_name" class="<?php echo $shipping_address->city_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->city_name) ?>',2);"><div id="elh_shipping_address_city_name" class="shipping_address_city_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->city_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->city_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->city_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->zipcode->Visible) { // zipcode ?>
	<?php if ($shipping_address->sortUrl($shipping_address->zipcode) == "") { ?>
		<th data-name="zipcode" class="<?php echo $shipping_address->zipcode->headerCellClass() ?>"><div id="elh_shipping_address_zipcode" class="shipping_address_zipcode"><div class="ew-table-header-caption"><?php echo $shipping_address->zipcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="zipcode" class="<?php echo $shipping_address->zipcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->zipcode) ?>',2);"><div id="elh_shipping_address_zipcode" class="shipping_address_zipcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->zipcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->zipcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->zipcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->name->Visible) { // name ?>
	<?php if ($shipping_address->sortUrl($shipping_address->name) == "") { ?>
		<th data-name="name" class="<?php echo $shipping_address->name->headerCellClass() ?>"><div id="elh_shipping_address_name" class="shipping_address_name"><div class="ew-table-header-caption"><?php echo $shipping_address->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $shipping_address->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->name) ?>',2);"><div id="elh_shipping_address_name" class="shipping_address_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->_email->Visible) { // email ?>
	<?php if ($shipping_address->sortUrl($shipping_address->_email) == "") { ?>
		<th data-name="_email" class="<?php echo $shipping_address->_email->headerCellClass() ?>"><div id="elh_shipping_address__email" class="shipping_address__email"><div class="ew-table-header-caption"><?php echo $shipping_address->_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_email" class="<?php echo $shipping_address->_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->_email) ?>',2);"><div id="elh_shipping_address__email" class="shipping_address__email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->mobile->Visible) { // mobile ?>
	<?php if ($shipping_address->sortUrl($shipping_address->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $shipping_address->mobile->headerCellClass() ?>"><div id="elh_shipping_address_mobile" class="shipping_address_mobile"><div class="ew-table-header-caption"><?php echo $shipping_address->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $shipping_address->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->mobile) ?>',2);"><div id="elh_shipping_address_mobile" class="shipping_address_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->gst_number->Visible) { // gst_number ?>
	<?php if ($shipping_address->sortUrl($shipping_address->gst_number) == "") { ?>
		<th data-name="gst_number" class="<?php echo $shipping_address->gst_number->headerCellClass() ?>"><div id="elh_shipping_address_gst_number" class="shipping_address_gst_number"><div class="ew-table-header-caption"><?php echo $shipping_address->gst_number->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst_number" class="<?php echo $shipping_address->gst_number->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->gst_number) ?>',2);"><div id="elh_shipping_address_gst_number" class="shipping_address_gst_number">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->gst_number->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->gst_number->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->gst_number->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->status->Visible) { // status ?>
	<?php if ($shipping_address->sortUrl($shipping_address->status) == "") { ?>
		<th data-name="status" class="<?php echo $shipping_address->status->headerCellClass() ?>"><div id="elh_shipping_address_status" class="shipping_address_status"><div class="ew-table-header-caption"><?php echo $shipping_address->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $shipping_address->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->status) ?>',2);"><div id="elh_shipping_address_status" class="shipping_address_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->operator->Visible) { // operator ?>
	<?php if ($shipping_address->sortUrl($shipping_address->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $shipping_address->operator->headerCellClass() ?>"><div id="elh_shipping_address_operator" class="shipping_address_operator"><div class="ew-table-header-caption"><?php echo $shipping_address->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $shipping_address->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->operator) ?>',2);"><div id="elh_shipping_address_operator" class="shipping_address_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->datetime->Visible) { // datetime ?>
	<?php if ($shipping_address->sortUrl($shipping_address->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $shipping_address->datetime->headerCellClass() ?>"><div id="elh_shipping_address_datetime" class="shipping_address_datetime"><div class="ew-table-header-caption"><?php echo $shipping_address->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $shipping_address->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $shipping_address->SortUrl($shipping_address->datetime) ?>',2);"><div id="elh_shipping_address_datetime" class="shipping_address_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$shipping_address_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($shipping_address->ExportAll && $shipping_address->isExport()) {
	$shipping_address_list->StopRec = $shipping_address_list->TotalRecs;
} else {

	// Set the last record to display
	if ($shipping_address_list->TotalRecs > $shipping_address_list->StartRec + $shipping_address_list->DisplayRecs - 1)
		$shipping_address_list->StopRec = $shipping_address_list->StartRec + $shipping_address_list->DisplayRecs - 1;
	else
		$shipping_address_list->StopRec = $shipping_address_list->TotalRecs;
}
$shipping_address_list->RecCnt = $shipping_address_list->StartRec - 1;
if ($shipping_address_list->Recordset && !$shipping_address_list->Recordset->EOF) {
	$shipping_address_list->Recordset->moveFirst();
	$selectLimit = $shipping_address_list->UseSelectLimit;
	if (!$selectLimit && $shipping_address_list->StartRec > 1)
		$shipping_address_list->Recordset->move($shipping_address_list->StartRec - 1);
} elseif (!$shipping_address->AllowAddDeleteRow && $shipping_address_list->StopRec == 0) {
	$shipping_address_list->StopRec = $shipping_address->GridAddRowCount;
}

// Initialize aggregate
$shipping_address->RowType = ROWTYPE_AGGREGATEINIT;
$shipping_address->resetAttributes();
$shipping_address_list->renderRow();
while ($shipping_address_list->RecCnt < $shipping_address_list->StopRec) {
	$shipping_address_list->RecCnt++;
	if ($shipping_address_list->RecCnt >= $shipping_address_list->StartRec) {
		$shipping_address_list->RowCnt++;

		// Set up key count
		$shipping_address_list->KeyCount = $shipping_address_list->RowIndex;

		// Init row class and style
		$shipping_address->resetAttributes();
		$shipping_address->CssClass = "";
		if ($shipping_address->isGridAdd()) {
		} else {
			$shipping_address_list->loadRowValues($shipping_address_list->Recordset); // Load row values
		}
		$shipping_address->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$shipping_address->RowAttrs = array_merge($shipping_address->RowAttrs, array('data-rowindex'=>$shipping_address_list->RowCnt, 'id'=>'r' . $shipping_address_list->RowCnt . '_shipping_address', 'data-rowtype'=>$shipping_address->RowType));

		// Render row
		$shipping_address_list->renderRow();

		// Render list options
		$shipping_address_list->renderListOptions();
?>
	<tr<?php echo $shipping_address->rowAttributes() ?>>
<?php

// Render list options (body, left)
$shipping_address_list->ListOptions->render("body", "left", $shipping_address_list->RowCnt);
?>
	<?php if ($shipping_address->id->Visible) { // id ?>
		<td data-name="id"<?php echo $shipping_address->id->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_id" class="shipping_address_id">
<span<?php echo $shipping_address->id->viewAttributes() ?>>
<?php echo $shipping_address->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->type->Visible) { // type ?>
		<td data-name="type"<?php echo $shipping_address->type->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_type" class="shipping_address_type">
<span<?php echo $shipping_address->type->viewAttributes() ?>>
<?php echo $shipping_address->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->_userid->Visible) { // userid ?>
		<td data-name="_userid"<?php echo $shipping_address->_userid->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address__userid" class="shipping_address__userid">
<span<?php echo $shipping_address->_userid->viewAttributes() ?>>
<?php echo $shipping_address->_userid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->formal_name->Visible) { // formal_name ?>
		<td data-name="formal_name"<?php echo $shipping_address->formal_name->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_formal_name" class="shipping_address_formal_name">
<span<?php echo $shipping_address->formal_name->viewAttributes() ?>>
<?php echo $shipping_address->formal_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->country->Visible) { // country ?>
		<td data-name="country"<?php echo $shipping_address->country->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_country" class="shipping_address_country">
<span<?php echo $shipping_address->country->viewAttributes() ?>>
<?php echo $shipping_address->country->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->state->Visible) { // state ?>
		<td data-name="state"<?php echo $shipping_address->state->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_state" class="shipping_address_state">
<span<?php echo $shipping_address->state->viewAttributes() ?>>
<?php echo $shipping_address->state->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->address->Visible) { // address ?>
		<td data-name="address"<?php echo $shipping_address->address->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_address" class="shipping_address_address">
<span<?php echo $shipping_address->address->viewAttributes() ?>>
<?php echo $shipping_address->address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->city_name->Visible) { // city_name ?>
		<td data-name="city_name"<?php echo $shipping_address->city_name->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_city_name" class="shipping_address_city_name">
<span<?php echo $shipping_address->city_name->viewAttributes() ?>>
<?php echo $shipping_address->city_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->zipcode->Visible) { // zipcode ?>
		<td data-name="zipcode"<?php echo $shipping_address->zipcode->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_zipcode" class="shipping_address_zipcode">
<span<?php echo $shipping_address->zipcode->viewAttributes() ?>>
<?php echo $shipping_address->zipcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->name->Visible) { // name ?>
		<td data-name="name"<?php echo $shipping_address->name->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_name" class="shipping_address_name">
<span<?php echo $shipping_address->name->viewAttributes() ?>>
<?php echo $shipping_address->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->_email->Visible) { // email ?>
		<td data-name="_email"<?php echo $shipping_address->_email->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address__email" class="shipping_address__email">
<span<?php echo $shipping_address->_email->viewAttributes() ?>>
<?php echo $shipping_address->_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $shipping_address->mobile->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_mobile" class="shipping_address_mobile">
<span<?php echo $shipping_address->mobile->viewAttributes() ?>>
<?php echo $shipping_address->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->gst_number->Visible) { // gst_number ?>
		<td data-name="gst_number"<?php echo $shipping_address->gst_number->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_gst_number" class="shipping_address_gst_number">
<span<?php echo $shipping_address->gst_number->viewAttributes() ?>>
<?php echo $shipping_address->gst_number->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->status->Visible) { // status ?>
		<td data-name="status"<?php echo $shipping_address->status->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_status" class="shipping_address_status">
<span<?php echo $shipping_address->status->viewAttributes() ?>>
<?php echo $shipping_address->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $shipping_address->operator->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_operator" class="shipping_address_operator">
<span<?php echo $shipping_address->operator->viewAttributes() ?>>
<?php echo $shipping_address->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($shipping_address->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $shipping_address->datetime->cellAttributes() ?>>
<span id="el<?php echo $shipping_address_list->RowCnt ?>_shipping_address_datetime" class="shipping_address_datetime">
<span<?php echo $shipping_address->datetime->viewAttributes() ?>>
<?php echo $shipping_address->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$shipping_address_list->ListOptions->render("body", "right", $shipping_address_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$shipping_address->isGridAdd())
		$shipping_address_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$shipping_address->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($shipping_address_list->Recordset)
	$shipping_address_list->Recordset->Close();
?>
<?php if (!$shipping_address->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$shipping_address->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($shipping_address_list->Pager)) $shipping_address_list->Pager = new PrevNextPager($shipping_address_list->StartRec, $shipping_address_list->DisplayRecs, $shipping_address_list->TotalRecs, $shipping_address_list->AutoHidePager) ?>
<?php if ($shipping_address_list->Pager->RecordCount > 0 && $shipping_address_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($shipping_address_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $shipping_address_list->pageUrl() ?>start=<?php echo $shipping_address_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($shipping_address_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $shipping_address_list->pageUrl() ?>start=<?php echo $shipping_address_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $shipping_address_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($shipping_address_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $shipping_address_list->pageUrl() ?>start=<?php echo $shipping_address_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($shipping_address_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $shipping_address_list->pageUrl() ?>start=<?php echo $shipping_address_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $shipping_address_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($shipping_address_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $shipping_address_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $shipping_address_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $shipping_address_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($shipping_address_list->TotalRecs > 0 && (!$shipping_address_list->AutoHidePageSizeSelector || $shipping_address_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="shipping_address">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($shipping_address_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($shipping_address_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($shipping_address_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($shipping_address_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($shipping_address_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($shipping_address->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $shipping_address_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($shipping_address_list->TotalRecs == 0 && !$shipping_address->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $shipping_address_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$shipping_address_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$shipping_address->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$shipping_address->isExport()) { ?>
<script>
ew.scrollableTable("gmp_shipping_address", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$shipping_address_list->terminate();
?>