<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$shipping_address_preview = new shipping_address_preview();

// Run the page
$shipping_address_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_address_preview->Page_Render();
?>
<?php $shipping_address_preview->showPageHeader(); ?>
<div class="card ew-grid shipping_address"><!-- .card -->
<?php if ($shipping_address_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$shipping_address_preview->renderListOptions();

// Render list options (header, left)
$shipping_address_preview->ListOptions->render("header", "left");
?>
<?php if ($shipping_address->id->Visible) { // id ?>
	<?php if ($shipping_address->SortUrl($shipping_address->id) == "") { ?>
		<th class="<?php echo $shipping_address->id->headerCellClass() ?>"><?php echo $shipping_address->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->id->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->id->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->id->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->type->Visible) { // type ?>
	<?php if ($shipping_address->SortUrl($shipping_address->type) == "") { ?>
		<th class="<?php echo $shipping_address->type->headerCellClass() ?>"><?php echo $shipping_address->type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->type->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->type->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->type->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->_userid->Visible) { // userid ?>
	<?php if ($shipping_address->SortUrl($shipping_address->_userid) == "") { ?>
		<th class="<?php echo $shipping_address->_userid->headerCellClass() ?>"><?php echo $shipping_address->_userid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->_userid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->_userid->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->_userid->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->_userid->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->_userid->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->formal_name->Visible) { // formal_name ?>
	<?php if ($shipping_address->SortUrl($shipping_address->formal_name) == "") { ?>
		<th class="<?php echo $shipping_address->formal_name->headerCellClass() ?>"><?php echo $shipping_address->formal_name->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->formal_name->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->formal_name->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->formal_name->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->formal_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->formal_name->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->country->Visible) { // country ?>
	<?php if ($shipping_address->SortUrl($shipping_address->country) == "") { ?>
		<th class="<?php echo $shipping_address->country->headerCellClass() ?>"><?php echo $shipping_address->country->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->country->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->country->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->country->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->country->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->country->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->state->Visible) { // state ?>
	<?php if ($shipping_address->SortUrl($shipping_address->state) == "") { ?>
		<th class="<?php echo $shipping_address->state->headerCellClass() ?>"><?php echo $shipping_address->state->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->state->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->state->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->state->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->state->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->state->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->address->Visible) { // address ?>
	<?php if ($shipping_address->SortUrl($shipping_address->address) == "") { ?>
		<th class="<?php echo $shipping_address->address->headerCellClass() ?>"><?php echo $shipping_address->address->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->address->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->address->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->address->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->address->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->address->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->city_name->Visible) { // city_name ?>
	<?php if ($shipping_address->SortUrl($shipping_address->city_name) == "") { ?>
		<th class="<?php echo $shipping_address->city_name->headerCellClass() ?>"><?php echo $shipping_address->city_name->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->city_name->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->city_name->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->city_name->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->city_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->city_name->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->zipcode->Visible) { // zipcode ?>
	<?php if ($shipping_address->SortUrl($shipping_address->zipcode) == "") { ?>
		<th class="<?php echo $shipping_address->zipcode->headerCellClass() ?>"><?php echo $shipping_address->zipcode->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->zipcode->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->zipcode->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->zipcode->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->zipcode->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->zipcode->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->name->Visible) { // name ?>
	<?php if ($shipping_address->SortUrl($shipping_address->name) == "") { ?>
		<th class="<?php echo $shipping_address->name->headerCellClass() ?>"><?php echo $shipping_address->name->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->name->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->name->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->name->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->name->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->name->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->_email->Visible) { // email ?>
	<?php if ($shipping_address->SortUrl($shipping_address->_email) == "") { ?>
		<th class="<?php echo $shipping_address->_email->headerCellClass() ?>"><?php echo $shipping_address->_email->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->_email->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->_email->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->_email->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->_email->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->_email->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->mobile->Visible) { // mobile ?>
	<?php if ($shipping_address->SortUrl($shipping_address->mobile) == "") { ?>
		<th class="<?php echo $shipping_address->mobile->headerCellClass() ?>"><?php echo $shipping_address->mobile->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->mobile->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->mobile->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->mobile->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->mobile->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->mobile->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->gst_number->Visible) { // gst_number ?>
	<?php if ($shipping_address->SortUrl($shipping_address->gst_number) == "") { ?>
		<th class="<?php echo $shipping_address->gst_number->headerCellClass() ?>"><?php echo $shipping_address->gst_number->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->gst_number->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->gst_number->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->gst_number->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->gst_number->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->gst_number->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->status->Visible) { // status ?>
	<?php if ($shipping_address->SortUrl($shipping_address->status) == "") { ?>
		<th class="<?php echo $shipping_address->status->headerCellClass() ?>"><?php echo $shipping_address->status->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->status->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->status->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->status->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->status->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->operator->Visible) { // operator ?>
	<?php if ($shipping_address->SortUrl($shipping_address->operator) == "") { ?>
		<th class="<?php echo $shipping_address->operator->headerCellClass() ?>"><?php echo $shipping_address->operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->operator->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->operator->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->operator->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($shipping_address->datetime->Visible) { // datetime ?>
	<?php if ($shipping_address->SortUrl($shipping_address->datetime) == "") { ?>
		<th class="<?php echo $shipping_address->datetime->headerCellClass() ?>"><?php echo $shipping_address->datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $shipping_address->datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($shipping_address->datetime->Name) ?>" data-sort-order="<?php echo $shipping_address_preview->SortField == $shipping_address->datetime->Name && $shipping_address_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $shipping_address->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($shipping_address_preview->SortField == $shipping_address->datetime->Name) { ?><?php if ($shipping_address_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($shipping_address_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$shipping_address_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$shipping_address_preview->RecCount = 0;
$shipping_address_preview->RowCnt = 0;
while ($shipping_address_preview->Recordset && !$shipping_address_preview->Recordset->EOF) {

	// Init row class and style
	$shipping_address_preview->RecCount++;
	$shipping_address_preview->RowCnt++;
	$shipping_address_preview->CssStyle = "";
	$shipping_address_preview->loadListRowValues($shipping_address_preview->Recordset);

	// Render row
	$shipping_address_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$shipping_address_preview->resetAttributes();
	$shipping_address_preview->renderListRow();

	// Render list options
	$shipping_address_preview->renderListOptions();
?>
	<tr<?php echo $shipping_address_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$shipping_address_preview->ListOptions->render("body", "left", $shipping_address_preview->RowCnt);
?>
<?php if ($shipping_address->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $shipping_address->id->cellAttributes() ?>>
<span<?php echo $shipping_address->id->viewAttributes() ?>>
<?php echo $shipping_address->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->type->Visible) { // type ?>
		<!-- type -->
		<td<?php echo $shipping_address->type->cellAttributes() ?>>
<span<?php echo $shipping_address->type->viewAttributes() ?>>
<?php echo $shipping_address->type->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->_userid->Visible) { // userid ?>
		<!-- userid -->
		<td<?php echo $shipping_address->_userid->cellAttributes() ?>>
<span<?php echo $shipping_address->_userid->viewAttributes() ?>>
<?php echo $shipping_address->_userid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->formal_name->Visible) { // formal_name ?>
		<!-- formal_name -->
		<td<?php echo $shipping_address->formal_name->cellAttributes() ?>>
<span<?php echo $shipping_address->formal_name->viewAttributes() ?>>
<?php echo $shipping_address->formal_name->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->country->Visible) { // country ?>
		<!-- country -->
		<td<?php echo $shipping_address->country->cellAttributes() ?>>
<span<?php echo $shipping_address->country->viewAttributes() ?>>
<?php echo $shipping_address->country->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->state->Visible) { // state ?>
		<!-- state -->
		<td<?php echo $shipping_address->state->cellAttributes() ?>>
<span<?php echo $shipping_address->state->viewAttributes() ?>>
<?php echo $shipping_address->state->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->address->Visible) { // address ?>
		<!-- address -->
		<td<?php echo $shipping_address->address->cellAttributes() ?>>
<span<?php echo $shipping_address->address->viewAttributes() ?>>
<?php echo $shipping_address->address->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->city_name->Visible) { // city_name ?>
		<!-- city_name -->
		<td<?php echo $shipping_address->city_name->cellAttributes() ?>>
<span<?php echo $shipping_address->city_name->viewAttributes() ?>>
<?php echo $shipping_address->city_name->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->zipcode->Visible) { // zipcode ?>
		<!-- zipcode -->
		<td<?php echo $shipping_address->zipcode->cellAttributes() ?>>
<span<?php echo $shipping_address->zipcode->viewAttributes() ?>>
<?php echo $shipping_address->zipcode->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->name->Visible) { // name ?>
		<!-- name -->
		<td<?php echo $shipping_address->name->cellAttributes() ?>>
<span<?php echo $shipping_address->name->viewAttributes() ?>>
<?php echo $shipping_address->name->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->_email->Visible) { // email ?>
		<!-- email -->
		<td<?php echo $shipping_address->_email->cellAttributes() ?>>
<span<?php echo $shipping_address->_email->viewAttributes() ?>>
<?php echo $shipping_address->_email->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->mobile->Visible) { // mobile ?>
		<!-- mobile -->
		<td<?php echo $shipping_address->mobile->cellAttributes() ?>>
<span<?php echo $shipping_address->mobile->viewAttributes() ?>>
<?php echo $shipping_address->mobile->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->gst_number->Visible) { // gst_number ?>
		<!-- gst_number -->
		<td<?php echo $shipping_address->gst_number->cellAttributes() ?>>
<span<?php echo $shipping_address->gst_number->viewAttributes() ?>>
<?php echo $shipping_address->gst_number->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->status->Visible) { // status ?>
		<!-- status -->
		<td<?php echo $shipping_address->status->cellAttributes() ?>>
<span<?php echo $shipping_address->status->viewAttributes() ?>>
<?php echo $shipping_address->status->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->operator->Visible) { // operator ?>
		<!-- operator -->
		<td<?php echo $shipping_address->operator->cellAttributes() ?>>
<span<?php echo $shipping_address->operator->viewAttributes() ?>>
<?php echo $shipping_address->operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($shipping_address->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td<?php echo $shipping_address->datetime->cellAttributes() ?>>
<span<?php echo $shipping_address->datetime->viewAttributes() ?>>
<?php echo $shipping_address->datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$shipping_address_preview->ListOptions->render("body", "right", $shipping_address_preview->RowCnt);
?>
	</tr>
<?php
	$shipping_address_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($shipping_address_preview->TotalRecs > 0) { ?>
<?php if (!isset($shipping_address_preview->Pager)) $shipping_address_preview->Pager = new PrevNextPager($shipping_address_preview->StartRec, $shipping_address_preview->DisplayRecs, $shipping_address_preview->TotalRecs) ?>
<?php if ($shipping_address_preview->Pager->RecordCount > 0 && $shipping_address_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($shipping_address_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $shipping_address_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($shipping_address_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $shipping_address_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($shipping_address_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $shipping_address_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($shipping_address_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $shipping_address_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $shipping_address_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $shipping_address_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $shipping_address_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($shipping_address_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$shipping_address_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($shipping_address_preview->Recordset)
	$shipping_address_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$shipping_address_preview->terminate();
?>