<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_address_view = new shipping_address_view();

// Run the page
$shipping_address_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_address_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$shipping_address->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fshipping_addressview = currentForm = new ew.Form("fshipping_addressview", "view");

// Form_CustomValidate event
fshipping_addressview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_addressview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_addressview.lists["x_type"] = <?php echo $shipping_address_view->type->Lookup->toClientList() ?>;
fshipping_addressview.lists["x_type"].options = <?php echo JsonEncode($shipping_address_view->type->options(FALSE, TRUE)) ?>;
fshipping_addressview.lists["x__userid"] = <?php echo $shipping_address_view->_userid->Lookup->toClientList() ?>;
fshipping_addressview.lists["x__userid"].options = <?php echo JsonEncode($shipping_address_view->_userid->lookupOptions()) ?>;
fshipping_addressview.lists["x_country"] = <?php echo $shipping_address_view->country->Lookup->toClientList() ?>;
fshipping_addressview.lists["x_country"].options = <?php echo JsonEncode($shipping_address_view->country->lookupOptions()) ?>;
fshipping_addressview.lists["x_state"] = <?php echo $shipping_address_view->state->Lookup->toClientList() ?>;
fshipping_addressview.lists["x_state"].options = <?php echo JsonEncode($shipping_address_view->state->lookupOptions()) ?>;
fshipping_addressview.lists["x_city"] = <?php echo $shipping_address_view->city->Lookup->toClientList() ?>;
fshipping_addressview.lists["x_city"].options = <?php echo JsonEncode($shipping_address_view->city->lookupOptions()) ?>;
fshipping_addressview.autoSuggests["x_city"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fshipping_addressview.lists["x_status"] = <?php echo $shipping_address_view->status->Lookup->toClientList() ?>;
fshipping_addressview.lists["x_status"].options = <?php echo JsonEncode($shipping_address_view->status->options(FALSE, TRUE)) ?>;
fshipping_addressview.lists["x_operator"] = <?php echo $shipping_address_view->operator->Lookup->toClientList() ?>;
fshipping_addressview.lists["x_operator"].options = <?php echo JsonEncode($shipping_address_view->operator->lookupOptions()) ?>;
fshipping_addressview.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$shipping_address->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $shipping_address_view->ExportOptions->render("body") ?>
<?php $shipping_address_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $shipping_address_view->showPageHeader(); ?>
<?php
$shipping_address_view->showMessage();
?>
<form name="fshipping_addressview" id="fshipping_addressview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_address_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_address_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_address">
<input type="hidden" name="modal" value="<?php echo (int)$shipping_address_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($shipping_address->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_id"><?php echo $shipping_address->id->caption() ?></span></td>
		<td data-name="id"<?php echo $shipping_address->id->cellAttributes() ?>>
<span id="el_shipping_address_id">
<span<?php echo $shipping_address->id->viewAttributes() ?>>
<?php echo $shipping_address->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_type"><?php echo $shipping_address->type->caption() ?></span></td>
		<td data-name="type"<?php echo $shipping_address->type->cellAttributes() ?>>
<span id="el_shipping_address_type">
<span<?php echo $shipping_address->type->viewAttributes() ?>>
<?php echo $shipping_address->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->_userid->Visible) { // userid ?>
	<tr id="r__userid">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address__userid"><?php echo $shipping_address->_userid->caption() ?></span></td>
		<td data-name="_userid"<?php echo $shipping_address->_userid->cellAttributes() ?>>
<span id="el_shipping_address__userid">
<span<?php echo $shipping_address->_userid->viewAttributes() ?>>
<?php echo $shipping_address->_userid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->formal_name->Visible) { // formal_name ?>
	<tr id="r_formal_name">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_formal_name"><?php echo $shipping_address->formal_name->caption() ?></span></td>
		<td data-name="formal_name"<?php echo $shipping_address->formal_name->cellAttributes() ?>>
<span id="el_shipping_address_formal_name">
<span<?php echo $shipping_address->formal_name->viewAttributes() ?>>
<?php echo $shipping_address->formal_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->country->Visible) { // country ?>
	<tr id="r_country">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_country"><?php echo $shipping_address->country->caption() ?></span></td>
		<td data-name="country"<?php echo $shipping_address->country->cellAttributes() ?>>
<span id="el_shipping_address_country">
<span<?php echo $shipping_address->country->viewAttributes() ?>>
<?php echo $shipping_address->country->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->state->Visible) { // state ?>
	<tr id="r_state">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_state"><?php echo $shipping_address->state->caption() ?></span></td>
		<td data-name="state"<?php echo $shipping_address->state->cellAttributes() ?>>
<span id="el_shipping_address_state">
<span<?php echo $shipping_address->state->viewAttributes() ?>>
<?php echo $shipping_address->state->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->city->Visible) { // city ?>
	<tr id="r_city">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_city"><?php echo $shipping_address->city->caption() ?></span></td>
		<td data-name="city"<?php echo $shipping_address->city->cellAttributes() ?>>
<span id="el_shipping_address_city">
<span<?php echo $shipping_address->city->viewAttributes() ?>>
<?php echo $shipping_address->city->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->address->Visible) { // address ?>
	<tr id="r_address">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_address"><?php echo $shipping_address->address->caption() ?></span></td>
		<td data-name="address"<?php echo $shipping_address->address->cellAttributes() ?>>
<span id="el_shipping_address_address">
<span<?php echo $shipping_address->address->viewAttributes() ?>>
<?php echo $shipping_address->address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->city_name->Visible) { // city_name ?>
	<tr id="r_city_name">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_city_name"><?php echo $shipping_address->city_name->caption() ?></span></td>
		<td data-name="city_name"<?php echo $shipping_address->city_name->cellAttributes() ?>>
<span id="el_shipping_address_city_name">
<span<?php echo $shipping_address->city_name->viewAttributes() ?>>
<?php echo $shipping_address->city_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->zipcode->Visible) { // zipcode ?>
	<tr id="r_zipcode">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_zipcode"><?php echo $shipping_address->zipcode->caption() ?></span></td>
		<td data-name="zipcode"<?php echo $shipping_address->zipcode->cellAttributes() ?>>
<span id="el_shipping_address_zipcode">
<span<?php echo $shipping_address->zipcode->viewAttributes() ?>>
<?php echo $shipping_address->zipcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_name"><?php echo $shipping_address->name->caption() ?></span></td>
		<td data-name="name"<?php echo $shipping_address->name->cellAttributes() ?>>
<span id="el_shipping_address_name">
<span<?php echo $shipping_address->name->viewAttributes() ?>>
<?php echo $shipping_address->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->_email->Visible) { // email ?>
	<tr id="r__email">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address__email"><?php echo $shipping_address->_email->caption() ?></span></td>
		<td data-name="_email"<?php echo $shipping_address->_email->cellAttributes() ?>>
<span id="el_shipping_address__email">
<span<?php echo $shipping_address->_email->viewAttributes() ?>>
<?php echo $shipping_address->_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->mobile->Visible) { // mobile ?>
	<tr id="r_mobile">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_mobile"><?php echo $shipping_address->mobile->caption() ?></span></td>
		<td data-name="mobile"<?php echo $shipping_address->mobile->cellAttributes() ?>>
<span id="el_shipping_address_mobile">
<span<?php echo $shipping_address->mobile->viewAttributes() ?>>
<?php echo $shipping_address->mobile->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->gst_number->Visible) { // gst_number ?>
	<tr id="r_gst_number">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_gst_number"><?php echo $shipping_address->gst_number->caption() ?></span></td>
		<td data-name="gst_number"<?php echo $shipping_address->gst_number->cellAttributes() ?>>
<span id="el_shipping_address_gst_number">
<span<?php echo $shipping_address->gst_number->viewAttributes() ?>>
<?php echo $shipping_address->gst_number->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_status"><?php echo $shipping_address->status->caption() ?></span></td>
		<td data-name="status"<?php echo $shipping_address->status->cellAttributes() ?>>
<span id="el_shipping_address_status">
<span<?php echo $shipping_address->status->viewAttributes() ?>>
<?php echo $shipping_address->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_operator"><?php echo $shipping_address->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $shipping_address->operator->cellAttributes() ?>>
<span id="el_shipping_address_operator">
<span<?php echo $shipping_address->operator->viewAttributes() ?>>
<?php echo $shipping_address->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($shipping_address->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $shipping_address_view->TableLeftColumnClass ?>"><span id="elh_shipping_address_datetime"><?php echo $shipping_address->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $shipping_address->datetime->cellAttributes() ?>>
<span id="el_shipping_address_datetime">
<span<?php echo $shipping_address->datetime->viewAttributes() ?>>
<?php echo $shipping_address->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$shipping_address_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$shipping_address->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$shipping_address_view->terminate();
?>