<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_company_add = new shipping_company_add();

// Run the page
$shipping_company_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_company_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fshipping_companyadd = currentForm = new ew.Form("fshipping_companyadd", "add");

// Validate form
fshipping_companyadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($shipping_company_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_company->name->caption(), $shipping_company->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_company_add->tracking_url->Required) { ?>
			elm = this.getElements("x" + infix + "_tracking_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_company->tracking_url->caption(), $shipping_company->tracking_url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_company_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_company->operator->caption(), $shipping_company->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($shipping_company_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $shipping_company->datetime->caption(), $shipping_company->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fshipping_companyadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_companyadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_companyadd.lists["x_operator"] = <?php echo $shipping_company_add->operator->Lookup->toClientList() ?>;
fshipping_companyadd.lists["x_operator"].options = <?php echo JsonEncode($shipping_company_add->operator->lookupOptions()) ?>;
fshipping_companyadd.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shipping_company_add->showPageHeader(); ?>
<?php
$shipping_company_add->showMessage();
?>
<form name="fshipping_companyadd" id="fshipping_companyadd" class="<?php echo $shipping_company_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_company_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_company_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_company">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$shipping_company_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($shipping_company->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_shipping_company_name" for="x_name" class="<?php echo $shipping_company_add->LeftColumnClass ?>"><?php echo $shipping_company->name->caption() ?><?php echo ($shipping_company->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_company_add->RightColumnClass ?>"><div<?php echo $shipping_company->name->cellAttributes() ?>>
<span id="el_shipping_company_name">
<input type="text" data-table="shipping_company" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($shipping_company->name->getPlaceHolder()) ?>" value="<?php echo $shipping_company->name->EditValue ?>"<?php echo $shipping_company->name->editAttributes() ?>>
</span>
<?php echo $shipping_company->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($shipping_company->tracking_url->Visible) { // tracking_url ?>
	<div id="r_tracking_url" class="form-group row">
		<label id="elh_shipping_company_tracking_url" for="x_tracking_url" class="<?php echo $shipping_company_add->LeftColumnClass ?>"><?php echo $shipping_company->tracking_url->caption() ?><?php echo ($shipping_company->tracking_url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $shipping_company_add->RightColumnClass ?>"><div<?php echo $shipping_company->tracking_url->cellAttributes() ?>>
<span id="el_shipping_company_tracking_url">
<input type="text" data-table="shipping_company" data-field="x_tracking_url" name="x_tracking_url" id="x_tracking_url" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($shipping_company->tracking_url->getPlaceHolder()) ?>" value="<?php echo $shipping_company->tracking_url->EditValue ?>"<?php echo $shipping_company->tracking_url->editAttributes() ?>>
</span>
<?php echo $shipping_company->tracking_url->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$shipping_company_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $shipping_company_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $shipping_company_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$shipping_company_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shipping_company_add->terminate();
?>