<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$shipping_company_delete = new shipping_company_delete();

// Run the page
$shipping_company_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$shipping_company_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fshipping_companydelete = currentForm = new ew.Form("fshipping_companydelete", "delete");

// Form_CustomValidate event
fshipping_companydelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fshipping_companydelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fshipping_companydelete.lists["x_operator"] = <?php echo $shipping_company_delete->operator->Lookup->toClientList() ?>;
fshipping_companydelete.lists["x_operator"].options = <?php echo JsonEncode($shipping_company_delete->operator->lookupOptions()) ?>;
fshipping_companydelete.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $shipping_company_delete->showPageHeader(); ?>
<?php
$shipping_company_delete->showMessage();
?>
<form name="fshipping_companydelete" id="fshipping_companydelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($shipping_company_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $shipping_company_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="shipping_company">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($shipping_company_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($shipping_company->id->Visible) { // id ?>
		<th class="<?php echo $shipping_company->id->headerCellClass() ?>"><span id="elh_shipping_company_id" class="shipping_company_id"><?php echo $shipping_company->id->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_company->name->Visible) { // name ?>
		<th class="<?php echo $shipping_company->name->headerCellClass() ?>"><span id="elh_shipping_company_name" class="shipping_company_name"><?php echo $shipping_company->name->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_company->tracking_url->Visible) { // tracking_url ?>
		<th class="<?php echo $shipping_company->tracking_url->headerCellClass() ?>"><span id="elh_shipping_company_tracking_url" class="shipping_company_tracking_url"><?php echo $shipping_company->tracking_url->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_company->operator->Visible) { // operator ?>
		<th class="<?php echo $shipping_company->operator->headerCellClass() ?>"><span id="elh_shipping_company_operator" class="shipping_company_operator"><?php echo $shipping_company->operator->caption() ?></span></th>
<?php } ?>
<?php if ($shipping_company->datetime->Visible) { // datetime ?>
		<th class="<?php echo $shipping_company->datetime->headerCellClass() ?>"><span id="elh_shipping_company_datetime" class="shipping_company_datetime"><?php echo $shipping_company->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$shipping_company_delete->RecCnt = 0;
$i = 0;
while (!$shipping_company_delete->Recordset->EOF) {
	$shipping_company_delete->RecCnt++;
	$shipping_company_delete->RowCnt++;

	// Set row properties
	$shipping_company->resetAttributes();
	$shipping_company->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$shipping_company_delete->loadRowValues($shipping_company_delete->Recordset);

	// Render row
	$shipping_company_delete->renderRow();
?>
	<tr<?php echo $shipping_company->rowAttributes() ?>>
<?php if ($shipping_company->id->Visible) { // id ?>
		<td<?php echo $shipping_company->id->cellAttributes() ?>>
<span id="el<?php echo $shipping_company_delete->RowCnt ?>_shipping_company_id" class="shipping_company_id">
<span<?php echo $shipping_company->id->viewAttributes() ?>>
<?php echo $shipping_company->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_company->name->Visible) { // name ?>
		<td<?php echo $shipping_company->name->cellAttributes() ?>>
<span id="el<?php echo $shipping_company_delete->RowCnt ?>_shipping_company_name" class="shipping_company_name">
<span<?php echo $shipping_company->name->viewAttributes() ?>>
<?php echo $shipping_company->name->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_company->tracking_url->Visible) { // tracking_url ?>
		<td<?php echo $shipping_company->tracking_url->cellAttributes() ?>>
<span id="el<?php echo $shipping_company_delete->RowCnt ?>_shipping_company_tracking_url" class="shipping_company_tracking_url">
<span<?php echo $shipping_company->tracking_url->viewAttributes() ?>>
<?php echo $shipping_company->tracking_url->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_company->operator->Visible) { // operator ?>
		<td<?php echo $shipping_company->operator->cellAttributes() ?>>
<span id="el<?php echo $shipping_company_delete->RowCnt ?>_shipping_company_operator" class="shipping_company_operator">
<span<?php echo $shipping_company->operator->viewAttributes() ?>>
<?php echo $shipping_company->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($shipping_company->datetime->Visible) { // datetime ?>
		<td<?php echo $shipping_company->datetime->cellAttributes() ?>>
<span id="el<?php echo $shipping_company_delete->RowCnt ?>_shipping_company_datetime" class="shipping_company_datetime">
<span<?php echo $shipping_company->datetime->viewAttributes() ?>>
<?php echo $shipping_company->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$shipping_company_delete->Recordset->moveNext();
}
$shipping_company_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $shipping_company_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$shipping_company_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$shipping_company_delete->terminate();
?>